<?php

namespace App\Soap\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SDTCFEV4 StructType
 * @subpackage Structs
 */
class SDTCFEV4 extends AbstractStructBase
{
    /**
     * The Emisor
     * @var \App\Soap\StructType\EFactura_WebServices_SDTCFEV4_Emisor
     */
    public $Emisor;
    /**
     * The ComplementoFiscal
     * @var \App\Soap\StructType\EFactura_WebServices_SDTCFEV4_ComplementoFiscal
     */
    public $ComplementoFiscal;
    /**
     * The PropietarioMercaderiaTransportada
     * @var \App\Soap\StructType\EFactura_WebServices_SDTCFEV4_PropietarioMercaderiaTransportada
     */
    public $PropietarioMercaderiaTransportada;
    /**
     * The Documento
     * @var \App\Soap\StructType\EFactura_WebServices_SDTCFEV4_Documento
     */
    public $Documento;
    /**
     * The Receptor
     * @var \App\Soap\StructType\EFactura_WebServices_SDTCFEV4_Receptor
     */
    public $Receptor;
    /**
     * The Totales
     * @var \App\Soap\StructType\EFactura_WebServices_SDTCFEV4_Totales
     */
    public $Totales;
    /**
     * The Detalle
     * @var \App\Soap\StructType\Detalle
     */
    public $Detalle;
    /**
     * The DescuentosRecargosGlobal
     * @var \App\Soap\StructType\DescuentosRecargosGlobal
     */
    public $DescuentosRecargosGlobal;
    /**
     * The Subtotales
     * @var \App\Soap\StructType\Subtotales
     */
    public $Subtotales;
    /**
     * The TotalesRetencionesPercepciones
     * @var \App\Soap\StructType\TotalesRetencionesPercepciones
     */
    public $TotalesRetencionesPercepciones;
    /**
     * The MediosPago
     * @var \App\Soap\StructType\MediosPago
     */
    public $MediosPago;
    /**
     * The Referencia
     * @var \App\Soap\StructType\Referencia
     */
    public $Referencia;
    /**
     * The Adenda
     * @var \App\Soap\StructType\Adenda
     */
    public $Adenda;
    /**
     * The Cobranza
     * @var \App\Soap\StructType\EFactura_WebServices_SDTCFEV4_Cobranza
     */
    public $Cobranza;
    /**
     * The Notificar
     * @var \App\Soap\StructType\Notificar
     */
    public $Notificar;
    /**
     * The PlanDePagos
     * @var \App\Soap\StructType\EFactura_WebServices_SDTCFEV4_PlanDePagos
     */
    public $PlanDePagos;
    /**
     * The ComprobantesDePago
     * @var \App\Soap\StructType\ComprobantesDePago
     */
    public $ComprobantesDePago;
    /**
     * Constructor method for SDTCFEV4
     * @uses SDTCFEV4::setEmisor()
     * @uses SDTCFEV4::setComplementoFiscal()
     * @uses SDTCFEV4::setPropietarioMercaderiaTransportada()
     * @uses SDTCFEV4::setDocumento()
     * @uses SDTCFEV4::setReceptor()
     * @uses SDTCFEV4::setTotales()
     * @uses SDTCFEV4::setDetalle()
     * @uses SDTCFEV4::setDescuentosRecargosGlobal()
     * @uses SDTCFEV4::setSubtotales()
     * @uses SDTCFEV4::setTotalesRetencionesPercepciones()
     * @uses SDTCFEV4::setMediosPago()
     * @uses SDTCFEV4::setReferencia()
     * @uses SDTCFEV4::setAdenda()
     * @uses SDTCFEV4::setCobranza()
     * @uses SDTCFEV4::setNotificar()
     * @uses SDTCFEV4::setPlanDePagos()
     * @uses SDTCFEV4::setComprobantesDePago()
     * @param \App\Soap\StructType\EFactura_WebServices_SDTCFEV4_Emisor $emisor
     * @param \App\Soap\StructType\EFactura_WebServices_SDTCFEV4_ComplementoFiscal $complementoFiscal
     * @param \App\Soap\StructType\EFactura_WebServices_SDTCFEV4_PropietarioMercaderiaTransportada $propietarioMercaderiaTransportada
     * @param \App\Soap\StructType\EFactura_WebServices_SDTCFEV4_Documento $documento
     * @param \App\Soap\StructType\EFactura_WebServices_SDTCFEV4_Receptor $receptor
     * @param \App\Soap\StructType\EFactura_WebServices_SDTCFEV4_Totales $totales
     * @param \App\Soap\StructType\Detalle $detalle
     * @param \App\Soap\StructType\DescuentosRecargosGlobal $descuentosRecargosGlobal
     * @param \App\Soap\StructType\Subtotales $subtotales
     * @param \App\Soap\StructType\TotalesRetencionesPercepciones $totalesRetencionesPercepciones
     * @param \App\Soap\StructType\MediosPago $mediosPago
     * @param \App\Soap\StructType\Referencia $referencia
     * @param \App\Soap\StructType\Adenda $adenda
     * @param \App\Soap\StructType\EFactura_WebServices_SDTCFEV4_Cobranza $cobranza
     * @param \App\Soap\StructType\Notificar $notificar
     * @param \App\Soap\StructType\EFactura_WebServices_SDTCFEV4_PlanDePagos $planDePagos
     * @param \App\Soap\StructType\ComprobantesDePago $comprobantesDePago
     */
    public function __construct(\App\Soap\StructType\EFactura_WebServices_SDTCFEV4_Emisor $emisor = null, \App\Soap\StructType\EFactura_WebServices_SDTCFEV4_ComplementoFiscal $complementoFiscal = null, \App\Soap\StructType\EFactura_WebServices_SDTCFEV4_PropietarioMercaderiaTransportada $propietarioMercaderiaTransportada = null, \App\Soap\StructType\EFactura_WebServices_SDTCFEV4_Documento $documento = null, \App\Soap\StructType\EFactura_WebServices_SDTCFEV4_Receptor $receptor = null, \App\Soap\StructType\EFactura_WebServices_SDTCFEV4_Totales $totales = null, \App\Soap\StructType\Detalle $detalle = null, \App\Soap\StructType\DescuentosRecargosGlobal $descuentosRecargosGlobal = null, \App\Soap\StructType\Subtotales $subtotales = null, \App\Soap\StructType\TotalesRetencionesPercepciones $totalesRetencionesPercepciones = null, \App\Soap\StructType\MediosPago $mediosPago = null, \App\Soap\StructType\Referencia $referencia = null, \App\Soap\StructType\Adenda $adenda = null, \App\Soap\StructType\EFactura_WebServices_SDTCFEV4_Cobranza $cobranza = null, \App\Soap\StructType\Notificar $notificar = null, \App\Soap\StructType\EFactura_WebServices_SDTCFEV4_PlanDePagos $planDePagos = null, \App\Soap\StructType\ComprobantesDePago $comprobantesDePago = null)
    {
        $this
            ->setEmisor($emisor)
            ->setComplementoFiscal($complementoFiscal)
            ->setPropietarioMercaderiaTransportada($propietarioMercaderiaTransportada)
            ->setDocumento($documento)
            ->setReceptor($receptor)
            ->setTotales($totales)
            ->setDetalle($detalle)
            ->setDescuentosRecargosGlobal($descuentosRecargosGlobal)
            ->setSubtotales($subtotales)
            ->setTotalesRetencionesPercepciones($totalesRetencionesPercepciones)
            ->setMediosPago($mediosPago)
            ->setReferencia($referencia)
            ->setAdenda($adenda)
            ->setCobranza($cobranza)
            ->setNotificar($notificar)
            ->setPlanDePagos($planDePagos)
            ->setComprobantesDePago($comprobantesDePago);
    }
    /**
     * Get Emisor value
     * @return \App\Soap\StructType\EFactura_WebServices_SDTCFEV4_Emisor|null
     */
    public function getEmisor()
    {
        return $this->Emisor;
    }
    /**
     * Set Emisor value
     * @param \App\Soap\StructType\EFactura_WebServices_SDTCFEV4_Emisor $emisor
     * @return \App\Soap\StructType\SDTCFEV4
     */
    public function setEmisor(\App\Soap\StructType\EFactura_WebServices_SDTCFEV4_Emisor $emisor = null)
    {
        $this->Emisor = $emisor;
        return $this;
    }
    /**
     * Get ComplementoFiscal value
     * @return \App\Soap\StructType\EFactura_WebServices_SDTCFEV4_ComplementoFiscal|null
     */
    public function getComplementoFiscal()
    {
        return $this->ComplementoFiscal;
    }
    /**
     * Set ComplementoFiscal value
     * @param \App\Soap\StructType\EFactura_WebServices_SDTCFEV4_ComplementoFiscal $complementoFiscal
     * @return \App\Soap\StructType\SDTCFEV4
     */
    public function setComplementoFiscal(\App\Soap\StructType\EFactura_WebServices_SDTCFEV4_ComplementoFiscal $complementoFiscal = null)
    {
        $this->ComplementoFiscal = $complementoFiscal;
        return $this;
    }
    /**
     * Get PropietarioMercaderiaTransportada value
     * @return \App\Soap\StructType\EFactura_WebServices_SDTCFEV4_PropietarioMercaderiaTransportada|null
     */
    public function getPropietarioMercaderiaTransportada()
    {
        return $this->PropietarioMercaderiaTransportada;
    }
    /**
     * Set PropietarioMercaderiaTransportada value
     * @param \App\Soap\StructType\EFactura_WebServices_SDTCFEV4_PropietarioMercaderiaTransportada $propietarioMercaderiaTransportada
     * @return \App\Soap\StructType\SDTCFEV4
     */
    public function setPropietarioMercaderiaTransportada(\App\Soap\StructType\EFactura_WebServices_SDTCFEV4_PropietarioMercaderiaTransportada $propietarioMercaderiaTransportada = null)
    {
        $this->PropietarioMercaderiaTransportada = $propietarioMercaderiaTransportada;
        return $this;
    }
    /**
     * Get Documento value
     * @return \App\Soap\StructType\EFactura_WebServices_SDTCFEV4_Documento|null
     */
    public function getDocumento()
    {
        return $this->Documento;
    }
    /**
     * Set Documento value
     * @param \App\Soap\StructType\EFactura_WebServices_SDTCFEV4_Documento $documento
     * @return \App\Soap\StructType\SDTCFEV4
     */
    public function setDocumento(\App\Soap\StructType\EFactura_WebServices_SDTCFEV4_Documento $documento = null)
    {
        $this->Documento = $documento;
        return $this;
    }
    /**
     * Get Receptor value
     * @return \App\Soap\StructType\EFactura_WebServices_SDTCFEV4_Receptor|null
     */
    public function getReceptor()
    {
        return $this->Receptor;
    }
    /**
     * Set Receptor value
     * @param \App\Soap\StructType\EFactura_WebServices_SDTCFEV4_Receptor $receptor
     * @return \App\Soap\StructType\SDTCFEV4
     */
    public function setReceptor(\App\Soap\StructType\EFactura_WebServices_SDTCFEV4_Receptor $receptor = null)
    {
        $this->Receptor = $receptor;
        return $this;
    }
    /**
     * Get Totales value
     * @return \App\Soap\StructType\EFactura_WebServices_SDTCFEV4_Totales|null
     */
    public function getTotales()
    {
        return $this->Totales;
    }
    /**
     * Set Totales value
     * @param \App\Soap\StructType\EFactura_WebServices_SDTCFEV4_Totales $totales
     * @return \App\Soap\StructType\SDTCFEV4
     */
    public function setTotales(\App\Soap\StructType\EFactura_WebServices_SDTCFEV4_Totales $totales = null)
    {
        $this->Totales = $totales;
        return $this;
    }
    /**
     * Get Detalle value
     * @return \App\Soap\StructType\Detalle|null
     */
    public function getDetalle()
    {
        return $this->Detalle;
    }
    /**
     * Set Detalle value
     * @param \App\Soap\StructType\Detalle $detalle
     * @return \App\Soap\StructType\SDTCFEV4
     */
    public function setDetalle(\App\Soap\StructType\Detalle $detalle = null)
    {
        $this->Detalle = $detalle;
        return $this;
    }
    /**
     * Get DescuentosRecargosGlobal value
     * @return \App\Soap\StructType\DescuentosRecargosGlobal|null
     */
    public function getDescuentosRecargosGlobal()
    {
        return $this->DescuentosRecargosGlobal;
    }
    /**
     * Set DescuentosRecargosGlobal value
     * @param \App\Soap\StructType\DescuentosRecargosGlobal $descuentosRecargosGlobal
     * @return \App\Soap\StructType\SDTCFEV4
     */
    public function setDescuentosRecargosGlobal(\App\Soap\StructType\DescuentosRecargosGlobal $descuentosRecargosGlobal = null)
    {
        $this->DescuentosRecargosGlobal = $descuentosRecargosGlobal;
        return $this;
    }
    /**
     * Get Subtotales value
     * @return \App\Soap\StructType\Subtotales|null
     */
    public function getSubtotales()
    {
        return $this->Subtotales;
    }
    /**
     * Set Subtotales value
     * @param \App\Soap\StructType\Subtotales $subtotales
     * @return \App\Soap\StructType\SDTCFEV4
     */
    public function setSubtotales(\App\Soap\StructType\Subtotales $subtotales = null)
    {
        $this->Subtotales = $subtotales;
        return $this;
    }
    /**
     * Get TotalesRetencionesPercepciones value
     * @return \App\Soap\StructType\TotalesRetencionesPercepciones|null
     */
    public function getTotalesRetencionesPercepciones()
    {
        return $this->TotalesRetencionesPercepciones;
    }
    /**
     * Set TotalesRetencionesPercepciones value
     * @param \App\Soap\StructType\TotalesRetencionesPercepciones $totalesRetencionesPercepciones
     * @return \App\Soap\StructType\SDTCFEV4
     */
    public function setTotalesRetencionesPercepciones(\App\Soap\StructType\TotalesRetencionesPercepciones $totalesRetencionesPercepciones = null)
    {
        $this->TotalesRetencionesPercepciones = $totalesRetencionesPercepciones;
        return $this;
    }
    /**
     * Get MediosPago value
     * @return \App\Soap\StructType\MediosPago|null
     */
    public function getMediosPago()
    {
        return $this->MediosPago;
    }
    /**
     * Set MediosPago value
     * @param \App\Soap\StructType\MediosPago $mediosPago
     * @return \App\Soap\StructType\SDTCFEV4
     */
    public function setMediosPago(\App\Soap\StructType\MediosPago $mediosPago = null)
    {
        $this->MediosPago = $mediosPago;
        return $this;
    }
    /**
     * Get Referencia value
     * @return \App\Soap\StructType\Referencia|null
     */
    public function getReferencia()
    {
        return $this->Referencia;
    }
    /**
     * Set Referencia value
     * @param \App\Soap\StructType\Referencia $referencia
     * @return \App\Soap\StructType\SDTCFEV4
     */
    public function setReferencia(\App\Soap\StructType\Referencia $referencia = null)
    {
        $this->Referencia = $referencia;
        return $this;
    }
    /**
     * Get Adenda value
     * @return \App\Soap\StructType\Adenda|null
     */
    public function getAdenda()
    {
        return $this->Adenda;
    }
    /**
     * Set Adenda value
     * @param \App\Soap\StructType\Adenda $adenda
     * @return \App\Soap\StructType\SDTCFEV4
     */
    public function setAdenda(\App\Soap\StructType\Adenda $adenda = null)
    {
        $this->Adenda = $adenda;
        return $this;
    }
    /**
     * Get Cobranza value
     * @return \App\Soap\StructType\EFactura_WebServices_SDTCFEV4_Cobranza|null
     */
    public function getCobranza()
    {
        return $this->Cobranza;
    }
    /**
     * Set Cobranza value
     * @param \App\Soap\StructType\EFactura_WebServices_SDTCFEV4_Cobranza $cobranza
     * @return \App\Soap\StructType\SDTCFEV4
     */
    public function setCobranza(\App\Soap\StructType\EFactura_WebServices_SDTCFEV4_Cobranza $cobranza = null)
    {
        $this->Cobranza = $cobranza;
        return $this;
    }
    /**
     * Get Notificar value
     * @return \App\Soap\StructType\Notificar|null
     */
    public function getNotificar()
    {
        return $this->Notificar;
    }
    /**
     * Set Notificar value
     * @param \App\Soap\StructType\Notificar $notificar
     * @return \App\Soap\StructType\SDTCFEV4
     */
    public function setNotificar(\App\Soap\StructType\Notificar $notificar = null)
    {
        $this->Notificar = $notificar;
        return $this;
    }
    /**
     * Get PlanDePagos value
     * @return \App\Soap\StructType\EFactura_WebServices_SDTCFEV4_PlanDePagos|null
     */
    public function getPlanDePagos()
    {
        return $this->PlanDePagos;
    }
    /**
     * Set PlanDePagos value
     * @param \App\Soap\StructType\EFactura_WebServices_SDTCFEV4_PlanDePagos $planDePagos
     * @return \App\Soap\StructType\SDTCFEV4
     */
    public function setPlanDePagos(\App\Soap\StructType\EFactura_WebServices_SDTCFEV4_PlanDePagos $planDePagos = null)
    {
        $this->PlanDePagos = $planDePagos;
        return $this;
    }
    /**
     * Get ComprobantesDePago value
     * @return \App\Soap\StructType\ComprobantesDePago|null
     */
    public function getComprobantesDePago()
    {
        return $this->ComprobantesDePago;
    }
    /**
     * Set ComprobantesDePago value
     * @param \App\Soap\StructType\ComprobantesDePago $comprobantesDePago
     * @return \App\Soap\StructType\SDTCFEV4
     */
    public function setComprobantesDePago(\App\Soap\StructType\ComprobantesDePago $comprobantesDePago = null)
    {
        $this->ComprobantesDePago = $comprobantesDePago;
        return $this;
    }
}
