<?php

namespace App\Soap\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Notificar StructType
 * @subpackage Structs
 */
class Notificar extends AbstractStructBase
{
    /**
     * The NotificarItem
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \App\Soap\StructType\EFactura_WebServices_SDTCFEV4_NotificarItem[]
     */
    public $NotificarItem;
    /**
     * The Item
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \App\Soap\StructType\EFactura_WebServices_SDTWSEnviarNotificacionesInV1_Item[]
     */
    public $Item;
    /**
     * Constructor method for Notificar
     * @uses Notificar::setNotificarItem()
     * @uses Notificar::setItem()
     * @param \App\Soap\StructType\EFactura_WebServices_SDTCFEV4_NotificarItem[] $notificarItem
     * @param \App\Soap\StructType\EFactura_WebServices_SDTWSEnviarNotificacionesInV1_Item[] $item
     */
    public function __construct(array $notificarItem = array(), array $item = array())
    {
        $this
            ->setNotificarItem($notificarItem)
            ->setItem($item);
    }
    /**
     * Get NotificarItem value
     * @return \App\Soap\StructType\EFactura_WebServices_SDTCFEV4_NotificarItem[]|null
     */
    public function getNotificarItem()
    {
        return $this->NotificarItem;
    }
    /**
     * This method is responsible for validating the values passed to the setNotificarItem method
     * This method is willingly generated in order to preserve the one-line inline validation within the setNotificarItem method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateNotificarItemForArrayConstraintsFromSetNotificarItem(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $notificarNotificarItemItem) {
            // validation for constraint: itemType
            if (!$notificarNotificarItemItem instanceof \App\Soap\StructType\EFactura_WebServices_SDTCFEV4_NotificarItem) {
                $invalidValues[] = is_object($notificarNotificarItemItem) ? get_class($notificarNotificarItemItem) : sprintf('%s(%s)', gettype($notificarNotificarItemItem), var_export($notificarNotificarItemItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The NotificarItem property can only contain items of type \App\Soap\StructType\EFactura_WebServices_SDTCFEV4_NotificarItem, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set NotificarItem value
     * @throws \InvalidArgumentException
     * @param \App\Soap\StructType\EFactura_WebServices_SDTCFEV4_NotificarItem[] $notificarItem
     * @return \App\Soap\StructType\Notificar
     */
    public function setNotificarItem(array $notificarItem = array())
    {
        // validation for constraint: array
        if ('' !== ($notificarItemArrayErrorMessage = self::validateNotificarItemForArrayConstraintsFromSetNotificarItem($notificarItem))) {
            throw new \InvalidArgumentException($notificarItemArrayErrorMessage, __LINE__);
        }
        $this->NotificarItem = $notificarItem;
        return $this;
    }
    /**
     * Add item to NotificarItem value
     * @throws \InvalidArgumentException
     * @param \App\Soap\StructType\EFactura_WebServices_SDTCFEV4_NotificarItem $item
     * @return \App\Soap\StructType\Notificar
     */
    public function addToNotificarItem(\App\Soap\StructType\EFactura_WebServices_SDTCFEV4_NotificarItem $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \App\Soap\StructType\EFactura_WebServices_SDTCFEV4_NotificarItem) {
            throw new \InvalidArgumentException(sprintf('The NotificarItem property can only contain items of type \App\Soap\StructType\EFactura_WebServices_SDTCFEV4_NotificarItem, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->NotificarItem[] = $item;
        return $this;
    }
    /**
     * Get Item value
     * @return \App\Soap\StructType\EFactura_WebServices_SDTWSEnviarNotificacionesInV1_Item[]|null
     */
    public function getItem()
    {
        return $this->Item;
    }
    /**
     * This method is responsible for validating the values passed to the setItem method
     * This method is willingly generated in order to preserve the one-line inline validation within the setItem method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateItemForArrayConstraintsFromSetItem(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $notificarItemItem) {
            // validation for constraint: itemType
            if (!$notificarItemItem instanceof \App\Soap\StructType\EFactura_WebServices_SDTWSEnviarNotificacionesInV1_Item) {
                $invalidValues[] = is_object($notificarItemItem) ? get_class($notificarItemItem) : sprintf('%s(%s)', gettype($notificarItemItem), var_export($notificarItemItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Item property can only contain items of type \App\Soap\StructType\EFactura_WebServices_SDTWSEnviarNotificacionesInV1_Item, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Item value
     * @throws \InvalidArgumentException
     * @param \App\Soap\StructType\EFactura_WebServices_SDTWSEnviarNotificacionesInV1_Item[] $item
     * @return \App\Soap\StructType\Notificar
     */
    public function setItem(array $item = array())
    {
        // validation for constraint: array
        if ('' !== ($itemArrayErrorMessage = self::validateItemForArrayConstraintsFromSetItem($item))) {
            throw new \InvalidArgumentException($itemArrayErrorMessage, __LINE__);
        }
        $this->Item = $item;
        return $this;
    }
    /**
     * Add item to Item value
     * @throws \InvalidArgumentException
     * @param \App\Soap\StructType\EFactura_WebServices_SDTWSEnviarNotificacionesInV1_Item $item
     * @return \App\Soap\StructType\Notificar
     */
    public function addToItem(\App\Soap\StructType\EFactura_WebServices_SDTWSEnviarNotificacionesInV1_Item $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \App\Soap\StructType\EFactura_WebServices_SDTWSEnviarNotificacionesInV1_Item) {
            throw new \InvalidArgumentException(sprintf('The Item property can only contain items of type \App\Soap\StructType\EFactura_WebServices_SDTWSEnviarNotificacionesInV1_Item, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Item[] = $item;
        return $this;
    }
}
