<?php

namespace App\Soap\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for eFactura.WebServices.SDTCFEV4.Receptor StructType
 * @subpackage Structs
 */
class EFactura_WebServices_SDTCFEV4_Receptor extends AbstractStructBase
{
    /**
     * The DenominacionSocial
     * @var string
     */
    public $DenominacionSocial;
    /**
     * The Direccion
     * @var string
     */
    public $Direccion;
    /**
     * The Ciudad
     * @var string
     */
    public $Ciudad;
    /**
     * The Localidad
     * @var string
     */
    public $Localidad;
    /**
     * The CodigoPostal
     * @var string
     */
    public $CodigoPostal;
    /**
     * The Pais
     * @var string
     */
    public $Pais;
    /**
     * The PaisNombre
     * @var string
     */
    public $PaisNombre;
    /**
     * The TipoDocumento
     * @var string
     */
    public $TipoDocumento;
    /**
     * The Documento
     * @var string
     */
    public $Documento;
    /**
     * The TipoDocumentoPais
     * @var string
     */
    public $TipoDocumentoPais;
    /**
     * The LugarDestinoEntrega
     * @var string
     */
    public $LugarDestinoEntrega;
    /**
     * The NumeroDeCompra
     * @var string
     */
    public $NumeroDeCompra;
    /**
     * The InformacionAdicional
     * @var string
     */
    public $InformacionAdicional;
    /**
     * The NoEnviarCFEAReceptor
     * @var bool
     */
    public $NoEnviarCFEAReceptor;
    /**
     * Constructor method for eFactura.WebServices.SDTCFEV4.Receptor
     * @uses EFactura_WebServices_SDTCFEV4_Receptor::setDenominacionSocial()
     * @uses EFactura_WebServices_SDTCFEV4_Receptor::setDireccion()
     * @uses EFactura_WebServices_SDTCFEV4_Receptor::setCiudad()
     * @uses EFactura_WebServices_SDTCFEV4_Receptor::setLocalidad()
     * @uses EFactura_WebServices_SDTCFEV4_Receptor::setCodigoPostal()
     * @uses EFactura_WebServices_SDTCFEV4_Receptor::setPais()
     * @uses EFactura_WebServices_SDTCFEV4_Receptor::setPaisNombre()
     * @uses EFactura_WebServices_SDTCFEV4_Receptor::setTipoDocumento()
     * @uses EFactura_WebServices_SDTCFEV4_Receptor::setDocumento()
     * @uses EFactura_WebServices_SDTCFEV4_Receptor::setTipoDocumentoPais()
     * @uses EFactura_WebServices_SDTCFEV4_Receptor::setLugarDestinoEntrega()
     * @uses EFactura_WebServices_SDTCFEV4_Receptor::setNumeroDeCompra()
     * @uses EFactura_WebServices_SDTCFEV4_Receptor::setInformacionAdicional()
     * @uses EFactura_WebServices_SDTCFEV4_Receptor::setNoEnviarCFEAReceptor()
     * @param string $denominacionSocial
     * @param string $direccion
     * @param string $ciudad
     * @param string $localidad
     * @param string $codigoPostal
     * @param string $pais
     * @param string $paisNombre
     * @param string $tipoDocumento
     * @param string $documento
     * @param string $tipoDocumentoPais
     * @param string $lugarDestinoEntrega
     * @param string $numeroDeCompra
     * @param string $informacionAdicional
     * @param bool $noEnviarCFEAReceptor
     */
    public function __construct($denominacionSocial = null, $direccion = null, $ciudad = null, $localidad = null, $codigoPostal = null, $pais = null, $paisNombre = null, $tipoDocumento = null, $documento = null, $tipoDocumentoPais = null, $lugarDestinoEntrega = null, $numeroDeCompra = null, $informacionAdicional = null, $noEnviarCFEAReceptor = null)
    {
        $this
            ->setDenominacionSocial($denominacionSocial)
            ->setDireccion($direccion)
            ->setCiudad($ciudad)
            ->setLocalidad($localidad)
            ->setCodigoPostal($codigoPostal)
            ->setPais($pais)
            ->setPaisNombre($paisNombre)
            ->setTipoDocumento($tipoDocumento)
            ->setDocumento($documento)
            ->setTipoDocumentoPais($tipoDocumentoPais)
            ->setLugarDestinoEntrega($lugarDestinoEntrega)
            ->setNumeroDeCompra($numeroDeCompra)
            ->setInformacionAdicional($informacionAdicional)
            ->setNoEnviarCFEAReceptor($noEnviarCFEAReceptor);
    }
    /**
     * Get DenominacionSocial value
     * @return string|null
     */
    public function getDenominacionSocial()
    {
        return $this->DenominacionSocial;
    }
    /**
     * Set DenominacionSocial value
     * @param string $denominacionSocial
     * @return \App\Soap\StructType\EFactura_WebServices_SDTCFEV4_Receptor
     */
    public function setDenominacionSocial($denominacionSocial = null)
    {
        // validation for constraint: string
        if (!is_null($denominacionSocial) && !is_string($denominacionSocial)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($denominacionSocial, true), gettype($denominacionSocial)), __LINE__);
        }
        $this->DenominacionSocial = $denominacionSocial;
        return $this;
    }
    /**
     * Get Direccion value
     * @return string|null
     */
    public function getDireccion()
    {
        return $this->Direccion;
    }
    /**
     * Set Direccion value
     * @param string $direccion
     * @return \App\Soap\StructType\EFactura_WebServices_SDTCFEV4_Receptor
     */
    public function setDireccion($direccion = null)
    {
        // validation for constraint: string
        if (!is_null($direccion) && !is_string($direccion)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($direccion, true), gettype($direccion)), __LINE__);
        }
        $this->Direccion = $direccion;
        return $this;
    }
    /**
     * Get Ciudad value
     * @return string|null
     */
    public function getCiudad()
    {
        return $this->Ciudad;
    }
    /**
     * Set Ciudad value
     * @param string $ciudad
     * @return \App\Soap\StructType\EFactura_WebServices_SDTCFEV4_Receptor
     */
    public function setCiudad($ciudad = null)
    {
        // validation for constraint: string
        if (!is_null($ciudad) && !is_string($ciudad)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ciudad, true), gettype($ciudad)), __LINE__);
        }
        $this->Ciudad = $ciudad;
        return $this;
    }
    /**
     * Get Localidad value
     * @return string|null
     */
    public function getLocalidad()
    {
        return $this->Localidad;
    }
    /**
     * Set Localidad value
     * @param string $localidad
     * @return \App\Soap\StructType\EFactura_WebServices_SDTCFEV4_Receptor
     */
    public function setLocalidad($localidad = null)
    {
        // validation for constraint: string
        if (!is_null($localidad) && !is_string($localidad)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($localidad, true), gettype($localidad)), __LINE__);
        }
        $this->Localidad = $localidad;
        return $this;
    }
    /**
     * Get CodigoPostal value
     * @return string|null
     */
    public function getCodigoPostal()
    {
        return $this->CodigoPostal;
    }
    /**
     * Set CodigoPostal value
     * @param string $codigoPostal
     * @return \App\Soap\StructType\EFactura_WebServices_SDTCFEV4_Receptor
     */
    public function setCodigoPostal($codigoPostal = null)
    {
        // validation for constraint: string
        if (!is_null($codigoPostal) && !is_string($codigoPostal)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($codigoPostal, true), gettype($codigoPostal)), __LINE__);
        }
        $this->CodigoPostal = $codigoPostal;
        return $this;
    }
    /**
     * Get Pais value
     * @return string|null
     */
    public function getPais()
    {
        return $this->Pais;
    }
    /**
     * Set Pais value
     * @param string $pais
     * @return \App\Soap\StructType\EFactura_WebServices_SDTCFEV4_Receptor
     */
    public function setPais($pais = null)
    {
        // validation for constraint: string
        if (!is_null($pais) && !is_string($pais)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pais, true), gettype($pais)), __LINE__);
        }
        $this->Pais = $pais;
        return $this;
    }
    /**
     * Get PaisNombre value
     * @return string|null
     */
    public function getPaisNombre()
    {
        return $this->PaisNombre;
    }
    /**
     * Set PaisNombre value
     * @param string $paisNombre
     * @return \App\Soap\StructType\EFactura_WebServices_SDTCFEV4_Receptor
     */
    public function setPaisNombre($paisNombre = null)
    {
        // validation for constraint: string
        if (!is_null($paisNombre) && !is_string($paisNombre)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($paisNombre, true), gettype($paisNombre)), __LINE__);
        }
        $this->PaisNombre = $paisNombre;
        return $this;
    }
    /**
     * Get TipoDocumento value
     * @return string|null
     */
    public function getTipoDocumento()
    {
        return $this->TipoDocumento;
    }
    /**
     * Set TipoDocumento value
     * @param string $tipoDocumento
     * @return \App\Soap\StructType\EFactura_WebServices_SDTCFEV4_Receptor
     */
    public function setTipoDocumento($tipoDocumento = null)
    {
        // validation for constraint: string
        if (!is_null($tipoDocumento) && !is_string($tipoDocumento)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($tipoDocumento, true), gettype($tipoDocumento)), __LINE__);
        }
        $this->TipoDocumento = $tipoDocumento;
        return $this;
    }
    /**
     * Get Documento value
     * @return string|null
     */
    public function getDocumento()
    {
        return $this->Documento;
    }
    /**
     * Set Documento value
     * @param string $documento
     * @return \App\Soap\StructType\EFactura_WebServices_SDTCFEV4_Receptor
     */
    public function setDocumento($documento = null)
    {
        // validation for constraint: string
        if (!is_null($documento) && !is_string($documento)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($documento, true), gettype($documento)), __LINE__);
        }
        $this->Documento = $documento;
        return $this;
    }
    /**
     * Get TipoDocumentoPais value
     * @return string|null
     */
    public function getTipoDocumentoPais()
    {
        return $this->TipoDocumentoPais;
    }
    /**
     * Set TipoDocumentoPais value
     * @param string $tipoDocumentoPais
     * @return \App\Soap\StructType\EFactura_WebServices_SDTCFEV4_Receptor
     */
    public function setTipoDocumentoPais($tipoDocumentoPais = null)
    {
        // validation for constraint: string
        if (!is_null($tipoDocumentoPais) && !is_string($tipoDocumentoPais)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($tipoDocumentoPais, true), gettype($tipoDocumentoPais)), __LINE__);
        }
        $this->TipoDocumentoPais = $tipoDocumentoPais;
        return $this;
    }
    /**
     * Get LugarDestinoEntrega value
     * @return string|null
     */
    public function getLugarDestinoEntrega()
    {
        return $this->LugarDestinoEntrega;
    }
    /**
     * Set LugarDestinoEntrega value
     * @param string $lugarDestinoEntrega
     * @return \App\Soap\StructType\EFactura_WebServices_SDTCFEV4_Receptor
     */
    public function setLugarDestinoEntrega($lugarDestinoEntrega = null)
    {
        // validation for constraint: string
        if (!is_null($lugarDestinoEntrega) && !is_string($lugarDestinoEntrega)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lugarDestinoEntrega, true), gettype($lugarDestinoEntrega)), __LINE__);
        }
        $this->LugarDestinoEntrega = $lugarDestinoEntrega;
        return $this;
    }
    /**
     * Get NumeroDeCompra value
     * @return string|null
     */
    public function getNumeroDeCompra()
    {
        return $this->NumeroDeCompra;
    }
    /**
     * Set NumeroDeCompra value
     * @param string $numeroDeCompra
     * @return \App\Soap\StructType\EFactura_WebServices_SDTCFEV4_Receptor
     */
    public function setNumeroDeCompra($numeroDeCompra = null)
    {
        // validation for constraint: string
        if (!is_null($numeroDeCompra) && !is_string($numeroDeCompra)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($numeroDeCompra, true), gettype($numeroDeCompra)), __LINE__);
        }
        $this->NumeroDeCompra = $numeroDeCompra;
        return $this;
    }
    /**
     * Get InformacionAdicional value
     * @return string|null
     */
    public function getInformacionAdicional()
    {
        return $this->InformacionAdicional;
    }
    /**
     * Set InformacionAdicional value
     * @param string $informacionAdicional
     * @return \App\Soap\StructType\EFactura_WebServices_SDTCFEV4_Receptor
     */
    public function setInformacionAdicional($informacionAdicional = null)
    {
        // validation for constraint: string
        if (!is_null($informacionAdicional) && !is_string($informacionAdicional)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($informacionAdicional, true), gettype($informacionAdicional)), __LINE__);
        }
        $this->InformacionAdicional = $informacionAdicional;
        return $this;
    }
    /**
     * Get NoEnviarCFEAReceptor value
     * @return bool|null
     */
    public function getNoEnviarCFEAReceptor()
    {
        return $this->NoEnviarCFEAReceptor;
    }
    /**
     * Set NoEnviarCFEAReceptor value
     * @param bool $noEnviarCFEAReceptor
     * @return \App\Soap\StructType\EFactura_WebServices_SDTCFEV4_Receptor
     */
    public function setNoEnviarCFEAReceptor($noEnviarCFEAReceptor = null)
    {
        // validation for constraint: boolean
        if (!is_null($noEnviarCFEAReceptor) && !is_bool($noEnviarCFEAReceptor)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($noEnviarCFEAReceptor, true), gettype($noEnviarCFEAReceptor)), __LINE__);
        }
        $this->NoEnviarCFEAReceptor = $noEnviarCFEAReceptor;
        return $this;
    }
}
