<?php

namespace App\Soap\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for eFactura.WebServices.SDTCFEV4.MediosPagoItem StructType
 * @subpackage Structs
 */
class EFactura_WebServices_SDTCFEV4_MediosPagoItem extends AbstractStructBase
{
    /**
     * The NumeroDeLinea
     * @var string
     */
    public $NumeroDeLinea;
    /**
     * The Id
     * @var string
     */
    public $Id;
    /**
     * The Glosa
     * @var string
     */
    public $Glosa;
    /**
     * The Orden
     * @var string
     */
    public $Orden;
    /**
     * The Monto
     * @var float
     */
    public $Monto;
    /**
     * Constructor method for eFactura.WebServices.SDTCFEV4.MediosPagoItem
     * @uses EFactura_WebServices_SDTCFEV4_MediosPagoItem::setNumeroDeLinea()
     * @uses EFactura_WebServices_SDTCFEV4_MediosPagoItem::setId()
     * @uses EFactura_WebServices_SDTCFEV4_MediosPagoItem::setGlosa()
     * @uses EFactura_WebServices_SDTCFEV4_MediosPagoItem::setOrden()
     * @uses EFactura_WebServices_SDTCFEV4_MediosPagoItem::setMonto()
     * @param string $numeroDeLinea
     * @param string $id
     * @param string $glosa
     * @param string $orden
     * @param float $monto
     */
    public function __construct($numeroDeLinea = null, $id = null, $glosa = null, $orden = null, $monto = null)
    {
        $this
            ->setNumeroDeLinea($numeroDeLinea)
            ->setId($id)
            ->setGlosa($glosa)
            ->setOrden($orden)
            ->setMonto($monto);
    }
    /**
     * Get NumeroDeLinea value
     * @return string|null
     */
    public function getNumeroDeLinea()
    {
        return $this->NumeroDeLinea;
    }
    /**
     * Set NumeroDeLinea value
     * @param string $numeroDeLinea
     * @return \App\Soap\StructType\EFactura_WebServices_SDTCFEV4_MediosPagoItem
     */
    public function setNumeroDeLinea($numeroDeLinea = null)
    {
        // validation for constraint: string
        if (!is_null($numeroDeLinea) && !is_string($numeroDeLinea)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($numeroDeLinea, true), gettype($numeroDeLinea)), __LINE__);
        }
        $this->NumeroDeLinea = $numeroDeLinea;
        return $this;
    }
    /**
     * Get Id value
     * @return string|null
     */
    public function getId()
    {
        return $this->Id;
    }
    /**
     * Set Id value
     * @param string $id
     * @return \App\Soap\StructType\EFactura_WebServices_SDTCFEV4_MediosPagoItem
     */
    public function setId($id = null)
    {
        // validation for constraint: string
        if (!is_null($id) && !is_string($id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($id, true), gettype($id)), __LINE__);
        }
        $this->Id = $id;
        return $this;
    }
    /**
     * Get Glosa value
     * @return string|null
     */
    public function getGlosa()
    {
        return $this->Glosa;
    }
    /**
     * Set Glosa value
     * @param string $glosa
     * @return \App\Soap\StructType\EFactura_WebServices_SDTCFEV4_MediosPagoItem
     */
    public function setGlosa($glosa = null)
    {
        // validation for constraint: string
        if (!is_null($glosa) && !is_string($glosa)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($glosa, true), gettype($glosa)), __LINE__);
        }
        $this->Glosa = $glosa;
        return $this;
    }
    /**
     * Get Orden value
     * @return string|null
     */
    public function getOrden()
    {
        return $this->Orden;
    }
    /**
     * Set Orden value
     * @param string $orden
     * @return \App\Soap\StructType\EFactura_WebServices_SDTCFEV4_MediosPagoItem
     */
    public function setOrden($orden = null)
    {
        // validation for constraint: string
        if (!is_null($orden) && !is_string($orden)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($orden, true), gettype($orden)), __LINE__);
        }
        $this->Orden = $orden;
        return $this;
    }
    /**
     * Get Monto value
     * @return float|null
     */
    public function getMonto()
    {
        return $this->Monto;
    }
    /**
     * Set Monto value
     * @param float $monto
     * @return \App\Soap\StructType\EFactura_WebServices_SDTCFEV4_MediosPagoItem
     */
    public function setMonto($monto = null)
    {
        // validation for constraint: float
        if (!is_null($monto) && !(is_float($monto) || is_numeric($monto))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($monto, true), gettype($monto)), __LINE__);
        }
        $this->Monto = $monto;
        return $this;
    }
}
