<?php

namespace App\Soap\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for eFactura.WebServices.SDTCFEV4.Emisor StructType
 * @subpackage Structs
 */
class EFactura_WebServices_SDTCFEV4_Emisor extends AbstractStructBase
{
    /**
     * The RUT
     * @var string
     */
    public $RUT;
    /**
     * The Sucursal
     * @var int
     */
    public $Sucursal;
    /**
     * The Caja
     * @var int
     */
    public $Caja;
    /**
     * The EstacionDeTrabajo
     * @var string
     */
    public $EstacionDeTrabajo;
    /**
     * The UsuarioId
     * @var int
     */
    public $UsuarioId;
    /**
     * The UsuarioNombre
     * @var string
     */
    public $UsuarioNombre;
    /**
     * Constructor method for eFactura.WebServices.SDTCFEV4.Emisor
     * @uses EFactura_WebServices_SDTCFEV4_Emisor::setRUT()
     * @uses EFactura_WebServices_SDTCFEV4_Emisor::setSucursal()
     * @uses EFactura_WebServices_SDTCFEV4_Emisor::setCaja()
     * @uses EFactura_WebServices_SDTCFEV4_Emisor::setEstacionDeTrabajo()
     * @uses EFactura_WebServices_SDTCFEV4_Emisor::setUsuarioId()
     * @uses EFactura_WebServices_SDTCFEV4_Emisor::setUsuarioNombre()
     * @param string $rUT
     * @param int $sucursal
     * @param int $caja
     * @param string $estacionDeTrabajo
     * @param int $usuarioId
     * @param string $usuarioNombre
     */
    public function __construct($rUT = null, $sucursal = null, $caja = null, $estacionDeTrabajo = null, $usuarioId = null, $usuarioNombre = null)
    {
        $this
            ->setRUT($rUT)
            ->setSucursal($sucursal)
            ->setCaja($caja)
            ->setEstacionDeTrabajo($estacionDeTrabajo)
            ->setUsuarioId($usuarioId)
            ->setUsuarioNombre($usuarioNombre);
    }
    /**
     * Get RUT value
     * @return string|null
     */
    public function getRUT()
    {
        return $this->RUT;
    }
    /**
     * Set RUT value
     * @param string $rUT
     * @return \App\Soap\StructType\EFactura_WebServices_SDTCFEV4_Emisor
     */
    public function setRUT($rUT = null)
    {
        // validation for constraint: string
        if (!is_null($rUT) && !is_string($rUT)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($rUT, true), gettype($rUT)), __LINE__);
        }
        $this->RUT = $rUT;
        return $this;
    }
    /**
     * Get Sucursal value
     * @return int|null
     */
    public function getSucursal()
    {
        return $this->Sucursal;
    }
    /**
     * Set Sucursal value
     * @param int $sucursal
     * @return \App\Soap\StructType\EFactura_WebServices_SDTCFEV4_Emisor
     */
    public function setSucursal($sucursal = null)
    {
        // validation for constraint: int
        if (!is_null($sucursal) && !(is_int($sucursal) || ctype_digit($sucursal))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($sucursal, true), gettype($sucursal)), __LINE__);
        }
        $this->Sucursal = $sucursal;
        return $this;
    }
    /**
     * Get Caja value
     * @return int|null
     */
    public function getCaja()
    {
        return $this->Caja;
    }
    /**
     * Set Caja value
     * @param int $caja
     * @return \App\Soap\StructType\EFactura_WebServices_SDTCFEV4_Emisor
     */
    public function setCaja($caja = null)
    {
        // validation for constraint: int
        if (!is_null($caja) && !(is_int($caja) || ctype_digit($caja))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($caja, true), gettype($caja)), __LINE__);
        }
        $this->Caja = $caja;
        return $this;
    }
    /**
     * Get EstacionDeTrabajo value
     * @return string|null
     */
    public function getEstacionDeTrabajo()
    {
        return $this->EstacionDeTrabajo;
    }
    /**
     * Set EstacionDeTrabajo value
     * @param string $estacionDeTrabajo
     * @return \App\Soap\StructType\EFactura_WebServices_SDTCFEV4_Emisor
     */
    public function setEstacionDeTrabajo($estacionDeTrabajo = null)
    {
        // validation for constraint: string
        if (!is_null($estacionDeTrabajo) && !is_string($estacionDeTrabajo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($estacionDeTrabajo, true), gettype($estacionDeTrabajo)), __LINE__);
        }
        $this->EstacionDeTrabajo = $estacionDeTrabajo;
        return $this;
    }
    /**
     * Get UsuarioId value
     * @return int|null
     */
    public function getUsuarioId()
    {
        return $this->UsuarioId;
    }
    /**
     * Set UsuarioId value
     * @param int $usuarioId
     * @return \App\Soap\StructType\EFactura_WebServices_SDTCFEV4_Emisor
     */
    public function setUsuarioId($usuarioId = null)
    {
        // validation for constraint: int
        if (!is_null($usuarioId) && !(is_int($usuarioId) || ctype_digit($usuarioId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($usuarioId, true), gettype($usuarioId)), __LINE__);
        }
        $this->UsuarioId = $usuarioId;
        return $this;
    }
    /**
     * Get UsuarioNombre value
     * @return string|null
     */
    public function getUsuarioNombre()
    {
        return $this->UsuarioNombre;
    }
    /**
     * Set UsuarioNombre value
     * @param string $usuarioNombre
     * @return \App\Soap\StructType\EFactura_WebServices_SDTCFEV4_Emisor
     */
    public function setUsuarioNombre($usuarioNombre = null)
    {
        // validation for constraint: string
        if (!is_null($usuarioNombre) && !is_string($usuarioNombre)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($usuarioNombre, true), gettype($usuarioNombre)), __LINE__);
        }
        $this->UsuarioNombre = $usuarioNombre;
        return $this;
    }
}
