<?php

namespace App\Soap\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for
 * eFactura.WebServices.SDTCFEV4.DetalleItem.RetencionPercepcionItem StructType
 * @subpackage Structs
 */
class EFactura_WebServices_SDTCFEV4_DetalleItem_RetencionPercepcionItem extends AbstractStructBase
{
    /**
     * The Codigo
     * @var string
     */
    public $Codigo;
    /**
     * The Tasa
     * @var float
     */
    public $Tasa;
    /**
     * The TotalSobreElQueSeAplica
     * @var float
     */
    public $TotalSobreElQueSeAplica;
    /**
     * The Monto
     * @var float
     */
    public $Monto;
    /**
     * The InformacionAdicional
     * @var string
     */
    public $InformacionAdicional;
    /**
     * Constructor method for
     * eFactura.WebServices.SDTCFEV4.DetalleItem.RetencionPercepcionItem
     * @uses EFactura_WebServices_SDTCFEV4_DetalleItem_RetencionPercepcionItem::setCodigo()
     * @uses EFactura_WebServices_SDTCFEV4_DetalleItem_RetencionPercepcionItem::setTasa()
     * @uses EFactura_WebServices_SDTCFEV4_DetalleItem_RetencionPercepcionItem::setTotalSobreElQueSeAplica()
     * @uses EFactura_WebServices_SDTCFEV4_DetalleItem_RetencionPercepcionItem::setMonto()
     * @uses EFactura_WebServices_SDTCFEV4_DetalleItem_RetencionPercepcionItem::setInformacionAdicional()
     * @param string $codigo
     * @param float $tasa
     * @param float $totalSobreElQueSeAplica
     * @param float $monto
     * @param string $informacionAdicional
     */
    public function __construct($codigo = null, $tasa = null, $totalSobreElQueSeAplica = null, $monto = null, $informacionAdicional = null)
    {
        $this
            ->setCodigo($codigo)
            ->setTasa($tasa)
            ->setTotalSobreElQueSeAplica($totalSobreElQueSeAplica)
            ->setMonto($monto)
            ->setInformacionAdicional($informacionAdicional);
    }
    /**
     * Get Codigo value
     * @return string|null
     */
    public function getCodigo()
    {
        return $this->Codigo;
    }
    /**
     * Set Codigo value
     * @param string $codigo
     * @return \App\Soap\StructType\EFactura_WebServices_SDTCFEV4_DetalleItem_RetencionPercepcionItem
     */
    public function setCodigo($codigo = null)
    {
        // validation for constraint: string
        if (!is_null($codigo) && !is_string($codigo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($codigo, true), gettype($codigo)), __LINE__);
        }
        $this->Codigo = $codigo;
        return $this;
    }
    /**
     * Get Tasa value
     * @return float|null
     */
    public function getTasa()
    {
        return $this->Tasa;
    }
    /**
     * Set Tasa value
     * @param float $tasa
     * @return \App\Soap\StructType\EFactura_WebServices_SDTCFEV4_DetalleItem_RetencionPercepcionItem
     */
    public function setTasa($tasa = null)
    {
        // validation for constraint: float
        if (!is_null($tasa) && !(is_float($tasa) || is_numeric($tasa))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($tasa, true), gettype($tasa)), __LINE__);
        }
        $this->Tasa = $tasa;
        return $this;
    }
    /**
     * Get TotalSobreElQueSeAplica value
     * @return float|null
     */
    public function getTotalSobreElQueSeAplica()
    {
        return $this->TotalSobreElQueSeAplica;
    }
    /**
     * Set TotalSobreElQueSeAplica value
     * @param float $totalSobreElQueSeAplica
     * @return \App\Soap\StructType\EFactura_WebServices_SDTCFEV4_DetalleItem_RetencionPercepcionItem
     */
    public function setTotalSobreElQueSeAplica($totalSobreElQueSeAplica = null)
    {
        // validation for constraint: float
        if (!is_null($totalSobreElQueSeAplica) && !(is_float($totalSobreElQueSeAplica) || is_numeric($totalSobreElQueSeAplica))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($totalSobreElQueSeAplica, true), gettype($totalSobreElQueSeAplica)), __LINE__);
        }
        $this->TotalSobreElQueSeAplica = $totalSobreElQueSeAplica;
        return $this;
    }
    /**
     * Get Monto value
     * @return float|null
     */
    public function getMonto()
    {
        return $this->Monto;
    }
    /**
     * Set Monto value
     * @param float $monto
     * @return \App\Soap\StructType\EFactura_WebServices_SDTCFEV4_DetalleItem_RetencionPercepcionItem
     */
    public function setMonto($monto = null)
    {
        // validation for constraint: float
        if (!is_null($monto) && !(is_float($monto) || is_numeric($monto))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($monto, true), gettype($monto)), __LINE__);
        }
        $this->Monto = $monto;
        return $this;
    }
    /**
     * Get InformacionAdicional value
     * @return string|null
     */
    public function getInformacionAdicional()
    {
        return $this->InformacionAdicional;
    }
    /**
     * Set InformacionAdicional value
     * @param string $informacionAdicional
     * @return \App\Soap\StructType\EFactura_WebServices_SDTCFEV4_DetalleItem_RetencionPercepcionItem
     */
    public function setInformacionAdicional($informacionAdicional = null)
    {
        // validation for constraint: string
        if (!is_null($informacionAdicional) && !is_string($informacionAdicional)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($informacionAdicional, true), gettype($informacionAdicional)), __LINE__);
        }
        $this->InformacionAdicional = $informacionAdicional;
        return $this;
    }
}
