<?php

namespace App\Soap\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for eFactura.WebServices.SDTCFEV2.SubtotalesItem StructType
 * @subpackage Structs
 */
class EFactura_WebServices_SDTCFEV2_SubtotalesItem extends AbstractStructBase
{
    /**
     * The Numero
     * @var string
     */
    public $Numero;
    /**
     * The Glosa
     * @var string
     */
    public $Glosa;
    /**
     * The Orden
     * @var string
     */
    public $Orden;
    /**
     * The Monto
     * @var float
     */
    public $Monto;
    /**
     * Constructor method for eFactura.WebServices.SDTCFEV2.SubtotalesItem
     * @uses EFactura_WebServices_SDTCFEV2_SubtotalesItem::setNumero()
     * @uses EFactura_WebServices_SDTCFEV2_SubtotalesItem::setGlosa()
     * @uses EFactura_WebServices_SDTCFEV2_SubtotalesItem::setOrden()
     * @uses EFactura_WebServices_SDTCFEV2_SubtotalesItem::setMonto()
     * @param string $numero
     * @param string $glosa
     * @param string $orden
     * @param float $monto
     */
    public function __construct($numero = null, $glosa = null, $orden = null, $monto = null)
    {
        $this
            ->setNumero($numero)
            ->setGlosa($glosa)
            ->setOrden($orden)
            ->setMonto($monto);
    }
    /**
     * Get Numero value
     * @return string|null
     */
    public function getNumero()
    {
        return $this->Numero;
    }
    /**
     * Set Numero value
     * @param string $numero
     * @return \App\Soap\StructType\EFactura_WebServices_SDTCFEV2_SubtotalesItem
     */
    public function setNumero($numero = null)
    {
        // validation for constraint: string
        if (!is_null($numero) && !is_string($numero)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($numero, true), gettype($numero)), __LINE__);
        }
        $this->Numero = $numero;
        return $this;
    }
    /**
     * Get Glosa value
     * @return string|null
     */
    public function getGlosa()
    {
        return $this->Glosa;
    }
    /**
     * Set Glosa value
     * @param string $glosa
     * @return \App\Soap\StructType\EFactura_WebServices_SDTCFEV2_SubtotalesItem
     */
    public function setGlosa($glosa = null)
    {
        // validation for constraint: string
        if (!is_null($glosa) && !is_string($glosa)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($glosa, true), gettype($glosa)), __LINE__);
        }
        $this->Glosa = $glosa;
        return $this;
    }
    /**
     * Get Orden value
     * @return string|null
     */
    public function getOrden()
    {
        return $this->Orden;
    }
    /**
     * Set Orden value
     * @param string $orden
     * @return \App\Soap\StructType\EFactura_WebServices_SDTCFEV2_SubtotalesItem
     */
    public function setOrden($orden = null)
    {
        // validation for constraint: string
        if (!is_null($orden) && !is_string($orden)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($orden, true), gettype($orden)), __LINE__);
        }
        $this->Orden = $orden;
        return $this;
    }
    /**
     * Get Monto value
     * @return float|null
     */
    public function getMonto()
    {
        return $this->Monto;
    }
    /**
     * Set Monto value
     * @param float $monto
     * @return \App\Soap\StructType\EFactura_WebServices_SDTCFEV2_SubtotalesItem
     */
    public function setMonto($monto = null)
    {
        // validation for constraint: float
        if (!is_null($monto) && !(is_float($monto) || is_numeric($monto))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($monto, true), gettype($monto)), __LINE__);
        }
        $this->Monto = $monto;
        return $this;
    }
}
