<?php

namespace App\Soap\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for eFactura.WebServices.SDTCFEV2.Emisor StructType
 * @subpackage Structs
 */
class EFactura_WebServices_SDTCFEV2_Emisor extends AbstractStructBase
{
    /**
     * The RUT
     * @var string
     */
    public $RUT;
    /**
     * The SucursalId
     * @var int
     */
    public $SucursalId;
    /**
     * Constructor method for eFactura.WebServices.SDTCFEV2.Emisor
     * @uses EFactura_WebServices_SDTCFEV2_Emisor::setRUT()
     * @uses EFactura_WebServices_SDTCFEV2_Emisor::setSucursalId()
     * @param string $rUT
     * @param int $sucursalId
     */
    public function __construct($rUT = null, $sucursalId = null)
    {
        $this
            ->setRUT($rUT)
            ->setSucursalId($sucursalId);
    }
    /**
     * Get RUT value
     * @return string|null
     */
    public function getRUT()
    {
        return $this->RUT;
    }
    /**
     * Set RUT value
     * @param string $rUT
     * @return \App\Soap\StructType\EFactura_WebServices_SDTCFEV2_Emisor
     */
    public function setRUT($rUT = null)
    {
        // validation for constraint: string
        if (!is_null($rUT) && !is_string($rUT)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($rUT, true), gettype($rUT)), __LINE__);
        }
        $this->RUT = $rUT;
        return $this;
    }
    /**
     * Get SucursalId value
     * @return int|null
     */
    public function getSucursalId()
    {
        return $this->SucursalId;
    }
    /**
     * Set SucursalId value
     * @param int $sucursalId
     * @return \App\Soap\StructType\EFactura_WebServices_SDTCFEV2_Emisor
     */
    public function setSucursalId($sucursalId = null)
    {
        // validation for constraint: int
        if (!is_null($sucursalId) && !(is_int($sucursalId) || ctype_digit($sucursalId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($sucursalId, true), gettype($sucursalId)), __LINE__);
        }
        $this->SucursalId = $sucursalId;
        return $this;
    }
}
