<?php

namespace App\Soap\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for eFactura.Definiciones.SDTCFEInterno.ReferenciaItem
 * StructType
 * @subpackage Structs
 */
class EFactura_Definiciones_SDTCFEInterno_ReferenciaItem extends AbstractStructBase
{
    /**
     * The NumeroDeLinea
     * @var string
     */
    public $NumeroDeLinea;
    /**
     * The CFEEI
     * @var string
     */
    public $CFEEI;
    /**
     * The CFETipo
     * @var string
     */
    public $CFETipo;
    /**
     * The CFEEmisorSerie
     * @var string
     */
    public $CFEEmisorSerie;
    /**
     * The CFEEmisorNumero
     * @var int
     */
    public $CFEEmisorNumero;
    /**
     * The CFEOficialSerie
     * @var string
     */
    public $CFEOficialSerie;
    /**
     * The CFEOficialNumero
     * @var int
     */
    public $CFEOficialNumero;
    /**
     * The Motivo
     * @var string
     */
    public $Motivo;
    /**
     * The Fecha
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $Fecha;
    /**
     * The Monto
     * @var float
     */
    public $Monto;
    /**
     * Constructor method for eFactura.Definiciones.SDTCFEInterno.ReferenciaItem
     * @uses EFactura_Definiciones_SDTCFEInterno_ReferenciaItem::setNumeroDeLinea()
     * @uses EFactura_Definiciones_SDTCFEInterno_ReferenciaItem::setCFEEI()
     * @uses EFactura_Definiciones_SDTCFEInterno_ReferenciaItem::setCFETipo()
     * @uses EFactura_Definiciones_SDTCFEInterno_ReferenciaItem::setCFEEmisorSerie()
     * @uses EFactura_Definiciones_SDTCFEInterno_ReferenciaItem::setCFEEmisorNumero()
     * @uses EFactura_Definiciones_SDTCFEInterno_ReferenciaItem::setCFEOficialSerie()
     * @uses EFactura_Definiciones_SDTCFEInterno_ReferenciaItem::setCFEOficialNumero()
     * @uses EFactura_Definiciones_SDTCFEInterno_ReferenciaItem::setMotivo()
     * @uses EFactura_Definiciones_SDTCFEInterno_ReferenciaItem::setFecha()
     * @uses EFactura_Definiciones_SDTCFEInterno_ReferenciaItem::setMonto()
     * @param string $numeroDeLinea
     * @param string $cFEEI
     * @param string $cFETipo
     * @param string $cFEEmisorSerie
     * @param int $cFEEmisorNumero
     * @param string $cFEOficialSerie
     * @param int $cFEOficialNumero
     * @param string $motivo
     * @param string $fecha
     * @param float $monto
     */
    public function __construct($numeroDeLinea = null, $cFEEI = null, $cFETipo = null, $cFEEmisorSerie = null, $cFEEmisorNumero = null, $cFEOficialSerie = null, $cFEOficialNumero = null, $motivo = null, $fecha = null, $monto = null)
    {
        $this
            ->setNumeroDeLinea($numeroDeLinea)
            ->setCFEEI($cFEEI)
            ->setCFETipo($cFETipo)
            ->setCFEEmisorSerie($cFEEmisorSerie)
            ->setCFEEmisorNumero($cFEEmisorNumero)
            ->setCFEOficialSerie($cFEOficialSerie)
            ->setCFEOficialNumero($cFEOficialNumero)
            ->setMotivo($motivo)
            ->setFecha($fecha)
            ->setMonto($monto);
    }
    /**
     * Get NumeroDeLinea value
     * @return string|null
     */
    public function getNumeroDeLinea()
    {
        return $this->NumeroDeLinea;
    }
    /**
     * Set NumeroDeLinea value
     * @param string $numeroDeLinea
     * @return \App\Soap\StructType\EFactura_Definiciones_SDTCFEInterno_ReferenciaItem
     */
    public function setNumeroDeLinea($numeroDeLinea = null)
    {
        // validation for constraint: string
        if (!is_null($numeroDeLinea) && !is_string($numeroDeLinea)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($numeroDeLinea, true), gettype($numeroDeLinea)), __LINE__);
        }
        $this->NumeroDeLinea = $numeroDeLinea;
        return $this;
    }
    /**
     * Get CFEEI value
     * @return string|null
     */
    public function getCFEEI()
    {
        return $this->CFEEI;
    }
    /**
     * Set CFEEI value
     * @param string $cFEEI
     * @return \App\Soap\StructType\EFactura_Definiciones_SDTCFEInterno_ReferenciaItem
     */
    public function setCFEEI($cFEEI = null)
    {
        // validation for constraint: string
        if (!is_null($cFEEI) && !is_string($cFEEI)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cFEEI, true), gettype($cFEEI)), __LINE__);
        }
        $this->CFEEI = $cFEEI;
        return $this;
    }
    /**
     * Get CFETipo value
     * @return string|null
     */
    public function getCFETipo()
    {
        return $this->CFETipo;
    }
    /**
     * Set CFETipo value
     * @param string $cFETipo
     * @return \App\Soap\StructType\EFactura_Definiciones_SDTCFEInterno_ReferenciaItem
     */
    public function setCFETipo($cFETipo = null)
    {
        // validation for constraint: string
        if (!is_null($cFETipo) && !is_string($cFETipo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cFETipo, true), gettype($cFETipo)), __LINE__);
        }
        $this->CFETipo = $cFETipo;
        return $this;
    }
    /**
     * Get CFEEmisorSerie value
     * @return string|null
     */
    public function getCFEEmisorSerie()
    {
        return $this->CFEEmisorSerie;
    }
    /**
     * Set CFEEmisorSerie value
     * @param string $cFEEmisorSerie
     * @return \App\Soap\StructType\EFactura_Definiciones_SDTCFEInterno_ReferenciaItem
     */
    public function setCFEEmisorSerie($cFEEmisorSerie = null)
    {
        // validation for constraint: string
        if (!is_null($cFEEmisorSerie) && !is_string($cFEEmisorSerie)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cFEEmisorSerie, true), gettype($cFEEmisorSerie)), __LINE__);
        }
        $this->CFEEmisorSerie = $cFEEmisorSerie;
        return $this;
    }
    /**
     * Get CFEEmisorNumero value
     * @return int|null
     */
    public function getCFEEmisorNumero()
    {
        return $this->CFEEmisorNumero;
    }
    /**
     * Set CFEEmisorNumero value
     * @param int $cFEEmisorNumero
     * @return \App\Soap\StructType\EFactura_Definiciones_SDTCFEInterno_ReferenciaItem
     */
    public function setCFEEmisorNumero($cFEEmisorNumero = null)
    {
        // validation for constraint: int
        if (!is_null($cFEEmisorNumero) && !(is_int($cFEEmisorNumero) || ctype_digit($cFEEmisorNumero))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($cFEEmisorNumero, true), gettype($cFEEmisorNumero)), __LINE__);
        }
        $this->CFEEmisorNumero = $cFEEmisorNumero;
        return $this;
    }
    /**
     * Get CFEOficialSerie value
     * @return string|null
     */
    public function getCFEOficialSerie()
    {
        return $this->CFEOficialSerie;
    }
    /**
     * Set CFEOficialSerie value
     * @param string $cFEOficialSerie
     * @return \App\Soap\StructType\EFactura_Definiciones_SDTCFEInterno_ReferenciaItem
     */
    public function setCFEOficialSerie($cFEOficialSerie = null)
    {
        // validation for constraint: string
        if (!is_null($cFEOficialSerie) && !is_string($cFEOficialSerie)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cFEOficialSerie, true), gettype($cFEOficialSerie)), __LINE__);
        }
        $this->CFEOficialSerie = $cFEOficialSerie;
        return $this;
    }
    /**
     * Get CFEOficialNumero value
     * @return int|null
     */
    public function getCFEOficialNumero()
    {
        return $this->CFEOficialNumero;
    }
    /**
     * Set CFEOficialNumero value
     * @param int $cFEOficialNumero
     * @return \App\Soap\StructType\EFactura_Definiciones_SDTCFEInterno_ReferenciaItem
     */
    public function setCFEOficialNumero($cFEOficialNumero = null)
    {
        // validation for constraint: int
        if (!is_null($cFEOficialNumero) && !(is_int($cFEOficialNumero) || ctype_digit($cFEOficialNumero))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($cFEOficialNumero, true), gettype($cFEOficialNumero)), __LINE__);
        }
        $this->CFEOficialNumero = $cFEOficialNumero;
        return $this;
    }
    /**
     * Get Motivo value
     * @return string|null
     */
    public function getMotivo()
    {
        return $this->Motivo;
    }
    /**
     * Set Motivo value
     * @param string $motivo
     * @return \App\Soap\StructType\EFactura_Definiciones_SDTCFEInterno_ReferenciaItem
     */
    public function setMotivo($motivo = null)
    {
        // validation for constraint: string
        if (!is_null($motivo) && !is_string($motivo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($motivo, true), gettype($motivo)), __LINE__);
        }
        $this->Motivo = $motivo;
        return $this;
    }
    /**
     * Get Fecha value
     * @return string|null
     */
    public function getFecha()
    {
        return $this->Fecha;
    }
    /**
     * Set Fecha value
     * @param string $fecha
     * @return \App\Soap\StructType\EFactura_Definiciones_SDTCFEInterno_ReferenciaItem
     */
    public function setFecha($fecha = null)
    {
        // validation for constraint: string
        if (!is_null($fecha) && !is_string($fecha)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fecha, true), gettype($fecha)), __LINE__);
        }
        $this->Fecha = $fecha;
        return $this;
    }
    /**
     * Get Monto value
     * @return float|null
     */
    public function getMonto()
    {
        return $this->Monto;
    }
    /**
     * Set Monto value
     * @param float $monto
     * @return \App\Soap\StructType\EFactura_Definiciones_SDTCFEInterno_ReferenciaItem
     */
    public function setMonto($monto = null)
    {
        // validation for constraint: float
        if (!is_null($monto) && !(is_float($monto) || is_numeric($monto))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($monto, true), gettype($monto)), __LINE__);
        }
        $this->Monto = $monto;
        return $this;
    }
}
