<?php

namespace App\Soap\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for eFactura.Definiciones.SDTCFEInterno.Documento StructType
 * @subpackage Structs
 */
class EFactura_Definiciones_SDTCFEInterno_Documento extends AbstractStructBase
{
    /**
     * The EI
     * @var string
     */
    public $EI;
    /**
     * The EmisorTipo
     * @var string
     */
    public $EmisorTipo;
    /**
     * The EmisorSerie
     * @var string
     */
    public $EmisorSerie;
    /**
     * The EmisorNumero
     * @var int
     */
    public $EmisorNumero;
    /**
     * The FechaEmision
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $FechaEmision;
    /**
     * The TipoTrasladoBienes
     * @var string
     */
    public $TipoTrasladoBienes;
    /**
     * The PeriodoFacturacionDesde
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $PeriodoFacturacionDesde;
    /**
     * The PeriodoFacturacionHasta
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $PeriodoFacturacionHasta;
    /**
     * The IndicadorMontosBrutos
     * @var string
     */
    public $IndicadorMontosBrutos;
    /**
     * The FormaPago
     * @var string
     */
    public $FormaPago;
    /**
     * The FechaVencimiento
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $FechaVencimiento;
    /**
     * The ClausulaVenta
     * @var string
     */
    public $ClausulaVenta;
    /**
     * The ModalidadVenta
     * @var string
     */
    public $ModalidadVenta;
    /**
     * The ViaDeTransporte
     * @var string
     */
    public $ViaDeTransporte;
    /**
     * The CFESerie
     * @var string
     */
    public $CFESerie;
    /**
     * The CFENumero
     * @var int
     */
    public $CFENumero;
    /**
     * The InformacionAdicional
     * @var string
     */
    public $InformacionAdicional;
    /**
     * The SecretoProfesional
     * @var string
     */
    public $SecretoProfesional;
    /**
     * The Formulario
     * @var string
     */
    public $Formulario;
    /**
     * The IndicadorPagosPorCuentaDeTerceros
     * @var bool
     */
    public $IndicadorPagosPorCuentaDeTerceros;
    /**
     * The IndicadorCobranzaPropia
     * @var bool
     */
    public $IndicadorCobranzaPropia;
    /**
     * The FechaValor
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $FechaValor;
    /**
     * The EmisorIdInterno
     * @var string
     */
    public $EmisorIdInterno;
    /**
     * The CompraMonedaExtranjeraParaSuReventa
     * @var bool
     */
    public $CompraMonedaExtranjeraParaSuReventa;
    /**
     * Constructor method for eFactura.Definiciones.SDTCFEInterno.Documento
     * @uses EFactura_Definiciones_SDTCFEInterno_Documento::setEI()
     * @uses EFactura_Definiciones_SDTCFEInterno_Documento::setEmisorTipo()
     * @uses EFactura_Definiciones_SDTCFEInterno_Documento::setEmisorSerie()
     * @uses EFactura_Definiciones_SDTCFEInterno_Documento::setEmisorNumero()
     * @uses EFactura_Definiciones_SDTCFEInterno_Documento::setFechaEmision()
     * @uses EFactura_Definiciones_SDTCFEInterno_Documento::setTipoTrasladoBienes()
     * @uses EFactura_Definiciones_SDTCFEInterno_Documento::setPeriodoFacturacionDesde()
     * @uses EFactura_Definiciones_SDTCFEInterno_Documento::setPeriodoFacturacionHasta()
     * @uses EFactura_Definiciones_SDTCFEInterno_Documento::setIndicadorMontosBrutos()
     * @uses EFactura_Definiciones_SDTCFEInterno_Documento::setFormaPago()
     * @uses EFactura_Definiciones_SDTCFEInterno_Documento::setFechaVencimiento()
     * @uses EFactura_Definiciones_SDTCFEInterno_Documento::setClausulaVenta()
     * @uses EFactura_Definiciones_SDTCFEInterno_Documento::setModalidadVenta()
     * @uses EFactura_Definiciones_SDTCFEInterno_Documento::setViaDeTransporte()
     * @uses EFactura_Definiciones_SDTCFEInterno_Documento::setCFESerie()
     * @uses EFactura_Definiciones_SDTCFEInterno_Documento::setCFENumero()
     * @uses EFactura_Definiciones_SDTCFEInterno_Documento::setInformacionAdicional()
     * @uses EFactura_Definiciones_SDTCFEInterno_Documento::setSecretoProfesional()
     * @uses EFactura_Definiciones_SDTCFEInterno_Documento::setFormulario()
     * @uses EFactura_Definiciones_SDTCFEInterno_Documento::setIndicadorPagosPorCuentaDeTerceros()
     * @uses EFactura_Definiciones_SDTCFEInterno_Documento::setIndicadorCobranzaPropia()
     * @uses EFactura_Definiciones_SDTCFEInterno_Documento::setFechaValor()
     * @uses EFactura_Definiciones_SDTCFEInterno_Documento::setEmisorIdInterno()
     * @uses EFactura_Definiciones_SDTCFEInterno_Documento::setCompraMonedaExtranjeraParaSuReventa()
     * @param string $eI
     * @param string $emisorTipo
     * @param string $emisorSerie
     * @param int $emisorNumero
     * @param string $fechaEmision
     * @param string $tipoTrasladoBienes
     * @param string $periodoFacturacionDesde
     * @param string $periodoFacturacionHasta
     * @param string $indicadorMontosBrutos
     * @param string $formaPago
     * @param string $fechaVencimiento
     * @param string $clausulaVenta
     * @param string $modalidadVenta
     * @param string $viaDeTransporte
     * @param string $cFESerie
     * @param int $cFENumero
     * @param string $informacionAdicional
     * @param string $secretoProfesional
     * @param string $formulario
     * @param bool $indicadorPagosPorCuentaDeTerceros
     * @param bool $indicadorCobranzaPropia
     * @param string $fechaValor
     * @param string $emisorIdInterno
     * @param bool $compraMonedaExtranjeraParaSuReventa
     */
    public function __construct($eI = null, $emisorTipo = null, $emisorSerie = null, $emisorNumero = null, $fechaEmision = null, $tipoTrasladoBienes = null, $periodoFacturacionDesde = null, $periodoFacturacionHasta = null, $indicadorMontosBrutos = null, $formaPago = null, $fechaVencimiento = null, $clausulaVenta = null, $modalidadVenta = null, $viaDeTransporte = null, $cFESerie = null, $cFENumero = null, $informacionAdicional = null, $secretoProfesional = null, $formulario = null, $indicadorPagosPorCuentaDeTerceros = null, $indicadorCobranzaPropia = null, $fechaValor = null, $emisorIdInterno = null, $compraMonedaExtranjeraParaSuReventa = null)
    {
        $this
            ->setEI($eI)
            ->setEmisorTipo($emisorTipo)
            ->setEmisorSerie($emisorSerie)
            ->setEmisorNumero($emisorNumero)
            ->setFechaEmision($fechaEmision)
            ->setTipoTrasladoBienes($tipoTrasladoBienes)
            ->setPeriodoFacturacionDesde($periodoFacturacionDesde)
            ->setPeriodoFacturacionHasta($periodoFacturacionHasta)
            ->setIndicadorMontosBrutos($indicadorMontosBrutos)
            ->setFormaPago($formaPago)
            ->setFechaVencimiento($fechaVencimiento)
            ->setClausulaVenta($clausulaVenta)
            ->setModalidadVenta($modalidadVenta)
            ->setViaDeTransporte($viaDeTransporte)
            ->setCFESerie($cFESerie)
            ->setCFENumero($cFENumero)
            ->setInformacionAdicional($informacionAdicional)
            ->setSecretoProfesional($secretoProfesional)
            ->setFormulario($formulario)
            ->setIndicadorPagosPorCuentaDeTerceros($indicadorPagosPorCuentaDeTerceros)
            ->setIndicadorCobranzaPropia($indicadorCobranzaPropia)
            ->setFechaValor($fechaValor)
            ->setEmisorIdInterno($emisorIdInterno)
            ->setCompraMonedaExtranjeraParaSuReventa($compraMonedaExtranjeraParaSuReventa);
    }
    /**
     * Get EI value
     * @return string|null
     */
    public function getEI()
    {
        return $this->EI;
    }
    /**
     * Set EI value
     * @param string $eI
     * @return \App\Soap\StructType\EFactura_Definiciones_SDTCFEInterno_Documento
     */
    public function setEI($eI = null)
    {
        // validation for constraint: string
        if (!is_null($eI) && !is_string($eI)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($eI, true), gettype($eI)), __LINE__);
        }
        $this->EI = $eI;
        return $this;
    }
    /**
     * Get EmisorTipo value
     * @return string|null
     */
    public function getEmisorTipo()
    {
        return $this->EmisorTipo;
    }
    /**
     * Set EmisorTipo value
     * @param string $emisorTipo
     * @return \App\Soap\StructType\EFactura_Definiciones_SDTCFEInterno_Documento
     */
    public function setEmisorTipo($emisorTipo = null)
    {
        // validation for constraint: string
        if (!is_null($emisorTipo) && !is_string($emisorTipo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($emisorTipo, true), gettype($emisorTipo)), __LINE__);
        }
        $this->EmisorTipo = $emisorTipo;
        return $this;
    }
    /**
     * Get EmisorSerie value
     * @return string|null
     */
    public function getEmisorSerie()
    {
        return $this->EmisorSerie;
    }
    /**
     * Set EmisorSerie value
     * @param string $emisorSerie
     * @return \App\Soap\StructType\EFactura_Definiciones_SDTCFEInterno_Documento
     */
    public function setEmisorSerie($emisorSerie = null)
    {
        // validation for constraint: string
        if (!is_null($emisorSerie) && !is_string($emisorSerie)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($emisorSerie, true), gettype($emisorSerie)), __LINE__);
        }
        $this->EmisorSerie = $emisorSerie;
        return $this;
    }
    /**
     * Get EmisorNumero value
     * @return int|null
     */
    public function getEmisorNumero()
    {
        return $this->EmisorNumero;
    }
    /**
     * Set EmisorNumero value
     * @param int $emisorNumero
     * @return \App\Soap\StructType\EFactura_Definiciones_SDTCFEInterno_Documento
     */
    public function setEmisorNumero($emisorNumero = null)
    {
        // validation for constraint: int
        if (!is_null($emisorNumero) && !(is_int($emisorNumero) || ctype_digit($emisorNumero))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($emisorNumero, true), gettype($emisorNumero)), __LINE__);
        }
        $this->EmisorNumero = $emisorNumero;
        return $this;
    }
    /**
     * Get FechaEmision value
     * @return string|null
     */
    public function getFechaEmision()
    {
        return $this->FechaEmision;
    }
    /**
     * Set FechaEmision value
     * @param string $fechaEmision
     * @return \App\Soap\StructType\EFactura_Definiciones_SDTCFEInterno_Documento
     */
    public function setFechaEmision($fechaEmision = null)
    {
        // validation for constraint: string
        if (!is_null($fechaEmision) && !is_string($fechaEmision)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fechaEmision, true), gettype($fechaEmision)), __LINE__);
        }
        $this->FechaEmision = $fechaEmision;
        return $this;
    }
    /**
     * Get TipoTrasladoBienes value
     * @return string|null
     */
    public function getTipoTrasladoBienes()
    {
        return $this->TipoTrasladoBienes;
    }
    /**
     * Set TipoTrasladoBienes value
     * @param string $tipoTrasladoBienes
     * @return \App\Soap\StructType\EFactura_Definiciones_SDTCFEInterno_Documento
     */
    public function setTipoTrasladoBienes($tipoTrasladoBienes = null)
    {
        // validation for constraint: string
        if (!is_null($tipoTrasladoBienes) && !is_string($tipoTrasladoBienes)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($tipoTrasladoBienes, true), gettype($tipoTrasladoBienes)), __LINE__);
        }
        $this->TipoTrasladoBienes = $tipoTrasladoBienes;
        return $this;
    }
    /**
     * Get PeriodoFacturacionDesde value
     * @return string|null
     */
    public function getPeriodoFacturacionDesde()
    {
        return $this->PeriodoFacturacionDesde;
    }
    /**
     * Set PeriodoFacturacionDesde value
     * @param string $periodoFacturacionDesde
     * @return \App\Soap\StructType\EFactura_Definiciones_SDTCFEInterno_Documento
     */
    public function setPeriodoFacturacionDesde($periodoFacturacionDesde = null)
    {
        // validation for constraint: string
        if (!is_null($periodoFacturacionDesde) && !is_string($periodoFacturacionDesde)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($periodoFacturacionDesde, true), gettype($periodoFacturacionDesde)), __LINE__);
        }
        $this->PeriodoFacturacionDesde = $periodoFacturacionDesde;
        return $this;
    }
    /**
     * Get PeriodoFacturacionHasta value
     * @return string|null
     */
    public function getPeriodoFacturacionHasta()
    {
        return $this->PeriodoFacturacionHasta;
    }
    /**
     * Set PeriodoFacturacionHasta value
     * @param string $periodoFacturacionHasta
     * @return \App\Soap\StructType\EFactura_Definiciones_SDTCFEInterno_Documento
     */
    public function setPeriodoFacturacionHasta($periodoFacturacionHasta = null)
    {
        // validation for constraint: string
        if (!is_null($periodoFacturacionHasta) && !is_string($periodoFacturacionHasta)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($periodoFacturacionHasta, true), gettype($periodoFacturacionHasta)), __LINE__);
        }
        $this->PeriodoFacturacionHasta = $periodoFacturacionHasta;
        return $this;
    }
    /**
     * Get IndicadorMontosBrutos value
     * @return string|null
     */
    public function getIndicadorMontosBrutos()
    {
        return $this->IndicadorMontosBrutos;
    }
    /**
     * Set IndicadorMontosBrutos value
     * @param string $indicadorMontosBrutos
     * @return \App\Soap\StructType\EFactura_Definiciones_SDTCFEInterno_Documento
     */
    public function setIndicadorMontosBrutos($indicadorMontosBrutos = null)
    {
        // validation for constraint: string
        if (!is_null($indicadorMontosBrutos) && !is_string($indicadorMontosBrutos)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($indicadorMontosBrutos, true), gettype($indicadorMontosBrutos)), __LINE__);
        }
        $this->IndicadorMontosBrutos = $indicadorMontosBrutos;
        return $this;
    }
    /**
     * Get FormaPago value
     * @return string|null
     */
    public function getFormaPago()
    {
        return $this->FormaPago;
    }
    /**
     * Set FormaPago value
     * @param string $formaPago
     * @return \App\Soap\StructType\EFactura_Definiciones_SDTCFEInterno_Documento
     */
    public function setFormaPago($formaPago = null)
    {
        // validation for constraint: string
        if (!is_null($formaPago) && !is_string($formaPago)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($formaPago, true), gettype($formaPago)), __LINE__);
        }
        $this->FormaPago = $formaPago;
        return $this;
    }
    /**
     * Get FechaVencimiento value
     * @return string|null
     */
    public function getFechaVencimiento()
    {
        return $this->FechaVencimiento;
    }
    /**
     * Set FechaVencimiento value
     * @param string $fechaVencimiento
     * @return \App\Soap\StructType\EFactura_Definiciones_SDTCFEInterno_Documento
     */
    public function setFechaVencimiento($fechaVencimiento = null)
    {
        // validation for constraint: string
        if (!is_null($fechaVencimiento) && !is_string($fechaVencimiento)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fechaVencimiento, true), gettype($fechaVencimiento)), __LINE__);
        }
        $this->FechaVencimiento = $fechaVencimiento;
        return $this;
    }
    /**
     * Get ClausulaVenta value
     * @return string|null
     */
    public function getClausulaVenta()
    {
        return $this->ClausulaVenta;
    }
    /**
     * Set ClausulaVenta value
     * @param string $clausulaVenta
     * @return \App\Soap\StructType\EFactura_Definiciones_SDTCFEInterno_Documento
     */
    public function setClausulaVenta($clausulaVenta = null)
    {
        // validation for constraint: string
        if (!is_null($clausulaVenta) && !is_string($clausulaVenta)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($clausulaVenta, true), gettype($clausulaVenta)), __LINE__);
        }
        $this->ClausulaVenta = $clausulaVenta;
        return $this;
    }
    /**
     * Get ModalidadVenta value
     * @return string|null
     */
    public function getModalidadVenta()
    {
        return $this->ModalidadVenta;
    }
    /**
     * Set ModalidadVenta value
     * @param string $modalidadVenta
     * @return \App\Soap\StructType\EFactura_Definiciones_SDTCFEInterno_Documento
     */
    public function setModalidadVenta($modalidadVenta = null)
    {
        // validation for constraint: string
        if (!is_null($modalidadVenta) && !is_string($modalidadVenta)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($modalidadVenta, true), gettype($modalidadVenta)), __LINE__);
        }
        $this->ModalidadVenta = $modalidadVenta;
        return $this;
    }
    /**
     * Get ViaDeTransporte value
     * @return string|null
     */
    public function getViaDeTransporte()
    {
        return $this->ViaDeTransporte;
    }
    /**
     * Set ViaDeTransporte value
     * @param string $viaDeTransporte
     * @return \App\Soap\StructType\EFactura_Definiciones_SDTCFEInterno_Documento
     */
    public function setViaDeTransporte($viaDeTransporte = null)
    {
        // validation for constraint: string
        if (!is_null($viaDeTransporte) && !is_string($viaDeTransporte)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($viaDeTransporte, true), gettype($viaDeTransporte)), __LINE__);
        }
        $this->ViaDeTransporte = $viaDeTransporte;
        return $this;
    }
    /**
     * Get CFESerie value
     * @return string|null
     */
    public function getCFESerie()
    {
        return $this->CFESerie;
    }
    /**
     * Set CFESerie value
     * @param string $cFESerie
     * @return \App\Soap\StructType\EFactura_Definiciones_SDTCFEInterno_Documento
     */
    public function setCFESerie($cFESerie = null)
    {
        // validation for constraint: string
        if (!is_null($cFESerie) && !is_string($cFESerie)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cFESerie, true), gettype($cFESerie)), __LINE__);
        }
        $this->CFESerie = $cFESerie;
        return $this;
    }
    /**
     * Get CFENumero value
     * @return int|null
     */
    public function getCFENumero()
    {
        return $this->CFENumero;
    }
    /**
     * Set CFENumero value
     * @param int $cFENumero
     * @return \App\Soap\StructType\EFactura_Definiciones_SDTCFEInterno_Documento
     */
    public function setCFENumero($cFENumero = null)
    {
        // validation for constraint: int
        if (!is_null($cFENumero) && !(is_int($cFENumero) || ctype_digit($cFENumero))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($cFENumero, true), gettype($cFENumero)), __LINE__);
        }
        $this->CFENumero = $cFENumero;
        return $this;
    }
    /**
     * Get InformacionAdicional value
     * @return string|null
     */
    public function getInformacionAdicional()
    {
        return $this->InformacionAdicional;
    }
    /**
     * Set InformacionAdicional value
     * @param string $informacionAdicional
     * @return \App\Soap\StructType\EFactura_Definiciones_SDTCFEInterno_Documento
     */
    public function setInformacionAdicional($informacionAdicional = null)
    {
        // validation for constraint: string
        if (!is_null($informacionAdicional) && !is_string($informacionAdicional)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($informacionAdicional, true), gettype($informacionAdicional)), __LINE__);
        }
        $this->InformacionAdicional = $informacionAdicional;
        return $this;
    }
    /**
     * Get SecretoProfesional value
     * @return string|null
     */
    public function getSecretoProfesional()
    {
        return $this->SecretoProfesional;
    }
    /**
     * Set SecretoProfesional value
     * @param string $secretoProfesional
     * @return \App\Soap\StructType\EFactura_Definiciones_SDTCFEInterno_Documento
     */
    public function setSecretoProfesional($secretoProfesional = null)
    {
        // validation for constraint: string
        if (!is_null($secretoProfesional) && !is_string($secretoProfesional)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($secretoProfesional, true), gettype($secretoProfesional)), __LINE__);
        }
        $this->SecretoProfesional = $secretoProfesional;
        return $this;
    }
    /**
     * Get Formulario value
     * @return string|null
     */
    public function getFormulario()
    {
        return $this->Formulario;
    }
    /**
     * Set Formulario value
     * @param string $formulario
     * @return \App\Soap\StructType\EFactura_Definiciones_SDTCFEInterno_Documento
     */
    public function setFormulario($formulario = null)
    {
        // validation for constraint: string
        if (!is_null($formulario) && !is_string($formulario)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($formulario, true), gettype($formulario)), __LINE__);
        }
        $this->Formulario = $formulario;
        return $this;
    }
    /**
     * Get IndicadorPagosPorCuentaDeTerceros value
     * @return bool|null
     */
    public function getIndicadorPagosPorCuentaDeTerceros()
    {
        return $this->IndicadorPagosPorCuentaDeTerceros;
    }
    /**
     * Set IndicadorPagosPorCuentaDeTerceros value
     * @param bool $indicadorPagosPorCuentaDeTerceros
     * @return \App\Soap\StructType\EFactura_Definiciones_SDTCFEInterno_Documento
     */
    public function setIndicadorPagosPorCuentaDeTerceros($indicadorPagosPorCuentaDeTerceros = null)
    {
        // validation for constraint: boolean
        if (!is_null($indicadorPagosPorCuentaDeTerceros) && !is_bool($indicadorPagosPorCuentaDeTerceros)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($indicadorPagosPorCuentaDeTerceros, true), gettype($indicadorPagosPorCuentaDeTerceros)), __LINE__);
        }
        $this->IndicadorPagosPorCuentaDeTerceros = $indicadorPagosPorCuentaDeTerceros;
        return $this;
    }
    /**
     * Get IndicadorCobranzaPropia value
     * @return bool|null
     */
    public function getIndicadorCobranzaPropia()
    {
        return $this->IndicadorCobranzaPropia;
    }
    /**
     * Set IndicadorCobranzaPropia value
     * @param bool $indicadorCobranzaPropia
     * @return \App\Soap\StructType\EFactura_Definiciones_SDTCFEInterno_Documento
     */
    public function setIndicadorCobranzaPropia($indicadorCobranzaPropia = null)
    {
        // validation for constraint: boolean
        if (!is_null($indicadorCobranzaPropia) && !is_bool($indicadorCobranzaPropia)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($indicadorCobranzaPropia, true), gettype($indicadorCobranzaPropia)), __LINE__);
        }
        $this->IndicadorCobranzaPropia = $indicadorCobranzaPropia;
        return $this;
    }
    /**
     * Get FechaValor value
     * @return string|null
     */
    public function getFechaValor()
    {
        return $this->FechaValor;
    }
    /**
     * Set FechaValor value
     * @param string $fechaValor
     * @return \App\Soap\StructType\EFactura_Definiciones_SDTCFEInterno_Documento
     */
    public function setFechaValor($fechaValor = null)
    {
        // validation for constraint: string
        if (!is_null($fechaValor) && !is_string($fechaValor)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fechaValor, true), gettype($fechaValor)), __LINE__);
        }
        $this->FechaValor = $fechaValor;
        return $this;
    }
    /**
     * Get EmisorIdInterno value
     * @return string|null
     */
    public function getEmisorIdInterno()
    {
        return $this->EmisorIdInterno;
    }
    /**
     * Set EmisorIdInterno value
     * @param string $emisorIdInterno
     * @return \App\Soap\StructType\EFactura_Definiciones_SDTCFEInterno_Documento
     */
    public function setEmisorIdInterno($emisorIdInterno = null)
    {
        // validation for constraint: string
        if (!is_null($emisorIdInterno) && !is_string($emisorIdInterno)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($emisorIdInterno, true), gettype($emisorIdInterno)), __LINE__);
        }
        $this->EmisorIdInterno = $emisorIdInterno;
        return $this;
    }
    /**
     * Get CompraMonedaExtranjeraParaSuReventa value
     * @return bool|null
     */
    public function getCompraMonedaExtranjeraParaSuReventa()
    {
        return $this->CompraMonedaExtranjeraParaSuReventa;
    }
    /**
     * Set CompraMonedaExtranjeraParaSuReventa value
     * @param bool $compraMonedaExtranjeraParaSuReventa
     * @return \App\Soap\StructType\EFactura_Definiciones_SDTCFEInterno_Documento
     */
    public function setCompraMonedaExtranjeraParaSuReventa($compraMonedaExtranjeraParaSuReventa = null)
    {
        // validation for constraint: boolean
        if (!is_null($compraMonedaExtranjeraParaSuReventa) && !is_bool($compraMonedaExtranjeraParaSuReventa)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($compraMonedaExtranjeraParaSuReventa, true), gettype($compraMonedaExtranjeraParaSuReventa)), __LINE__);
        }
        $this->CompraMonedaExtranjeraParaSuReventa = $compraMonedaExtranjeraParaSuReventa;
        return $this;
    }
}
