<?php

namespace App\Soap\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for
 * eFactura.Definiciones.SDTCFEInterno.DetalleItem.DescuentoRecargoItem StructType
 * @subpackage Structs
 */
class EFactura_Definiciones_SDTCFEInterno_DetalleItem_DescuentoRecargoItem extends AbstractStructBase
{
    /**
     * The MovimientoTipo
     * @var string
     */
    public $MovimientoTipo;
    /**
     * The Tipo
     * @var int
     */
    public $Tipo;
    /**
     * The Codigo
     * @var string
     */
    public $Codigo;
    /**
     * The Valor
     * @var float
     */
    public $Valor;
    /**
     * Constructor method for
     * eFactura.Definiciones.SDTCFEInterno.DetalleItem.DescuentoRecargoItem
     * @uses EFactura_Definiciones_SDTCFEInterno_DetalleItem_DescuentoRecargoItem::setMovimientoTipo()
     * @uses EFactura_Definiciones_SDTCFEInterno_DetalleItem_DescuentoRecargoItem::setTipo()
     * @uses EFactura_Definiciones_SDTCFEInterno_DetalleItem_DescuentoRecargoItem::setCodigo()
     * @uses EFactura_Definiciones_SDTCFEInterno_DetalleItem_DescuentoRecargoItem::setValor()
     * @param string $movimientoTipo
     * @param int $tipo
     * @param string $codigo
     * @param float $valor
     */
    public function __construct($movimientoTipo = null, $tipo = null, $codigo = null, $valor = null)
    {
        $this
            ->setMovimientoTipo($movimientoTipo)
            ->setTipo($tipo)
            ->setCodigo($codigo)
            ->setValor($valor);
    }
    /**
     * Get MovimientoTipo value
     * @return string|null
     */
    public function getMovimientoTipo()
    {
        return $this->MovimientoTipo;
    }
    /**
     * Set MovimientoTipo value
     * @param string $movimientoTipo
     * @return \App\Soap\StructType\EFactura_Definiciones_SDTCFEInterno_DetalleItem_DescuentoRecargoItem
     */
    public function setMovimientoTipo($movimientoTipo = null)
    {
        // validation for constraint: string
        if (!is_null($movimientoTipo) && !is_string($movimientoTipo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($movimientoTipo, true), gettype($movimientoTipo)), __LINE__);
        }
        $this->MovimientoTipo = $movimientoTipo;
        return $this;
    }
    /**
     * Get Tipo value
     * @return int|null
     */
    public function getTipo()
    {
        return $this->Tipo;
    }
    /**
     * Set Tipo value
     * @param int $tipo
     * @return \App\Soap\StructType\EFactura_Definiciones_SDTCFEInterno_DetalleItem_DescuentoRecargoItem
     */
    public function setTipo($tipo = null)
    {
        // validation for constraint: int
        if (!is_null($tipo) && !(is_int($tipo) || ctype_digit($tipo))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($tipo, true), gettype($tipo)), __LINE__);
        }
        $this->Tipo = $tipo;
        return $this;
    }
    /**
     * Get Codigo value
     * @return string|null
     */
    public function getCodigo()
    {
        return $this->Codigo;
    }
    /**
     * Set Codigo value
     * @param string $codigo
     * @return \App\Soap\StructType\EFactura_Definiciones_SDTCFEInterno_DetalleItem_DescuentoRecargoItem
     */
    public function setCodigo($codigo = null)
    {
        // validation for constraint: string
        if (!is_null($codigo) && !is_string($codigo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($codigo, true), gettype($codigo)), __LINE__);
        }
        $this->Codigo = $codigo;
        return $this;
    }
    /**
     * Get Valor value
     * @return float|null
     */
    public function getValor()
    {
        return $this->Valor;
    }
    /**
     * Set Valor value
     * @param float $valor
     * @return \App\Soap\StructType\EFactura_Definiciones_SDTCFEInterno_DetalleItem_DescuentoRecargoItem
     */
    public function setValor($valor = null)
    {
        // validation for constraint: float
        if (!is_null($valor) && !(is_float($valor) || is_numeric($valor))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($valor, true), gettype($valor)), __LINE__);
        }
        $this->Valor = $valor;
        return $this;
    }
}
