<?php

namespace App\Soap\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for eFactura.Definiciones.SDTCFEInterno.ComprobantesDePagoItem
 * StructType
 * @subpackage Structs
 */
class EFactura_Definiciones_SDTCFEInterno_ComprobantesDePagoItem extends AbstractStructBase
{
    /**
     * The MedioDePagoId
     * @var string
     */
    public $MedioDePagoId;
    /**
     * The Serie
     * @var string
     */
    public $Serie;
    /**
     * The Numero
     * @var int
     */
    public $Numero;
    /**
     * The Titular
     * @var string
     */
    public $Titular;
    /**
     * The Autorizacion
     * @var string
     */
    public $Autorizacion;
    /**
     * The FechaEmision
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $FechaEmision;
    /**
     * The FechaCobro
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $FechaCobro;
    /**
     * The Moneda
     * @var string
     */
    public $Moneda;
    /**
     * The Importe
     * @var float
     */
    public $Importe;
    /**
     * The Adquirente
     * @var string
     */
    public $Adquirente;
    /**
     * The Sello
     * @var string
     */
    public $Sello;
    /**
     * The Banco
     * @var string
     */
    public $Banco;
    /**
     * Constructor method for
     * eFactura.Definiciones.SDTCFEInterno.ComprobantesDePagoItem
     * @uses EFactura_Definiciones_SDTCFEInterno_ComprobantesDePagoItem::setMedioDePagoId()
     * @uses EFactura_Definiciones_SDTCFEInterno_ComprobantesDePagoItem::setSerie()
     * @uses EFactura_Definiciones_SDTCFEInterno_ComprobantesDePagoItem::setNumero()
     * @uses EFactura_Definiciones_SDTCFEInterno_ComprobantesDePagoItem::setTitular()
     * @uses EFactura_Definiciones_SDTCFEInterno_ComprobantesDePagoItem::setAutorizacion()
     * @uses EFactura_Definiciones_SDTCFEInterno_ComprobantesDePagoItem::setFechaEmision()
     * @uses EFactura_Definiciones_SDTCFEInterno_ComprobantesDePagoItem::setFechaCobro()
     * @uses EFactura_Definiciones_SDTCFEInterno_ComprobantesDePagoItem::setMoneda()
     * @uses EFactura_Definiciones_SDTCFEInterno_ComprobantesDePagoItem::setImporte()
     * @uses EFactura_Definiciones_SDTCFEInterno_ComprobantesDePagoItem::setAdquirente()
     * @uses EFactura_Definiciones_SDTCFEInterno_ComprobantesDePagoItem::setSello()
     * @uses EFactura_Definiciones_SDTCFEInterno_ComprobantesDePagoItem::setBanco()
     * @param string $medioDePagoId
     * @param string $serie
     * @param int $numero
     * @param string $titular
     * @param string $autorizacion
     * @param string $fechaEmision
     * @param string $fechaCobro
     * @param string $moneda
     * @param float $importe
     * @param string $adquirente
     * @param string $sello
     * @param string $banco
     */
    public function __construct($medioDePagoId = null, $serie = null, $numero = null, $titular = null, $autorizacion = null, $fechaEmision = null, $fechaCobro = null, $moneda = null, $importe = null, $adquirente = null, $sello = null, $banco = null)
    {
        $this
            ->setMedioDePagoId($medioDePagoId)
            ->setSerie($serie)
            ->setNumero($numero)
            ->setTitular($titular)
            ->setAutorizacion($autorizacion)
            ->setFechaEmision($fechaEmision)
            ->setFechaCobro($fechaCobro)
            ->setMoneda($moneda)
            ->setImporte($importe)
            ->setAdquirente($adquirente)
            ->setSello($sello)
            ->setBanco($banco);
    }
    /**
     * Get MedioDePagoId value
     * @return string|null
     */
    public function getMedioDePagoId()
    {
        return $this->MedioDePagoId;
    }
    /**
     * Set MedioDePagoId value
     * @param string $medioDePagoId
     * @return \App\Soap\StructType\EFactura_Definiciones_SDTCFEInterno_ComprobantesDePagoItem
     */
    public function setMedioDePagoId($medioDePagoId = null)
    {
        // validation for constraint: string
        if (!is_null($medioDePagoId) && !is_string($medioDePagoId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($medioDePagoId, true), gettype($medioDePagoId)), __LINE__);
        }
        $this->MedioDePagoId = $medioDePagoId;
        return $this;
    }
    /**
     * Get Serie value
     * @return string|null
     */
    public function getSerie()
    {
        return $this->Serie;
    }
    /**
     * Set Serie value
     * @param string $serie
     * @return \App\Soap\StructType\EFactura_Definiciones_SDTCFEInterno_ComprobantesDePagoItem
     */
    public function setSerie($serie = null)
    {
        // validation for constraint: string
        if (!is_null($serie) && !is_string($serie)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($serie, true), gettype($serie)), __LINE__);
        }
        $this->Serie = $serie;
        return $this;
    }
    /**
     * Get Numero value
     * @return int|null
     */
    public function getNumero()
    {
        return $this->Numero;
    }
    /**
     * Set Numero value
     * @param int $numero
     * @return \App\Soap\StructType\EFactura_Definiciones_SDTCFEInterno_ComprobantesDePagoItem
     */
    public function setNumero($numero = null)
    {
        // validation for constraint: int
        if (!is_null($numero) && !(is_int($numero) || ctype_digit($numero))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($numero, true), gettype($numero)), __LINE__);
        }
        $this->Numero = $numero;
        return $this;
    }
    /**
     * Get Titular value
     * @return string|null
     */
    public function getTitular()
    {
        return $this->Titular;
    }
    /**
     * Set Titular value
     * @param string $titular
     * @return \App\Soap\StructType\EFactura_Definiciones_SDTCFEInterno_ComprobantesDePagoItem
     */
    public function setTitular($titular = null)
    {
        // validation for constraint: string
        if (!is_null($titular) && !is_string($titular)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($titular, true), gettype($titular)), __LINE__);
        }
        $this->Titular = $titular;
        return $this;
    }
    /**
     * Get Autorizacion value
     * @return string|null
     */
    public function getAutorizacion()
    {
        return $this->Autorizacion;
    }
    /**
     * Set Autorizacion value
     * @param string $autorizacion
     * @return \App\Soap\StructType\EFactura_Definiciones_SDTCFEInterno_ComprobantesDePagoItem
     */
    public function setAutorizacion($autorizacion = null)
    {
        // validation for constraint: string
        if (!is_null($autorizacion) && !is_string($autorizacion)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($autorizacion, true), gettype($autorizacion)), __LINE__);
        }
        $this->Autorizacion = $autorizacion;
        return $this;
    }
    /**
     * Get FechaEmision value
     * @return string|null
     */
    public function getFechaEmision()
    {
        return $this->FechaEmision;
    }
    /**
     * Set FechaEmision value
     * @param string $fechaEmision
     * @return \App\Soap\StructType\EFactura_Definiciones_SDTCFEInterno_ComprobantesDePagoItem
     */
    public function setFechaEmision($fechaEmision = null)
    {
        // validation for constraint: string
        if (!is_null($fechaEmision) && !is_string($fechaEmision)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fechaEmision, true), gettype($fechaEmision)), __LINE__);
        }
        $this->FechaEmision = $fechaEmision;
        return $this;
    }
    /**
     * Get FechaCobro value
     * @return string|null
     */
    public function getFechaCobro()
    {
        return $this->FechaCobro;
    }
    /**
     * Set FechaCobro value
     * @param string $fechaCobro
     * @return \App\Soap\StructType\EFactura_Definiciones_SDTCFEInterno_ComprobantesDePagoItem
     */
    public function setFechaCobro($fechaCobro = null)
    {
        // validation for constraint: string
        if (!is_null($fechaCobro) && !is_string($fechaCobro)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fechaCobro, true), gettype($fechaCobro)), __LINE__);
        }
        $this->FechaCobro = $fechaCobro;
        return $this;
    }
    /**
     * Get Moneda value
     * @return string|null
     */
    public function getMoneda()
    {
        return $this->Moneda;
    }
    /**
     * Set Moneda value
     * @param string $moneda
     * @return \App\Soap\StructType\EFactura_Definiciones_SDTCFEInterno_ComprobantesDePagoItem
     */
    public function setMoneda($moneda = null)
    {
        // validation for constraint: string
        if (!is_null($moneda) && !is_string($moneda)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($moneda, true), gettype($moneda)), __LINE__);
        }
        $this->Moneda = $moneda;
        return $this;
    }
    /**
     * Get Importe value
     * @return float|null
     */
    public function getImporte()
    {
        return $this->Importe;
    }
    /**
     * Set Importe value
     * @param float $importe
     * @return \App\Soap\StructType\EFactura_Definiciones_SDTCFEInterno_ComprobantesDePagoItem
     */
    public function setImporte($importe = null)
    {
        // validation for constraint: float
        if (!is_null($importe) && !(is_float($importe) || is_numeric($importe))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($importe, true), gettype($importe)), __LINE__);
        }
        $this->Importe = $importe;
        return $this;
    }
    /**
     * Get Adquirente value
     * @return string|null
     */
    public function getAdquirente()
    {
        return $this->Adquirente;
    }
    /**
     * Set Adquirente value
     * @param string $adquirente
     * @return \App\Soap\StructType\EFactura_Definiciones_SDTCFEInterno_ComprobantesDePagoItem
     */
    public function setAdquirente($adquirente = null)
    {
        // validation for constraint: string
        if (!is_null($adquirente) && !is_string($adquirente)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($adquirente, true), gettype($adquirente)), __LINE__);
        }
        $this->Adquirente = $adquirente;
        return $this;
    }
    /**
     * Get Sello value
     * @return string|null
     */
    public function getSello()
    {
        return $this->Sello;
    }
    /**
     * Set Sello value
     * @param string $sello
     * @return \App\Soap\StructType\EFactura_Definiciones_SDTCFEInterno_ComprobantesDePagoItem
     */
    public function setSello($sello = null)
    {
        // validation for constraint: string
        if (!is_null($sello) && !is_string($sello)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sello, true), gettype($sello)), __LINE__);
        }
        $this->Sello = $sello;
        return $this;
    }
    /**
     * Get Banco value
     * @return string|null
     */
    public function getBanco()
    {
        return $this->Banco;
    }
    /**
     * Set Banco value
     * @param string $banco
     * @return \App\Soap\StructType\EFactura_Definiciones_SDTCFEInterno_ComprobantesDePagoItem
     */
    public function setBanco($banco = null)
    {
        // validation for constraint: string
        if (!is_null($banco) && !is_string($banco)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($banco, true), gettype($banco)), __LINE__);
        }
        $this->Banco = $banco;
        return $this;
    }
}
