<?php

namespace App\Soap\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for ENVIARCFES ServiceType
 * @subpackage Services
 */
class ENVIARCFES extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named ENVIARCFES
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \App\Soap\StructType\WSCFEV5_ENVIARCFES $parameters
     * @return \App\Soap\StructType\WSCFEV5_ENVIARCFESResponse|bool
     */
    public function ENVIARCFES(\App\Soap\StructType\WSCFEV5_ENVIARCFES $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->ENVIARCFES($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \App\Soap\StructType\WSCFEV5_ENVIARCFESResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
