<?php

namespace App\Soap\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for ENVIARCFE ServiceType
 * @subpackage Services
 */
class ENVIARCFE extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named ENVIARCFE
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \App\Soap\StructType\WSCFEV5_ENVIARCFE $parameters
     * @return \App\Soap\StructType\WSCFEV5_ENVIARCFEResponse|bool
     */
    public function ENVIARCFE(\App\Soap\StructType\WSCFEV5_ENVIARCFE $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->ENVIARCFE($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \App\Soap\StructType\WSCFEV5_ENVIARCFEResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
