<?php
/**
 * This file aims to show you how to use this generated package.
 * In addition, the goal is to show which methods are available and the first needed parameter(s)
 * You have to use an associative array such as:
 * - the key must be a constant beginning with WSDL_ from AbstractSoapClientBase class (each generated ServiceType class extends this class)
 * - the value must be the corresponding key value (each option matches a {@link http://www.php.net/manual/en/soapclient.soapclient.php} option)
 * $options = array(
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'https://drop-api-eto-ta.overheid.nl/2020/01/dossierservice.svc?wsdl',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_TRACE => true,
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_LOGIN => 'you_secret_login',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_PASSWORD => 'you_secret_password',
 * );
 * etc...
 */
require_once __DIR__ . '/vendor/autoload.php';
/**
 * Minimal options
 */
$options = array(
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'https://drop-api-eto-ta.overheid.nl/2020/01/dossierservice.svc?wsdl',
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_CLASSMAP => ClassMap::get(),
);
/**
 * Samples for Is ServiceType
 */
$is = new \ServiceType\Is($options);
/**
 * Sample call for IsAlive operation/method
 */
if ($is->IsAlive(new \StructType\IsAlive()) !== false) {
    print_r($is->getResult());
} else {
    print_r($is->getLastError());
}
/**
 * Samples for Voeg ServiceType
 */
$voeg = new \ServiceType\Voeg($options);
/**
 * Sample call for VoegDossierToe operation/method
 */
if ($voeg->VoegDossierToe(new \StructType\VoegDossierToe()) !== false) {
    print_r($voeg->getResult());
} else {
    print_r($voeg->getLastError());
}
/**
 * Sample call for VoegDossierToeEnPubliceer operation/method
 */
if ($voeg->VoegDossierToeEnPubliceer(new \StructType\VoegDossierToeEnPubliceer()) !== false) {
    print_r($voeg->getResult());
} else {
    print_r($voeg->getLastError());
}
/**
 * Samples for Geef ServiceType
 */
$geef = new \ServiceType\Geef($options);
/**
 * Sample call for GeefDocumentInfo operation/method
 */
if ($geef->GeefDocumentInfo(new \StructType\GeefDocumentInfo()) !== false) {
    print_r($geef->getResult());
} else {
    print_r($geef->getLastError());
}
