<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for VoegDossierToeGegevens StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:VoegDossierToeGegevens
 * @subpackage Structs
 */
class VoegDossierToeGegevens extends AbstractStructBase
{
    /**
     * The Documenttype
     * @var string
     */
    public $Documenttype;
    /**
     * The GewenstePublicatiedatum
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\Datum
     */
    public $GewenstePublicatiedatum;
    /**
     * The InhoudZip
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $InhoudZip;
    /**
     * The Inhoudsopgave
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var \StructType\Inhoudsopgave
     */
    public $Inhoudsopgave;
    /**
     * The MasterconfiguratieVersie
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var \StructType\MasterconfiguratieVersie
     */
    public $MasterconfiguratieVersie;
    /**
     * The MetadataElementen
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var \ArrayType\ArrayOfMetadata
     */
    public $MetadataElementen;
    /**
     * The Processtap
     * @var string
     */
    public $Processtap;
    /**
     * The Publicatiedoelen
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var \ArrayType\ArrayOfPublicatiedoel
     */
    public $Publicatiedoelen;
    /**
     * The Publicatievorm
     * @var string
     */
    public $Publicatievorm;
    /**
     * Constructor method for VoegDossierToeGegevens
     * @uses VoegDossierToeGegevens::setDocumenttype()
     * @uses VoegDossierToeGegevens::setGewenstePublicatiedatum()
     * @uses VoegDossierToeGegevens::setInhoudZip()
     * @uses VoegDossierToeGegevens::setInhoudsopgave()
     * @uses VoegDossierToeGegevens::setMasterconfiguratieVersie()
     * @uses VoegDossierToeGegevens::setMetadataElementen()
     * @uses VoegDossierToeGegevens::setProcesstap()
     * @uses VoegDossierToeGegevens::setPublicatiedoelen()
     * @uses VoegDossierToeGegevens::setPublicatievorm()
     * @param string $documenttype
     * @param \StructType\Datum $gewenstePublicatiedatum
     * @param string $inhoudZip
     * @param \StructType\Inhoudsopgave $inhoudsopgave
     * @param \StructType\MasterconfiguratieVersie $masterconfiguratieVersie
     * @param \ArrayType\ArrayOfMetadata $metadataElementen
     * @param string $processtap
     * @param \ArrayType\ArrayOfPublicatiedoel $publicatiedoelen
     * @param string $publicatievorm
     */
    public function __construct($documenttype = null, \StructType\Datum $gewenstePublicatiedatum = null, $inhoudZip = null, \StructType\Inhoudsopgave $inhoudsopgave = null, \StructType\MasterconfiguratieVersie $masterconfiguratieVersie = null, \ArrayType\ArrayOfMetadata $metadataElementen = null, $processtap = null, \ArrayType\ArrayOfPublicatiedoel $publicatiedoelen = null, $publicatievorm = null)
    {
        $this
            ->setDocumenttype($documenttype)
            ->setGewenstePublicatiedatum($gewenstePublicatiedatum)
            ->setInhoudZip($inhoudZip)
            ->setInhoudsopgave($inhoudsopgave)
            ->setMasterconfiguratieVersie($masterconfiguratieVersie)
            ->setMetadataElementen($metadataElementen)
            ->setProcesstap($processtap)
            ->setPublicatiedoelen($publicatiedoelen)
            ->setPublicatievorm($publicatievorm);
    }
    /**
     * Get Documenttype value
     * @return string|null
     */
    public function getDocumenttype()
    {
        return $this->Documenttype;
    }
    /**
     * Set Documenttype value
     * @uses \EnumType\Documenttype::valueIsValid()
     * @uses \EnumType\Documenttype::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $documenttype
     * @return \StructType\VoegDossierToeGegevens
     */
    public function setDocumenttype($documenttype = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\Documenttype::valueIsValid($documenttype)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\Documenttype', is_array($documenttype) ? implode(', ', $documenttype) : var_export($documenttype, true), implode(', ', \EnumType\Documenttype::getValidValues())), __LINE__);
        }
        $this->Documenttype = $documenttype;
        return $this;
    }
    /**
     * Get GewenstePublicatiedatum value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\Datum|null
     */
    public function getGewenstePublicatiedatum()
    {
        return isset($this->GewenstePublicatiedatum) ? $this->GewenstePublicatiedatum : null;
    }
    /**
     * Set GewenstePublicatiedatum value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\Datum $gewenstePublicatiedatum
     * @return \StructType\VoegDossierToeGegevens
     */
    public function setGewenstePublicatiedatum(\StructType\Datum $gewenstePublicatiedatum = null)
    {
        if (is_null($gewenstePublicatiedatum) || (is_array($gewenstePublicatiedatum) && empty($gewenstePublicatiedatum))) {
            unset($this->GewenstePublicatiedatum);
        } else {
            $this->GewenstePublicatiedatum = $gewenstePublicatiedatum;
        }
        return $this;
    }
    /**
     * Get InhoudZip value
     * @return string|null
     */
    public function getInhoudZip()
    {
        return $this->InhoudZip;
    }
    /**
     * Set InhoudZip value
     * @param string $inhoudZip
     * @return \StructType\VoegDossierToeGegevens
     */
    public function setInhoudZip($inhoudZip = null)
    {
        // validation for constraint: string
        if (!is_null($inhoudZip) && !is_string($inhoudZip)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($inhoudZip, true), gettype($inhoudZip)), __LINE__);
        }
        $this->InhoudZip = $inhoudZip;
        return $this;
    }
    /**
     * Get Inhoudsopgave value
     * @return \StructType\Inhoudsopgave|null
     */
    public function getInhoudsopgave()
    {
        return $this->Inhoudsopgave;
    }
    /**
     * Set Inhoudsopgave value
     * @param \StructType\Inhoudsopgave $inhoudsopgave
     * @return \StructType\VoegDossierToeGegevens
     */
    public function setInhoudsopgave(\StructType\Inhoudsopgave $inhoudsopgave = null)
    {
        $this->Inhoudsopgave = $inhoudsopgave;
        return $this;
    }
    /**
     * Get MasterconfiguratieVersie value
     * @return \StructType\MasterconfiguratieVersie|null
     */
    public function getMasterconfiguratieVersie()
    {
        return $this->MasterconfiguratieVersie;
    }
    /**
     * Set MasterconfiguratieVersie value
     * @param \StructType\MasterconfiguratieVersie $masterconfiguratieVersie
     * @return \StructType\VoegDossierToeGegevens
     */
    public function setMasterconfiguratieVersie(\StructType\MasterconfiguratieVersie $masterconfiguratieVersie = null)
    {
        $this->MasterconfiguratieVersie = $masterconfiguratieVersie;
        return $this;
    }
    /**
     * Get MetadataElementen value
     * @return \ArrayType\ArrayOfMetadata|null
     */
    public function getMetadataElementen()
    {
        return $this->MetadataElementen;
    }
    /**
     * Set MetadataElementen value
     * @param \ArrayType\ArrayOfMetadata $metadataElementen
     * @return \StructType\VoegDossierToeGegevens
     */
    public function setMetadataElementen(\ArrayType\ArrayOfMetadata $metadataElementen = null)
    {
        $this->MetadataElementen = $metadataElementen;
        return $this;
    }
    /**
     * Get Processtap value
     * @return string|null
     */
    public function getProcesstap()
    {
        return $this->Processtap;
    }
    /**
     * Set Processtap value
     * @uses \EnumType\Processtap::valueIsValid()
     * @uses \EnumType\Processtap::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $processtap
     * @return \StructType\VoegDossierToeGegevens
     */
    public function setProcesstap($processtap = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\Processtap::valueIsValid($processtap)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\Processtap', is_array($processtap) ? implode(', ', $processtap) : var_export($processtap, true), implode(', ', \EnumType\Processtap::getValidValues())), __LINE__);
        }
        $this->Processtap = $processtap;
        return $this;
    }
    /**
     * Get Publicatiedoelen value
     * @return \ArrayType\ArrayOfPublicatiedoel|null
     */
    public function getPublicatiedoelen()
    {
        return $this->Publicatiedoelen;
    }
    /**
     * Set Publicatiedoelen value
     * @param \ArrayType\ArrayOfPublicatiedoel $publicatiedoelen
     * @return \StructType\VoegDossierToeGegevens
     */
    public function setPublicatiedoelen(\ArrayType\ArrayOfPublicatiedoel $publicatiedoelen = null)
    {
        $this->Publicatiedoelen = $publicatiedoelen;
        return $this;
    }
    /**
     * Get Publicatievorm value
     * @return string|null
     */
    public function getPublicatievorm()
    {
        return $this->Publicatievorm;
    }
    /**
     * Set Publicatievorm value
     * @uses \EnumType\Publicatievorm::valueIsValid()
     * @uses \EnumType\Publicatievorm::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $publicatievorm
     * @return \StructType\VoegDossierToeGegevens
     */
    public function setPublicatievorm($publicatievorm = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\Publicatievorm::valueIsValid($publicatievorm)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\Publicatievorm', is_array($publicatievorm) ? implode(', ', $publicatievorm) : var_export($publicatievorm, true), implode(', ', \EnumType\Publicatievorm::getValidValues())), __LINE__);
        }
        $this->Publicatievorm = $publicatievorm;
        return $this;
    }
}
