<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Metadata StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:Metadata
 * @subpackage Structs
 */
class Metadata extends AbstractStructBase
{
    /**
     * The Content
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Content;
    /**
     * The MetadataElementen
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfMetadata
     */
    public $MetadataElementen;
    /**
     * The Name
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Name;
    /**
     * The Scheme
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Scheme;
    /**
     * Constructor method for Metadata
     * @uses Metadata::setContent()
     * @uses Metadata::setMetadataElementen()
     * @uses Metadata::setName()
     * @uses Metadata::setScheme()
     * @param string $content
     * @param \ArrayType\ArrayOfMetadata $metadataElementen
     * @param string $name
     * @param string $scheme
     */
    public function __construct($content = null, \ArrayType\ArrayOfMetadata $metadataElementen = null, $name = null, $scheme = null)
    {
        $this
            ->setContent($content)
            ->setMetadataElementen($metadataElementen)
            ->setName($name)
            ->setScheme($scheme);
    }
    /**
     * Get Content value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getContent()
    {
        return isset($this->Content) ? $this->Content : null;
    }
    /**
     * Set Content value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $content
     * @return \StructType\Metadata
     */
    public function setContent($content = null)
    {
        // validation for constraint: string
        if (!is_null($content) && !is_string($content)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($content, true), gettype($content)), __LINE__);
        }
        if (is_null($content) || (is_array($content) && empty($content))) {
            unset($this->Content);
        } else {
            $this->Content = $content;
        }
        return $this;
    }
    /**
     * Get MetadataElementen value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfMetadata|null
     */
    public function getMetadataElementen()
    {
        return isset($this->MetadataElementen) ? $this->MetadataElementen : null;
    }
    /**
     * Set MetadataElementen value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfMetadata $metadataElementen
     * @return \StructType\Metadata
     */
    public function setMetadataElementen(\ArrayType\ArrayOfMetadata $metadataElementen = null)
    {
        if (is_null($metadataElementen) || (is_array($metadataElementen) && empty($metadataElementen))) {
            unset($this->MetadataElementen);
        } else {
            $this->MetadataElementen = $metadataElementen;
        }
        return $this;
    }
    /**
     * Get Name value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getName()
    {
        return isset($this->Name) ? $this->Name : null;
    }
    /**
     * Set Name value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $name
     * @return \StructType\Metadata
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name, true), gettype($name)), __LINE__);
        }
        if (is_null($name) || (is_array($name) && empty($name))) {
            unset($this->Name);
        } else {
            $this->Name = $name;
        }
        return $this;
    }
    /**
     * Get Scheme value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getScheme()
    {
        return isset($this->Scheme) ? $this->Scheme : null;
    }
    /**
     * Set Scheme value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $scheme
     * @return \StructType\Metadata
     */
    public function setScheme($scheme = null)
    {
        // validation for constraint: string
        if (!is_null($scheme) && !is_string($scheme)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($scheme, true), gettype($scheme)), __LINE__);
        }
        if (is_null($scheme) || (is_array($scheme) && empty($scheme))) {
            unset($this->Scheme);
        } else {
            $this->Scheme = $scheme;
        }
        return $this;
    }
}
