<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Inhoudsopgave StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:Inhoudsopgave
 * @subpackage Structs
 */
class Inhoudsopgave extends AbstractStructBase
{
    /**
     * The Bijlages
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfBestandInfo
     */
    public $Bijlages;
    /**
     * The ContentBestandsnaam
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ContentBestandsnaam;
    /**
     * The EmbeddedBestanden
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfBestandInfo
     */
    public $EmbeddedBestanden;
    /**
     * Constructor method for Inhoudsopgave
     * @uses Inhoudsopgave::setBijlages()
     * @uses Inhoudsopgave::setContentBestandsnaam()
     * @uses Inhoudsopgave::setEmbeddedBestanden()
     * @param \ArrayType\ArrayOfBestandInfo $bijlages
     * @param string $contentBestandsnaam
     * @param \ArrayType\ArrayOfBestandInfo $embeddedBestanden
     */
    public function __construct(\ArrayType\ArrayOfBestandInfo $bijlages = null, $contentBestandsnaam = null, \ArrayType\ArrayOfBestandInfo $embeddedBestanden = null)
    {
        $this
            ->setBijlages($bijlages)
            ->setContentBestandsnaam($contentBestandsnaam)
            ->setEmbeddedBestanden($embeddedBestanden);
    }
    /**
     * Get Bijlages value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfBestandInfo|null
     */
    public function getBijlages()
    {
        return isset($this->Bijlages) ? $this->Bijlages : null;
    }
    /**
     * Set Bijlages value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfBestandInfo $bijlages
     * @return \StructType\Inhoudsopgave
     */
    public function setBijlages(\ArrayType\ArrayOfBestandInfo $bijlages = null)
    {
        if (is_null($bijlages) || (is_array($bijlages) && empty($bijlages))) {
            unset($this->Bijlages);
        } else {
            $this->Bijlages = $bijlages;
        }
        return $this;
    }
    /**
     * Get ContentBestandsnaam value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getContentBestandsnaam()
    {
        return isset($this->ContentBestandsnaam) ? $this->ContentBestandsnaam : null;
    }
    /**
     * Set ContentBestandsnaam value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $contentBestandsnaam
     * @return \StructType\Inhoudsopgave
     */
    public function setContentBestandsnaam($contentBestandsnaam = null)
    {
        // validation for constraint: string
        if (!is_null($contentBestandsnaam) && !is_string($contentBestandsnaam)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($contentBestandsnaam, true), gettype($contentBestandsnaam)), __LINE__);
        }
        if (is_null($contentBestandsnaam) || (is_array($contentBestandsnaam) && empty($contentBestandsnaam))) {
            unset($this->ContentBestandsnaam);
        } else {
            $this->ContentBestandsnaam = $contentBestandsnaam;
        }
        return $this;
    }
    /**
     * Get EmbeddedBestanden value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfBestandInfo|null
     */
    public function getEmbeddedBestanden()
    {
        return isset($this->EmbeddedBestanden) ? $this->EmbeddedBestanden : null;
    }
    /**
     * Set EmbeddedBestanden value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfBestandInfo $embeddedBestanden
     * @return \StructType\Inhoudsopgave
     */
    public function setEmbeddedBestanden(\ArrayType\ArrayOfBestandInfo $embeddedBestanden = null)
    {
        if (is_null($embeddedBestanden) || (is_array($embeddedBestanden) && empty($embeddedBestanden))) {
            unset($this->EmbeddedBestanden);
        } else {
            $this->EmbeddedBestanden = $embeddedBestanden;
        }
        return $this;
    }
}
