<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DocumentInfo StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:DocumentInfo
 * @subpackage Structs
 */
class DocumentInfo extends AbstractStructBase
{
    /**
     * The Creatiedatum
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\Datum
     */
    public $Creatiedatum;
    /**
     * The DocumentStatus
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $DocumentStatus;
    /**
     * The Documentnummer
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Documentnummer;
    /**
     * The Dossiernummer
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Dossiernummer;
    /**
     * The Publicaties
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfPublicatieInfo
     */
    public $Publicaties;
    /**
     * Constructor method for DocumentInfo
     * @uses DocumentInfo::setCreatiedatum()
     * @uses DocumentInfo::setDocumentStatus()
     * @uses DocumentInfo::setDocumentnummer()
     * @uses DocumentInfo::setDossiernummer()
     * @uses DocumentInfo::setPublicaties()
     * @param \StructType\Datum $creatiedatum
     * @param string $documentStatus
     * @param string $documentnummer
     * @param string $dossiernummer
     * @param \ArrayType\ArrayOfPublicatieInfo $publicaties
     */
    public function __construct(\StructType\Datum $creatiedatum = null, $documentStatus = null, $documentnummer = null, $dossiernummer = null, \ArrayType\ArrayOfPublicatieInfo $publicaties = null)
    {
        $this
            ->setCreatiedatum($creatiedatum)
            ->setDocumentStatus($documentStatus)
            ->setDocumentnummer($documentnummer)
            ->setDossiernummer($dossiernummer)
            ->setPublicaties($publicaties);
    }
    /**
     * Get Creatiedatum value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\Datum|null
     */
    public function getCreatiedatum()
    {
        return isset($this->Creatiedatum) ? $this->Creatiedatum : null;
    }
    /**
     * Set Creatiedatum value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\Datum $creatiedatum
     * @return \StructType\DocumentInfo
     */
    public function setCreatiedatum(\StructType\Datum $creatiedatum = null)
    {
        if (is_null($creatiedatum) || (is_array($creatiedatum) && empty($creatiedatum))) {
            unset($this->Creatiedatum);
        } else {
            $this->Creatiedatum = $creatiedatum;
        }
        return $this;
    }
    /**
     * Get DocumentStatus value
     * @return string|null
     */
    public function getDocumentStatus()
    {
        return $this->DocumentStatus;
    }
    /**
     * Set DocumentStatus value
     * @uses \EnumType\DocumentStatus::valueIsValid()
     * @uses \EnumType\DocumentStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $documentStatus
     * @return \StructType\DocumentInfo
     */
    public function setDocumentStatus($documentStatus = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\DocumentStatus::valueIsValid($documentStatus)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\DocumentStatus', is_array($documentStatus) ? implode(', ', $documentStatus) : var_export($documentStatus, true), implode(', ', \EnumType\DocumentStatus::getValidValues())), __LINE__);
        }
        $this->DocumentStatus = $documentStatus;
        return $this;
    }
    /**
     * Get Documentnummer value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDocumentnummer()
    {
        return isset($this->Documentnummer) ? $this->Documentnummer : null;
    }
    /**
     * Set Documentnummer value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $documentnummer
     * @return \StructType\DocumentInfo
     */
    public function setDocumentnummer($documentnummer = null)
    {
        // validation for constraint: string
        if (!is_null($documentnummer) && !is_string($documentnummer)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($documentnummer, true), gettype($documentnummer)), __LINE__);
        }
        if (is_null($documentnummer) || (is_array($documentnummer) && empty($documentnummer))) {
            unset($this->Documentnummer);
        } else {
            $this->Documentnummer = $documentnummer;
        }
        return $this;
    }
    /**
     * Get Dossiernummer value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDossiernummer()
    {
        return isset($this->Dossiernummer) ? $this->Dossiernummer : null;
    }
    /**
     * Set Dossiernummer value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $dossiernummer
     * @return \StructType\DocumentInfo
     */
    public function setDossiernummer($dossiernummer = null)
    {
        // validation for constraint: string
        if (!is_null($dossiernummer) && !is_string($dossiernummer)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dossiernummer, true), gettype($dossiernummer)), __LINE__);
        }
        if (is_null($dossiernummer) || (is_array($dossiernummer) && empty($dossiernummer))) {
            unset($this->Dossiernummer);
        } else {
            $this->Dossiernummer = $dossiernummer;
        }
        return $this;
    }
    /**
     * Get Publicaties value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfPublicatieInfo|null
     */
    public function getPublicaties()
    {
        return isset($this->Publicaties) ? $this->Publicaties : null;
    }
    /**
     * Set Publicaties value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfPublicatieInfo $publicaties
     * @return \StructType\DocumentInfo
     */
    public function setPublicaties(\ArrayType\ArrayOfPublicatieInfo $publicaties = null)
    {
        if (is_null($publicaties) || (is_array($publicaties) && empty($publicaties))) {
            unset($this->Publicaties);
        } else {
            $this->Publicaties = $publicaties;
        }
        return $this;
    }
}
