<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Datum StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:Datum
 * @subpackage Structs
 */
class Datum extends AbstractStructBase
{
    /**
     * The Dag
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $Dag;
    /**
     * The Jaar
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $Jaar;
    /**
     * The Maand
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $Maand;
    /**
     * Constructor method for Datum
     * @uses Datum::setDag()
     * @uses Datum::setJaar()
     * @uses Datum::setMaand()
     * @param int $dag
     * @param int $jaar
     * @param int $maand
     */
    public function __construct($dag = null, $jaar = null, $maand = null)
    {
        $this
            ->setDag($dag)
            ->setJaar($jaar)
            ->setMaand($maand);
    }
    /**
     * Get Dag value
     * @return int|null
     */
    public function getDag()
    {
        return $this->Dag;
    }
    /**
     * Set Dag value
     * @param int $dag
     * @return \StructType\Datum
     */
    public function setDag($dag = null)
    {
        // validation for constraint: int
        if (!is_null($dag) && !(is_int($dag) || ctype_digit($dag))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($dag, true), gettype($dag)), __LINE__);
        }
        $this->Dag = $dag;
        return $this;
    }
    /**
     * Get Jaar value
     * @return int|null
     */
    public function getJaar()
    {
        return $this->Jaar;
    }
    /**
     * Set Jaar value
     * @param int $jaar
     * @return \StructType\Datum
     */
    public function setJaar($jaar = null)
    {
        // validation for constraint: int
        if (!is_null($jaar) && !(is_int($jaar) || ctype_digit($jaar))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($jaar, true), gettype($jaar)), __LINE__);
        }
        $this->Jaar = $jaar;
        return $this;
    }
    /**
     * Get Maand value
     * @return int|null
     */
    public function getMaand()
    {
        return $this->Maand;
    }
    /**
     * Set Maand value
     * @param int $maand
     * @return \StructType\Datum
     */
    public function setMaand($maand = null)
    {
        // validation for constraint: int
        if (!is_null($maand) && !(is_int($maand) || ctype_digit($maand))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($maand, true), gettype($maand)), __LINE__);
        }
        $this->Maand = $maand;
        return $this;
    }
}
