<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BestandInfo StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:BestandInfo
 * @subpackage Structs
 */
class BestandInfo extends AbstractStructBase
{
    /**
     * The Mimetype
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Mimetype;
    /**
     * The Naam
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Naam;
    /**
     * Constructor method for BestandInfo
     * @uses BestandInfo::setMimetype()
     * @uses BestandInfo::setNaam()
     * @param string $mimetype
     * @param string $naam
     */
    public function __construct($mimetype = null, $naam = null)
    {
        $this
            ->setMimetype($mimetype)
            ->setNaam($naam);
    }
    /**
     * Get Mimetype value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMimetype()
    {
        return isset($this->Mimetype) ? $this->Mimetype : null;
    }
    /**
     * Set Mimetype value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $mimetype
     * @return \StructType\BestandInfo
     */
    public function setMimetype($mimetype = null)
    {
        // validation for constraint: string
        if (!is_null($mimetype) && !is_string($mimetype)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($mimetype, true), gettype($mimetype)), __LINE__);
        }
        if (is_null($mimetype) || (is_array($mimetype) && empty($mimetype))) {
            unset($this->Mimetype);
        } else {
            $this->Mimetype = $mimetype;
        }
        return $this;
    }
    /**
     * Get Naam value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getNaam()
    {
        return isset($this->Naam) ? $this->Naam : null;
    }
    /**
     * Set Naam value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $naam
     * @return \StructType\BestandInfo
     */
    public function setNaam($naam = null)
    {
        // validation for constraint: string
        if (!is_null($naam) && !is_string($naam)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($naam, true), gettype($naam)), __LINE__);
        }
        if (is_null($naam) || (is_array($naam) && empty($naam))) {
            unset($this->Naam);
        } else {
            $this->Naam = $naam;
        }
        return $this;
    }
}
