<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Voeg ServiceType
 * @subpackage Services
 */
class Voeg extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named VoegDossierToe
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\VoegDossierToe $parameters
     * @return \StructType\VoegDossierToeResponse|bool
     */
    public function VoegDossierToe(\StructType\VoegDossierToe $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->VoegDossierToe($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named VoegDossierToeEnPubliceer
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\VoegDossierToeEnPubliceer $parameters
     * @return \StructType\VoegDossierToeEnPubliceerResponse|bool
     */
    public function VoegDossierToeEnPubliceer(\StructType\VoegDossierToeEnPubliceer $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->VoegDossierToeEnPubliceer($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\VoegDossierToeEnPubliceerResponse|\StructType\VoegDossierToeResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
