<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfMetadata ArrayType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:ArrayOfMetadata
 * @subpackage Arrays
 */
class ArrayOfMetadata extends AbstractStructArrayBase
{
    /**
     * The Metadata
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\Metadata[]
     */
    public $Metadata;
    /**
     * Constructor method for ArrayOfMetadata
     * @uses ArrayOfMetadata::setMetadata()
     * @param \StructType\Metadata[] $metadata
     */
    public function __construct(array $metadata = array())
    {
        $this
            ->setMetadata($metadata);
    }
    /**
     * Get Metadata value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\Metadata[]|null
     */
    public function getMetadata()
    {
        return isset($this->Metadata) ? $this->Metadata : null;
    }
    /**
     * This method is responsible for validating the values passed to the setMetadata method
     * This method is willingly generated in order to preserve the one-line inline validation within the setMetadata method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateMetadataForArrayConstraintsFromSetMetadata(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfMetadataMetadataItem) {
            // validation for constraint: itemType
            if (!$arrayOfMetadataMetadataItem instanceof \StructType\Metadata) {
                $invalidValues[] = is_object($arrayOfMetadataMetadataItem) ? get_class($arrayOfMetadataMetadataItem) : sprintf('%s(%s)', gettype($arrayOfMetadataMetadataItem), var_export($arrayOfMetadataMetadataItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Metadata property can only contain items of type \StructType\Metadata, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Metadata value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\Metadata[] $metadata
     * @return \ArrayType\ArrayOfMetadata
     */
    public function setMetadata(array $metadata = array())
    {
        // validation for constraint: array
        if ('' !== ($metadataArrayErrorMessage = self::validateMetadataForArrayConstraintsFromSetMetadata($metadata))) {
            throw new \InvalidArgumentException($metadataArrayErrorMessage, __LINE__);
        }
        if (is_null($metadata) || (is_array($metadata) && empty($metadata))) {
            unset($this->Metadata);
        } else {
            $this->Metadata = $metadata;
        }
        return $this;
    }
    /**
     * Add item to Metadata value
     * @throws \InvalidArgumentException
     * @param \StructType\Metadata $item
     * @return \ArrayType\ArrayOfMetadata
     */
    public function addToMetadata(\StructType\Metadata $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Metadata) {
            throw new \InvalidArgumentException(sprintf('The Metadata property can only contain items of type \StructType\Metadata, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Metadata[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\Metadata|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\Metadata|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\Metadata|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\Metadata|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\Metadata|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string Metadata
     */
    public function getAttributeName()
    {
        return 'Metadata';
    }
}
