<?php

namespace \Losc\CucmBundle\Model\Webservice\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for XWifiHotspot StructType
 * @subpackage Structs
 */
class XWifiHotspot extends AbstractStructBase
{
    /**
     * The name
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 50
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $name;
    /**
     * The ssidPrefix
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $ssidPrefix;
    /**
     * The frequencyBand
     * Meta information extracted from the WSDL
     * - default: Auto
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $frequencyBand;
    /**
     * The authenticationMethod
     * Meta information extracted from the WSDL
     * - default: None
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $authenticationMethod;
    /**
     * The description
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 255
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $description;
    /**
     * The userModifiable
     * Meta information extracted from the WSDL
     * - default: Allowed
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $userModifiable;
    /**
     * The hostName
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 64
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $hostName;
    /**
     * The port
     * Meta information extracted from the WSDL
     * - default: 1812
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $port;
    /**
     * The sharedSecret
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $sharedSecret;
    /**
     * The pskPassPhrase
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $pskPassPhrase;
    /**
     * The wepKey
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $wepKey;
    /**
     * The passwordDescription
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 255
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $passwordDescription;
    /**
     * Constructor method for XWifiHotspot
     * @uses XWifiHotspot::setName()
     * @uses XWifiHotspot::setSsidPrefix()
     * @uses XWifiHotspot::setFrequencyBand()
     * @uses XWifiHotspot::setAuthenticationMethod()
     * @uses XWifiHotspot::setDescription()
     * @uses XWifiHotspot::setUserModifiable()
     * @uses XWifiHotspot::setHostName()
     * @uses XWifiHotspot::setPort()
     * @uses XWifiHotspot::setSharedSecret()
     * @uses XWifiHotspot::setPskPassPhrase()
     * @uses XWifiHotspot::setWepKey()
     * @uses XWifiHotspot::setPasswordDescription()
     * @param string $name
     * @param string $ssidPrefix
     * @param string $frequencyBand
     * @param string $authenticationMethod
     * @param string $description
     * @param string $userModifiable
     * @param string $hostName
     * @param string $port
     * @param string $sharedSecret
     * @param string $pskPassPhrase
     * @param string $wepKey
     * @param string $passwordDescription
     */
    public function __construct($name = null, $ssidPrefix = null, $frequencyBand = 'Auto', $authenticationMethod = 'None', $description = null, $userModifiable = 'Allowed', $hostName = null, $port = '1812', $sharedSecret = null, $pskPassPhrase = null, $wepKey = null, $passwordDescription = null)
    {
        $this
            ->setName($name)
            ->setSsidPrefix($ssidPrefix)
            ->setFrequencyBand($frequencyBand)
            ->setAuthenticationMethod($authenticationMethod)
            ->setDescription($description)
            ->setUserModifiable($userModifiable)
            ->setHostName($hostName)
            ->setPort($port)
            ->setSharedSecret($sharedSecret)
            ->setPskPassPhrase($pskPassPhrase)
            ->setWepKey($wepKey)
            ->setPasswordDescription($passwordDescription);
    }
    /**
     * Get name value
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Set name value
     * @param string $name
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XWifiHotspot
     */
    public function setName($name = null)
    {
        $this->name = $name;
        return $this;
    }
    /**
     * Get ssidPrefix value
     * @return string
     */
    public function getSsidPrefix()
    {
        return $this->ssidPrefix;
    }
    /**
     * Set ssidPrefix value
     * @param string $ssidPrefix
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XWifiHotspot
     */
    public function setSsidPrefix($ssidPrefix = null)
    {
        $this->ssidPrefix = $ssidPrefix;
        return $this;
    }
    /**
     * Get frequencyBand value
     * @return string
     */
    public function getFrequencyBand()
    {
        return $this->frequencyBand;
    }
    /**
     * Set frequencyBand value
     * @param string $frequencyBand
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XWifiHotspot
     */
    public function setFrequencyBand($frequencyBand = 'Auto')
    {
        $this->frequencyBand = $frequencyBand;
        return $this;
    }
    /**
     * Get authenticationMethod value
     * @return string
     */
    public function getAuthenticationMethod()
    {
        return $this->authenticationMethod;
    }
    /**
     * Set authenticationMethod value
     * @param string $authenticationMethod
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XWifiHotspot
     */
    public function setAuthenticationMethod($authenticationMethod = 'None')
    {
        $this->authenticationMethod = $authenticationMethod;
        return $this;
    }
    /**
     * Get description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->description;
    }
    /**
     * Set description value
     * @param string $description
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XWifiHotspot
     */
    public function setDescription($description = null)
    {
        $this->description = $description;
        return $this;
    }
    /**
     * Get userModifiable value
     * @return string|null
     */
    public function getUserModifiable()
    {
        return $this->userModifiable;
    }
    /**
     * Set userModifiable value
     * @param string $userModifiable
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XWifiHotspot
     */
    public function setUserModifiable($userModifiable = 'Allowed')
    {
        $this->userModifiable = $userModifiable;
        return $this;
    }
    /**
     * Get hostName value
     * @return string|null
     */
    public function getHostName()
    {
        return $this->hostName;
    }
    /**
     * Set hostName value
     * @param string $hostName
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XWifiHotspot
     */
    public function setHostName($hostName = null)
    {
        $this->hostName = $hostName;
        return $this;
    }
    /**
     * Get port value
     * @return string|null
     */
    public function getPort()
    {
        return $this->port;
    }
    /**
     * Set port value
     * @param string $port
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XWifiHotspot
     */
    public function setPort($port = '1812')
    {
        $this->port = $port;
        return $this;
    }
    /**
     * Get sharedSecret value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSharedSecret()
    {
        return isset($this->sharedSecret) ? $this->sharedSecret : null;
    }
    /**
     * Set sharedSecret value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $sharedSecret
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XWifiHotspot
     */
    public function setSharedSecret($sharedSecret = null)
    {
        if (is_null($sharedSecret) || (is_array($sharedSecret) && empty($sharedSecret))) {
            unset($this->sharedSecret);
        } else {
            $this->sharedSecret = $sharedSecret;
        }
        return $this;
    }
    /**
     * Get pskPassPhrase value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPskPassPhrase()
    {
        return isset($this->pskPassPhrase) ? $this->pskPassPhrase : null;
    }
    /**
     * Set pskPassPhrase value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $pskPassPhrase
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XWifiHotspot
     */
    public function setPskPassPhrase($pskPassPhrase = null)
    {
        if (is_null($pskPassPhrase) || (is_array($pskPassPhrase) && empty($pskPassPhrase))) {
            unset($this->pskPassPhrase);
        } else {
            $this->pskPassPhrase = $pskPassPhrase;
        }
        return $this;
    }
    /**
     * Get wepKey value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getWepKey()
    {
        return isset($this->wepKey) ? $this->wepKey : null;
    }
    /**
     * Set wepKey value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $wepKey
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XWifiHotspot
     */
    public function setWepKey($wepKey = null)
    {
        if (is_null($wepKey) || (is_array($wepKey) && empty($wepKey))) {
            unset($this->wepKey);
        } else {
            $this->wepKey = $wepKey;
        }
        return $this;
    }
    /**
     * Get passwordDescription value
     * @return string|null
     */
    public function getPasswordDescription()
    {
        return $this->passwordDescription;
    }
    /**
     * Set passwordDescription value
     * @param string $passwordDescription
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XWifiHotspot
     */
    public function setPasswordDescription($passwordDescription = null)
    {
        $this->passwordDescription = $passwordDescription;
        return $this;
    }
}
