<?php

namespace \Losc\CucmBundle\Model\Webservice\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for XUserPhoneAssociation StructType
 * @subpackage Structs
 */
class XUserPhoneAssociation extends AbstractStructBase
{
    /**
     * The userId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $userId;
    /**
     * The lastName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $lastName;
    /**
     * The productType
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $productType;
    /**
     * The name
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 128
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $name;
    /**
     * The e164Mask
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $e164Mask;
    /**
     * The extension
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $extension;
    /**
     * The password
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $password;
    /**
     * The pin
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $pin;
    /**
     * The middleName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $middleName;
    /**
     * The firstName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $firstName;
    /**
     * The dnCssName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $dnCssName;
    /**
     * The phoneCssName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $phoneCssName;
    /**
     * The routePartitionName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $routePartitionName;
    /**
     * The voiceMailProfileName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $voiceMailProfileName;
    /**
     * The enableExtensionMobility
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $enableExtensionMobility;
    /**
     * The DirectoryURI
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $DirectoryURI;
    /**
     * The DirectoryNumberURIPartition
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $DirectoryNumberURIPartition;
    /**
     * Constructor method for XUserPhoneAssociation
     * @uses XUserPhoneAssociation::setUserId()
     * @uses XUserPhoneAssociation::setLastName()
     * @uses XUserPhoneAssociation::setProductType()
     * @uses XUserPhoneAssociation::setName()
     * @uses XUserPhoneAssociation::setE164Mask()
     * @uses XUserPhoneAssociation::setExtension()
     * @uses XUserPhoneAssociation::setPassword()
     * @uses XUserPhoneAssociation::setPin()
     * @uses XUserPhoneAssociation::setMiddleName()
     * @uses XUserPhoneAssociation::setFirstName()
     * @uses XUserPhoneAssociation::setDnCssName()
     * @uses XUserPhoneAssociation::setPhoneCssName()
     * @uses XUserPhoneAssociation::setRoutePartitionName()
     * @uses XUserPhoneAssociation::setVoiceMailProfileName()
     * @uses XUserPhoneAssociation::setEnableExtensionMobility()
     * @uses XUserPhoneAssociation::setDirectoryURI()
     * @uses XUserPhoneAssociation::setDirectoryNumberURIPartition()
     * @param string $userId
     * @param string $lastName
     * @param string $productType
     * @param string $name
     * @param string $e164Mask
     * @param string $extension
     * @param string $password
     * @param string $pin
     * @param string $middleName
     * @param string $firstName
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $dnCssName
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $phoneCssName
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $routePartitionName
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $voiceMailProfileName
     * @param string $enableExtensionMobility
     * @param string $directoryURI
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $directoryNumberURIPartition
     */
    public function __construct($userId = null, $lastName = null, $productType = null, $name = null, $e164Mask = null, $extension = null, $password = null, $pin = null, $middleName = null, $firstName = null, \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $dnCssName = null, \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $phoneCssName = null, \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $routePartitionName = null, \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $voiceMailProfileName = null, $enableExtensionMobility = null, $directoryURI = null, \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $directoryNumberURIPartition = null)
    {
        $this
            ->setUserId($userId)
            ->setLastName($lastName)
            ->setProductType($productType)
            ->setName($name)
            ->setE164Mask($e164Mask)
            ->setExtension($extension)
            ->setPassword($password)
            ->setPin($pin)
            ->setMiddleName($middleName)
            ->setFirstName($firstName)
            ->setDnCssName($dnCssName)
            ->setPhoneCssName($phoneCssName)
            ->setRoutePartitionName($routePartitionName)
            ->setVoiceMailProfileName($voiceMailProfileName)
            ->setEnableExtensionMobility($enableExtensionMobility)
            ->setDirectoryURI($directoryURI)
            ->setDirectoryNumberURIPartition($directoryNumberURIPartition);
    }
    /**
     * Get userId value
     * @return string
     */
    public function getUserId()
    {
        return $this->userId;
    }
    /**
     * Set userId value
     * @param string $userId
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XUserPhoneAssociation
     */
    public function setUserId($userId = null)
    {
        $this->userId = $userId;
        return $this;
    }
    /**
     * Get lastName value
     * @return string
     */
    public function getLastName()
    {
        return $this->lastName;
    }
    /**
     * Set lastName value
     * @param string $lastName
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XUserPhoneAssociation
     */
    public function setLastName($lastName = null)
    {
        $this->lastName = $lastName;
        return $this;
    }
    /**
     * Get productType value
     * @return string
     */
    public function getProductType()
    {
        return $this->productType;
    }
    /**
     * Set productType value
     * @param string $productType
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XUserPhoneAssociation
     */
    public function setProductType($productType = null)
    {
        $this->productType = $productType;
        return $this;
    }
    /**
     * Get name value
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Set name value
     * @param string $name
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XUserPhoneAssociation
     */
    public function setName($name = null)
    {
        $this->name = $name;
        return $this;
    }
    /**
     * Get e164Mask value
     * @return string
     */
    public function getE164Mask()
    {
        return $this->e164Mask;
    }
    /**
     * Set e164Mask value
     * @param string $e164Mask
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XUserPhoneAssociation
     */
    public function setE164Mask($e164Mask = null)
    {
        $this->e164Mask = $e164Mask;
        return $this;
    }
    /**
     * Get extension value
     * @return string
     */
    public function getExtension()
    {
        return $this->extension;
    }
    /**
     * Set extension value
     * @param string $extension
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XUserPhoneAssociation
     */
    public function setExtension($extension = null)
    {
        $this->extension = $extension;
        return $this;
    }
    /**
     * Get password value
     * @return string|null
     */
    public function getPassword()
    {
        return $this->password;
    }
    /**
     * Set password value
     * @param string $password
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XUserPhoneAssociation
     */
    public function setPassword($password = null)
    {
        $this->password = $password;
        return $this;
    }
    /**
     * Get pin value
     * @return string|null
     */
    public function getPin()
    {
        return $this->pin;
    }
    /**
     * Set pin value
     * @param string $pin
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XUserPhoneAssociation
     */
    public function setPin($pin = null)
    {
        $this->pin = $pin;
        return $this;
    }
    /**
     * Get middleName value
     * @return string|null
     */
    public function getMiddleName()
    {
        return $this->middleName;
    }
    /**
     * Set middleName value
     * @param string $middleName
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XUserPhoneAssociation
     */
    public function setMiddleName($middleName = null)
    {
        $this->middleName = $middleName;
        return $this;
    }
    /**
     * Get firstName value
     * @return string|null
     */
    public function getFirstName()
    {
        return $this->firstName;
    }
    /**
     * Set firstName value
     * @param string $firstName
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XUserPhoneAssociation
     */
    public function setFirstName($firstName = null)
    {
        $this->firstName = $firstName;
        return $this;
    }
    /**
     * Get dnCssName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XFkType|null
     */
    public function getDnCssName()
    {
        return isset($this->dnCssName) ? $this->dnCssName : null;
    }
    /**
     * Set dnCssName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $dnCssName
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XUserPhoneAssociation
     */
    public function setDnCssName(\\Losc\CucmBundle\Model\Webservice\StructType\XFkType $dnCssName = null)
    {
        if (is_null($dnCssName) || (is_array($dnCssName) && empty($dnCssName))) {
            unset($this->dnCssName);
        } else {
            $this->dnCssName = $dnCssName;
        }
        return $this;
    }
    /**
     * Get phoneCssName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XFkType|null
     */
    public function getPhoneCssName()
    {
        return isset($this->phoneCssName) ? $this->phoneCssName : null;
    }
    /**
     * Set phoneCssName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $phoneCssName
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XUserPhoneAssociation
     */
    public function setPhoneCssName(\\Losc\CucmBundle\Model\Webservice\StructType\XFkType $phoneCssName = null)
    {
        if (is_null($phoneCssName) || (is_array($phoneCssName) && empty($phoneCssName))) {
            unset($this->phoneCssName);
        } else {
            $this->phoneCssName = $phoneCssName;
        }
        return $this;
    }
    /**
     * Get routePartitionName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XFkType|null
     */
    public function getRoutePartitionName()
    {
        return isset($this->routePartitionName) ? $this->routePartitionName : null;
    }
    /**
     * Set routePartitionName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $routePartitionName
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XUserPhoneAssociation
     */
    public function setRoutePartitionName(\\Losc\CucmBundle\Model\Webservice\StructType\XFkType $routePartitionName = null)
    {
        if (is_null($routePartitionName) || (is_array($routePartitionName) && empty($routePartitionName))) {
            unset($this->routePartitionName);
        } else {
            $this->routePartitionName = $routePartitionName;
        }
        return $this;
    }
    /**
     * Get voiceMailProfileName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XFkType|null
     */
    public function getVoiceMailProfileName()
    {
        return isset($this->voiceMailProfileName) ? $this->voiceMailProfileName : null;
    }
    /**
     * Set voiceMailProfileName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $voiceMailProfileName
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XUserPhoneAssociation
     */
    public function setVoiceMailProfileName(\\Losc\CucmBundle\Model\Webservice\StructType\XFkType $voiceMailProfileName = null)
    {
        if (is_null($voiceMailProfileName) || (is_array($voiceMailProfileName) && empty($voiceMailProfileName))) {
            unset($this->voiceMailProfileName);
        } else {
            $this->voiceMailProfileName = $voiceMailProfileName;
        }
        return $this;
    }
    /**
     * Get enableExtensionMobility value
     * @return string|null
     */
    public function getEnableExtensionMobility()
    {
        return $this->enableExtensionMobility;
    }
    /**
     * Set enableExtensionMobility value
     * @param string $enableExtensionMobility
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XUserPhoneAssociation
     */
    public function setEnableExtensionMobility($enableExtensionMobility = null)
    {
        $this->enableExtensionMobility = $enableExtensionMobility;
        return $this;
    }
    /**
     * Get DirectoryURI value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDirectoryURI()
    {
        return isset($this->DirectoryURI) ? $this->DirectoryURI : null;
    }
    /**
     * Set DirectoryURI value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $directoryURI
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XUserPhoneAssociation
     */
    public function setDirectoryURI($directoryURI = null)
    {
        if (is_null($directoryURI) || (is_array($directoryURI) && empty($directoryURI))) {
            unset($this->DirectoryURI);
        } else {
            $this->DirectoryURI = $directoryURI;
        }
        return $this;
    }
    /**
     * Get DirectoryNumberURIPartition value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XFkType|null
     */
    public function getDirectoryNumberURIPartition()
    {
        return isset($this->DirectoryNumberURIPartition) ? $this->DirectoryNumberURIPartition : null;
    }
    /**
     * Set DirectoryNumberURIPartition value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $directoryNumberURIPartition
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XUserPhoneAssociation
     */
    public function setDirectoryNumberURIPartition(\\Losc\CucmBundle\Model\Webservice\StructType\XFkType $directoryNumberURIPartition = null)
    {
        if (is_null($directoryNumberURIPartition) || (is_array($directoryNumberURIPartition) && empty($directoryNumberURIPartition))) {
            unset($this->DirectoryNumberURIPartition);
        } else {
            $this->DirectoryNumberURIPartition = $directoryNumberURIPartition;
        }
        return $this;
    }
}
