<?php

namespace \Losc\CucmBundle\Model\Webservice\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for XTimeSchedule StructType
 * @subpackage Structs
 */
class XTimeSchedule extends AbstractStructBase
{
    /**
     * The name
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 50
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $name;
    /**
     * The members
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\Members
     */
    public $members;
    /**
     * The description
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 255
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $description;
    /**
     * The isPublished
     * Meta information extracted from the WSDL
     * - documentation: TimeSchedule cannot be published if it has a todOwnerId assigned to it. Only Administrative Time Schedule can be published.
     * - base: xsd:string
     * - default: false
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $isPublished;
    /**
     * The timeScheduleCategory
     * Meta information extracted from the WSDL
     * - default: Regular
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $timeScheduleCategory;
    /**
     * The todOwnerIdName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $todOwnerIdName;
    /**
     * Constructor method for XTimeSchedule
     * @uses XTimeSchedule::setName()
     * @uses XTimeSchedule::setMembers()
     * @uses XTimeSchedule::setDescription()
     * @uses XTimeSchedule::setIsPublished()
     * @uses XTimeSchedule::setTimeScheduleCategory()
     * @uses XTimeSchedule::setTodOwnerIdName()
     * @param string $name
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\Members $members
     * @param string $description
     * @param string $isPublished
     * @param string $timeScheduleCategory
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $todOwnerIdName
     */
    public function __construct($name = null, \\Losc\CucmBundle\Model\Webservice\StructType\Members $members = null, $description = null, $isPublished = 'false', $timeScheduleCategory = 'Regular', \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $todOwnerIdName = null)
    {
        $this
            ->setName($name)
            ->setMembers($members)
            ->setDescription($description)
            ->setIsPublished($isPublished)
            ->setTimeScheduleCategory($timeScheduleCategory)
            ->setTodOwnerIdName($todOwnerIdName);
    }
    /**
     * Get name value
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Set name value
     * @param string $name
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XTimeSchedule
     */
    public function setName($name = null)
    {
        $this->name = $name;
        return $this;
    }
    /**
     * Get members value
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\Members
     */
    public function getMembers()
    {
        return $this->members;
    }
    /**
     * Set members value
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\Members $members
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XTimeSchedule
     */
    public function setMembers(\\Losc\CucmBundle\Model\Webservice\StructType\Members $members = null)
    {
        $this->members = $members;
        return $this;
    }
    /**
     * Get description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->description;
    }
    /**
     * Set description value
     * @param string $description
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XTimeSchedule
     */
    public function setDescription($description = null)
    {
        $this->description = $description;
        return $this;
    }
    /**
     * Get isPublished value
     * @return string|null
     */
    public function getIsPublished()
    {
        return $this->isPublished;
    }
    /**
     * Set isPublished value
     * @param string $isPublished
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XTimeSchedule
     */
    public function setIsPublished($isPublished = 'false')
    {
        $this->isPublished = $isPublished;
        return $this;
    }
    /**
     * Get timeScheduleCategory value
     * @return string|null
     */
    public function getTimeScheduleCategory()
    {
        return $this->timeScheduleCategory;
    }
    /**
     * Set timeScheduleCategory value
     * @param string $timeScheduleCategory
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XTimeSchedule
     */
    public function setTimeScheduleCategory($timeScheduleCategory = 'Regular')
    {
        $this->timeScheduleCategory = $timeScheduleCategory;
        return $this;
    }
    /**
     * Get todOwnerIdName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XFkType|null
     */
    public function getTodOwnerIdName()
    {
        return isset($this->todOwnerIdName) ? $this->todOwnerIdName : null;
    }
    /**
     * Set todOwnerIdName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $todOwnerIdName
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XTimeSchedule
     */
    public function setTodOwnerIdName(\\Losc\CucmBundle\Model\Webservice\StructType\XFkType $todOwnerIdName = null)
    {
        if (is_null($todOwnerIdName) || (is_array($todOwnerIdName) && empty($todOwnerIdName))) {
            unset($this->todOwnerIdName);
        } else {
            $this->todOwnerIdName = $todOwnerIdName;
        }
        return $this;
    }
}
