<?php

namespace \Losc\CucmBundle\Model\Webservice\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for XSipTrunkSecurityProfile StructType
 * @subpackage Structs
 */
class XSipTrunkSecurityProfile extends AbstractStructBase
{
    /**
     * The name
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 64
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $name;
    /**
     * The sipV150OutboundSdpOfferFiltering
     * Meta information extracted from the WSDL
     * - default: Use Default Filter
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $sipV150OutboundSdpOfferFiltering;
    /**
     * The description
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 100
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $description;
    /**
     * The securityMode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $securityMode;
    /**
     * The incomingTransport
     * Meta information extracted from the WSDL
     * - default: TCP+UDP
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $incomingTransport;
    /**
     * The outgoingTransport
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $outgoingTransport;
    /**
     * The digestAuthentication
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - default: false
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $digestAuthentication;
    /**
     * The noncePolicyTime
     * Meta information extracted from the WSDL
     * - documentation: Only if digestAuthentication is enabled this value can be changed.
     * - default: 600
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $noncePolicyTime;
    /**
     * The x509SubjectName
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 4096
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $x509SubjectName;
    /**
     * The incomingPort
     * Meta information extracted from the WSDL
     * - default: 5060
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $incomingPort;
    /**
     * The applLevelAuthentication
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - default: false
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $applLevelAuthentication;
    /**
     * The acceptPresenceSubscription
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - default: false
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $acceptPresenceSubscription;
    /**
     * The acceptOutOfDialogRefer
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - default: false
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $acceptOutOfDialogRefer;
    /**
     * The acceptUnsolicitedNotification
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - default: false
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $acceptUnsolicitedNotification;
    /**
     * The allowReplaceHeader
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - default: false
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $allowReplaceHeader;
    /**
     * The transmitSecurityStatus
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - default: false
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $transmitSecurityStatus;
    /**
     * The allowChargingHeader
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - default: false
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $allowChargingHeader;
    /**
     * Constructor method for XSipTrunkSecurityProfile
     * @uses XSipTrunkSecurityProfile::setName()
     * @uses XSipTrunkSecurityProfile::setSipV150OutboundSdpOfferFiltering()
     * @uses XSipTrunkSecurityProfile::setDescription()
     * @uses XSipTrunkSecurityProfile::setSecurityMode()
     * @uses XSipTrunkSecurityProfile::setIncomingTransport()
     * @uses XSipTrunkSecurityProfile::setOutgoingTransport()
     * @uses XSipTrunkSecurityProfile::setDigestAuthentication()
     * @uses XSipTrunkSecurityProfile::setNoncePolicyTime()
     * @uses XSipTrunkSecurityProfile::setX509SubjectName()
     * @uses XSipTrunkSecurityProfile::setIncomingPort()
     * @uses XSipTrunkSecurityProfile::setApplLevelAuthentication()
     * @uses XSipTrunkSecurityProfile::setAcceptPresenceSubscription()
     * @uses XSipTrunkSecurityProfile::setAcceptOutOfDialogRefer()
     * @uses XSipTrunkSecurityProfile::setAcceptUnsolicitedNotification()
     * @uses XSipTrunkSecurityProfile::setAllowReplaceHeader()
     * @uses XSipTrunkSecurityProfile::setTransmitSecurityStatus()
     * @uses XSipTrunkSecurityProfile::setAllowChargingHeader()
     * @param string $name
     * @param string $sipV150OutboundSdpOfferFiltering
     * @param string $description
     * @param string $securityMode
     * @param string $incomingTransport
     * @param string $outgoingTransport
     * @param string $digestAuthentication
     * @param string $noncePolicyTime
     * @param string $x509SubjectName
     * @param string $incomingPort
     * @param string $applLevelAuthentication
     * @param string $acceptPresenceSubscription
     * @param string $acceptOutOfDialogRefer
     * @param string $acceptUnsolicitedNotification
     * @param string $allowReplaceHeader
     * @param string $transmitSecurityStatus
     * @param string $allowChargingHeader
     */
    public function __construct($name = null, $sipV150OutboundSdpOfferFiltering = 'Use Default Filter', $description = null, $securityMode = null, $incomingTransport = 'TCP+UDP', $outgoingTransport = null, $digestAuthentication = 'false', $noncePolicyTime = '600', $x509SubjectName = null, $incomingPort = '5060', $applLevelAuthentication = 'false', $acceptPresenceSubscription = 'false', $acceptOutOfDialogRefer = 'false', $acceptUnsolicitedNotification = 'false', $allowReplaceHeader = 'false', $transmitSecurityStatus = 'false', $allowChargingHeader = 'false')
    {
        $this
            ->setName($name)
            ->setSipV150OutboundSdpOfferFiltering($sipV150OutboundSdpOfferFiltering)
            ->setDescription($description)
            ->setSecurityMode($securityMode)
            ->setIncomingTransport($incomingTransport)
            ->setOutgoingTransport($outgoingTransport)
            ->setDigestAuthentication($digestAuthentication)
            ->setNoncePolicyTime($noncePolicyTime)
            ->setX509SubjectName($x509SubjectName)
            ->setIncomingPort($incomingPort)
            ->setApplLevelAuthentication($applLevelAuthentication)
            ->setAcceptPresenceSubscription($acceptPresenceSubscription)
            ->setAcceptOutOfDialogRefer($acceptOutOfDialogRefer)
            ->setAcceptUnsolicitedNotification($acceptUnsolicitedNotification)
            ->setAllowReplaceHeader($allowReplaceHeader)
            ->setTransmitSecurityStatus($transmitSecurityStatus)
            ->setAllowChargingHeader($allowChargingHeader);
    }
    /**
     * Get name value
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Set name value
     * @param string $name
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XSipTrunkSecurityProfile
     */
    public function setName($name = null)
    {
        $this->name = $name;
        return $this;
    }
    /**
     * Get sipV150OutboundSdpOfferFiltering value
     * @return string
     */
    public function getSipV150OutboundSdpOfferFiltering()
    {
        return $this->sipV150OutboundSdpOfferFiltering;
    }
    /**
     * Set sipV150OutboundSdpOfferFiltering value
     * @param string $sipV150OutboundSdpOfferFiltering
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XSipTrunkSecurityProfile
     */
    public function setSipV150OutboundSdpOfferFiltering($sipV150OutboundSdpOfferFiltering = 'Use Default Filter')
    {
        $this->sipV150OutboundSdpOfferFiltering = $sipV150OutboundSdpOfferFiltering;
        return $this;
    }
    /**
     * Get description value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDescription()
    {
        return isset($this->description) ? $this->description : null;
    }
    /**
     * Set description value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $description
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XSipTrunkSecurityProfile
     */
    public function setDescription($description = null)
    {
        if (is_null($description) || (is_array($description) && empty($description))) {
            unset($this->description);
        } else {
            $this->description = $description;
        }
        return $this;
    }
    /**
     * Get securityMode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSecurityMode()
    {
        return isset($this->securityMode) ? $this->securityMode : null;
    }
    /**
     * Set securityMode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $securityMode
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XSipTrunkSecurityProfile
     */
    public function setSecurityMode($securityMode = null)
    {
        if (is_null($securityMode) || (is_array($securityMode) && empty($securityMode))) {
            unset($this->securityMode);
        } else {
            $this->securityMode = $securityMode;
        }
        return $this;
    }
    /**
     * Get incomingTransport value
     * @return string|null
     */
    public function getIncomingTransport()
    {
        return $this->incomingTransport;
    }
    /**
     * Set incomingTransport value
     * @param string $incomingTransport
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XSipTrunkSecurityProfile
     */
    public function setIncomingTransport($incomingTransport = 'TCP+UDP')
    {
        $this->incomingTransport = $incomingTransport;
        return $this;
    }
    /**
     * Get outgoingTransport value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOutgoingTransport()
    {
        return isset($this->outgoingTransport) ? $this->outgoingTransport : null;
    }
    /**
     * Set outgoingTransport value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $outgoingTransport
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XSipTrunkSecurityProfile
     */
    public function setOutgoingTransport($outgoingTransport = null)
    {
        if (is_null($outgoingTransport) || (is_array($outgoingTransport) && empty($outgoingTransport))) {
            unset($this->outgoingTransport);
        } else {
            $this->outgoingTransport = $outgoingTransport;
        }
        return $this;
    }
    /**
     * Get digestAuthentication value
     * @return string|null
     */
    public function getDigestAuthentication()
    {
        return $this->digestAuthentication;
    }
    /**
     * Set digestAuthentication value
     * @param string $digestAuthentication
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XSipTrunkSecurityProfile
     */
    public function setDigestAuthentication($digestAuthentication = 'false')
    {
        $this->digestAuthentication = $digestAuthentication;
        return $this;
    }
    /**
     * Get noncePolicyTime value
     * @return string|null
     */
    public function getNoncePolicyTime()
    {
        return $this->noncePolicyTime;
    }
    /**
     * Set noncePolicyTime value
     * @param string $noncePolicyTime
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XSipTrunkSecurityProfile
     */
    public function setNoncePolicyTime($noncePolicyTime = '600')
    {
        $this->noncePolicyTime = $noncePolicyTime;
        return $this;
    }
    /**
     * Get x509SubjectName value
     * @return string|null
     */
    public function getX509SubjectName()
    {
        return $this->x509SubjectName;
    }
    /**
     * Set x509SubjectName value
     * @param string $x509SubjectName
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XSipTrunkSecurityProfile
     */
    public function setX509SubjectName($x509SubjectName = null)
    {
        $this->x509SubjectName = $x509SubjectName;
        return $this;
    }
    /**
     * Get incomingPort value
     * @return string|null
     */
    public function getIncomingPort()
    {
        return $this->incomingPort;
    }
    /**
     * Set incomingPort value
     * @param string $incomingPort
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XSipTrunkSecurityProfile
     */
    public function setIncomingPort($incomingPort = '5060')
    {
        $this->incomingPort = $incomingPort;
        return $this;
    }
    /**
     * Get applLevelAuthentication value
     * @return string|null
     */
    public function getApplLevelAuthentication()
    {
        return $this->applLevelAuthentication;
    }
    /**
     * Set applLevelAuthentication value
     * @param string $applLevelAuthentication
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XSipTrunkSecurityProfile
     */
    public function setApplLevelAuthentication($applLevelAuthentication = 'false')
    {
        $this->applLevelAuthentication = $applLevelAuthentication;
        return $this;
    }
    /**
     * Get acceptPresenceSubscription value
     * @return string|null
     */
    public function getAcceptPresenceSubscription()
    {
        return $this->acceptPresenceSubscription;
    }
    /**
     * Set acceptPresenceSubscription value
     * @param string $acceptPresenceSubscription
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XSipTrunkSecurityProfile
     */
    public function setAcceptPresenceSubscription($acceptPresenceSubscription = 'false')
    {
        $this->acceptPresenceSubscription = $acceptPresenceSubscription;
        return $this;
    }
    /**
     * Get acceptOutOfDialogRefer value
     * @return string|null
     */
    public function getAcceptOutOfDialogRefer()
    {
        return $this->acceptOutOfDialogRefer;
    }
    /**
     * Set acceptOutOfDialogRefer value
     * @param string $acceptOutOfDialogRefer
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XSipTrunkSecurityProfile
     */
    public function setAcceptOutOfDialogRefer($acceptOutOfDialogRefer = 'false')
    {
        $this->acceptOutOfDialogRefer = $acceptOutOfDialogRefer;
        return $this;
    }
    /**
     * Get acceptUnsolicitedNotification value
     * @return string|null
     */
    public function getAcceptUnsolicitedNotification()
    {
        return $this->acceptUnsolicitedNotification;
    }
    /**
     * Set acceptUnsolicitedNotification value
     * @param string $acceptUnsolicitedNotification
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XSipTrunkSecurityProfile
     */
    public function setAcceptUnsolicitedNotification($acceptUnsolicitedNotification = 'false')
    {
        $this->acceptUnsolicitedNotification = $acceptUnsolicitedNotification;
        return $this;
    }
    /**
     * Get allowReplaceHeader value
     * @return string|null
     */
    public function getAllowReplaceHeader()
    {
        return $this->allowReplaceHeader;
    }
    /**
     * Set allowReplaceHeader value
     * @param string $allowReplaceHeader
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XSipTrunkSecurityProfile
     */
    public function setAllowReplaceHeader($allowReplaceHeader = 'false')
    {
        $this->allowReplaceHeader = $allowReplaceHeader;
        return $this;
    }
    /**
     * Get transmitSecurityStatus value
     * @return string|null
     */
    public function getTransmitSecurityStatus()
    {
        return $this->transmitSecurityStatus;
    }
    /**
     * Set transmitSecurityStatus value
     * @param string $transmitSecurityStatus
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XSipTrunkSecurityProfile
     */
    public function setTransmitSecurityStatus($transmitSecurityStatus = 'false')
    {
        $this->transmitSecurityStatus = $transmitSecurityStatus;
        return $this;
    }
    /**
     * Get allowChargingHeader value
     * @return string|null
     */
    public function getAllowChargingHeader()
    {
        return $this->allowChargingHeader;
    }
    /**
     * Set allowChargingHeader value
     * @param string $allowChargingHeader
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XSipTrunkSecurityProfile
     */
    public function setAllowChargingHeader($allowChargingHeader = 'false')
    {
        $this->allowChargingHeader = $allowChargingHeader;
        return $this;
    }
}
