<?php

namespace \Losc\CucmBundle\Model\Webservice\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for XSIPNormalizationScript StructType
 * @subpackage Structs
 */
class XSIPNormalizationScript extends AbstractStructBase
{
    /**
     * The name
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $name;
    /**
     * The content
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $content;
    /**
     * The scriptExecutionErrorRecoveryAction
     * Meta information extracted from the WSDL
     * - default: Message Rollback Only
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $scriptExecutionErrorRecoveryAction;
    /**
     * The systemResourceErrorRecoveryAction
     * Meta information extracted from the WSDL
     * - default: Disable Script
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $systemResourceErrorRecoveryAction;
    /**
     * The maxMemoryThreshold
     * Meta information extracted from the WSDL
     * - default: 50
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $maxMemoryThreshold;
    /**
     * The maxLuaInstructionsThreshold
     * Meta information extracted from the WSDL
     * - default: 1000
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $maxLuaInstructionsThreshold;
    /**
     * The isStandard
     * Meta information extracted from the WSDL
     * - documentation: If the value of isStandard is t (true), the fields are not editable.
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $isStandard;
    /**
     * The description
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $description;
    /**
     * Constructor method for XSIPNormalizationScript
     * @uses XSIPNormalizationScript::setName()
     * @uses XSIPNormalizationScript::setContent()
     * @uses XSIPNormalizationScript::setScriptExecutionErrorRecoveryAction()
     * @uses XSIPNormalizationScript::setSystemResourceErrorRecoveryAction()
     * @uses XSIPNormalizationScript::setMaxMemoryThreshold()
     * @uses XSIPNormalizationScript::setMaxLuaInstructionsThreshold()
     * @uses XSIPNormalizationScript::setIsStandard()
     * @uses XSIPNormalizationScript::setDescription()
     * @param string $name
     * @param string $content
     * @param string $scriptExecutionErrorRecoveryAction
     * @param string $systemResourceErrorRecoveryAction
     * @param string $maxMemoryThreshold
     * @param string $maxLuaInstructionsThreshold
     * @param string $isStandard
     * @param string $description
     */
    public function __construct($name = null, $content = null, $scriptExecutionErrorRecoveryAction = 'Message Rollback Only', $systemResourceErrorRecoveryAction = 'Disable Script', $maxMemoryThreshold = '50', $maxLuaInstructionsThreshold = '1000', $isStandard = null, $description = null)
    {
        $this
            ->setName($name)
            ->setContent($content)
            ->setScriptExecutionErrorRecoveryAction($scriptExecutionErrorRecoveryAction)
            ->setSystemResourceErrorRecoveryAction($systemResourceErrorRecoveryAction)
            ->setMaxMemoryThreshold($maxMemoryThreshold)
            ->setMaxLuaInstructionsThreshold($maxLuaInstructionsThreshold)
            ->setIsStandard($isStandard)
            ->setDescription($description);
    }
    /**
     * Get name value
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Set name value
     * @param string $name
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XSIPNormalizationScript
     */
    public function setName($name = null)
    {
        $this->name = $name;
        return $this;
    }
    /**
     * Get content value
     * @return string
     */
    public function getContent()
    {
        return $this->content;
    }
    /**
     * Set content value
     * @param string $content
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XSIPNormalizationScript
     */
    public function setContent($content = null)
    {
        $this->content = $content;
        return $this;
    }
    /**
     * Get scriptExecutionErrorRecoveryAction value
     * @return string
     */
    public function getScriptExecutionErrorRecoveryAction()
    {
        return $this->scriptExecutionErrorRecoveryAction;
    }
    /**
     * Set scriptExecutionErrorRecoveryAction value
     * @param string $scriptExecutionErrorRecoveryAction
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XSIPNormalizationScript
     */
    public function setScriptExecutionErrorRecoveryAction($scriptExecutionErrorRecoveryAction = 'Message Rollback Only')
    {
        $this->scriptExecutionErrorRecoveryAction = $scriptExecutionErrorRecoveryAction;
        return $this;
    }
    /**
     * Get systemResourceErrorRecoveryAction value
     * @return string
     */
    public function getSystemResourceErrorRecoveryAction()
    {
        return $this->systemResourceErrorRecoveryAction;
    }
    /**
     * Set systemResourceErrorRecoveryAction value
     * @param string $systemResourceErrorRecoveryAction
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XSIPNormalizationScript
     */
    public function setSystemResourceErrorRecoveryAction($systemResourceErrorRecoveryAction = 'Disable Script')
    {
        $this->systemResourceErrorRecoveryAction = $systemResourceErrorRecoveryAction;
        return $this;
    }
    /**
     * Get maxMemoryThreshold value
     * @return string
     */
    public function getMaxMemoryThreshold()
    {
        return $this->maxMemoryThreshold;
    }
    /**
     * Set maxMemoryThreshold value
     * @param string $maxMemoryThreshold
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XSIPNormalizationScript
     */
    public function setMaxMemoryThreshold($maxMemoryThreshold = '50')
    {
        $this->maxMemoryThreshold = $maxMemoryThreshold;
        return $this;
    }
    /**
     * Get maxLuaInstructionsThreshold value
     * @return string
     */
    public function getMaxLuaInstructionsThreshold()
    {
        return $this->maxLuaInstructionsThreshold;
    }
    /**
     * Set maxLuaInstructionsThreshold value
     * @param string $maxLuaInstructionsThreshold
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XSIPNormalizationScript
     */
    public function setMaxLuaInstructionsThreshold($maxLuaInstructionsThreshold = '1000')
    {
        $this->maxLuaInstructionsThreshold = $maxLuaInstructionsThreshold;
        return $this;
    }
    /**
     * Get isStandard value
     * @return string
     */
    public function getIsStandard()
    {
        return $this->isStandard;
    }
    /**
     * Set isStandard value
     * @param string $isStandard
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XSIPNormalizationScript
     */
    public function setIsStandard($isStandard = null)
    {
        $this->isStandard = $isStandard;
        return $this;
    }
    /**
     * Get description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->description;
    }
    /**
     * Set description value
     * @param string $description
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XSIPNormalizationScript
     */
    public function setDescription($description = null)
    {
        $this->description = $description;
        return $this;
    }
}
