<?php

namespace \Losc\CucmBundle\Model\Webservice\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for XPhoneSecurityProfile StructType
 * @subpackage Structs
 */
class XPhoneSecurityProfile extends AbstractStructBase
{
    /**
     * The phoneType
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $phoneType;
    /**
     * The protocol
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $protocol;
    /**
     * The name
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $name;
    /**
     * The description
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $description;
    /**
     * The deviceSecurityMode
     * Meta information extracted from the WSDL
     * - documentation: Applicable only for sip phones
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $deviceSecurityMode;
    /**
     * The authenticationMode
     * Meta information extracted from the WSDL
     * - documentation: Applicable only for sip phones
     * - default: By Null String
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $authenticationMode;
    /**
     * The keySize
     * Meta information extracted from the WSDL
     * - documentation: Applicable only for sip phones
     * - default: 1024
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $keySize;
    /**
     * The tftpEncryptedConfig
     * Meta information extracted from the WSDL
     * - documentation: Applicable only for sip phones
     * - base: xsd:string
     * - default: false
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $tftpEncryptedConfig;
    /**
     * The nonceValidityTime
     * Meta information extracted from the WSDL
     * - documentation: Applicable only for sip phones
     * - default: 600
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $nonceValidityTime;
    /**
     * The transportType
     * Meta information extracted from the WSDL
     * - documentation: Applicable only for sip phones
     * - default: TCP+UDP
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $transportType;
    /**
     * The sipPhonePort
     * Meta information extracted from the WSDL
     * - documentation: Applicable only for sip phones
     * - default: 5060
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $sipPhonePort;
    /**
     * The enableDigestAuthentication
     * Meta information extracted from the WSDL
     * - documentation: Applicable only for sip phones
     * - base: xsd:string
     * - default: false
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $enableDigestAuthentication;
    /**
     * The excludeDigestCredentials
     * Meta information extracted from the WSDL
     * - documentation: Applicable only for sip phones
     * - base: xsd:string
     * - default: false
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $excludeDigestCredentials;
    /**
     * Constructor method for XPhoneSecurityProfile
     * @uses XPhoneSecurityProfile::setPhoneType()
     * @uses XPhoneSecurityProfile::setProtocol()
     * @uses XPhoneSecurityProfile::setName()
     * @uses XPhoneSecurityProfile::setDescription()
     * @uses XPhoneSecurityProfile::setDeviceSecurityMode()
     * @uses XPhoneSecurityProfile::setAuthenticationMode()
     * @uses XPhoneSecurityProfile::setKeySize()
     * @uses XPhoneSecurityProfile::setTftpEncryptedConfig()
     * @uses XPhoneSecurityProfile::setNonceValidityTime()
     * @uses XPhoneSecurityProfile::setTransportType()
     * @uses XPhoneSecurityProfile::setSipPhonePort()
     * @uses XPhoneSecurityProfile::setEnableDigestAuthentication()
     * @uses XPhoneSecurityProfile::setExcludeDigestCredentials()
     * @param string $phoneType
     * @param string $protocol
     * @param string $name
     * @param string $description
     * @param string $deviceSecurityMode
     * @param string $authenticationMode
     * @param string $keySize
     * @param string $tftpEncryptedConfig
     * @param string $nonceValidityTime
     * @param string $transportType
     * @param string $sipPhonePort
     * @param string $enableDigestAuthentication
     * @param string $excludeDigestCredentials
     */
    public function __construct($phoneType = null, $protocol = null, $name = null, $description = null, $deviceSecurityMode = null, $authenticationMode = 'By Null String', $keySize = '1024', $tftpEncryptedConfig = 'false', $nonceValidityTime = '600', $transportType = 'TCP+UDP', $sipPhonePort = '5060', $enableDigestAuthentication = 'false', $excludeDigestCredentials = 'false')
    {
        $this
            ->setPhoneType($phoneType)
            ->setProtocol($protocol)
            ->setName($name)
            ->setDescription($description)
            ->setDeviceSecurityMode($deviceSecurityMode)
            ->setAuthenticationMode($authenticationMode)
            ->setKeySize($keySize)
            ->setTftpEncryptedConfig($tftpEncryptedConfig)
            ->setNonceValidityTime($nonceValidityTime)
            ->setTransportType($transportType)
            ->setSipPhonePort($sipPhonePort)
            ->setEnableDigestAuthentication($enableDigestAuthentication)
            ->setExcludeDigestCredentials($excludeDigestCredentials);
    }
    /**
     * Get phoneType value
     * @return string
     */
    public function getPhoneType()
    {
        return $this->phoneType;
    }
    /**
     * Set phoneType value
     * @param string $phoneType
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XPhoneSecurityProfile
     */
    public function setPhoneType($phoneType = null)
    {
        $this->phoneType = $phoneType;
        return $this;
    }
    /**
     * Get protocol value
     * @return string
     */
    public function getProtocol()
    {
        return $this->protocol;
    }
    /**
     * Set protocol value
     * @param string $protocol
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XPhoneSecurityProfile
     */
    public function setProtocol($protocol = null)
    {
        $this->protocol = $protocol;
        return $this;
    }
    /**
     * Get name value
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Set name value
     * @param string $name
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XPhoneSecurityProfile
     */
    public function setName($name = null)
    {
        $this->name = $name;
        return $this;
    }
    /**
     * Get description value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDescription()
    {
        return isset($this->description) ? $this->description : null;
    }
    /**
     * Set description value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $description
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XPhoneSecurityProfile
     */
    public function setDescription($description = null)
    {
        if (is_null($description) || (is_array($description) && empty($description))) {
            unset($this->description);
        } else {
            $this->description = $description;
        }
        return $this;
    }
    /**
     * Get deviceSecurityMode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDeviceSecurityMode()
    {
        return isset($this->deviceSecurityMode) ? $this->deviceSecurityMode : null;
    }
    /**
     * Set deviceSecurityMode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $deviceSecurityMode
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XPhoneSecurityProfile
     */
    public function setDeviceSecurityMode($deviceSecurityMode = null)
    {
        if (is_null($deviceSecurityMode) || (is_array($deviceSecurityMode) && empty($deviceSecurityMode))) {
            unset($this->deviceSecurityMode);
        } else {
            $this->deviceSecurityMode = $deviceSecurityMode;
        }
        return $this;
    }
    /**
     * Get authenticationMode value
     * @return string|null
     */
    public function getAuthenticationMode()
    {
        return $this->authenticationMode;
    }
    /**
     * Set authenticationMode value
     * @param string $authenticationMode
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XPhoneSecurityProfile
     */
    public function setAuthenticationMode($authenticationMode = 'By Null String')
    {
        $this->authenticationMode = $authenticationMode;
        return $this;
    }
    /**
     * Get keySize value
     * @return string|null
     */
    public function getKeySize()
    {
        return $this->keySize;
    }
    /**
     * Set keySize value
     * @param string $keySize
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XPhoneSecurityProfile
     */
    public function setKeySize($keySize = '1024')
    {
        $this->keySize = $keySize;
        return $this;
    }
    /**
     * Get tftpEncryptedConfig value
     * @return string|null
     */
    public function getTftpEncryptedConfig()
    {
        return $this->tftpEncryptedConfig;
    }
    /**
     * Set tftpEncryptedConfig value
     * @param string $tftpEncryptedConfig
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XPhoneSecurityProfile
     */
    public function setTftpEncryptedConfig($tftpEncryptedConfig = 'false')
    {
        $this->tftpEncryptedConfig = $tftpEncryptedConfig;
        return $this;
    }
    /**
     * Get nonceValidityTime value
     * @return string|null
     */
    public function getNonceValidityTime()
    {
        return $this->nonceValidityTime;
    }
    /**
     * Set nonceValidityTime value
     * @param string $nonceValidityTime
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XPhoneSecurityProfile
     */
    public function setNonceValidityTime($nonceValidityTime = '600')
    {
        $this->nonceValidityTime = $nonceValidityTime;
        return $this;
    }
    /**
     * Get transportType value
     * @return string|null
     */
    public function getTransportType()
    {
        return $this->transportType;
    }
    /**
     * Set transportType value
     * @param string $transportType
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XPhoneSecurityProfile
     */
    public function setTransportType($transportType = 'TCP+UDP')
    {
        $this->transportType = $transportType;
        return $this;
    }
    /**
     * Get sipPhonePort value
     * @return string|null
     */
    public function getSipPhonePort()
    {
        return $this->sipPhonePort;
    }
    /**
     * Set sipPhonePort value
     * @param string $sipPhonePort
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XPhoneSecurityProfile
     */
    public function setSipPhonePort($sipPhonePort = '5060')
    {
        $this->sipPhonePort = $sipPhonePort;
        return $this;
    }
    /**
     * Get enableDigestAuthentication value
     * @return string|null
     */
    public function getEnableDigestAuthentication()
    {
        return $this->enableDigestAuthentication;
    }
    /**
     * Set enableDigestAuthentication value
     * @param string $enableDigestAuthentication
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XPhoneSecurityProfile
     */
    public function setEnableDigestAuthentication($enableDigestAuthentication = 'false')
    {
        $this->enableDigestAuthentication = $enableDigestAuthentication;
        return $this;
    }
    /**
     * Get excludeDigestCredentials value
     * @return string|null
     */
    public function getExcludeDigestCredentials()
    {
        return $this->excludeDigestCredentials;
    }
    /**
     * Set excludeDigestCredentials value
     * @param string $excludeDigestCredentials
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XPhoneSecurityProfile
     */
    public function setExcludeDigestCredentials($excludeDigestCredentials = 'false')
    {
        $this->excludeDigestCredentials = $excludeDigestCredentials;
        return $this;
    }
}
