<?php

namespace \Losc\CucmBundle\Model\Webservice\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for XMobilityProfile StructType
 * @subpackage Structs
 */
class XMobilityProfile extends AbstractStructBase
{
    /**
     * The name
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 50
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $name;
    /**
     * The description
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $description;
    /**
     * The mobileClientCallingOption
     * Meta information extracted from the WSDL
     * - default: Dial via Office Reverse
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $mobileClientCallingOption;
    /**
     * The dvofServiceAccessNumber
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $dvofServiceAccessNumber;
    /**
     * The dirn
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\XDirn
     */
    public $dirn;
    /**
     * The dvorCallerId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $dvorCallerId;
    /**
     * Constructor method for XMobilityProfile
     * @uses XMobilityProfile::setName()
     * @uses XMobilityProfile::setDescription()
     * @uses XMobilityProfile::setMobileClientCallingOption()
     * @uses XMobilityProfile::setDvofServiceAccessNumber()
     * @uses XMobilityProfile::setDirn()
     * @uses XMobilityProfile::setDvorCallerId()
     * @param string $name
     * @param string $description
     * @param string $mobileClientCallingOption
     * @param string $dvofServiceAccessNumber
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XDirn $dirn
     * @param string $dvorCallerId
     */
    public function __construct($name = null, $description = null, $mobileClientCallingOption = 'Dial via Office Reverse', $dvofServiceAccessNumber = null, \\Losc\CucmBundle\Model\Webservice\StructType\XDirn $dirn = null, $dvorCallerId = null)
    {
        $this
            ->setName($name)
            ->setDescription($description)
            ->setMobileClientCallingOption($mobileClientCallingOption)
            ->setDvofServiceAccessNumber($dvofServiceAccessNumber)
            ->setDirn($dirn)
            ->setDvorCallerId($dvorCallerId);
    }
    /**
     * Get name value
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Set name value
     * @param string $name
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XMobilityProfile
     */
    public function setName($name = null)
    {
        $this->name = $name;
        return $this;
    }
    /**
     * Get description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->description;
    }
    /**
     * Set description value
     * @param string $description
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XMobilityProfile
     */
    public function setDescription($description = null)
    {
        $this->description = $description;
        return $this;
    }
    /**
     * Get mobileClientCallingOption value
     * @return string|null
     */
    public function getMobileClientCallingOption()
    {
        return $this->mobileClientCallingOption;
    }
    /**
     * Set mobileClientCallingOption value
     * @param string $mobileClientCallingOption
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XMobilityProfile
     */
    public function setMobileClientCallingOption($mobileClientCallingOption = 'Dial via Office Reverse')
    {
        $this->mobileClientCallingOption = $mobileClientCallingOption;
        return $this;
    }
    /**
     * Get dvofServiceAccessNumber value
     * @return string|null
     */
    public function getDvofServiceAccessNumber()
    {
        return $this->dvofServiceAccessNumber;
    }
    /**
     * Set dvofServiceAccessNumber value
     * @param string $dvofServiceAccessNumber
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XMobilityProfile
     */
    public function setDvofServiceAccessNumber($dvofServiceAccessNumber = null)
    {
        $this->dvofServiceAccessNumber = $dvofServiceAccessNumber;
        return $this;
    }
    /**
     * Get dirn value
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XDirn|null
     */
    public function getDirn()
    {
        return $this->dirn;
    }
    /**
     * Set dirn value
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XDirn $dirn
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XMobilityProfile
     */
    public function setDirn(\\Losc\CucmBundle\Model\Webservice\StructType\XDirn $dirn = null)
    {
        $this->dirn = $dirn;
        return $this;
    }
    /**
     * Get dvorCallerId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDvorCallerId()
    {
        return isset($this->dvorCallerId) ? $this->dvorCallerId : null;
    }
    /**
     * Set dvorCallerId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $dvorCallerId
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XMobilityProfile
     */
    public function setDvorCallerId($dvorCallerId = null)
    {
        if (is_null($dvorCallerId) || (is_array($dvorCallerId) && empty($dvorCallerId))) {
            unset($this->dvorCallerId);
        } else {
            $this->dvorCallerId = $dvorCallerId;
        }
        return $this;
    }
}
