<?php

namespace \Losc\CucmBundle\Model\Webservice\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for XImeFirewall StructType
 * @subpackage Structs
 */
class XImeFirewall extends AbstractStructBase
{
    /**
     * The name
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 50
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $name;
    /**
     * The ipAddress
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 15
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $ipAddress;
    /**
     * The description
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $description;
    /**
     * The port
     * Meta information extracted from the WSDL
     * - default: 8060
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $port;
    /**
     * Constructor method for XImeFirewall
     * @uses XImeFirewall::setName()
     * @uses XImeFirewall::setIpAddress()
     * @uses XImeFirewall::setDescription()
     * @uses XImeFirewall::setPort()
     * @param string $name
     * @param string $ipAddress
     * @param string $description
     * @param string $port
     */
    public function __construct($name = null, $ipAddress = null, $description = null, $port = '8060')
    {
        $this
            ->setName($name)
            ->setIpAddress($ipAddress)
            ->setDescription($description)
            ->setPort($port);
    }
    /**
     * Get name value
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Set name value
     * @param string $name
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XImeFirewall
     */
    public function setName($name = null)
    {
        $this->name = $name;
        return $this;
    }
    /**
     * Get ipAddress value
     * @return string
     */
    public function getIpAddress()
    {
        return $this->ipAddress;
    }
    /**
     * Set ipAddress value
     * @param string $ipAddress
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XImeFirewall
     */
    public function setIpAddress($ipAddress = null)
    {
        $this->ipAddress = $ipAddress;
        return $this;
    }
    /**
     * Get description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->description;
    }
    /**
     * Set description value
     * @param string $description
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XImeFirewall
     */
    public function setDescription($description = null)
    {
        $this->description = $description;
        return $this;
    }
    /**
     * Get port value
     * @return string|null
     */
    public function getPort()
    {
        return $this->port;
    }
    /**
     * Set port value
     * @param string $port
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XImeFirewall
     */
    public function setPort($port = '8060')
    {
        $this->port = $port;
        return $this;
    }
}
