<?php

namespace \Losc\CucmBundle\Model\Webservice\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for XHuntPilot StructType
 * @subpackage Structs
 */
class XHuntPilot extends AbstractStructBase
{
    /**
     * The pattern
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $pattern;
    /**
     * The blockEnable
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $blockEnable;
    /**
     * The useCallingPartyPhoneMask
     * Meta information extracted from the WSDL
     * - default: Default
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $useCallingPartyPhoneMask;
    /**
     * The huntListName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $huntListName;
    /**
     * The description
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $description;
    /**
     * The routePartitionName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $routePartitionName;
    /**
     * The calledPartyTransformationMask
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $calledPartyTransformationMask;
    /**
     * The callingPartyTransformationMask
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $callingPartyTransformationMask;
    /**
     * The callingPartyPrefixDigits
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 50
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $callingPartyPrefixDigits;
    /**
     * The dialPlanName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $dialPlanName;
    /**
     * The digitDiscardInstructionName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $digitDiscardInstructionName;
    /**
     * The patternUrgency
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $patternUrgency;
    /**
     * The prefixDigitsOut
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $prefixDigitsOut;
    /**
     * The routeFilterName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $routeFilterName;
    /**
     * The callingLinePresentationBit
     * Meta information extracted from the WSDL
     * - default: Default
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $callingLinePresentationBit;
    /**
     * The callingNamePresentationBit
     * Meta information extracted from the WSDL
     * - default: Default
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $callingNamePresentationBit;
    /**
     * The connectedLinePresentationBit
     * Meta information extracted from the WSDL
     * - default: Default
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $connectedLinePresentationBit;
    /**
     * The connectedNamePresentationBit
     * Meta information extracted from the WSDL
     * - default: Default
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $connectedNamePresentationBit;
    /**
     * The patternPrecedence
     * Meta information extracted from the WSDL
     * - default: Default
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $patternPrecedence;
    /**
     * The provideOutsideDialtone
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - default: true
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $provideOutsideDialtone;
    /**
     * The callingPartyNumberingPlan
     * Meta information extracted from the WSDL
     * - default: Cisco CallManager
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $callingPartyNumberingPlan;
    /**
     * The callingPartyNumberType
     * Meta information extracted from the WSDL
     * - default: Cisco CallManager
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $callingPartyNumberType;
    /**
     * The calledPartyNumberingPlan
     * Meta information extracted from the WSDL
     * - default: Cisco CallManager
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $calledPartyNumberingPlan;
    /**
     * The calledPartyNumberType
     * Meta information extracted from the WSDL
     * - default: Cisco CallManager
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $calledPartyNumberType;
    /**
     * The parkMonForwardNoRetrieve
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\ParkMonForwardNoRetrieve
     */
    public $parkMonForwardNoRetrieve;
    /**
     * The alertingName
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 50
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $alertingName;
    /**
     * The asciiAlertingName
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 32
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $asciiAlertingName;
    /**
     * The e164Mask
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $e164Mask;
    /**
     * The aarNeighborhoodName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $aarNeighborhoodName;
    /**
     * The forwardHuntNoAnswer
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\ForwardHuntNoAnswer
     */
    public $forwardHuntNoAnswer;
    /**
     * The forwardHuntBusy
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\ForwardHuntBusy
     */
    public $forwardHuntBusy;
    /**
     * The callPickupGroupName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $callPickupGroupName;
    /**
     * The maxHuntduration
     * Meta information extracted from the WSDL
     * - documentation: Value "-1" in the response means no value has been assigned and internally the CM will use default setting i.e., 1800s.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $maxHuntduration;
    /**
     * The releaseClause
     * Meta information extracted from the WSDL
     * - default: No Error
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $releaseClause;
    /**
     * The displayConnectedNumber
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - default: false
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $displayConnectedNumber;
    /**
     * The queueCalls
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\XCallsQueue
     */
    public $queueCalls;
    /**
     * Constructor method for XHuntPilot
     * @uses XHuntPilot::setPattern()
     * @uses XHuntPilot::setBlockEnable()
     * @uses XHuntPilot::setUseCallingPartyPhoneMask()
     * @uses XHuntPilot::setHuntListName()
     * @uses XHuntPilot::setDescription()
     * @uses XHuntPilot::setRoutePartitionName()
     * @uses XHuntPilot::setCalledPartyTransformationMask()
     * @uses XHuntPilot::setCallingPartyTransformationMask()
     * @uses XHuntPilot::setCallingPartyPrefixDigits()
     * @uses XHuntPilot::setDialPlanName()
     * @uses XHuntPilot::setDigitDiscardInstructionName()
     * @uses XHuntPilot::setPatternUrgency()
     * @uses XHuntPilot::setPrefixDigitsOut()
     * @uses XHuntPilot::setRouteFilterName()
     * @uses XHuntPilot::setCallingLinePresentationBit()
     * @uses XHuntPilot::setCallingNamePresentationBit()
     * @uses XHuntPilot::setConnectedLinePresentationBit()
     * @uses XHuntPilot::setConnectedNamePresentationBit()
     * @uses XHuntPilot::setPatternPrecedence()
     * @uses XHuntPilot::setProvideOutsideDialtone()
     * @uses XHuntPilot::setCallingPartyNumberingPlan()
     * @uses XHuntPilot::setCallingPartyNumberType()
     * @uses XHuntPilot::setCalledPartyNumberingPlan()
     * @uses XHuntPilot::setCalledPartyNumberType()
     * @uses XHuntPilot::setParkMonForwardNoRetrieve()
     * @uses XHuntPilot::setAlertingName()
     * @uses XHuntPilot::setAsciiAlertingName()
     * @uses XHuntPilot::setE164Mask()
     * @uses XHuntPilot::setAarNeighborhoodName()
     * @uses XHuntPilot::setForwardHuntNoAnswer()
     * @uses XHuntPilot::setForwardHuntBusy()
     * @uses XHuntPilot::setCallPickupGroupName()
     * @uses XHuntPilot::setMaxHuntduration()
     * @uses XHuntPilot::setReleaseClause()
     * @uses XHuntPilot::setDisplayConnectedNumber()
     * @uses XHuntPilot::setQueueCalls()
     * @param string $pattern
     * @param string $blockEnable
     * @param string $useCallingPartyPhoneMask
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $huntListName
     * @param string $description
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $routePartitionName
     * @param string $calledPartyTransformationMask
     * @param string $callingPartyTransformationMask
     * @param string $callingPartyPrefixDigits
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $dialPlanName
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $digitDiscardInstructionName
     * @param string $patternUrgency
     * @param string $prefixDigitsOut
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $routeFilterName
     * @param string $callingLinePresentationBit
     * @param string $callingNamePresentationBit
     * @param string $connectedLinePresentationBit
     * @param string $connectedNamePresentationBit
     * @param string $patternPrecedence
     * @param string $provideOutsideDialtone
     * @param string $callingPartyNumberingPlan
     * @param string $callingPartyNumberType
     * @param string $calledPartyNumberingPlan
     * @param string $calledPartyNumberType
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\ParkMonForwardNoRetrieve $parkMonForwardNoRetrieve
     * @param string $alertingName
     * @param string $asciiAlertingName
     * @param string $e164Mask
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $aarNeighborhoodName
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\ForwardHuntNoAnswer $forwardHuntNoAnswer
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\ForwardHuntBusy $forwardHuntBusy
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $callPickupGroupName
     * @param string $maxHuntduration
     * @param string $releaseClause
     * @param string $displayConnectedNumber
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XCallsQueue $queueCalls
     */
    public function __construct($pattern = null, $blockEnable = null, $useCallingPartyPhoneMask = 'Default', \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $huntListName = null, $description = null, \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $routePartitionName = null, $calledPartyTransformationMask = null, $callingPartyTransformationMask = null, $callingPartyPrefixDigits = null, \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $dialPlanName = null, \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $digitDiscardInstructionName = null, $patternUrgency = null, $prefixDigitsOut = null, \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $routeFilterName = null, $callingLinePresentationBit = 'Default', $callingNamePresentationBit = 'Default', $connectedLinePresentationBit = 'Default', $connectedNamePresentationBit = 'Default', $patternPrecedence = 'Default', $provideOutsideDialtone = 'true', $callingPartyNumberingPlan = 'Cisco CallManager', $callingPartyNumberType = 'Cisco CallManager', $calledPartyNumberingPlan = 'Cisco CallManager', $calledPartyNumberType = 'Cisco CallManager', \\Losc\CucmBundle\Model\Webservice\StructType\ParkMonForwardNoRetrieve $parkMonForwardNoRetrieve = null, $alertingName = null, $asciiAlertingName = null, $e164Mask = null, \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $aarNeighborhoodName = null, \\Losc\CucmBundle\Model\Webservice\StructType\ForwardHuntNoAnswer $forwardHuntNoAnswer = null, \\Losc\CucmBundle\Model\Webservice\StructType\ForwardHuntBusy $forwardHuntBusy = null, \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $callPickupGroupName = null, $maxHuntduration = null, $releaseClause = 'No Error', $displayConnectedNumber = 'false', \\Losc\CucmBundle\Model\Webservice\StructType\XCallsQueue $queueCalls = null)
    {
        $this
            ->setPattern($pattern)
            ->setBlockEnable($blockEnable)
            ->setUseCallingPartyPhoneMask($useCallingPartyPhoneMask)
            ->setHuntListName($huntListName)
            ->setDescription($description)
            ->setRoutePartitionName($routePartitionName)
            ->setCalledPartyTransformationMask($calledPartyTransformationMask)
            ->setCallingPartyTransformationMask($callingPartyTransformationMask)
            ->setCallingPartyPrefixDigits($callingPartyPrefixDigits)
            ->setDialPlanName($dialPlanName)
            ->setDigitDiscardInstructionName($digitDiscardInstructionName)
            ->setPatternUrgency($patternUrgency)
            ->setPrefixDigitsOut($prefixDigitsOut)
            ->setRouteFilterName($routeFilterName)
            ->setCallingLinePresentationBit($callingLinePresentationBit)
            ->setCallingNamePresentationBit($callingNamePresentationBit)
            ->setConnectedLinePresentationBit($connectedLinePresentationBit)
            ->setConnectedNamePresentationBit($connectedNamePresentationBit)
            ->setPatternPrecedence($patternPrecedence)
            ->setProvideOutsideDialtone($provideOutsideDialtone)
            ->setCallingPartyNumberingPlan($callingPartyNumberingPlan)
            ->setCallingPartyNumberType($callingPartyNumberType)
            ->setCalledPartyNumberingPlan($calledPartyNumberingPlan)
            ->setCalledPartyNumberType($calledPartyNumberType)
            ->setParkMonForwardNoRetrieve($parkMonForwardNoRetrieve)
            ->setAlertingName($alertingName)
            ->setAsciiAlertingName($asciiAlertingName)
            ->setE164Mask($e164Mask)
            ->setAarNeighborhoodName($aarNeighborhoodName)
            ->setForwardHuntNoAnswer($forwardHuntNoAnswer)
            ->setForwardHuntBusy($forwardHuntBusy)
            ->setCallPickupGroupName($callPickupGroupName)
            ->setMaxHuntduration($maxHuntduration)
            ->setReleaseClause($releaseClause)
            ->setDisplayConnectedNumber($displayConnectedNumber)
            ->setQueueCalls($queueCalls);
    }
    /**
     * Get pattern value
     * @return string
     */
    public function getPattern()
    {
        return $this->pattern;
    }
    /**
     * Set pattern value
     * @param string $pattern
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XHuntPilot
     */
    public function setPattern($pattern = null)
    {
        $this->pattern = $pattern;
        return $this;
    }
    /**
     * Get blockEnable value
     * @return string
     */
    public function getBlockEnable()
    {
        return $this->blockEnable;
    }
    /**
     * Set blockEnable value
     * @param string $blockEnable
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XHuntPilot
     */
    public function setBlockEnable($blockEnable = null)
    {
        $this->blockEnable = $blockEnable;
        return $this;
    }
    /**
     * Get useCallingPartyPhoneMask value
     * @return string
     */
    public function getUseCallingPartyPhoneMask()
    {
        return $this->useCallingPartyPhoneMask;
    }
    /**
     * Set useCallingPartyPhoneMask value
     * @param string $useCallingPartyPhoneMask
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XHuntPilot
     */
    public function setUseCallingPartyPhoneMask($useCallingPartyPhoneMask = 'Default')
    {
        $this->useCallingPartyPhoneMask = $useCallingPartyPhoneMask;
        return $this;
    }
    /**
     * Get huntListName value
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public function getHuntListName()
    {
        return $this->huntListName;
    }
    /**
     * Set huntListName value
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $huntListName
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XHuntPilot
     */
    public function setHuntListName(\\Losc\CucmBundle\Model\Webservice\StructType\XFkType $huntListName = null)
    {
        $this->huntListName = $huntListName;
        return $this;
    }
    /**
     * Get description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->description;
    }
    /**
     * Set description value
     * @param string $description
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XHuntPilot
     */
    public function setDescription($description = null)
    {
        $this->description = $description;
        return $this;
    }
    /**
     * Get routePartitionName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XFkType|null
     */
    public function getRoutePartitionName()
    {
        return isset($this->routePartitionName) ? $this->routePartitionName : null;
    }
    /**
     * Set routePartitionName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $routePartitionName
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XHuntPilot
     */
    public function setRoutePartitionName(\\Losc\CucmBundle\Model\Webservice\StructType\XFkType $routePartitionName = null)
    {
        if (is_null($routePartitionName) || (is_array($routePartitionName) && empty($routePartitionName))) {
            unset($this->routePartitionName);
        } else {
            $this->routePartitionName = $routePartitionName;
        }
        return $this;
    }
    /**
     * Get calledPartyTransformationMask value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCalledPartyTransformationMask()
    {
        return isset($this->calledPartyTransformationMask) ? $this->calledPartyTransformationMask : null;
    }
    /**
     * Set calledPartyTransformationMask value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $calledPartyTransformationMask
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XHuntPilot
     */
    public function setCalledPartyTransformationMask($calledPartyTransformationMask = null)
    {
        if (is_null($calledPartyTransformationMask) || (is_array($calledPartyTransformationMask) && empty($calledPartyTransformationMask))) {
            unset($this->calledPartyTransformationMask);
        } else {
            $this->calledPartyTransformationMask = $calledPartyTransformationMask;
        }
        return $this;
    }
    /**
     * Get callingPartyTransformationMask value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCallingPartyTransformationMask()
    {
        return isset($this->callingPartyTransformationMask) ? $this->callingPartyTransformationMask : null;
    }
    /**
     * Set callingPartyTransformationMask value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $callingPartyTransformationMask
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XHuntPilot
     */
    public function setCallingPartyTransformationMask($callingPartyTransformationMask = null)
    {
        if (is_null($callingPartyTransformationMask) || (is_array($callingPartyTransformationMask) && empty($callingPartyTransformationMask))) {
            unset($this->callingPartyTransformationMask);
        } else {
            $this->callingPartyTransformationMask = $callingPartyTransformationMask;
        }
        return $this;
    }
    /**
     * Get callingPartyPrefixDigits value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCallingPartyPrefixDigits()
    {
        return isset($this->callingPartyPrefixDigits) ? $this->callingPartyPrefixDigits : null;
    }
    /**
     * Set callingPartyPrefixDigits value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $callingPartyPrefixDigits
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XHuntPilot
     */
    public function setCallingPartyPrefixDigits($callingPartyPrefixDigits = null)
    {
        if (is_null($callingPartyPrefixDigits) || (is_array($callingPartyPrefixDigits) && empty($callingPartyPrefixDigits))) {
            unset($this->callingPartyPrefixDigits);
        } else {
            $this->callingPartyPrefixDigits = $callingPartyPrefixDigits;
        }
        return $this;
    }
    /**
     * Get dialPlanName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XFkType|null
     */
    public function getDialPlanName()
    {
        return isset($this->dialPlanName) ? $this->dialPlanName : null;
    }
    /**
     * Set dialPlanName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $dialPlanName
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XHuntPilot
     */
    public function setDialPlanName(\\Losc\CucmBundle\Model\Webservice\StructType\XFkType $dialPlanName = null)
    {
        if (is_null($dialPlanName) || (is_array($dialPlanName) && empty($dialPlanName))) {
            unset($this->dialPlanName);
        } else {
            $this->dialPlanName = $dialPlanName;
        }
        return $this;
    }
    /**
     * Get digitDiscardInstructionName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XFkType|null
     */
    public function getDigitDiscardInstructionName()
    {
        return isset($this->digitDiscardInstructionName) ? $this->digitDiscardInstructionName : null;
    }
    /**
     * Set digitDiscardInstructionName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $digitDiscardInstructionName
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XHuntPilot
     */
    public function setDigitDiscardInstructionName(\\Losc\CucmBundle\Model\Webservice\StructType\XFkType $digitDiscardInstructionName = null)
    {
        if (is_null($digitDiscardInstructionName) || (is_array($digitDiscardInstructionName) && empty($digitDiscardInstructionName))) {
            unset($this->digitDiscardInstructionName);
        } else {
            $this->digitDiscardInstructionName = $digitDiscardInstructionName;
        }
        return $this;
    }
    /**
     * Get patternUrgency value
     * @return string|null
     */
    public function getPatternUrgency()
    {
        return $this->patternUrgency;
    }
    /**
     * Set patternUrgency value
     * @param string $patternUrgency
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XHuntPilot
     */
    public function setPatternUrgency($patternUrgency = null)
    {
        $this->patternUrgency = $patternUrgency;
        return $this;
    }
    /**
     * Get prefixDigitsOut value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPrefixDigitsOut()
    {
        return isset($this->prefixDigitsOut) ? $this->prefixDigitsOut : null;
    }
    /**
     * Set prefixDigitsOut value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $prefixDigitsOut
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XHuntPilot
     */
    public function setPrefixDigitsOut($prefixDigitsOut = null)
    {
        if (is_null($prefixDigitsOut) || (is_array($prefixDigitsOut) && empty($prefixDigitsOut))) {
            unset($this->prefixDigitsOut);
        } else {
            $this->prefixDigitsOut = $prefixDigitsOut;
        }
        return $this;
    }
    /**
     * Get routeFilterName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XFkType|null
     */
    public function getRouteFilterName()
    {
        return isset($this->routeFilterName) ? $this->routeFilterName : null;
    }
    /**
     * Set routeFilterName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $routeFilterName
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XHuntPilot
     */
    public function setRouteFilterName(\\Losc\CucmBundle\Model\Webservice\StructType\XFkType $routeFilterName = null)
    {
        if (is_null($routeFilterName) || (is_array($routeFilterName) && empty($routeFilterName))) {
            unset($this->routeFilterName);
        } else {
            $this->routeFilterName = $routeFilterName;
        }
        return $this;
    }
    /**
     * Get callingLinePresentationBit value
     * @return string|null
     */
    public function getCallingLinePresentationBit()
    {
        return $this->callingLinePresentationBit;
    }
    /**
     * Set callingLinePresentationBit value
     * @param string $callingLinePresentationBit
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XHuntPilot
     */
    public function setCallingLinePresentationBit($callingLinePresentationBit = 'Default')
    {
        $this->callingLinePresentationBit = $callingLinePresentationBit;
        return $this;
    }
    /**
     * Get callingNamePresentationBit value
     * @return string|null
     */
    public function getCallingNamePresentationBit()
    {
        return $this->callingNamePresentationBit;
    }
    /**
     * Set callingNamePresentationBit value
     * @param string $callingNamePresentationBit
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XHuntPilot
     */
    public function setCallingNamePresentationBit($callingNamePresentationBit = 'Default')
    {
        $this->callingNamePresentationBit = $callingNamePresentationBit;
        return $this;
    }
    /**
     * Get connectedLinePresentationBit value
     * @return string|null
     */
    public function getConnectedLinePresentationBit()
    {
        return $this->connectedLinePresentationBit;
    }
    /**
     * Set connectedLinePresentationBit value
     * @param string $connectedLinePresentationBit
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XHuntPilot
     */
    public function setConnectedLinePresentationBit($connectedLinePresentationBit = 'Default')
    {
        $this->connectedLinePresentationBit = $connectedLinePresentationBit;
        return $this;
    }
    /**
     * Get connectedNamePresentationBit value
     * @return string|null
     */
    public function getConnectedNamePresentationBit()
    {
        return $this->connectedNamePresentationBit;
    }
    /**
     * Set connectedNamePresentationBit value
     * @param string $connectedNamePresentationBit
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XHuntPilot
     */
    public function setConnectedNamePresentationBit($connectedNamePresentationBit = 'Default')
    {
        $this->connectedNamePresentationBit = $connectedNamePresentationBit;
        return $this;
    }
    /**
     * Get patternPrecedence value
     * @return string|null
     */
    public function getPatternPrecedence()
    {
        return $this->patternPrecedence;
    }
    /**
     * Set patternPrecedence value
     * @param string $patternPrecedence
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XHuntPilot
     */
    public function setPatternPrecedence($patternPrecedence = 'Default')
    {
        $this->patternPrecedence = $patternPrecedence;
        return $this;
    }
    /**
     * Get provideOutsideDialtone value
     * @return string|null
     */
    public function getProvideOutsideDialtone()
    {
        return $this->provideOutsideDialtone;
    }
    /**
     * Set provideOutsideDialtone value
     * @param string $provideOutsideDialtone
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XHuntPilot
     */
    public function setProvideOutsideDialtone($provideOutsideDialtone = 'true')
    {
        $this->provideOutsideDialtone = $provideOutsideDialtone;
        return $this;
    }
    /**
     * Get callingPartyNumberingPlan value
     * @return string|null
     */
    public function getCallingPartyNumberingPlan()
    {
        return $this->callingPartyNumberingPlan;
    }
    /**
     * Set callingPartyNumberingPlan value
     * @param string $callingPartyNumberingPlan
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XHuntPilot
     */
    public function setCallingPartyNumberingPlan($callingPartyNumberingPlan = 'Cisco CallManager')
    {
        $this->callingPartyNumberingPlan = $callingPartyNumberingPlan;
        return $this;
    }
    /**
     * Get callingPartyNumberType value
     * @return string|null
     */
    public function getCallingPartyNumberType()
    {
        return $this->callingPartyNumberType;
    }
    /**
     * Set callingPartyNumberType value
     * @param string $callingPartyNumberType
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XHuntPilot
     */
    public function setCallingPartyNumberType($callingPartyNumberType = 'Cisco CallManager')
    {
        $this->callingPartyNumberType = $callingPartyNumberType;
        return $this;
    }
    /**
     * Get calledPartyNumberingPlan value
     * @return string|null
     */
    public function getCalledPartyNumberingPlan()
    {
        return $this->calledPartyNumberingPlan;
    }
    /**
     * Set calledPartyNumberingPlan value
     * @param string $calledPartyNumberingPlan
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XHuntPilot
     */
    public function setCalledPartyNumberingPlan($calledPartyNumberingPlan = 'Cisco CallManager')
    {
        $this->calledPartyNumberingPlan = $calledPartyNumberingPlan;
        return $this;
    }
    /**
     * Get calledPartyNumberType value
     * @return string|null
     */
    public function getCalledPartyNumberType()
    {
        return $this->calledPartyNumberType;
    }
    /**
     * Set calledPartyNumberType value
     * @param string $calledPartyNumberType
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XHuntPilot
     */
    public function setCalledPartyNumberType($calledPartyNumberType = 'Cisco CallManager')
    {
        $this->calledPartyNumberType = $calledPartyNumberType;
        return $this;
    }
    /**
     * Get parkMonForwardNoRetrieve value
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\ParkMonForwardNoRetrieve|null
     */
    public function getParkMonForwardNoRetrieve()
    {
        return $this->parkMonForwardNoRetrieve;
    }
    /**
     * Set parkMonForwardNoRetrieve value
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\ParkMonForwardNoRetrieve $parkMonForwardNoRetrieve
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XHuntPilot
     */
    public function setParkMonForwardNoRetrieve(\\Losc\CucmBundle\Model\Webservice\StructType\ParkMonForwardNoRetrieve $parkMonForwardNoRetrieve = null)
    {
        $this->parkMonForwardNoRetrieve = $parkMonForwardNoRetrieve;
        return $this;
    }
    /**
     * Get alertingName value
     * @return string|null
     */
    public function getAlertingName()
    {
        return $this->alertingName;
    }
    /**
     * Set alertingName value
     * @param string $alertingName
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XHuntPilot
     */
    public function setAlertingName($alertingName = null)
    {
        $this->alertingName = $alertingName;
        return $this;
    }
    /**
     * Get asciiAlertingName value
     * @return string|null
     */
    public function getAsciiAlertingName()
    {
        return $this->asciiAlertingName;
    }
    /**
     * Set asciiAlertingName value
     * @param string $asciiAlertingName
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XHuntPilot
     */
    public function setAsciiAlertingName($asciiAlertingName = null)
    {
        $this->asciiAlertingName = $asciiAlertingName;
        return $this;
    }
    /**
     * Get e164Mask value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getE164Mask()
    {
        return isset($this->e164Mask) ? $this->e164Mask : null;
    }
    /**
     * Set e164Mask value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $e164Mask
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XHuntPilot
     */
    public function setE164Mask($e164Mask = null)
    {
        if (is_null($e164Mask) || (is_array($e164Mask) && empty($e164Mask))) {
            unset($this->e164Mask);
        } else {
            $this->e164Mask = $e164Mask;
        }
        return $this;
    }
    /**
     * Get aarNeighborhoodName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XFkType|null
     */
    public function getAarNeighborhoodName()
    {
        return isset($this->aarNeighborhoodName) ? $this->aarNeighborhoodName : null;
    }
    /**
     * Set aarNeighborhoodName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $aarNeighborhoodName
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XHuntPilot
     */
    public function setAarNeighborhoodName(\\Losc\CucmBundle\Model\Webservice\StructType\XFkType $aarNeighborhoodName = null)
    {
        if (is_null($aarNeighborhoodName) || (is_array($aarNeighborhoodName) && empty($aarNeighborhoodName))) {
            unset($this->aarNeighborhoodName);
        } else {
            $this->aarNeighborhoodName = $aarNeighborhoodName;
        }
        return $this;
    }
    /**
     * Get forwardHuntNoAnswer value
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\ForwardHuntNoAnswer|null
     */
    public function getForwardHuntNoAnswer()
    {
        return $this->forwardHuntNoAnswer;
    }
    /**
     * Set forwardHuntNoAnswer value
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\ForwardHuntNoAnswer $forwardHuntNoAnswer
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XHuntPilot
     */
    public function setForwardHuntNoAnswer(\\Losc\CucmBundle\Model\Webservice\StructType\ForwardHuntNoAnswer $forwardHuntNoAnswer = null)
    {
        $this->forwardHuntNoAnswer = $forwardHuntNoAnswer;
        return $this;
    }
    /**
     * Get forwardHuntBusy value
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\ForwardHuntBusy|null
     */
    public function getForwardHuntBusy()
    {
        return $this->forwardHuntBusy;
    }
    /**
     * Set forwardHuntBusy value
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\ForwardHuntBusy $forwardHuntBusy
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XHuntPilot
     */
    public function setForwardHuntBusy(\\Losc\CucmBundle\Model\Webservice\StructType\ForwardHuntBusy $forwardHuntBusy = null)
    {
        $this->forwardHuntBusy = $forwardHuntBusy;
        return $this;
    }
    /**
     * Get callPickupGroupName value
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XFkType|null
     */
    public function getCallPickupGroupName()
    {
        return $this->callPickupGroupName;
    }
    /**
     * Set callPickupGroupName value
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $callPickupGroupName
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XHuntPilot
     */
    public function setCallPickupGroupName(\\Losc\CucmBundle\Model\Webservice\StructType\XFkType $callPickupGroupName = null)
    {
        $this->callPickupGroupName = $callPickupGroupName;
        return $this;
    }
    /**
     * Get maxHuntduration value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMaxHuntduration()
    {
        return isset($this->maxHuntduration) ? $this->maxHuntduration : null;
    }
    /**
     * Set maxHuntduration value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $maxHuntduration
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XHuntPilot
     */
    public function setMaxHuntduration($maxHuntduration = null)
    {
        if (is_null($maxHuntduration) || (is_array($maxHuntduration) && empty($maxHuntduration))) {
            unset($this->maxHuntduration);
        } else {
            $this->maxHuntduration = $maxHuntduration;
        }
        return $this;
    }
    /**
     * Get releaseClause value
     * @return string|null
     */
    public function getReleaseClause()
    {
        return $this->releaseClause;
    }
    /**
     * Set releaseClause value
     * @param string $releaseClause
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XHuntPilot
     */
    public function setReleaseClause($releaseClause = 'No Error')
    {
        $this->releaseClause = $releaseClause;
        return $this;
    }
    /**
     * Get displayConnectedNumber value
     * @return string|null
     */
    public function getDisplayConnectedNumber()
    {
        return $this->displayConnectedNumber;
    }
    /**
     * Set displayConnectedNumber value
     * @param string $displayConnectedNumber
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XHuntPilot
     */
    public function setDisplayConnectedNumber($displayConnectedNumber = 'false')
    {
        $this->displayConnectedNumber = $displayConnectedNumber;
        return $this;
    }
    /**
     * Get queueCalls value
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XCallsQueue|null
     */
    public function getQueueCalls()
    {
        return $this->queueCalls;
    }
    /**
     * Set queueCalls value
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XCallsQueue $queueCalls
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XHuntPilot
     */
    public function setQueueCalls(\\Losc\CucmBundle\Model\Webservice\StructType\XCallsQueue $queueCalls = null)
    {
        $this->queueCalls = $queueCalls;
        return $this;
    }
}
