<?php

namespace \Losc\CucmBundle\Model\Webservice\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for XGatewayEndpointDigitalBri StructType
 * @subpackage Structs
 */
class XGatewayEndpointDigitalBri extends AbstractStructBase
{
    /**
     * The index
     * Meta information extracted from the WSDL
     * - default: 0
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $index;
    /**
     * The name
     * Meta information extracted from the WSDL
     * - documentation: The device name,using only URL-friendly characters
     * - base: xsd:string
     * - maxLength: 128
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $name;
    /**
     * The product
     * Meta information extracted from the WSDL
     * - documentation: Product ID string. read-only except when creating a device.
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $product;
    /**
     * The class
     * Meta information extracted from the WSDL
     * - documentation: Class ID string. Class information is read-only except when creating a device.
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $class;
    /**
     * The protocol
     * Meta information extracted from the WSDL
     * - documentation: Protocol option is read-only,except when creating a device.
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $protocol;
    /**
     * The protocolSide
     * Meta information extracted from the WSDL
     * - documentation: Side information is read-only except when creating a device
     * - default: User
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $protocolSide;
    /**
     * The callingSearchSpaceName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $callingSearchSpaceName;
    /**
     * The devicePoolName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $devicePoolName;
    /**
     * The commonDeviceConfigName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $commonDeviceConfigName;
    /**
     * The locationName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $locationName;
    /**
     * The mediaResourceListName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $mediaResourceListName;
    /**
     * The automatedAlternateRoutingCssName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $automatedAlternateRoutingCssName;
    /**
     * The aarNeighborhoodName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $aarNeighborhoodName;
    /**
     * The cgpnTransformationCssName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $cgpnTransformationCssName;
    /**
     * The geoLocationName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $geoLocationName;
    /**
     * The redirectInboundNumberIe
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $redirectInboundNumberIe;
    /**
     * The briProtocol
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $briProtocol;
    /**
     * The calledPlan
     * Meta information extracted from the WSDL
     * - default: Cisco CallManager
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $calledPlan;
    /**
     * The calledPri
     * Meta information extracted from the WSDL
     * - default: Cisco CallManager
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $calledPri;
    /**
     * The callerIdDn
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 255
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $callerIdDn;
    /**
     * The callingPartySelection
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $callingPartySelection;
    /**
     * The callingPlan
     * Meta information extracted from the WSDL
     * - default: Cisco CallManager
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $callingPlan;
    /**
     * The callingPri
     * Meta information extracted from the WSDL
     * - default: Cisco CallManager
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $callingPri;
    /**
     * The clockReference
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $clockReference;
    /**
     * The csuParam
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $csuParam;
    /**
     * The dChannelEnable
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $dChannelEnable;
    /**
     * The channelSelectionOrder
     * Meta information extracted from the WSDL
     * - default: Top Down
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $channelSelectionOrder;
    /**
     * The pcmType
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $pcmType;
    /**
     * The firstDelay
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $firstDelay;
    /**
     * The intraDelay
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $intraDelay;
    /**
     * The redirectOutboundNumberIe
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $redirectOutboundNumberIe;
    /**
     * The numDigitsToStrip
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $numDigitsToStrip;
    /**
     * The prefix
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $prefix;
    /**
     * The presentationBit
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $presentationBit;
    /**
     * The sendRestart
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $sendRestart;
    /**
     * The setupNonIsdnPi
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $setupNonIsdnPi;
    /**
     * The sigDigits
     * Meta information extracted from the WSDL
     * - minOccurs: 1
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\SigDigits
     */
    public $sigDigits;
    /**
     * The statusPoll
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $statusPoll;
    /**
     * The GClearEnable
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $GClearEnable;
    /**
     * The description
     * Meta information extracted from the WSDL
     * - documentation: Optional description of the device
     * - base: xsd:string
     * - maxLength: 128
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $description;
    /**
     * The networkLocation
     * Meta information extracted from the WSDL
     * - documentation: The new Device Destination for Trunk to Trunk Transfer and Drop Conference Feature is required for most gateways ,except FXS gateways and phones.Not Nullable.
     * - default: Use System Default
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $networkLocation;
    /**
     * The networkLocale
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $networkLocale;
    /**
     * The vendorConfig
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\XVendorConfig
     */
    public $vendorConfig;
    /**
     * The useDevicePoolCgpnTransformCss
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - default: true
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $useDevicePoolCgpnTransformCss;
    /**
     * The packetCaptureMode
     * Meta information extracted from the WSDL
     * - default: None
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $packetCaptureMode;
    /**
     * The packetCaptureDuration
     * Meta information extracted from the WSDL
     * - default: 0
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $packetCaptureDuration;
    /**
     * The cdpnTransformationCssName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $cdpnTransformationCssName;
    /**
     * The useDevicePoolCdpnTransformCss
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - default: true
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $useDevicePoolCdpnTransformCss;
    /**
     * The geoLocationFilterName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $geoLocationFilterName;
    /**
     * The nationalPrefix
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 16
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $nationalPrefix;
    /**
     * The internationalPrefix
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 16
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $internationalPrefix;
    /**
     * The unknownPrefix
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 16
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $unknownPrefix;
    /**
     * The subscriberPrefix
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 16
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $subscriberPrefix;
    /**
     * The nationalStripDigits
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $nationalStripDigits;
    /**
     * The internationalStripDigits
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $internationalStripDigits;
    /**
     * The unknownStripDigits
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $unknownStripDigits;
    /**
     * The subscriberStripDigits
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $subscriberStripDigits;
    /**
     * The nationalTransformationCssName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $nationalTransformationCssName;
    /**
     * The internationalTransformationCssName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $internationalTransformationCssName;
    /**
     * The unknownTransformationCssName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $unknownTransformationCssName;
    /**
     * The subscriberTransformationCssName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $subscriberTransformationCssName;
    /**
     * The pstnAccess
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - default: true
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $pstnAccess;
    /**
     * The imeE164TransformationName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $imeE164TransformationName;
    /**
     * The useDevicePoolCgpnTransformCssNatl
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - default: true
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $useDevicePoolCgpnTransformCssNatl;
    /**
     * The useDevicePoolCgpnTransformCssIntl
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - default: true
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $useDevicePoolCgpnTransformCssIntl;
    /**
     * The useDevicePoolCgpnTransformCssUnkn
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - default: true
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $useDevicePoolCgpnTransformCssUnkn;
    /**
     * The useDevicePoolCgpnTransformCssSubs
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - default: true
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $useDevicePoolCgpnTransformCssSubs;
    /**
     * The calledPartyNationalPrefix
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 16
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $calledPartyNationalPrefix;
    /**
     * The calledPartyInternationalPrefix
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 16
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $calledPartyInternationalPrefix;
    /**
     * The calledPartyUnknownPrefix
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 16
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $calledPartyUnknownPrefix;
    /**
     * The calledPartySubscriberPrefix
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 16
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $calledPartySubscriberPrefix;
    /**
     * The calledPartyNationalStripDigits
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $calledPartyNationalStripDigits;
    /**
     * The calledPartyInternationalStripDigits
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $calledPartyInternationalStripDigits;
    /**
     * The calledPartyUnknownStripDigits
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $calledPartyUnknownStripDigits;
    /**
     * The calledPartySubscriberStripDigits
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $calledPartySubscriberStripDigits;
    /**
     * The calledPartyNationalTransformationCssName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $calledPartyNationalTransformationCssName;
    /**
     * The calledPartyInternationalTransformationCssName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $calledPartyInternationalTransformationCssName;
    /**
     * The calledPartyUnknownTransformationCssName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $calledPartyUnknownTransformationCssName;
    /**
     * The calledPartySubscriberTransformationCssName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $calledPartySubscriberTransformationCssName;
    /**
     * The useDevicePoolCalledCssNatl
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - default: true
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $useDevicePoolCalledCssNatl;
    /**
     * The useDevicePoolCalledCssIntl
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - default: true
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $useDevicePoolCalledCssIntl;
    /**
     * The useDevicePoolCalledCssUnkn
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - default: true
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $useDevicePoolCalledCssUnkn;
    /**
     * The useDevicePoolCalledCssSubs
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - default: true
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $useDevicePoolCalledCssSubs;
    /**
     * The ctiid
     * @var int
     */
    public $ctiid;
    /**
     * Constructor method for XGatewayEndpointDigitalBri
     * @uses XGatewayEndpointDigitalBri::setIndex()
     * @uses XGatewayEndpointDigitalBri::setName()
     * @uses XGatewayEndpointDigitalBri::setProduct()
     * @uses XGatewayEndpointDigitalBri::setClass()
     * @uses XGatewayEndpointDigitalBri::setProtocol()
     * @uses XGatewayEndpointDigitalBri::setProtocolSide()
     * @uses XGatewayEndpointDigitalBri::setCallingSearchSpaceName()
     * @uses XGatewayEndpointDigitalBri::setDevicePoolName()
     * @uses XGatewayEndpointDigitalBri::setCommonDeviceConfigName()
     * @uses XGatewayEndpointDigitalBri::setLocationName()
     * @uses XGatewayEndpointDigitalBri::setMediaResourceListName()
     * @uses XGatewayEndpointDigitalBri::setAutomatedAlternateRoutingCssName()
     * @uses XGatewayEndpointDigitalBri::setAarNeighborhoodName()
     * @uses XGatewayEndpointDigitalBri::setCgpnTransformationCssName()
     * @uses XGatewayEndpointDigitalBri::setGeoLocationName()
     * @uses XGatewayEndpointDigitalBri::setRedirectInboundNumberIe()
     * @uses XGatewayEndpointDigitalBri::setBriProtocol()
     * @uses XGatewayEndpointDigitalBri::setCalledPlan()
     * @uses XGatewayEndpointDigitalBri::setCalledPri()
     * @uses XGatewayEndpointDigitalBri::setCallerIdDn()
     * @uses XGatewayEndpointDigitalBri::setCallingPartySelection()
     * @uses XGatewayEndpointDigitalBri::setCallingPlan()
     * @uses XGatewayEndpointDigitalBri::setCallingPri()
     * @uses XGatewayEndpointDigitalBri::setClockReference()
     * @uses XGatewayEndpointDigitalBri::setCsuParam()
     * @uses XGatewayEndpointDigitalBri::setDChannelEnable()
     * @uses XGatewayEndpointDigitalBri::setChannelSelectionOrder()
     * @uses XGatewayEndpointDigitalBri::setPcmType()
     * @uses XGatewayEndpointDigitalBri::setFirstDelay()
     * @uses XGatewayEndpointDigitalBri::setIntraDelay()
     * @uses XGatewayEndpointDigitalBri::setRedirectOutboundNumberIe()
     * @uses XGatewayEndpointDigitalBri::setNumDigitsToStrip()
     * @uses XGatewayEndpointDigitalBri::setPrefix()
     * @uses XGatewayEndpointDigitalBri::setPresentationBit()
     * @uses XGatewayEndpointDigitalBri::setSendRestart()
     * @uses XGatewayEndpointDigitalBri::setSetupNonIsdnPi()
     * @uses XGatewayEndpointDigitalBri::setSigDigits()
     * @uses XGatewayEndpointDigitalBri::setStatusPoll()
     * @uses XGatewayEndpointDigitalBri::setGClearEnable()
     * @uses XGatewayEndpointDigitalBri::setDescription()
     * @uses XGatewayEndpointDigitalBri::setNetworkLocation()
     * @uses XGatewayEndpointDigitalBri::setNetworkLocale()
     * @uses XGatewayEndpointDigitalBri::setVendorConfig()
     * @uses XGatewayEndpointDigitalBri::setUseDevicePoolCgpnTransformCss()
     * @uses XGatewayEndpointDigitalBri::setPacketCaptureMode()
     * @uses XGatewayEndpointDigitalBri::setPacketCaptureDuration()
     * @uses XGatewayEndpointDigitalBri::setCdpnTransformationCssName()
     * @uses XGatewayEndpointDigitalBri::setUseDevicePoolCdpnTransformCss()
     * @uses XGatewayEndpointDigitalBri::setGeoLocationFilterName()
     * @uses XGatewayEndpointDigitalBri::setNationalPrefix()
     * @uses XGatewayEndpointDigitalBri::setInternationalPrefix()
     * @uses XGatewayEndpointDigitalBri::setUnknownPrefix()
     * @uses XGatewayEndpointDigitalBri::setSubscriberPrefix()
     * @uses XGatewayEndpointDigitalBri::setNationalStripDigits()
     * @uses XGatewayEndpointDigitalBri::setInternationalStripDigits()
     * @uses XGatewayEndpointDigitalBri::setUnknownStripDigits()
     * @uses XGatewayEndpointDigitalBri::setSubscriberStripDigits()
     * @uses XGatewayEndpointDigitalBri::setNationalTransformationCssName()
     * @uses XGatewayEndpointDigitalBri::setInternationalTransformationCssName()
     * @uses XGatewayEndpointDigitalBri::setUnknownTransformationCssName()
     * @uses XGatewayEndpointDigitalBri::setSubscriberTransformationCssName()
     * @uses XGatewayEndpointDigitalBri::setPstnAccess()
     * @uses XGatewayEndpointDigitalBri::setImeE164TransformationName()
     * @uses XGatewayEndpointDigitalBri::setUseDevicePoolCgpnTransformCssNatl()
     * @uses XGatewayEndpointDigitalBri::setUseDevicePoolCgpnTransformCssIntl()
     * @uses XGatewayEndpointDigitalBri::setUseDevicePoolCgpnTransformCssUnkn()
     * @uses XGatewayEndpointDigitalBri::setUseDevicePoolCgpnTransformCssSubs()
     * @uses XGatewayEndpointDigitalBri::setCalledPartyNationalPrefix()
     * @uses XGatewayEndpointDigitalBri::setCalledPartyInternationalPrefix()
     * @uses XGatewayEndpointDigitalBri::setCalledPartyUnknownPrefix()
     * @uses XGatewayEndpointDigitalBri::setCalledPartySubscriberPrefix()
     * @uses XGatewayEndpointDigitalBri::setCalledPartyNationalStripDigits()
     * @uses XGatewayEndpointDigitalBri::setCalledPartyInternationalStripDigits()
     * @uses XGatewayEndpointDigitalBri::setCalledPartyUnknownStripDigits()
     * @uses XGatewayEndpointDigitalBri::setCalledPartySubscriberStripDigits()
     * @uses XGatewayEndpointDigitalBri::setCalledPartyNationalTransformationCssName()
     * @uses XGatewayEndpointDigitalBri::setCalledPartyInternationalTransformationCssName()
     * @uses XGatewayEndpointDigitalBri::setCalledPartyUnknownTransformationCssName()
     * @uses XGatewayEndpointDigitalBri::setCalledPartySubscriberTransformationCssName()
     * @uses XGatewayEndpointDigitalBri::setUseDevicePoolCalledCssNatl()
     * @uses XGatewayEndpointDigitalBri::setUseDevicePoolCalledCssIntl()
     * @uses XGatewayEndpointDigitalBri::setUseDevicePoolCalledCssUnkn()
     * @uses XGatewayEndpointDigitalBri::setUseDevicePoolCalledCssSubs()
     * @uses XGatewayEndpointDigitalBri::setCtiid()
     * @param string $index
     * @param string $name
     * @param string $product
     * @param string $class
     * @param string $protocol
     * @param string $protocolSide
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $callingSearchSpaceName
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $devicePoolName
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $commonDeviceConfigName
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $locationName
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $mediaResourceListName
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $automatedAlternateRoutingCssName
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $aarNeighborhoodName
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $cgpnTransformationCssName
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $geoLocationName
     * @param string $redirectInboundNumberIe
     * @param string $briProtocol
     * @param string $calledPlan
     * @param string $calledPri
     * @param string $callerIdDn
     * @param string $callingPartySelection
     * @param string $callingPlan
     * @param string $callingPri
     * @param string $clockReference
     * @param string $csuParam
     * @param string $dChannelEnable
     * @param string $channelSelectionOrder
     * @param string $pcmType
     * @param string $firstDelay
     * @param string $intraDelay
     * @param string $redirectOutboundNumberIe
     * @param string $numDigitsToStrip
     * @param string $prefix
     * @param string $presentationBit
     * @param string $sendRestart
     * @param string $setupNonIsdnPi
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\SigDigits $sigDigits
     * @param string $statusPoll
     * @param string $gClearEnable
     * @param string $description
     * @param string $networkLocation
     * @param string $networkLocale
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XVendorConfig $vendorConfig
     * @param string $useDevicePoolCgpnTransformCss
     * @param string $packetCaptureMode
     * @param string $packetCaptureDuration
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $cdpnTransformationCssName
     * @param string $useDevicePoolCdpnTransformCss
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $geoLocationFilterName
     * @param string $nationalPrefix
     * @param string $internationalPrefix
     * @param string $unknownPrefix
     * @param string $subscriberPrefix
     * @param string $nationalStripDigits
     * @param string $internationalStripDigits
     * @param string $unknownStripDigits
     * @param string $subscriberStripDigits
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $nationalTransformationCssName
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $internationalTransformationCssName
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $unknownTransformationCssName
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $subscriberTransformationCssName
     * @param string $pstnAccess
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $imeE164TransformationName
     * @param string $useDevicePoolCgpnTransformCssNatl
     * @param string $useDevicePoolCgpnTransformCssIntl
     * @param string $useDevicePoolCgpnTransformCssUnkn
     * @param string $useDevicePoolCgpnTransformCssSubs
     * @param string $calledPartyNationalPrefix
     * @param string $calledPartyInternationalPrefix
     * @param string $calledPartyUnknownPrefix
     * @param string $calledPartySubscriberPrefix
     * @param string $calledPartyNationalStripDigits
     * @param string $calledPartyInternationalStripDigits
     * @param string $calledPartyUnknownStripDigits
     * @param string $calledPartySubscriberStripDigits
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $calledPartyNationalTransformationCssName
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $calledPartyInternationalTransformationCssName
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $calledPartyUnknownTransformationCssName
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $calledPartySubscriberTransformationCssName
     * @param string $useDevicePoolCalledCssNatl
     * @param string $useDevicePoolCalledCssIntl
     * @param string $useDevicePoolCalledCssUnkn
     * @param string $useDevicePoolCalledCssSubs
     * @param int $ctiid
     */
    public function __construct($index = '0', $name = null, $product = null, $class = null, $protocol = null, $protocolSide = 'User', \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $callingSearchSpaceName = null, \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $devicePoolName = null, \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $commonDeviceConfigName = null, \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $locationName = null, \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $mediaResourceListName = null, \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $automatedAlternateRoutingCssName = null, \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $aarNeighborhoodName = null, \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $cgpnTransformationCssName = null, \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $geoLocationName = null, $redirectInboundNumberIe = null, $briProtocol = null, $calledPlan = 'Cisco CallManager', $calledPri = 'Cisco CallManager', $callerIdDn = null, $callingPartySelection = null, $callingPlan = 'Cisco CallManager', $callingPri = 'Cisco CallManager', $clockReference = null, $csuParam = null, $dChannelEnable = null, $channelSelectionOrder = 'Top Down', $pcmType = null, $firstDelay = null, $intraDelay = null, $redirectOutboundNumberIe = null, $numDigitsToStrip = null, $prefix = null, $presentationBit = null, $sendRestart = null, $setupNonIsdnPi = null, \\Losc\CucmBundle\Model\Webservice\StructType\SigDigits $sigDigits = null, $statusPoll = null, $gClearEnable = null, $description = null, $networkLocation = 'Use System Default', $networkLocale = null, \\Losc\CucmBundle\Model\Webservice\StructType\XVendorConfig $vendorConfig = null, $useDevicePoolCgpnTransformCss = 'true', $packetCaptureMode = 'None', $packetCaptureDuration = '0', \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $cdpnTransformationCssName = null, $useDevicePoolCdpnTransformCss = 'true', \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $geoLocationFilterName = null, $nationalPrefix = null, $internationalPrefix = null, $unknownPrefix = null, $subscriberPrefix = null, $nationalStripDigits = null, $internationalStripDigits = null, $unknownStripDigits = null, $subscriberStripDigits = null, \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $nationalTransformationCssName = null, \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $internationalTransformationCssName = null, \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $unknownTransformationCssName = null, \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $subscriberTransformationCssName = null, $pstnAccess = 'true', \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $imeE164TransformationName = null, $useDevicePoolCgpnTransformCssNatl = 'true', $useDevicePoolCgpnTransformCssIntl = 'true', $useDevicePoolCgpnTransformCssUnkn = 'true', $useDevicePoolCgpnTransformCssSubs = 'true', $calledPartyNationalPrefix = null, $calledPartyInternationalPrefix = null, $calledPartyUnknownPrefix = null, $calledPartySubscriberPrefix = null, $calledPartyNationalStripDigits = null, $calledPartyInternationalStripDigits = null, $calledPartyUnknownStripDigits = null, $calledPartySubscriberStripDigits = null, \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $calledPartyNationalTransformationCssName = null, \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $calledPartyInternationalTransformationCssName = null, \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $calledPartyUnknownTransformationCssName = null, \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $calledPartySubscriberTransformationCssName = null, $useDevicePoolCalledCssNatl = 'true', $useDevicePoolCalledCssIntl = 'true', $useDevicePoolCalledCssUnkn = 'true', $useDevicePoolCalledCssSubs = 'true', $ctiid = null)
    {
        $this
            ->setIndex($index)
            ->setName($name)
            ->setProduct($product)
            ->setClass($class)
            ->setProtocol($protocol)
            ->setProtocolSide($protocolSide)
            ->setCallingSearchSpaceName($callingSearchSpaceName)
            ->setDevicePoolName($devicePoolName)
            ->setCommonDeviceConfigName($commonDeviceConfigName)
            ->setLocationName($locationName)
            ->setMediaResourceListName($mediaResourceListName)
            ->setAutomatedAlternateRoutingCssName($automatedAlternateRoutingCssName)
            ->setAarNeighborhoodName($aarNeighborhoodName)
            ->setCgpnTransformationCssName($cgpnTransformationCssName)
            ->setGeoLocationName($geoLocationName)
            ->setRedirectInboundNumberIe($redirectInboundNumberIe)
            ->setBriProtocol($briProtocol)
            ->setCalledPlan($calledPlan)
            ->setCalledPri($calledPri)
            ->setCallerIdDn($callerIdDn)
            ->setCallingPartySelection($callingPartySelection)
            ->setCallingPlan($callingPlan)
            ->setCallingPri($callingPri)
            ->setClockReference($clockReference)
            ->setCsuParam($csuParam)
            ->setDChannelEnable($dChannelEnable)
            ->setChannelSelectionOrder($channelSelectionOrder)
            ->setPcmType($pcmType)
            ->setFirstDelay($firstDelay)
            ->setIntraDelay($intraDelay)
            ->setRedirectOutboundNumberIe($redirectOutboundNumberIe)
            ->setNumDigitsToStrip($numDigitsToStrip)
            ->setPrefix($prefix)
            ->setPresentationBit($presentationBit)
            ->setSendRestart($sendRestart)
            ->setSetupNonIsdnPi($setupNonIsdnPi)
            ->setSigDigits($sigDigits)
            ->setStatusPoll($statusPoll)
            ->setGClearEnable($gClearEnable)
            ->setDescription($description)
            ->setNetworkLocation($networkLocation)
            ->setNetworkLocale($networkLocale)
            ->setVendorConfig($vendorConfig)
            ->setUseDevicePoolCgpnTransformCss($useDevicePoolCgpnTransformCss)
            ->setPacketCaptureMode($packetCaptureMode)
            ->setPacketCaptureDuration($packetCaptureDuration)
            ->setCdpnTransformationCssName($cdpnTransformationCssName)
            ->setUseDevicePoolCdpnTransformCss($useDevicePoolCdpnTransformCss)
            ->setGeoLocationFilterName($geoLocationFilterName)
            ->setNationalPrefix($nationalPrefix)
            ->setInternationalPrefix($internationalPrefix)
            ->setUnknownPrefix($unknownPrefix)
            ->setSubscriberPrefix($subscriberPrefix)
            ->setNationalStripDigits($nationalStripDigits)
            ->setInternationalStripDigits($internationalStripDigits)
            ->setUnknownStripDigits($unknownStripDigits)
            ->setSubscriberStripDigits($subscriberStripDigits)
            ->setNationalTransformationCssName($nationalTransformationCssName)
            ->setInternationalTransformationCssName($internationalTransformationCssName)
            ->setUnknownTransformationCssName($unknownTransformationCssName)
            ->setSubscriberTransformationCssName($subscriberTransformationCssName)
            ->setPstnAccess($pstnAccess)
            ->setImeE164TransformationName($imeE164TransformationName)
            ->setUseDevicePoolCgpnTransformCssNatl($useDevicePoolCgpnTransformCssNatl)
            ->setUseDevicePoolCgpnTransformCssIntl($useDevicePoolCgpnTransformCssIntl)
            ->setUseDevicePoolCgpnTransformCssUnkn($useDevicePoolCgpnTransformCssUnkn)
            ->setUseDevicePoolCgpnTransformCssSubs($useDevicePoolCgpnTransformCssSubs)
            ->setCalledPartyNationalPrefix($calledPartyNationalPrefix)
            ->setCalledPartyInternationalPrefix($calledPartyInternationalPrefix)
            ->setCalledPartyUnknownPrefix($calledPartyUnknownPrefix)
            ->setCalledPartySubscriberPrefix($calledPartySubscriberPrefix)
            ->setCalledPartyNationalStripDigits($calledPartyNationalStripDigits)
            ->setCalledPartyInternationalStripDigits($calledPartyInternationalStripDigits)
            ->setCalledPartyUnknownStripDigits($calledPartyUnknownStripDigits)
            ->setCalledPartySubscriberStripDigits($calledPartySubscriberStripDigits)
            ->setCalledPartyNationalTransformationCssName($calledPartyNationalTransformationCssName)
            ->setCalledPartyInternationalTransformationCssName($calledPartyInternationalTransformationCssName)
            ->setCalledPartyUnknownTransformationCssName($calledPartyUnknownTransformationCssName)
            ->setCalledPartySubscriberTransformationCssName($calledPartySubscriberTransformationCssName)
            ->setUseDevicePoolCalledCssNatl($useDevicePoolCalledCssNatl)
            ->setUseDevicePoolCalledCssIntl($useDevicePoolCalledCssIntl)
            ->setUseDevicePoolCalledCssUnkn($useDevicePoolCalledCssUnkn)
            ->setUseDevicePoolCalledCssSubs($useDevicePoolCalledCssSubs)
            ->setCtiid($ctiid);
    }
    /**
     * Get index value
     * @return string
     */
    public function getIndex()
    {
        return $this->index;
    }
    /**
     * Set index value
     * @param string $index
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XGatewayEndpointDigitalBri
     */
    public function setIndex($index = '0')
    {
        $this->index = $index;
        return $this;
    }
    /**
     * Get name value
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Set name value
     * @param string $name
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XGatewayEndpointDigitalBri
     */
    public function setName($name = null)
    {
        $this->name = $name;
        return $this;
    }
    /**
     * Get product value
     * @return string
     */
    public function getProduct()
    {
        return $this->product;
    }
    /**
     * Set product value
     * @param string $product
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XGatewayEndpointDigitalBri
     */
    public function setProduct($product = null)
    {
        $this->product = $product;
        return $this;
    }
    /**
     * Get class value
     * @return string
     */
    public function getClass()
    {
        return $this->class;
    }
    /**
     * Set class value
     * @param string $class
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XGatewayEndpointDigitalBri
     */
    public function setClass($class = null)
    {
        $this->class = $class;
        return $this;
    }
    /**
     * Get protocol value
     * @return string
     */
    public function getProtocol()
    {
        return $this->protocol;
    }
    /**
     * Set protocol value
     * @param string $protocol
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XGatewayEndpointDigitalBri
     */
    public function setProtocol($protocol = null)
    {
        $this->protocol = $protocol;
        return $this;
    }
    /**
     * Get protocolSide value
     * @return string
     */
    public function getProtocolSide()
    {
        return $this->protocolSide;
    }
    /**
     * Set protocolSide value
     * @param string $protocolSide
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XGatewayEndpointDigitalBri
     */
    public function setProtocolSide($protocolSide = 'User')
    {
        $this->protocolSide = $protocolSide;
        return $this;
    }
    /**
     * Get callingSearchSpaceName value
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public function getCallingSearchSpaceName()
    {
        return $this->callingSearchSpaceName;
    }
    /**
     * Set callingSearchSpaceName value
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $callingSearchSpaceName
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XGatewayEndpointDigitalBri
     */
    public function setCallingSearchSpaceName(\\Losc\CucmBundle\Model\Webservice\StructType\XFkType $callingSearchSpaceName = null)
    {
        $this->callingSearchSpaceName = $callingSearchSpaceName;
        return $this;
    }
    /**
     * Get devicePoolName value
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public function getDevicePoolName()
    {
        return $this->devicePoolName;
    }
    /**
     * Set devicePoolName value
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $devicePoolName
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XGatewayEndpointDigitalBri
     */
    public function setDevicePoolName(\\Losc\CucmBundle\Model\Webservice\StructType\XFkType $devicePoolName = null)
    {
        $this->devicePoolName = $devicePoolName;
        return $this;
    }
    /**
     * Get commonDeviceConfigName value
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public function getCommonDeviceConfigName()
    {
        return $this->commonDeviceConfigName;
    }
    /**
     * Set commonDeviceConfigName value
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $commonDeviceConfigName
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XGatewayEndpointDigitalBri
     */
    public function setCommonDeviceConfigName(\\Losc\CucmBundle\Model\Webservice\StructType\XFkType $commonDeviceConfigName = null)
    {
        $this->commonDeviceConfigName = $commonDeviceConfigName;
        return $this;
    }
    /**
     * Get locationName value
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public function getLocationName()
    {
        return $this->locationName;
    }
    /**
     * Set locationName value
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $locationName
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XGatewayEndpointDigitalBri
     */
    public function setLocationName(\\Losc\CucmBundle\Model\Webservice\StructType\XFkType $locationName = null)
    {
        $this->locationName = $locationName;
        return $this;
    }
    /**
     * Get mediaResourceListName value
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public function getMediaResourceListName()
    {
        return $this->mediaResourceListName;
    }
    /**
     * Set mediaResourceListName value
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $mediaResourceListName
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XGatewayEndpointDigitalBri
     */
    public function setMediaResourceListName(\\Losc\CucmBundle\Model\Webservice\StructType\XFkType $mediaResourceListName = null)
    {
        $this->mediaResourceListName = $mediaResourceListName;
        return $this;
    }
    /**
     * Get automatedAlternateRoutingCssName value
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public function getAutomatedAlternateRoutingCssName()
    {
        return $this->automatedAlternateRoutingCssName;
    }
    /**
     * Set automatedAlternateRoutingCssName value
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $automatedAlternateRoutingCssName
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XGatewayEndpointDigitalBri
     */
    public function setAutomatedAlternateRoutingCssName(\\Losc\CucmBundle\Model\Webservice\StructType\XFkType $automatedAlternateRoutingCssName = null)
    {
        $this->automatedAlternateRoutingCssName = $automatedAlternateRoutingCssName;
        return $this;
    }
    /**
     * Get aarNeighborhoodName value
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public function getAarNeighborhoodName()
    {
        return $this->aarNeighborhoodName;
    }
    /**
     * Set aarNeighborhoodName value
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $aarNeighborhoodName
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XGatewayEndpointDigitalBri
     */
    public function setAarNeighborhoodName(\\Losc\CucmBundle\Model\Webservice\StructType\XFkType $aarNeighborhoodName = null)
    {
        $this->aarNeighborhoodName = $aarNeighborhoodName;
        return $this;
    }
    /**
     * Get cgpnTransformationCssName value
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public function getCgpnTransformationCssName()
    {
        return $this->cgpnTransformationCssName;
    }
    /**
     * Set cgpnTransformationCssName value
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $cgpnTransformationCssName
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XGatewayEndpointDigitalBri
     */
    public function setCgpnTransformationCssName(\\Losc\CucmBundle\Model\Webservice\StructType\XFkType $cgpnTransformationCssName = null)
    {
        $this->cgpnTransformationCssName = $cgpnTransformationCssName;
        return $this;
    }
    /**
     * Get geoLocationName value
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public function getGeoLocationName()
    {
        return $this->geoLocationName;
    }
    /**
     * Set geoLocationName value
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $geoLocationName
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XGatewayEndpointDigitalBri
     */
    public function setGeoLocationName(\\Losc\CucmBundle\Model\Webservice\StructType\XFkType $geoLocationName = null)
    {
        $this->geoLocationName = $geoLocationName;
        return $this;
    }
    /**
     * Get redirectInboundNumberIe value
     * @return string
     */
    public function getRedirectInboundNumberIe()
    {
        return $this->redirectInboundNumberIe;
    }
    /**
     * Set redirectInboundNumberIe value
     * @param string $redirectInboundNumberIe
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XGatewayEndpointDigitalBri
     */
    public function setRedirectInboundNumberIe($redirectInboundNumberIe = null)
    {
        $this->redirectInboundNumberIe = $redirectInboundNumberIe;
        return $this;
    }
    /**
     * Get briProtocol value
     * @return string
     */
    public function getBriProtocol()
    {
        return $this->briProtocol;
    }
    /**
     * Set briProtocol value
     * @param string $briProtocol
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XGatewayEndpointDigitalBri
     */
    public function setBriProtocol($briProtocol = null)
    {
        $this->briProtocol = $briProtocol;
        return $this;
    }
    /**
     * Get calledPlan value
     * @return string
     */
    public function getCalledPlan()
    {
        return $this->calledPlan;
    }
    /**
     * Set calledPlan value
     * @param string $calledPlan
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XGatewayEndpointDigitalBri
     */
    public function setCalledPlan($calledPlan = 'Cisco CallManager')
    {
        $this->calledPlan = $calledPlan;
        return $this;
    }
    /**
     * Get calledPri value
     * @return string
     */
    public function getCalledPri()
    {
        return $this->calledPri;
    }
    /**
     * Set calledPri value
     * @param string $calledPri
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XGatewayEndpointDigitalBri
     */
    public function setCalledPri($calledPri = 'Cisco CallManager')
    {
        $this->calledPri = $calledPri;
        return $this;
    }
    /**
     * Get callerIdDn value
     * @return string
     */
    public function getCallerIdDn()
    {
        return $this->callerIdDn;
    }
    /**
     * Set callerIdDn value
     * @param string $callerIdDn
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XGatewayEndpointDigitalBri
     */
    public function setCallerIdDn($callerIdDn = null)
    {
        $this->callerIdDn = $callerIdDn;
        return $this;
    }
    /**
     * Get callingPartySelection value
     * @return string
     */
    public function getCallingPartySelection()
    {
        return $this->callingPartySelection;
    }
    /**
     * Set callingPartySelection value
     * @param string $callingPartySelection
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XGatewayEndpointDigitalBri
     */
    public function setCallingPartySelection($callingPartySelection = null)
    {
        $this->callingPartySelection = $callingPartySelection;
        return $this;
    }
    /**
     * Get callingPlan value
     * @return string
     */
    public function getCallingPlan()
    {
        return $this->callingPlan;
    }
    /**
     * Set callingPlan value
     * @param string $callingPlan
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XGatewayEndpointDigitalBri
     */
    public function setCallingPlan($callingPlan = 'Cisco CallManager')
    {
        $this->callingPlan = $callingPlan;
        return $this;
    }
    /**
     * Get callingPri value
     * @return string
     */
    public function getCallingPri()
    {
        return $this->callingPri;
    }
    /**
     * Set callingPri value
     * @param string $callingPri
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XGatewayEndpointDigitalBri
     */
    public function setCallingPri($callingPri = 'Cisco CallManager')
    {
        $this->callingPri = $callingPri;
        return $this;
    }
    /**
     * Get clockReference value
     * @return string
     */
    public function getClockReference()
    {
        return $this->clockReference;
    }
    /**
     * Set clockReference value
     * @param string $clockReference
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XGatewayEndpointDigitalBri
     */
    public function setClockReference($clockReference = null)
    {
        $this->clockReference = $clockReference;
        return $this;
    }
    /**
     * Get csuParam value
     * @return string
     */
    public function getCsuParam()
    {
        return $this->csuParam;
    }
    /**
     * Set csuParam value
     * @param string $csuParam
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XGatewayEndpointDigitalBri
     */
    public function setCsuParam($csuParam = null)
    {
        $this->csuParam = $csuParam;
        return $this;
    }
    /**
     * Get dChannelEnable value
     * @return string
     */
    public function getDChannelEnable()
    {
        return $this->dChannelEnable;
    }
    /**
     * Set dChannelEnable value
     * @param string $dChannelEnable
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XGatewayEndpointDigitalBri
     */
    public function setDChannelEnable($dChannelEnable = null)
    {
        $this->dChannelEnable = $dChannelEnable;
        return $this;
    }
    /**
     * Get channelSelectionOrder value
     * @return string
     */
    public function getChannelSelectionOrder()
    {
        return $this->channelSelectionOrder;
    }
    /**
     * Set channelSelectionOrder value
     * @param string $channelSelectionOrder
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XGatewayEndpointDigitalBri
     */
    public function setChannelSelectionOrder($channelSelectionOrder = 'Top Down')
    {
        $this->channelSelectionOrder = $channelSelectionOrder;
        return $this;
    }
    /**
     * Get pcmType value
     * @return string
     */
    public function getPcmType()
    {
        return $this->pcmType;
    }
    /**
     * Set pcmType value
     * @param string $pcmType
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XGatewayEndpointDigitalBri
     */
    public function setPcmType($pcmType = null)
    {
        $this->pcmType = $pcmType;
        return $this;
    }
    /**
     * Get firstDelay value
     * @return string
     */
    public function getFirstDelay()
    {
        return $this->firstDelay;
    }
    /**
     * Set firstDelay value
     * @param string $firstDelay
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XGatewayEndpointDigitalBri
     */
    public function setFirstDelay($firstDelay = null)
    {
        $this->firstDelay = $firstDelay;
        return $this;
    }
    /**
     * Get intraDelay value
     * @return string
     */
    public function getIntraDelay()
    {
        return $this->intraDelay;
    }
    /**
     * Set intraDelay value
     * @param string $intraDelay
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XGatewayEndpointDigitalBri
     */
    public function setIntraDelay($intraDelay = null)
    {
        $this->intraDelay = $intraDelay;
        return $this;
    }
    /**
     * Get redirectOutboundNumberIe value
     * @return string
     */
    public function getRedirectOutboundNumberIe()
    {
        return $this->redirectOutboundNumberIe;
    }
    /**
     * Set redirectOutboundNumberIe value
     * @param string $redirectOutboundNumberIe
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XGatewayEndpointDigitalBri
     */
    public function setRedirectOutboundNumberIe($redirectOutboundNumberIe = null)
    {
        $this->redirectOutboundNumberIe = $redirectOutboundNumberIe;
        return $this;
    }
    /**
     * Get numDigitsToStrip value
     * @return string
     */
    public function getNumDigitsToStrip()
    {
        return $this->numDigitsToStrip;
    }
    /**
     * Set numDigitsToStrip value
     * @param string $numDigitsToStrip
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XGatewayEndpointDigitalBri
     */
    public function setNumDigitsToStrip($numDigitsToStrip = null)
    {
        $this->numDigitsToStrip = $numDigitsToStrip;
        return $this;
    }
    /**
     * Get prefix value
     * @return string
     */
    public function getPrefix()
    {
        return $this->prefix;
    }
    /**
     * Set prefix value
     * @param string $prefix
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XGatewayEndpointDigitalBri
     */
    public function setPrefix($prefix = null)
    {
        $this->prefix = $prefix;
        return $this;
    }
    /**
     * Get presentationBit value
     * @return string
     */
    public function getPresentationBit()
    {
        return $this->presentationBit;
    }
    /**
     * Set presentationBit value
     * @param string $presentationBit
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XGatewayEndpointDigitalBri
     */
    public function setPresentationBit($presentationBit = null)
    {
        $this->presentationBit = $presentationBit;
        return $this;
    }
    /**
     * Get sendRestart value
     * @return string
     */
    public function getSendRestart()
    {
        return $this->sendRestart;
    }
    /**
     * Set sendRestart value
     * @param string $sendRestart
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XGatewayEndpointDigitalBri
     */
    public function setSendRestart($sendRestart = null)
    {
        $this->sendRestart = $sendRestart;
        return $this;
    }
    /**
     * Get setupNonIsdnPi value
     * @return string
     */
    public function getSetupNonIsdnPi()
    {
        return $this->setupNonIsdnPi;
    }
    /**
     * Set setupNonIsdnPi value
     * @param string $setupNonIsdnPi
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XGatewayEndpointDigitalBri
     */
    public function setSetupNonIsdnPi($setupNonIsdnPi = null)
    {
        $this->setupNonIsdnPi = $setupNonIsdnPi;
        return $this;
    }
    /**
     * Get sigDigits value
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\SigDigits
     */
    public function getSigDigits()
    {
        return $this->sigDigits;
    }
    /**
     * Set sigDigits value
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\SigDigits $sigDigits
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XGatewayEndpointDigitalBri
     */
    public function setSigDigits(\\Losc\CucmBundle\Model\Webservice\StructType\SigDigits $sigDigits = null)
    {
        $this->sigDigits = $sigDigits;
        return $this;
    }
    /**
     * Get statusPoll value
     * @return string
     */
    public function getStatusPoll()
    {
        return $this->statusPoll;
    }
    /**
     * Set statusPoll value
     * @param string $statusPoll
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XGatewayEndpointDigitalBri
     */
    public function setStatusPoll($statusPoll = null)
    {
        $this->statusPoll = $statusPoll;
        return $this;
    }
    /**
     * Get GClearEnable value
     * @return string
     */
    public function getGClearEnable()
    {
        return $this->GClearEnable;
    }
    /**
     * Set GClearEnable value
     * @param string $gClearEnable
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XGatewayEndpointDigitalBri
     */
    public function setGClearEnable($gClearEnable = null)
    {
        $this->GClearEnable = $gClearEnable;
        return $this;
    }
    /**
     * Get description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->description;
    }
    /**
     * Set description value
     * @param string $description
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XGatewayEndpointDigitalBri
     */
    public function setDescription($description = null)
    {
        $this->description = $description;
        return $this;
    }
    /**
     * Get networkLocation value
     * @return string|null
     */
    public function getNetworkLocation()
    {
        return $this->networkLocation;
    }
    /**
     * Set networkLocation value
     * @param string $networkLocation
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XGatewayEndpointDigitalBri
     */
    public function setNetworkLocation($networkLocation = 'Use System Default')
    {
        $this->networkLocation = $networkLocation;
        return $this;
    }
    /**
     * Get networkLocale value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getNetworkLocale()
    {
        return isset($this->networkLocale) ? $this->networkLocale : null;
    }
    /**
     * Set networkLocale value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $networkLocale
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XGatewayEndpointDigitalBri
     */
    public function setNetworkLocale($networkLocale = null)
    {
        if (is_null($networkLocale) || (is_array($networkLocale) && empty($networkLocale))) {
            unset($this->networkLocale);
        } else {
            $this->networkLocale = $networkLocale;
        }
        return $this;
    }
    /**
     * Get vendorConfig value
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XVendorConfig|null
     */
    public function getVendorConfig()
    {
        return $this->vendorConfig;
    }
    /**
     * Set vendorConfig value
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XVendorConfig $vendorConfig
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XGatewayEndpointDigitalBri
     */
    public function setVendorConfig(\\Losc\CucmBundle\Model\Webservice\StructType\XVendorConfig $vendorConfig = null)
    {
        $this->vendorConfig = $vendorConfig;
        return $this;
    }
    /**
     * Get useDevicePoolCgpnTransformCss value
     * @return string|null
     */
    public function getUseDevicePoolCgpnTransformCss()
    {
        return $this->useDevicePoolCgpnTransformCss;
    }
    /**
     * Set useDevicePoolCgpnTransformCss value
     * @param string $useDevicePoolCgpnTransformCss
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XGatewayEndpointDigitalBri
     */
    public function setUseDevicePoolCgpnTransformCss($useDevicePoolCgpnTransformCss = 'true')
    {
        $this->useDevicePoolCgpnTransformCss = $useDevicePoolCgpnTransformCss;
        return $this;
    }
    /**
     * Get packetCaptureMode value
     * @return string|null
     */
    public function getPacketCaptureMode()
    {
        return $this->packetCaptureMode;
    }
    /**
     * Set packetCaptureMode value
     * @param string $packetCaptureMode
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XGatewayEndpointDigitalBri
     */
    public function setPacketCaptureMode($packetCaptureMode = 'None')
    {
        $this->packetCaptureMode = $packetCaptureMode;
        return $this;
    }
    /**
     * Get packetCaptureDuration value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPacketCaptureDuration()
    {
        return isset($this->packetCaptureDuration) ? $this->packetCaptureDuration : null;
    }
    /**
     * Set packetCaptureDuration value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $packetCaptureDuration
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XGatewayEndpointDigitalBri
     */
    public function setPacketCaptureDuration($packetCaptureDuration = '0')
    {
        if (is_null($packetCaptureDuration) || (is_array($packetCaptureDuration) && empty($packetCaptureDuration))) {
            unset($this->packetCaptureDuration);
        } else {
            $this->packetCaptureDuration = $packetCaptureDuration;
        }
        return $this;
    }
    /**
     * Get cdpnTransformationCssName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XFkType|null
     */
    public function getCdpnTransformationCssName()
    {
        return isset($this->cdpnTransformationCssName) ? $this->cdpnTransformationCssName : null;
    }
    /**
     * Set cdpnTransformationCssName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $cdpnTransformationCssName
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XGatewayEndpointDigitalBri
     */
    public function setCdpnTransformationCssName(\\Losc\CucmBundle\Model\Webservice\StructType\XFkType $cdpnTransformationCssName = null)
    {
        if (is_null($cdpnTransformationCssName) || (is_array($cdpnTransformationCssName) && empty($cdpnTransformationCssName))) {
            unset($this->cdpnTransformationCssName);
        } else {
            $this->cdpnTransformationCssName = $cdpnTransformationCssName;
        }
        return $this;
    }
    /**
     * Get useDevicePoolCdpnTransformCss value
     * @return string|null
     */
    public function getUseDevicePoolCdpnTransformCss()
    {
        return $this->useDevicePoolCdpnTransformCss;
    }
    /**
     * Set useDevicePoolCdpnTransformCss value
     * @param string $useDevicePoolCdpnTransformCss
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XGatewayEndpointDigitalBri
     */
    public function setUseDevicePoolCdpnTransformCss($useDevicePoolCdpnTransformCss = 'true')
    {
        $this->useDevicePoolCdpnTransformCss = $useDevicePoolCdpnTransformCss;
        return $this;
    }
    /**
     * Get geoLocationFilterName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XFkType|null
     */
    public function getGeoLocationFilterName()
    {
        return isset($this->geoLocationFilterName) ? $this->geoLocationFilterName : null;
    }
    /**
     * Set geoLocationFilterName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $geoLocationFilterName
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XGatewayEndpointDigitalBri
     */
    public function setGeoLocationFilterName(\\Losc\CucmBundle\Model\Webservice\StructType\XFkType $geoLocationFilterName = null)
    {
        if (is_null($geoLocationFilterName) || (is_array($geoLocationFilterName) && empty($geoLocationFilterName))) {
            unset($this->geoLocationFilterName);
        } else {
            $this->geoLocationFilterName = $geoLocationFilterName;
        }
        return $this;
    }
    /**
     * Get nationalPrefix value
     * @return string|null
     */
    public function getNationalPrefix()
    {
        return $this->nationalPrefix;
    }
    /**
     * Set nationalPrefix value
     * @param string $nationalPrefix
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XGatewayEndpointDigitalBri
     */
    public function setNationalPrefix($nationalPrefix = null)
    {
        $this->nationalPrefix = $nationalPrefix;
        return $this;
    }
    /**
     * Get internationalPrefix value
     * @return string|null
     */
    public function getInternationalPrefix()
    {
        return $this->internationalPrefix;
    }
    /**
     * Set internationalPrefix value
     * @param string $internationalPrefix
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XGatewayEndpointDigitalBri
     */
    public function setInternationalPrefix($internationalPrefix = null)
    {
        $this->internationalPrefix = $internationalPrefix;
        return $this;
    }
    /**
     * Get unknownPrefix value
     * @return string|null
     */
    public function getUnknownPrefix()
    {
        return $this->unknownPrefix;
    }
    /**
     * Set unknownPrefix value
     * @param string $unknownPrefix
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XGatewayEndpointDigitalBri
     */
    public function setUnknownPrefix($unknownPrefix = null)
    {
        $this->unknownPrefix = $unknownPrefix;
        return $this;
    }
    /**
     * Get subscriberPrefix value
     * @return string|null
     */
    public function getSubscriberPrefix()
    {
        return $this->subscriberPrefix;
    }
    /**
     * Set subscriberPrefix value
     * @param string $subscriberPrefix
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XGatewayEndpointDigitalBri
     */
    public function setSubscriberPrefix($subscriberPrefix = null)
    {
        $this->subscriberPrefix = $subscriberPrefix;
        return $this;
    }
    /**
     * Get nationalStripDigits value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getNationalStripDigits()
    {
        return isset($this->nationalStripDigits) ? $this->nationalStripDigits : null;
    }
    /**
     * Set nationalStripDigits value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $nationalStripDigits
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XGatewayEndpointDigitalBri
     */
    public function setNationalStripDigits($nationalStripDigits = null)
    {
        if (is_null($nationalStripDigits) || (is_array($nationalStripDigits) && empty($nationalStripDigits))) {
            unset($this->nationalStripDigits);
        } else {
            $this->nationalStripDigits = $nationalStripDigits;
        }
        return $this;
    }
    /**
     * Get internationalStripDigits value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getInternationalStripDigits()
    {
        return isset($this->internationalStripDigits) ? $this->internationalStripDigits : null;
    }
    /**
     * Set internationalStripDigits value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $internationalStripDigits
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XGatewayEndpointDigitalBri
     */
    public function setInternationalStripDigits($internationalStripDigits = null)
    {
        if (is_null($internationalStripDigits) || (is_array($internationalStripDigits) && empty($internationalStripDigits))) {
            unset($this->internationalStripDigits);
        } else {
            $this->internationalStripDigits = $internationalStripDigits;
        }
        return $this;
    }
    /**
     * Get unknownStripDigits value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getUnknownStripDigits()
    {
        return isset($this->unknownStripDigits) ? $this->unknownStripDigits : null;
    }
    /**
     * Set unknownStripDigits value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $unknownStripDigits
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XGatewayEndpointDigitalBri
     */
    public function setUnknownStripDigits($unknownStripDigits = null)
    {
        if (is_null($unknownStripDigits) || (is_array($unknownStripDigits) && empty($unknownStripDigits))) {
            unset($this->unknownStripDigits);
        } else {
            $this->unknownStripDigits = $unknownStripDigits;
        }
        return $this;
    }
    /**
     * Get subscriberStripDigits value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSubscriberStripDigits()
    {
        return isset($this->subscriberStripDigits) ? $this->subscriberStripDigits : null;
    }
    /**
     * Set subscriberStripDigits value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $subscriberStripDigits
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XGatewayEndpointDigitalBri
     */
    public function setSubscriberStripDigits($subscriberStripDigits = null)
    {
        if (is_null($subscriberStripDigits) || (is_array($subscriberStripDigits) && empty($subscriberStripDigits))) {
            unset($this->subscriberStripDigits);
        } else {
            $this->subscriberStripDigits = $subscriberStripDigits;
        }
        return $this;
    }
    /**
     * Get nationalTransformationCssName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XFkType|null
     */
    public function getNationalTransformationCssName()
    {
        return isset($this->nationalTransformationCssName) ? $this->nationalTransformationCssName : null;
    }
    /**
     * Set nationalTransformationCssName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $nationalTransformationCssName
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XGatewayEndpointDigitalBri
     */
    public function setNationalTransformationCssName(\\Losc\CucmBundle\Model\Webservice\StructType\XFkType $nationalTransformationCssName = null)
    {
        if (is_null($nationalTransformationCssName) || (is_array($nationalTransformationCssName) && empty($nationalTransformationCssName))) {
            unset($this->nationalTransformationCssName);
        } else {
            $this->nationalTransformationCssName = $nationalTransformationCssName;
        }
        return $this;
    }
    /**
     * Get internationalTransformationCssName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XFkType|null
     */
    public function getInternationalTransformationCssName()
    {
        return isset($this->internationalTransformationCssName) ? $this->internationalTransformationCssName : null;
    }
    /**
     * Set internationalTransformationCssName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $internationalTransformationCssName
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XGatewayEndpointDigitalBri
     */
    public function setInternationalTransformationCssName(\\Losc\CucmBundle\Model\Webservice\StructType\XFkType $internationalTransformationCssName = null)
    {
        if (is_null($internationalTransformationCssName) || (is_array($internationalTransformationCssName) && empty($internationalTransformationCssName))) {
            unset($this->internationalTransformationCssName);
        } else {
            $this->internationalTransformationCssName = $internationalTransformationCssName;
        }
        return $this;
    }
    /**
     * Get unknownTransformationCssName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XFkType|null
     */
    public function getUnknownTransformationCssName()
    {
        return isset($this->unknownTransformationCssName) ? $this->unknownTransformationCssName : null;
    }
    /**
     * Set unknownTransformationCssName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $unknownTransformationCssName
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XGatewayEndpointDigitalBri
     */
    public function setUnknownTransformationCssName(\\Losc\CucmBundle\Model\Webservice\StructType\XFkType $unknownTransformationCssName = null)
    {
        if (is_null($unknownTransformationCssName) || (is_array($unknownTransformationCssName) && empty($unknownTransformationCssName))) {
            unset($this->unknownTransformationCssName);
        } else {
            $this->unknownTransformationCssName = $unknownTransformationCssName;
        }
        return $this;
    }
    /**
     * Get subscriberTransformationCssName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XFkType|null
     */
    public function getSubscriberTransformationCssName()
    {
        return isset($this->subscriberTransformationCssName) ? $this->subscriberTransformationCssName : null;
    }
    /**
     * Set subscriberTransformationCssName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $subscriberTransformationCssName
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XGatewayEndpointDigitalBri
     */
    public function setSubscriberTransformationCssName(\\Losc\CucmBundle\Model\Webservice\StructType\XFkType $subscriberTransformationCssName = null)
    {
        if (is_null($subscriberTransformationCssName) || (is_array($subscriberTransformationCssName) && empty($subscriberTransformationCssName))) {
            unset($this->subscriberTransformationCssName);
        } else {
            $this->subscriberTransformationCssName = $subscriberTransformationCssName;
        }
        return $this;
    }
    /**
     * Get pstnAccess value
     * @return string|null
     */
    public function getPstnAccess()
    {
        return $this->pstnAccess;
    }
    /**
     * Set pstnAccess value
     * @param string $pstnAccess
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XGatewayEndpointDigitalBri
     */
    public function setPstnAccess($pstnAccess = 'true')
    {
        $this->pstnAccess = $pstnAccess;
        return $this;
    }
    /**
     * Get imeE164TransformationName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XFkType|null
     */
    public function getImeE164TransformationName()
    {
        return isset($this->imeE164TransformationName) ? $this->imeE164TransformationName : null;
    }
    /**
     * Set imeE164TransformationName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $imeE164TransformationName
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XGatewayEndpointDigitalBri
     */
    public function setImeE164TransformationName(\\Losc\CucmBundle\Model\Webservice\StructType\XFkType $imeE164TransformationName = null)
    {
        if (is_null($imeE164TransformationName) || (is_array($imeE164TransformationName) && empty($imeE164TransformationName))) {
            unset($this->imeE164TransformationName);
        } else {
            $this->imeE164TransformationName = $imeE164TransformationName;
        }
        return $this;
    }
    /**
     * Get useDevicePoolCgpnTransformCssNatl value
     * @return string|null
     */
    public function getUseDevicePoolCgpnTransformCssNatl()
    {
        return $this->useDevicePoolCgpnTransformCssNatl;
    }
    /**
     * Set useDevicePoolCgpnTransformCssNatl value
     * @param string $useDevicePoolCgpnTransformCssNatl
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XGatewayEndpointDigitalBri
     */
    public function setUseDevicePoolCgpnTransformCssNatl($useDevicePoolCgpnTransformCssNatl = 'true')
    {
        $this->useDevicePoolCgpnTransformCssNatl = $useDevicePoolCgpnTransformCssNatl;
        return $this;
    }
    /**
     * Get useDevicePoolCgpnTransformCssIntl value
     * @return string|null
     */
    public function getUseDevicePoolCgpnTransformCssIntl()
    {
        return $this->useDevicePoolCgpnTransformCssIntl;
    }
    /**
     * Set useDevicePoolCgpnTransformCssIntl value
     * @param string $useDevicePoolCgpnTransformCssIntl
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XGatewayEndpointDigitalBri
     */
    public function setUseDevicePoolCgpnTransformCssIntl($useDevicePoolCgpnTransformCssIntl = 'true')
    {
        $this->useDevicePoolCgpnTransformCssIntl = $useDevicePoolCgpnTransformCssIntl;
        return $this;
    }
    /**
     * Get useDevicePoolCgpnTransformCssUnkn value
     * @return string|null
     */
    public function getUseDevicePoolCgpnTransformCssUnkn()
    {
        return $this->useDevicePoolCgpnTransformCssUnkn;
    }
    /**
     * Set useDevicePoolCgpnTransformCssUnkn value
     * @param string $useDevicePoolCgpnTransformCssUnkn
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XGatewayEndpointDigitalBri
     */
    public function setUseDevicePoolCgpnTransformCssUnkn($useDevicePoolCgpnTransformCssUnkn = 'true')
    {
        $this->useDevicePoolCgpnTransformCssUnkn = $useDevicePoolCgpnTransformCssUnkn;
        return $this;
    }
    /**
     * Get useDevicePoolCgpnTransformCssSubs value
     * @return string|null
     */
    public function getUseDevicePoolCgpnTransformCssSubs()
    {
        return $this->useDevicePoolCgpnTransformCssSubs;
    }
    /**
     * Set useDevicePoolCgpnTransformCssSubs value
     * @param string $useDevicePoolCgpnTransformCssSubs
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XGatewayEndpointDigitalBri
     */
    public function setUseDevicePoolCgpnTransformCssSubs($useDevicePoolCgpnTransformCssSubs = 'true')
    {
        $this->useDevicePoolCgpnTransformCssSubs = $useDevicePoolCgpnTransformCssSubs;
        return $this;
    }
    /**
     * Get calledPartyNationalPrefix value
     * @return string|null
     */
    public function getCalledPartyNationalPrefix()
    {
        return $this->calledPartyNationalPrefix;
    }
    /**
     * Set calledPartyNationalPrefix value
     * @param string $calledPartyNationalPrefix
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XGatewayEndpointDigitalBri
     */
    public function setCalledPartyNationalPrefix($calledPartyNationalPrefix = null)
    {
        $this->calledPartyNationalPrefix = $calledPartyNationalPrefix;
        return $this;
    }
    /**
     * Get calledPartyInternationalPrefix value
     * @return string|null
     */
    public function getCalledPartyInternationalPrefix()
    {
        return $this->calledPartyInternationalPrefix;
    }
    /**
     * Set calledPartyInternationalPrefix value
     * @param string $calledPartyInternationalPrefix
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XGatewayEndpointDigitalBri
     */
    public function setCalledPartyInternationalPrefix($calledPartyInternationalPrefix = null)
    {
        $this->calledPartyInternationalPrefix = $calledPartyInternationalPrefix;
        return $this;
    }
    /**
     * Get calledPartyUnknownPrefix value
     * @return string|null
     */
    public function getCalledPartyUnknownPrefix()
    {
        return $this->calledPartyUnknownPrefix;
    }
    /**
     * Set calledPartyUnknownPrefix value
     * @param string $calledPartyUnknownPrefix
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XGatewayEndpointDigitalBri
     */
    public function setCalledPartyUnknownPrefix($calledPartyUnknownPrefix = null)
    {
        $this->calledPartyUnknownPrefix = $calledPartyUnknownPrefix;
        return $this;
    }
    /**
     * Get calledPartySubscriberPrefix value
     * @return string|null
     */
    public function getCalledPartySubscriberPrefix()
    {
        return $this->calledPartySubscriberPrefix;
    }
    /**
     * Set calledPartySubscriberPrefix value
     * @param string $calledPartySubscriberPrefix
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XGatewayEndpointDigitalBri
     */
    public function setCalledPartySubscriberPrefix($calledPartySubscriberPrefix = null)
    {
        $this->calledPartySubscriberPrefix = $calledPartySubscriberPrefix;
        return $this;
    }
    /**
     * Get calledPartyNationalStripDigits value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCalledPartyNationalStripDigits()
    {
        return isset($this->calledPartyNationalStripDigits) ? $this->calledPartyNationalStripDigits : null;
    }
    /**
     * Set calledPartyNationalStripDigits value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $calledPartyNationalStripDigits
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XGatewayEndpointDigitalBri
     */
    public function setCalledPartyNationalStripDigits($calledPartyNationalStripDigits = null)
    {
        if (is_null($calledPartyNationalStripDigits) || (is_array($calledPartyNationalStripDigits) && empty($calledPartyNationalStripDigits))) {
            unset($this->calledPartyNationalStripDigits);
        } else {
            $this->calledPartyNationalStripDigits = $calledPartyNationalStripDigits;
        }
        return $this;
    }
    /**
     * Get calledPartyInternationalStripDigits value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCalledPartyInternationalStripDigits()
    {
        return isset($this->calledPartyInternationalStripDigits) ? $this->calledPartyInternationalStripDigits : null;
    }
    /**
     * Set calledPartyInternationalStripDigits value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $calledPartyInternationalStripDigits
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XGatewayEndpointDigitalBri
     */
    public function setCalledPartyInternationalStripDigits($calledPartyInternationalStripDigits = null)
    {
        if (is_null($calledPartyInternationalStripDigits) || (is_array($calledPartyInternationalStripDigits) && empty($calledPartyInternationalStripDigits))) {
            unset($this->calledPartyInternationalStripDigits);
        } else {
            $this->calledPartyInternationalStripDigits = $calledPartyInternationalStripDigits;
        }
        return $this;
    }
    /**
     * Get calledPartyUnknownStripDigits value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCalledPartyUnknownStripDigits()
    {
        return isset($this->calledPartyUnknownStripDigits) ? $this->calledPartyUnknownStripDigits : null;
    }
    /**
     * Set calledPartyUnknownStripDigits value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $calledPartyUnknownStripDigits
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XGatewayEndpointDigitalBri
     */
    public function setCalledPartyUnknownStripDigits($calledPartyUnknownStripDigits = null)
    {
        if (is_null($calledPartyUnknownStripDigits) || (is_array($calledPartyUnknownStripDigits) && empty($calledPartyUnknownStripDigits))) {
            unset($this->calledPartyUnknownStripDigits);
        } else {
            $this->calledPartyUnknownStripDigits = $calledPartyUnknownStripDigits;
        }
        return $this;
    }
    /**
     * Get calledPartySubscriberStripDigits value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCalledPartySubscriberStripDigits()
    {
        return isset($this->calledPartySubscriberStripDigits) ? $this->calledPartySubscriberStripDigits : null;
    }
    /**
     * Set calledPartySubscriberStripDigits value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $calledPartySubscriberStripDigits
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XGatewayEndpointDigitalBri
     */
    public function setCalledPartySubscriberStripDigits($calledPartySubscriberStripDigits = null)
    {
        if (is_null($calledPartySubscriberStripDigits) || (is_array($calledPartySubscriberStripDigits) && empty($calledPartySubscriberStripDigits))) {
            unset($this->calledPartySubscriberStripDigits);
        } else {
            $this->calledPartySubscriberStripDigits = $calledPartySubscriberStripDigits;
        }
        return $this;
    }
    /**
     * Get calledPartyNationalTransformationCssName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XFkType|null
     */
    public function getCalledPartyNationalTransformationCssName()
    {
        return isset($this->calledPartyNationalTransformationCssName) ? $this->calledPartyNationalTransformationCssName : null;
    }
    /**
     * Set calledPartyNationalTransformationCssName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $calledPartyNationalTransformationCssName
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XGatewayEndpointDigitalBri
     */
    public function setCalledPartyNationalTransformationCssName(\\Losc\CucmBundle\Model\Webservice\StructType\XFkType $calledPartyNationalTransformationCssName = null)
    {
        if (is_null($calledPartyNationalTransformationCssName) || (is_array($calledPartyNationalTransformationCssName) && empty($calledPartyNationalTransformationCssName))) {
            unset($this->calledPartyNationalTransformationCssName);
        } else {
            $this->calledPartyNationalTransformationCssName = $calledPartyNationalTransformationCssName;
        }
        return $this;
    }
    /**
     * Get calledPartyInternationalTransformationCssName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XFkType|null
     */
    public function getCalledPartyInternationalTransformationCssName()
    {
        return isset($this->calledPartyInternationalTransformationCssName) ? $this->calledPartyInternationalTransformationCssName : null;
    }
    /**
     * Set calledPartyInternationalTransformationCssName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $calledPartyInternationalTransformationCssName
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XGatewayEndpointDigitalBri
     */
    public function setCalledPartyInternationalTransformationCssName(\\Losc\CucmBundle\Model\Webservice\StructType\XFkType $calledPartyInternationalTransformationCssName = null)
    {
        if (is_null($calledPartyInternationalTransformationCssName) || (is_array($calledPartyInternationalTransformationCssName) && empty($calledPartyInternationalTransformationCssName))) {
            unset($this->calledPartyInternationalTransformationCssName);
        } else {
            $this->calledPartyInternationalTransformationCssName = $calledPartyInternationalTransformationCssName;
        }
        return $this;
    }
    /**
     * Get calledPartyUnknownTransformationCssName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XFkType|null
     */
    public function getCalledPartyUnknownTransformationCssName()
    {
        return isset($this->calledPartyUnknownTransformationCssName) ? $this->calledPartyUnknownTransformationCssName : null;
    }
    /**
     * Set calledPartyUnknownTransformationCssName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $calledPartyUnknownTransformationCssName
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XGatewayEndpointDigitalBri
     */
    public function setCalledPartyUnknownTransformationCssName(\\Losc\CucmBundle\Model\Webservice\StructType\XFkType $calledPartyUnknownTransformationCssName = null)
    {
        if (is_null($calledPartyUnknownTransformationCssName) || (is_array($calledPartyUnknownTransformationCssName) && empty($calledPartyUnknownTransformationCssName))) {
            unset($this->calledPartyUnknownTransformationCssName);
        } else {
            $this->calledPartyUnknownTransformationCssName = $calledPartyUnknownTransformationCssName;
        }
        return $this;
    }
    /**
     * Get calledPartySubscriberTransformationCssName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XFkType|null
     */
    public function getCalledPartySubscriberTransformationCssName()
    {
        return isset($this->calledPartySubscriberTransformationCssName) ? $this->calledPartySubscriberTransformationCssName : null;
    }
    /**
     * Set calledPartySubscriberTransformationCssName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $calledPartySubscriberTransformationCssName
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XGatewayEndpointDigitalBri
     */
    public function setCalledPartySubscriberTransformationCssName(\\Losc\CucmBundle\Model\Webservice\StructType\XFkType $calledPartySubscriberTransformationCssName = null)
    {
        if (is_null($calledPartySubscriberTransformationCssName) || (is_array($calledPartySubscriberTransformationCssName) && empty($calledPartySubscriberTransformationCssName))) {
            unset($this->calledPartySubscriberTransformationCssName);
        } else {
            $this->calledPartySubscriberTransformationCssName = $calledPartySubscriberTransformationCssName;
        }
        return $this;
    }
    /**
     * Get useDevicePoolCalledCssNatl value
     * @return string|null
     */
    public function getUseDevicePoolCalledCssNatl()
    {
        return $this->useDevicePoolCalledCssNatl;
    }
    /**
     * Set useDevicePoolCalledCssNatl value
     * @param string $useDevicePoolCalledCssNatl
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XGatewayEndpointDigitalBri
     */
    public function setUseDevicePoolCalledCssNatl($useDevicePoolCalledCssNatl = 'true')
    {
        $this->useDevicePoolCalledCssNatl = $useDevicePoolCalledCssNatl;
        return $this;
    }
    /**
     * Get useDevicePoolCalledCssIntl value
     * @return string|null
     */
    public function getUseDevicePoolCalledCssIntl()
    {
        return $this->useDevicePoolCalledCssIntl;
    }
    /**
     * Set useDevicePoolCalledCssIntl value
     * @param string $useDevicePoolCalledCssIntl
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XGatewayEndpointDigitalBri
     */
    public function setUseDevicePoolCalledCssIntl($useDevicePoolCalledCssIntl = 'true')
    {
        $this->useDevicePoolCalledCssIntl = $useDevicePoolCalledCssIntl;
        return $this;
    }
    /**
     * Get useDevicePoolCalledCssUnkn value
     * @return string|null
     */
    public function getUseDevicePoolCalledCssUnkn()
    {
        return $this->useDevicePoolCalledCssUnkn;
    }
    /**
     * Set useDevicePoolCalledCssUnkn value
     * @param string $useDevicePoolCalledCssUnkn
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XGatewayEndpointDigitalBri
     */
    public function setUseDevicePoolCalledCssUnkn($useDevicePoolCalledCssUnkn = 'true')
    {
        $this->useDevicePoolCalledCssUnkn = $useDevicePoolCalledCssUnkn;
        return $this;
    }
    /**
     * Get useDevicePoolCalledCssSubs value
     * @return string|null
     */
    public function getUseDevicePoolCalledCssSubs()
    {
        return $this->useDevicePoolCalledCssSubs;
    }
    /**
     * Set useDevicePoolCalledCssSubs value
     * @param string $useDevicePoolCalledCssSubs
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XGatewayEndpointDigitalBri
     */
    public function setUseDevicePoolCalledCssSubs($useDevicePoolCalledCssSubs = 'true')
    {
        $this->useDevicePoolCalledCssSubs = $useDevicePoolCalledCssSubs;
        return $this;
    }
    /**
     * Get ctiid value
     * @return int|null
     */
    public function getCtiid()
    {
        return $this->ctiid;
    }
    /**
     * Set ctiid value
     * @param int $ctiid
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XGatewayEndpointDigitalBri
     */
    public function setCtiid($ctiid = null)
    {
        $this->ctiid = $ctiid;
        return $this;
    }
}
