<?php

namespace \Losc\CucmBundle\Model\Webservice\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for XConferenceBridge StructType
 * @subpackage Structs
 */
class XConferenceBridge extends AbstractStructBase
{
    /**
     * The name
     * Meta information extracted from the WSDL
     * - base: xsd:Name
     * - maxLength: 128
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $name;
    /**
     * The product
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $product;
    /**
     * The devicePoolName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $devicePoolName;
    /**
     * The locationName
     * Meta information extracted from the WSDL
     * - default: Hub_None
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $locationName;
    /**
     * The description
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 128
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $description;
    /**
     * The commonDeviceConfigName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $commonDeviceConfigName;
    /**
     * The subUnit
     * Meta information extracted from the WSDL
     * - documentation: Applicable for Cisco Conference Bridge (WS-SVC-CMM) and Cisco Media Server(WS-SVC-CMM-MS). Valid values range from 1 to 4.The value should be given as per the formula. Cisco Media Server : subunit = ((Extract two digits after 'A'
     * from the name)-2)/3 + 1. Cisco Conference Bridge: subunit = ((Extract two digits after 'C' from the name)-1)/3 + 1
     * - default: 0
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $subUnit;
    /**
     * The loadInformation
     * Meta information extracted from the WSDL
     * - documentation: This tag is used only by Cisco Conference Bridge Hardware.For devices with load information, if any special load information is specified, the special attribute is set to TRUE. Otherwise, the load information is the default for the
     * product.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\XLoadInformation
     */
    public $loadInformation;
    /**
     * The vendorConfig
     * Meta information extracted from the WSDL
     * - documentation: This tag is used only by Cisco Video Conference Bridge(IPVC-35xx),Cisco Conference Bridge (WS-SVC-CMM) and Cisco Media Server(WS-SVC-CMM-MS).
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\XVendorConfig
     */
    public $vendorConfig;
    /**
     * The maximumCapacity
     * Meta information extracted from the WSDL
     * - documentation: This tag is mandatory for Cisco Conference Bridge(WS-SVC-CMM) and Cisco Media Server(WS-SVC-CMM-MS). Valid values for this tag are 32,64,96,128.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $maximumCapacity;
    /**
     * The useTrustedRelayPoint
     * Meta information extracted from the WSDL
     * - default: Default
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $useTrustedRelayPoint;
    /**
     * The securityProfileName
     * Meta information extracted from the WSDL
     * - documentation: Valid only for Cisco IOS Enhanced Conference Bridge
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $securityProfileName;
    /**
     * The destinationAddress
     * Meta information extracted from the WSDL
     * - documentation: Valid only for Cisco TelePresence MCU
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $destinationAddress;
    /**
     * The mcuConferenceBridgeSipPort
     * Meta information extracted from the WSDL
     * - documentation: Valid only for Cisco TelePresence MCU
     * - default: 5060
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $mcuConferenceBridgeSipPort;
    /**
     * The sipProfile
     * Meta information extracted from the WSDL
     * - documentation: Valid only for Cisco TelePresence MCU
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $sipProfile;
    /**
     * The srtpAllowed
     * Meta information extracted from the WSDL
     * - documentation: Valid only for Cisco TelePresence MCU
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $srtpAllowed;
    /**
     * The normalizationScript
     * Meta information extracted from the WSDL
     * - documentation: Valid only for Cisco TelePresence MCU
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $normalizationScript;
    /**
     * The enableTrace
     * Meta information extracted from the WSDL
     * - documentation: Valid only for Cisco TelePresence MCU
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $enableTrace;
    /**
     * The normalizationScriptInfos
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\NormalizationScriptInfos
     */
    public $normalizationScriptInfos;
    /**
     * The userName
     * Meta information extracted from the WSDL
     * - documentation: Valid only for Cisco TelePresence MCU and max length is 31
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $userName;
    /**
     * The password
     * Meta information extracted from the WSDL
     * - documentation: Valid only for Cisco TelePresence MCU and max length is 31
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $password;
    /**
     * The httpPort
     * Meta information extracted from the WSDL
     * - documentation: Valid only for Cisco TelePresence MCU
     * - default: 80
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $httpPort;
    /**
     * The useHttps
     * Meta information extracted from the WSDL
     * - documentation: Valid only for Cisco TelePresence MCU
     * - base: xsd:string
     * - default: false
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $useHttps;
    /**
     * The addresses
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\Addresses
     */
    public $addresses;
    /**
     * The conferenceBridgePrefix
     * Meta information extracted from the WSDL
     * - documentation: Valid only for Cisco TelePresence Conference bridges
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $conferenceBridgePrefix;
    /**
     * The overrideSIPTrunkAddress
     * Meta information extracted from the WSDL
     * - documentation: Valid only for Cisco TelePresence Conference bridges
     * - base: xsd:string
     * - default: false
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $overrideSIPTrunkAddress;
    /**
     * The sipTrunkName
     * Meta information extracted from the WSDL
     * - documentation: Valid only for Cisco TelePresence Conference bridges
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $sipTrunkName;
    /**
     * Constructor method for XConferenceBridge
     * @uses XConferenceBridge::setName()
     * @uses XConferenceBridge::setProduct()
     * @uses XConferenceBridge::setDevicePoolName()
     * @uses XConferenceBridge::setLocationName()
     * @uses XConferenceBridge::setDescription()
     * @uses XConferenceBridge::setCommonDeviceConfigName()
     * @uses XConferenceBridge::setSubUnit()
     * @uses XConferenceBridge::setLoadInformation()
     * @uses XConferenceBridge::setVendorConfig()
     * @uses XConferenceBridge::setMaximumCapacity()
     * @uses XConferenceBridge::setUseTrustedRelayPoint()
     * @uses XConferenceBridge::setSecurityProfileName()
     * @uses XConferenceBridge::setDestinationAddress()
     * @uses XConferenceBridge::setMcuConferenceBridgeSipPort()
     * @uses XConferenceBridge::setSipProfile()
     * @uses XConferenceBridge::setSrtpAllowed()
     * @uses XConferenceBridge::setNormalizationScript()
     * @uses XConferenceBridge::setEnableTrace()
     * @uses XConferenceBridge::setNormalizationScriptInfos()
     * @uses XConferenceBridge::setUserName()
     * @uses XConferenceBridge::setPassword()
     * @uses XConferenceBridge::setHttpPort()
     * @uses XConferenceBridge::setUseHttps()
     * @uses XConferenceBridge::setAddresses()
     * @uses XConferenceBridge::setConferenceBridgePrefix()
     * @uses XConferenceBridge::setOverrideSIPTrunkAddress()
     * @uses XConferenceBridge::setSipTrunkName()
     * @param string $name
     * @param string $product
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $devicePoolName
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $locationName
     * @param string $description
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $commonDeviceConfigName
     * @param string $subUnit
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XLoadInformation $loadInformation
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XVendorConfig $vendorConfig
     * @param string $maximumCapacity
     * @param string $useTrustedRelayPoint
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $securityProfileName
     * @param string $destinationAddress
     * @param string $mcuConferenceBridgeSipPort
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $sipProfile
     * @param string $srtpAllowed
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $normalizationScript
     * @param string $enableTrace
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\NormalizationScriptInfos $normalizationScriptInfos
     * @param string $userName
     * @param string $password
     * @param string $httpPort
     * @param string $useHttps
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\Addresses $addresses
     * @param string $conferenceBridgePrefix
     * @param string $overrideSIPTrunkAddress
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $sipTrunkName
     */
    public function __construct($name = null, $product = null, \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $devicePoolName = null, \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $locationName = 'Hub_None', $description = null, \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $commonDeviceConfigName = null, $subUnit = '0', \\Losc\CucmBundle\Model\Webservice\StructType\XLoadInformation $loadInformation = null, \\Losc\CucmBundle\Model\Webservice\StructType\XVendorConfig $vendorConfig = null, $maximumCapacity = null, $useTrustedRelayPoint = 'Default', \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $securityProfileName = null, $destinationAddress = null, $mcuConferenceBridgeSipPort = '5060', \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $sipProfile = null, $srtpAllowed = null, \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $normalizationScript = null, $enableTrace = null, \\Losc\CucmBundle\Model\Webservice\StructType\NormalizationScriptInfos $normalizationScriptInfos = null, $userName = null, $password = null, $httpPort = '80', $useHttps = 'false', \\Losc\CucmBundle\Model\Webservice\StructType\Addresses $addresses = null, $conferenceBridgePrefix = null, $overrideSIPTrunkAddress = 'false', \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $sipTrunkName = null)
    {
        $this
            ->setName($name)
            ->setProduct($product)
            ->setDevicePoolName($devicePoolName)
            ->setLocationName($locationName)
            ->setDescription($description)
            ->setCommonDeviceConfigName($commonDeviceConfigName)
            ->setSubUnit($subUnit)
            ->setLoadInformation($loadInformation)
            ->setVendorConfig($vendorConfig)
            ->setMaximumCapacity($maximumCapacity)
            ->setUseTrustedRelayPoint($useTrustedRelayPoint)
            ->setSecurityProfileName($securityProfileName)
            ->setDestinationAddress($destinationAddress)
            ->setMcuConferenceBridgeSipPort($mcuConferenceBridgeSipPort)
            ->setSipProfile($sipProfile)
            ->setSrtpAllowed($srtpAllowed)
            ->setNormalizationScript($normalizationScript)
            ->setEnableTrace($enableTrace)
            ->setNormalizationScriptInfos($normalizationScriptInfos)
            ->setUserName($userName)
            ->setPassword($password)
            ->setHttpPort($httpPort)
            ->setUseHttps($useHttps)
            ->setAddresses($addresses)
            ->setConferenceBridgePrefix($conferenceBridgePrefix)
            ->setOverrideSIPTrunkAddress($overrideSIPTrunkAddress)
            ->setSipTrunkName($sipTrunkName);
    }
    /**
     * Get name value
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Set name value
     * @param string $name
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XConferenceBridge
     */
    public function setName($name = null)
    {
        $this->name = $name;
        return $this;
    }
    /**
     * Get product value
     * @return string
     */
    public function getProduct()
    {
        return $this->product;
    }
    /**
     * Set product value
     * @param string $product
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XConferenceBridge
     */
    public function setProduct($product = null)
    {
        $this->product = $product;
        return $this;
    }
    /**
     * Get devicePoolName value
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public function getDevicePoolName()
    {
        return $this->devicePoolName;
    }
    /**
     * Set devicePoolName value
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $devicePoolName
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XConferenceBridge
     */
    public function setDevicePoolName(\\Losc\CucmBundle\Model\Webservice\StructType\XFkType $devicePoolName = null)
    {
        $this->devicePoolName = $devicePoolName;
        return $this;
    }
    /**
     * Get locationName value
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public function getLocationName()
    {
        return $this->locationName;
    }
    /**
     * Set locationName value
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $locationName
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XConferenceBridge
     */
    public function setLocationName(\\Losc\CucmBundle\Model\Webservice\StructType\XFkType $locationName = 'Hub_None')
    {
        $this->locationName = $locationName;
        return $this;
    }
    /**
     * Get description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->description;
    }
    /**
     * Set description value
     * @param string $description
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XConferenceBridge
     */
    public function setDescription($description = null)
    {
        $this->description = $description;
        return $this;
    }
    /**
     * Get commonDeviceConfigName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XFkType|null
     */
    public function getCommonDeviceConfigName()
    {
        return isset($this->commonDeviceConfigName) ? $this->commonDeviceConfigName : null;
    }
    /**
     * Set commonDeviceConfigName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $commonDeviceConfigName
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XConferenceBridge
     */
    public function setCommonDeviceConfigName(\\Losc\CucmBundle\Model\Webservice\StructType\XFkType $commonDeviceConfigName = null)
    {
        if (is_null($commonDeviceConfigName) || (is_array($commonDeviceConfigName) && empty($commonDeviceConfigName))) {
            unset($this->commonDeviceConfigName);
        } else {
            $this->commonDeviceConfigName = $commonDeviceConfigName;
        }
        return $this;
    }
    /**
     * Get subUnit value
     * @return string|null
     */
    public function getSubUnit()
    {
        return $this->subUnit;
    }
    /**
     * Set subUnit value
     * @param string $subUnit
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XConferenceBridge
     */
    public function setSubUnit($subUnit = '0')
    {
        $this->subUnit = $subUnit;
        return $this;
    }
    /**
     * Get loadInformation value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XLoadInformation|null
     */
    public function getLoadInformation()
    {
        return isset($this->loadInformation) ? $this->loadInformation : null;
    }
    /**
     * Set loadInformation value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XLoadInformation $loadInformation
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XConferenceBridge
     */
    public function setLoadInformation(\\Losc\CucmBundle\Model\Webservice\StructType\XLoadInformation $loadInformation = null)
    {
        if (is_null($loadInformation) || (is_array($loadInformation) && empty($loadInformation))) {
            unset($this->loadInformation);
        } else {
            $this->loadInformation = $loadInformation;
        }
        return $this;
    }
    /**
     * Get vendorConfig value
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XVendorConfig|null
     */
    public function getVendorConfig()
    {
        return $this->vendorConfig;
    }
    /**
     * Set vendorConfig value
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XVendorConfig $vendorConfig
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XConferenceBridge
     */
    public function setVendorConfig(\\Losc\CucmBundle\Model\Webservice\StructType\XVendorConfig $vendorConfig = null)
    {
        $this->vendorConfig = $vendorConfig;
        return $this;
    }
    /**
     * Get maximumCapacity value
     * @return string|null
     */
    public function getMaximumCapacity()
    {
        return $this->maximumCapacity;
    }
    /**
     * Set maximumCapacity value
     * @param string $maximumCapacity
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XConferenceBridge
     */
    public function setMaximumCapacity($maximumCapacity = null)
    {
        $this->maximumCapacity = $maximumCapacity;
        return $this;
    }
    /**
     * Get useTrustedRelayPoint value
     * @return string|null
     */
    public function getUseTrustedRelayPoint()
    {
        return $this->useTrustedRelayPoint;
    }
    /**
     * Set useTrustedRelayPoint value
     * @param string $useTrustedRelayPoint
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XConferenceBridge
     */
    public function setUseTrustedRelayPoint($useTrustedRelayPoint = 'Default')
    {
        $this->useTrustedRelayPoint = $useTrustedRelayPoint;
        return $this;
    }
    /**
     * Get securityProfileName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XFkType|null
     */
    public function getSecurityProfileName()
    {
        return isset($this->securityProfileName) ? $this->securityProfileName : null;
    }
    /**
     * Set securityProfileName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $securityProfileName
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XConferenceBridge
     */
    public function setSecurityProfileName(\\Losc\CucmBundle\Model\Webservice\StructType\XFkType $securityProfileName = null)
    {
        if (is_null($securityProfileName) || (is_array($securityProfileName) && empty($securityProfileName))) {
            unset($this->securityProfileName);
        } else {
            $this->securityProfileName = $securityProfileName;
        }
        return $this;
    }
    /**
     * Get destinationAddress value
     * @return string|null
     */
    public function getDestinationAddress()
    {
        return $this->destinationAddress;
    }
    /**
     * Set destinationAddress value
     * @param string $destinationAddress
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XConferenceBridge
     */
    public function setDestinationAddress($destinationAddress = null)
    {
        $this->destinationAddress = $destinationAddress;
        return $this;
    }
    /**
     * Get mcuConferenceBridgeSipPort value
     * @return string|null
     */
    public function getMcuConferenceBridgeSipPort()
    {
        return $this->mcuConferenceBridgeSipPort;
    }
    /**
     * Set mcuConferenceBridgeSipPort value
     * @param string $mcuConferenceBridgeSipPort
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XConferenceBridge
     */
    public function setMcuConferenceBridgeSipPort($mcuConferenceBridgeSipPort = '5060')
    {
        $this->mcuConferenceBridgeSipPort = $mcuConferenceBridgeSipPort;
        return $this;
    }
    /**
     * Get sipProfile value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XFkType|null
     */
    public function getSipProfile()
    {
        return isset($this->sipProfile) ? $this->sipProfile : null;
    }
    /**
     * Set sipProfile value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $sipProfile
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XConferenceBridge
     */
    public function setSipProfile(\\Losc\CucmBundle\Model\Webservice\StructType\XFkType $sipProfile = null)
    {
        if (is_null($sipProfile) || (is_array($sipProfile) && empty($sipProfile))) {
            unset($this->sipProfile);
        } else {
            $this->sipProfile = $sipProfile;
        }
        return $this;
    }
    /**
     * Get srtpAllowed value
     * @return string|null
     */
    public function getSrtpAllowed()
    {
        return $this->srtpAllowed;
    }
    /**
     * Set srtpAllowed value
     * @param string $srtpAllowed
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XConferenceBridge
     */
    public function setSrtpAllowed($srtpAllowed = null)
    {
        $this->srtpAllowed = $srtpAllowed;
        return $this;
    }
    /**
     * Get normalizationScript value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XFkType|null
     */
    public function getNormalizationScript()
    {
        return isset($this->normalizationScript) ? $this->normalizationScript : null;
    }
    /**
     * Set normalizationScript value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $normalizationScript
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XConferenceBridge
     */
    public function setNormalizationScript(\\Losc\CucmBundle\Model\Webservice\StructType\XFkType $normalizationScript = null)
    {
        if (is_null($normalizationScript) || (is_array($normalizationScript) && empty($normalizationScript))) {
            unset($this->normalizationScript);
        } else {
            $this->normalizationScript = $normalizationScript;
        }
        return $this;
    }
    /**
     * Get enableTrace value
     * @return string|null
     */
    public function getEnableTrace()
    {
        return $this->enableTrace;
    }
    /**
     * Set enableTrace value
     * @param string $enableTrace
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XConferenceBridge
     */
    public function setEnableTrace($enableTrace = null)
    {
        $this->enableTrace = $enableTrace;
        return $this;
    }
    /**
     * Get normalizationScriptInfos value
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\NormalizationScriptInfos|null
     */
    public function getNormalizationScriptInfos()
    {
        return $this->normalizationScriptInfos;
    }
    /**
     * Set normalizationScriptInfos value
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\NormalizationScriptInfos $normalizationScriptInfos
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XConferenceBridge
     */
    public function setNormalizationScriptInfos(\\Losc\CucmBundle\Model\Webservice\StructType\NormalizationScriptInfos $normalizationScriptInfos = null)
    {
        $this->normalizationScriptInfos = $normalizationScriptInfos;
        return $this;
    }
    /**
     * Get userName value
     * @return string|null
     */
    public function getUserName()
    {
        return $this->userName;
    }
    /**
     * Set userName value
     * @param string $userName
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XConferenceBridge
     */
    public function setUserName($userName = null)
    {
        $this->userName = $userName;
        return $this;
    }
    /**
     * Get password value
     * @return string|null
     */
    public function getPassword()
    {
        return $this->password;
    }
    /**
     * Set password value
     * @param string $password
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XConferenceBridge
     */
    public function setPassword($password = null)
    {
        $this->password = $password;
        return $this;
    }
    /**
     * Get httpPort value
     * @return string|null
     */
    public function getHttpPort()
    {
        return $this->httpPort;
    }
    /**
     * Set httpPort value
     * @param string $httpPort
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XConferenceBridge
     */
    public function setHttpPort($httpPort = '80')
    {
        $this->httpPort = $httpPort;
        return $this;
    }
    /**
     * Get useHttps value
     * @return string|null
     */
    public function getUseHttps()
    {
        return $this->useHttps;
    }
    /**
     * Set useHttps value
     * @param string $useHttps
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XConferenceBridge
     */
    public function setUseHttps($useHttps = 'false')
    {
        $this->useHttps = $useHttps;
        return $this;
    }
    /**
     * Get addresses value
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\Addresses|null
     */
    public function getAddresses()
    {
        return $this->addresses;
    }
    /**
     * Set addresses value
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\Addresses $addresses
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XConferenceBridge
     */
    public function setAddresses(\\Losc\CucmBundle\Model\Webservice\StructType\Addresses $addresses = null)
    {
        $this->addresses = $addresses;
        return $this;
    }
    /**
     * Get conferenceBridgePrefix value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getConferenceBridgePrefix()
    {
        return isset($this->conferenceBridgePrefix) ? $this->conferenceBridgePrefix : null;
    }
    /**
     * Set conferenceBridgePrefix value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $conferenceBridgePrefix
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XConferenceBridge
     */
    public function setConferenceBridgePrefix($conferenceBridgePrefix = null)
    {
        if (is_null($conferenceBridgePrefix) || (is_array($conferenceBridgePrefix) && empty($conferenceBridgePrefix))) {
            unset($this->conferenceBridgePrefix);
        } else {
            $this->conferenceBridgePrefix = $conferenceBridgePrefix;
        }
        return $this;
    }
    /**
     * Get overrideSIPTrunkAddress value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOverrideSIPTrunkAddress()
    {
        return isset($this->overrideSIPTrunkAddress) ? $this->overrideSIPTrunkAddress : null;
    }
    /**
     * Set overrideSIPTrunkAddress value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $overrideSIPTrunkAddress
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XConferenceBridge
     */
    public function setOverrideSIPTrunkAddress($overrideSIPTrunkAddress = 'false')
    {
        if (is_null($overrideSIPTrunkAddress) || (is_array($overrideSIPTrunkAddress) && empty($overrideSIPTrunkAddress))) {
            unset($this->overrideSIPTrunkAddress);
        } else {
            $this->overrideSIPTrunkAddress = $overrideSIPTrunkAddress;
        }
        return $this;
    }
    /**
     * Get sipTrunkName value
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XFkType|null
     */
    public function getSipTrunkName()
    {
        return $this->sipTrunkName;
    }
    /**
     * Set sipTrunkName value
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $sipTrunkName
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XConferenceBridge
     */
    public function setSipTrunkName(\\Losc\CucmBundle\Model\Webservice\StructType\XFkType $sipTrunkName = null)
    {
        $this->sipTrunkName = $sipTrunkName;
        return $this;
    }
}
