<?php

namespace \Losc\CucmBundle\Model\Webservice\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for XCallsQueue StructType
 * @subpackage Structs
 */
class XCallsQueue extends AbstractStructBase
{
    /**
     * The maxCallersInQueue
     * Meta information extracted from the WSDL
     * - default: 32
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $maxCallersInQueue;
    /**
     * The maxWaitTimeInQueue
     * Meta information extracted from the WSDL
     * - default: 900
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $maxWaitTimeInQueue;
    /**
     * The queueFullDestination
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 50
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $queueFullDestination;
    /**
     * The callingSearchSpacePilotQueueFull
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $callingSearchSpacePilotQueueFull;
    /**
     * The maxWaitTimeDestination
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 50
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $maxWaitTimeDestination;
    /**
     * The callingSearchSpaceMaxWaitTime
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $callingSearchSpaceMaxWaitTime;
    /**
     * The noAgentDestination
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 50
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $noAgentDestination;
    /**
     * The callingSearchSpaceNoAgent
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $callingSearchSpaceNoAgent;
    /**
     * The networkHoldMohAudioSourceID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $networkHoldMohAudioSourceID;
    /**
     * Constructor method for XCallsQueue
     * @uses XCallsQueue::setMaxCallersInQueue()
     * @uses XCallsQueue::setMaxWaitTimeInQueue()
     * @uses XCallsQueue::setQueueFullDestination()
     * @uses XCallsQueue::setCallingSearchSpacePilotQueueFull()
     * @uses XCallsQueue::setMaxWaitTimeDestination()
     * @uses XCallsQueue::setCallingSearchSpaceMaxWaitTime()
     * @uses XCallsQueue::setNoAgentDestination()
     * @uses XCallsQueue::setCallingSearchSpaceNoAgent()
     * @uses XCallsQueue::setNetworkHoldMohAudioSourceID()
     * @param string $maxCallersInQueue
     * @param string $maxWaitTimeInQueue
     * @param string $queueFullDestination
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $callingSearchSpacePilotQueueFull
     * @param string $maxWaitTimeDestination
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $callingSearchSpaceMaxWaitTime
     * @param string $noAgentDestination
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $callingSearchSpaceNoAgent
     * @param string $networkHoldMohAudioSourceID
     */
    public function __construct($maxCallersInQueue = '32', $maxWaitTimeInQueue = '900', $queueFullDestination = null, \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $callingSearchSpacePilotQueueFull = null, $maxWaitTimeDestination = null, \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $callingSearchSpaceMaxWaitTime = null, $noAgentDestination = null, \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $callingSearchSpaceNoAgent = null, $networkHoldMohAudioSourceID = null)
    {
        $this
            ->setMaxCallersInQueue($maxCallersInQueue)
            ->setMaxWaitTimeInQueue($maxWaitTimeInQueue)
            ->setQueueFullDestination($queueFullDestination)
            ->setCallingSearchSpacePilotQueueFull($callingSearchSpacePilotQueueFull)
            ->setMaxWaitTimeDestination($maxWaitTimeDestination)
            ->setCallingSearchSpaceMaxWaitTime($callingSearchSpaceMaxWaitTime)
            ->setNoAgentDestination($noAgentDestination)
            ->setCallingSearchSpaceNoAgent($callingSearchSpaceNoAgent)
            ->setNetworkHoldMohAudioSourceID($networkHoldMohAudioSourceID);
    }
    /**
     * Get maxCallersInQueue value
     * @return string
     */
    public function getMaxCallersInQueue()
    {
        return $this->maxCallersInQueue;
    }
    /**
     * Set maxCallersInQueue value
     * @param string $maxCallersInQueue
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XCallsQueue
     */
    public function setMaxCallersInQueue($maxCallersInQueue = '32')
    {
        $this->maxCallersInQueue = $maxCallersInQueue;
        return $this;
    }
    /**
     * Get maxWaitTimeInQueue value
     * @return string
     */
    public function getMaxWaitTimeInQueue()
    {
        return $this->maxWaitTimeInQueue;
    }
    /**
     * Set maxWaitTimeInQueue value
     * @param string $maxWaitTimeInQueue
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XCallsQueue
     */
    public function setMaxWaitTimeInQueue($maxWaitTimeInQueue = '900')
    {
        $this->maxWaitTimeInQueue = $maxWaitTimeInQueue;
        return $this;
    }
    /**
     * Get queueFullDestination value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getQueueFullDestination()
    {
        return isset($this->queueFullDestination) ? $this->queueFullDestination : null;
    }
    /**
     * Set queueFullDestination value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $queueFullDestination
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XCallsQueue
     */
    public function setQueueFullDestination($queueFullDestination = null)
    {
        if (is_null($queueFullDestination) || (is_array($queueFullDestination) && empty($queueFullDestination))) {
            unset($this->queueFullDestination);
        } else {
            $this->queueFullDestination = $queueFullDestination;
        }
        return $this;
    }
    /**
     * Get callingSearchSpacePilotQueueFull value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XFkType|null
     */
    public function getCallingSearchSpacePilotQueueFull()
    {
        return isset($this->callingSearchSpacePilotQueueFull) ? $this->callingSearchSpacePilotQueueFull : null;
    }
    /**
     * Set callingSearchSpacePilotQueueFull value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $callingSearchSpacePilotQueueFull
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XCallsQueue
     */
    public function setCallingSearchSpacePilotQueueFull(\\Losc\CucmBundle\Model\Webservice\StructType\XFkType $callingSearchSpacePilotQueueFull = null)
    {
        if (is_null($callingSearchSpacePilotQueueFull) || (is_array($callingSearchSpacePilotQueueFull) && empty($callingSearchSpacePilotQueueFull))) {
            unset($this->callingSearchSpacePilotQueueFull);
        } else {
            $this->callingSearchSpacePilotQueueFull = $callingSearchSpacePilotQueueFull;
        }
        return $this;
    }
    /**
     * Get maxWaitTimeDestination value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMaxWaitTimeDestination()
    {
        return isset($this->maxWaitTimeDestination) ? $this->maxWaitTimeDestination : null;
    }
    /**
     * Set maxWaitTimeDestination value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $maxWaitTimeDestination
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XCallsQueue
     */
    public function setMaxWaitTimeDestination($maxWaitTimeDestination = null)
    {
        if (is_null($maxWaitTimeDestination) || (is_array($maxWaitTimeDestination) && empty($maxWaitTimeDestination))) {
            unset($this->maxWaitTimeDestination);
        } else {
            $this->maxWaitTimeDestination = $maxWaitTimeDestination;
        }
        return $this;
    }
    /**
     * Get callingSearchSpaceMaxWaitTime value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XFkType|null
     */
    public function getCallingSearchSpaceMaxWaitTime()
    {
        return isset($this->callingSearchSpaceMaxWaitTime) ? $this->callingSearchSpaceMaxWaitTime : null;
    }
    /**
     * Set callingSearchSpaceMaxWaitTime value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $callingSearchSpaceMaxWaitTime
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XCallsQueue
     */
    public function setCallingSearchSpaceMaxWaitTime(\\Losc\CucmBundle\Model\Webservice\StructType\XFkType $callingSearchSpaceMaxWaitTime = null)
    {
        if (is_null($callingSearchSpaceMaxWaitTime) || (is_array($callingSearchSpaceMaxWaitTime) && empty($callingSearchSpaceMaxWaitTime))) {
            unset($this->callingSearchSpaceMaxWaitTime);
        } else {
            $this->callingSearchSpaceMaxWaitTime = $callingSearchSpaceMaxWaitTime;
        }
        return $this;
    }
    /**
     * Get noAgentDestination value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getNoAgentDestination()
    {
        return isset($this->noAgentDestination) ? $this->noAgentDestination : null;
    }
    /**
     * Set noAgentDestination value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $noAgentDestination
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XCallsQueue
     */
    public function setNoAgentDestination($noAgentDestination = null)
    {
        if (is_null($noAgentDestination) || (is_array($noAgentDestination) && empty($noAgentDestination))) {
            unset($this->noAgentDestination);
        } else {
            $this->noAgentDestination = $noAgentDestination;
        }
        return $this;
    }
    /**
     * Get callingSearchSpaceNoAgent value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XFkType|null
     */
    public function getCallingSearchSpaceNoAgent()
    {
        return isset($this->callingSearchSpaceNoAgent) ? $this->callingSearchSpaceNoAgent : null;
    }
    /**
     * Set callingSearchSpaceNoAgent value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $callingSearchSpaceNoAgent
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XCallsQueue
     */
    public function setCallingSearchSpaceNoAgent(\\Losc\CucmBundle\Model\Webservice\StructType\XFkType $callingSearchSpaceNoAgent = null)
    {
        if (is_null($callingSearchSpaceNoAgent) || (is_array($callingSearchSpaceNoAgent) && empty($callingSearchSpaceNoAgent))) {
            unset($this->callingSearchSpaceNoAgent);
        } else {
            $this->callingSearchSpaceNoAgent = $callingSearchSpaceNoAgent;
        }
        return $this;
    }
    /**
     * Get networkHoldMohAudioSourceID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getNetworkHoldMohAudioSourceID()
    {
        return isset($this->networkHoldMohAudioSourceID) ? $this->networkHoldMohAudioSourceID : null;
    }
    /**
     * Set networkHoldMohAudioSourceID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $networkHoldMohAudioSourceID
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XCallsQueue
     */
    public function setNetworkHoldMohAudioSourceID($networkHoldMohAudioSourceID = null)
    {
        if (is_null($networkHoldMohAudioSourceID) || (is_array($networkHoldMohAudioSourceID) && empty($networkHoldMohAudioSourceID))) {
            unset($this->networkHoldMohAudioSourceID);
        } else {
            $this->networkHoldMohAudioSourceID = $networkHoldMohAudioSourceID;
        }
        return $this;
    }
}
