<?php

namespace \Losc\CucmBundle\Model\Webservice\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UpdateUniversalLineTemplateReq StructType
 * @subpackage Structs
 */
class UpdateUniversalLineTemplateReq extends NameAndGUIDRequest
{
    /**
     * The newName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $newName;
    /**
     * The urgentPriority
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $urgentPriority;
    /**
     * The lineDescription
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $lineDescription;
    /**
     * The routePartition
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $routePartition;
    /**
     * The voiceMailProfile
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $voiceMailProfile;
    /**
     * The callingSearchSpace
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $callingSearchSpace;
    /**
     * The alertingName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $alertingName;
    /**
     * The extCallControlProfile
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $extCallControlProfile;
    /**
     * The blfPresenceGroup
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $blfPresenceGroup;
    /**
     * The callPickupGroup
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $callPickupGroup;
    /**
     * The partyEntranceTone
     * Meta information extracted from the WSDL
     * - default: Default
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $partyEntranceTone;
    /**
     * The autoAnswer
     * Meta information extracted from the WSDL
     * - default: Auto Answer Off
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $autoAnswer;
    /**
     * The rejectAnonymousCall
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $rejectAnonymousCall;
    /**
     * The userHoldMohAudioSource
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $userHoldMohAudioSource;
    /**
     * The networkHoldMohAudioSource
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $networkHoldMohAudioSource;
    /**
     * The aarDestinationMask
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 128
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $aarDestinationMask;
    /**
     * The aarGroup
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $aarGroup;
    /**
     * The retainDestInCallFwdHistory
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $retainDestInCallFwdHistory;
    /**
     * The forwardDestAllCalls
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $forwardDestAllCalls;
    /**
     * The primaryCssForwardingAllCalls
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $primaryCssForwardingAllCalls;
    /**
     * The secondaryCssForwardingAllCalls
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $secondaryCssForwardingAllCalls;
    /**
     * The CssActivationPolicy
     * Meta information extracted from the WSDL
     * - default: Use System Default
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $CssActivationPolicy;
    /**
     * The fwdDestExtCallsWhenNotRetrieved
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $fwdDestExtCallsWhenNotRetrieved;
    /**
     * The cssFwdExtCallsWhenNotRetrieved
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $cssFwdExtCallsWhenNotRetrieved;
    /**
     * The fwdDestInternalCallsWhenNotRetrieved
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $fwdDestInternalCallsWhenNotRetrieved;
    /**
     * The cssFwdInternalCallsWhenNotRetrieved
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $cssFwdInternalCallsWhenNotRetrieved;
    /**
     * The parkMonitorReversionTime
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $parkMonitorReversionTime;
    /**
     * The target
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $target;
    /**
     * The mlppCss
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $mlppCss;
    /**
     * The mlppNoAnsRingDuration
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $mlppNoAnsRingDuration;
    /**
     * The confidentialAccess
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\ConfidentialAccess
     */
    public $confidentialAccess;
    /**
     * The holdReversionRingDuration
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $holdReversionRingDuration;
    /**
     * The holdReversionNotificationInterval
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $holdReversionNotificationInterval;
    /**
     * The busyIntCallsDestination
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $busyIntCallsDestination;
    /**
     * The busyIntCallsCss
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $busyIntCallsCss;
    /**
     * The busyExtCallsDestination
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $busyExtCallsDestination;
    /**
     * The busyExtCallsCss
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $busyExtCallsCss;
    /**
     * The noAnsIntCallsDestination
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $noAnsIntCallsDestination;
    /**
     * The noAnsIntCallsCss
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $noAnsIntCallsCss;
    /**
     * The noAnsExtCallsDestination
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $noAnsExtCallsDestination;
    /**
     * The noAnsExtCallsCss
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $noAnsExtCallsCss;
    /**
     * The noCoverageIntCallsDestination
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $noCoverageIntCallsDestination;
    /**
     * The noCoverageIntCallsCss
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $noCoverageIntCallsCss;
    /**
     * The noCoverageExtCallsDestination
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $noCoverageExtCallsDestination;
    /**
     * The noCoverageExtCallsCss
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $noCoverageExtCallsCss;
    /**
     * The unregisteredIntCallsDestination
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $unregisteredIntCallsDestination;
    /**
     * The unregisteredIntCallsCss
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $unregisteredIntCallsCss;
    /**
     * The unregisteredExtCallsDestination
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $unregisteredExtCallsDestination;
    /**
     * The unregisteredExtCallsCss
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $unregisteredExtCallsCss;
    /**
     * The ctiFailureDestination
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $ctiFailureDestination;
    /**
     * The ctiFailureCss
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $ctiFailureCss;
    /**
     * The callControlAgentProfile
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $callControlAgentProfile;
    /**
     * The enterpriseAltNum
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\EnterpriseAltNum
     */
    public $enterpriseAltNum;
    /**
     * The e164AltNum
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\E164AltNum
     */
    public $e164AltNum;
    /**
     * The advertisedFailoverNumber
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $advertisedFailoverNumber;
    /**
     * Constructor method for UpdateUniversalLineTemplateReq
     * @uses UpdateUniversalLineTemplateReq::setNewName()
     * @uses UpdateUniversalLineTemplateReq::setUrgentPriority()
     * @uses UpdateUniversalLineTemplateReq::setLineDescription()
     * @uses UpdateUniversalLineTemplateReq::setRoutePartition()
     * @uses UpdateUniversalLineTemplateReq::setVoiceMailProfile()
     * @uses UpdateUniversalLineTemplateReq::setCallingSearchSpace()
     * @uses UpdateUniversalLineTemplateReq::setAlertingName()
     * @uses UpdateUniversalLineTemplateReq::setExtCallControlProfile()
     * @uses UpdateUniversalLineTemplateReq::setBlfPresenceGroup()
     * @uses UpdateUniversalLineTemplateReq::setCallPickupGroup()
     * @uses UpdateUniversalLineTemplateReq::setPartyEntranceTone()
     * @uses UpdateUniversalLineTemplateReq::setAutoAnswer()
     * @uses UpdateUniversalLineTemplateReq::setRejectAnonymousCall()
     * @uses UpdateUniversalLineTemplateReq::setUserHoldMohAudioSource()
     * @uses UpdateUniversalLineTemplateReq::setNetworkHoldMohAudioSource()
     * @uses UpdateUniversalLineTemplateReq::setAarDestinationMask()
     * @uses UpdateUniversalLineTemplateReq::setAarGroup()
     * @uses UpdateUniversalLineTemplateReq::setRetainDestInCallFwdHistory()
     * @uses UpdateUniversalLineTemplateReq::setForwardDestAllCalls()
     * @uses UpdateUniversalLineTemplateReq::setPrimaryCssForwardingAllCalls()
     * @uses UpdateUniversalLineTemplateReq::setSecondaryCssForwardingAllCalls()
     * @uses UpdateUniversalLineTemplateReq::setCssActivationPolicy()
     * @uses UpdateUniversalLineTemplateReq::setFwdDestExtCallsWhenNotRetrieved()
     * @uses UpdateUniversalLineTemplateReq::setCssFwdExtCallsWhenNotRetrieved()
     * @uses UpdateUniversalLineTemplateReq::setFwdDestInternalCallsWhenNotRetrieved()
     * @uses UpdateUniversalLineTemplateReq::setCssFwdInternalCallsWhenNotRetrieved()
     * @uses UpdateUniversalLineTemplateReq::setParkMonitorReversionTime()
     * @uses UpdateUniversalLineTemplateReq::setTarget()
     * @uses UpdateUniversalLineTemplateReq::setMlppCss()
     * @uses UpdateUniversalLineTemplateReq::setMlppNoAnsRingDuration()
     * @uses UpdateUniversalLineTemplateReq::setConfidentialAccess()
     * @uses UpdateUniversalLineTemplateReq::setHoldReversionRingDuration()
     * @uses UpdateUniversalLineTemplateReq::setHoldReversionNotificationInterval()
     * @uses UpdateUniversalLineTemplateReq::setBusyIntCallsDestination()
     * @uses UpdateUniversalLineTemplateReq::setBusyIntCallsCss()
     * @uses UpdateUniversalLineTemplateReq::setBusyExtCallsDestination()
     * @uses UpdateUniversalLineTemplateReq::setBusyExtCallsCss()
     * @uses UpdateUniversalLineTemplateReq::setNoAnsIntCallsDestination()
     * @uses UpdateUniversalLineTemplateReq::setNoAnsIntCallsCss()
     * @uses UpdateUniversalLineTemplateReq::setNoAnsExtCallsDestination()
     * @uses UpdateUniversalLineTemplateReq::setNoAnsExtCallsCss()
     * @uses UpdateUniversalLineTemplateReq::setNoCoverageIntCallsDestination()
     * @uses UpdateUniversalLineTemplateReq::setNoCoverageIntCallsCss()
     * @uses UpdateUniversalLineTemplateReq::setNoCoverageExtCallsDestination()
     * @uses UpdateUniversalLineTemplateReq::setNoCoverageExtCallsCss()
     * @uses UpdateUniversalLineTemplateReq::setUnregisteredIntCallsDestination()
     * @uses UpdateUniversalLineTemplateReq::setUnregisteredIntCallsCss()
     * @uses UpdateUniversalLineTemplateReq::setUnregisteredExtCallsDestination()
     * @uses UpdateUniversalLineTemplateReq::setUnregisteredExtCallsCss()
     * @uses UpdateUniversalLineTemplateReq::setCtiFailureDestination()
     * @uses UpdateUniversalLineTemplateReq::setCtiFailureCss()
     * @uses UpdateUniversalLineTemplateReq::setCallControlAgentProfile()
     * @uses UpdateUniversalLineTemplateReq::setEnterpriseAltNum()
     * @uses UpdateUniversalLineTemplateReq::setE164AltNum()
     * @uses UpdateUniversalLineTemplateReq::setAdvertisedFailoverNumber()
     * @param string $newName
     * @param string $urgentPriority
     * @param string $lineDescription
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $routePartition
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $voiceMailProfile
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $callingSearchSpace
     * @param string $alertingName
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $extCallControlProfile
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $blfPresenceGroup
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $callPickupGroup
     * @param string $partyEntranceTone
     * @param string $autoAnswer
     * @param string $rejectAnonymousCall
     * @param string $userHoldMohAudioSource
     * @param string $networkHoldMohAudioSource
     * @param string $aarDestinationMask
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $aarGroup
     * @param string $retainDestInCallFwdHistory
     * @param string $forwardDestAllCalls
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $primaryCssForwardingAllCalls
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $secondaryCssForwardingAllCalls
     * @param string $cssActivationPolicy
     * @param string $fwdDestExtCallsWhenNotRetrieved
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $cssFwdExtCallsWhenNotRetrieved
     * @param string $fwdDestInternalCallsWhenNotRetrieved
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $cssFwdInternalCallsWhenNotRetrieved
     * @param string $parkMonitorReversionTime
     * @param string $target
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $mlppCss
     * @param string $mlppNoAnsRingDuration
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\ConfidentialAccess $confidentialAccess
     * @param string $holdReversionRingDuration
     * @param string $holdReversionNotificationInterval
     * @param string $busyIntCallsDestination
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $busyIntCallsCss
     * @param string $busyExtCallsDestination
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $busyExtCallsCss
     * @param string $noAnsIntCallsDestination
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $noAnsIntCallsCss
     * @param string $noAnsExtCallsDestination
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $noAnsExtCallsCss
     * @param string $noCoverageIntCallsDestination
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $noCoverageIntCallsCss
     * @param string $noCoverageExtCallsDestination
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $noCoverageExtCallsCss
     * @param string $unregisteredIntCallsDestination
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $unregisteredIntCallsCss
     * @param string $unregisteredExtCallsDestination
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $unregisteredExtCallsCss
     * @param string $ctiFailureDestination
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $ctiFailureCss
     * @param string $callControlAgentProfile
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\EnterpriseAltNum $enterpriseAltNum
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\E164AltNum $e164AltNum
     * @param string $advertisedFailoverNumber
     */
    public function __construct($newName = null, $urgentPriority = null, $lineDescription = null, \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $routePartition = null, \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $voiceMailProfile = null, \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $callingSearchSpace = null, $alertingName = null, \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $extCallControlProfile = null, \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $blfPresenceGroup = null, \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $callPickupGroup = null, $partyEntranceTone = 'Default', $autoAnswer = 'Auto Answer Off', $rejectAnonymousCall = null, $userHoldMohAudioSource = null, $networkHoldMohAudioSource = null, $aarDestinationMask = null, \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $aarGroup = null, $retainDestInCallFwdHistory = null, $forwardDestAllCalls = null, \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $primaryCssForwardingAllCalls = null, \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $secondaryCssForwardingAllCalls = null, $cssActivationPolicy = 'Use System Default', $fwdDestExtCallsWhenNotRetrieved = null, \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $cssFwdExtCallsWhenNotRetrieved = null, $fwdDestInternalCallsWhenNotRetrieved = null, \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $cssFwdInternalCallsWhenNotRetrieved = null, $parkMonitorReversionTime = null, $target = null, \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $mlppCss = null, $mlppNoAnsRingDuration = null, \\Losc\CucmBundle\Model\Webservice\StructType\ConfidentialAccess $confidentialAccess = null, $holdReversionRingDuration = null, $holdReversionNotificationInterval = null, $busyIntCallsDestination = null, \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $busyIntCallsCss = null, $busyExtCallsDestination = null, \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $busyExtCallsCss = null, $noAnsIntCallsDestination = null, \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $noAnsIntCallsCss = null, $noAnsExtCallsDestination = null, \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $noAnsExtCallsCss = null, $noCoverageIntCallsDestination = null, \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $noCoverageIntCallsCss = null, $noCoverageExtCallsDestination = null, \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $noCoverageExtCallsCss = null, $unregisteredIntCallsDestination = null, \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $unregisteredIntCallsCss = null, $unregisteredExtCallsDestination = null, \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $unregisteredExtCallsCss = null, $ctiFailureDestination = null, \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $ctiFailureCss = null, $callControlAgentProfile = null, \\Losc\CucmBundle\Model\Webservice\StructType\EnterpriseAltNum $enterpriseAltNum = null, \\Losc\CucmBundle\Model\Webservice\StructType\E164AltNum $e164AltNum = null, $advertisedFailoverNumber = null)
    {
        $this
            ->setNewName($newName)
            ->setUrgentPriority($urgentPriority)
            ->setLineDescription($lineDescription)
            ->setRoutePartition($routePartition)
            ->setVoiceMailProfile($voiceMailProfile)
            ->setCallingSearchSpace($callingSearchSpace)
            ->setAlertingName($alertingName)
            ->setExtCallControlProfile($extCallControlProfile)
            ->setBlfPresenceGroup($blfPresenceGroup)
            ->setCallPickupGroup($callPickupGroup)
            ->setPartyEntranceTone($partyEntranceTone)
            ->setAutoAnswer($autoAnswer)
            ->setRejectAnonymousCall($rejectAnonymousCall)
            ->setUserHoldMohAudioSource($userHoldMohAudioSource)
            ->setNetworkHoldMohAudioSource($networkHoldMohAudioSource)
            ->setAarDestinationMask($aarDestinationMask)
            ->setAarGroup($aarGroup)
            ->setRetainDestInCallFwdHistory($retainDestInCallFwdHistory)
            ->setForwardDestAllCalls($forwardDestAllCalls)
            ->setPrimaryCssForwardingAllCalls($primaryCssForwardingAllCalls)
            ->setSecondaryCssForwardingAllCalls($secondaryCssForwardingAllCalls)
            ->setCssActivationPolicy($cssActivationPolicy)
            ->setFwdDestExtCallsWhenNotRetrieved($fwdDestExtCallsWhenNotRetrieved)
            ->setCssFwdExtCallsWhenNotRetrieved($cssFwdExtCallsWhenNotRetrieved)
            ->setFwdDestInternalCallsWhenNotRetrieved($fwdDestInternalCallsWhenNotRetrieved)
            ->setCssFwdInternalCallsWhenNotRetrieved($cssFwdInternalCallsWhenNotRetrieved)
            ->setParkMonitorReversionTime($parkMonitorReversionTime)
            ->setTarget($target)
            ->setMlppCss($mlppCss)
            ->setMlppNoAnsRingDuration($mlppNoAnsRingDuration)
            ->setConfidentialAccess($confidentialAccess)
            ->setHoldReversionRingDuration($holdReversionRingDuration)
            ->setHoldReversionNotificationInterval($holdReversionNotificationInterval)
            ->setBusyIntCallsDestination($busyIntCallsDestination)
            ->setBusyIntCallsCss($busyIntCallsCss)
            ->setBusyExtCallsDestination($busyExtCallsDestination)
            ->setBusyExtCallsCss($busyExtCallsCss)
            ->setNoAnsIntCallsDestination($noAnsIntCallsDestination)
            ->setNoAnsIntCallsCss($noAnsIntCallsCss)
            ->setNoAnsExtCallsDestination($noAnsExtCallsDestination)
            ->setNoAnsExtCallsCss($noAnsExtCallsCss)
            ->setNoCoverageIntCallsDestination($noCoverageIntCallsDestination)
            ->setNoCoverageIntCallsCss($noCoverageIntCallsCss)
            ->setNoCoverageExtCallsDestination($noCoverageExtCallsDestination)
            ->setNoCoverageExtCallsCss($noCoverageExtCallsCss)
            ->setUnregisteredIntCallsDestination($unregisteredIntCallsDestination)
            ->setUnregisteredIntCallsCss($unregisteredIntCallsCss)
            ->setUnregisteredExtCallsDestination($unregisteredExtCallsDestination)
            ->setUnregisteredExtCallsCss($unregisteredExtCallsCss)
            ->setCtiFailureDestination($ctiFailureDestination)
            ->setCtiFailureCss($ctiFailureCss)
            ->setCallControlAgentProfile($callControlAgentProfile)
            ->setEnterpriseAltNum($enterpriseAltNum)
            ->setE164AltNum($e164AltNum)
            ->setAdvertisedFailoverNumber($advertisedFailoverNumber);
    }
    /**
     * Get newName value
     * @return string|null
     */
    public function getNewName()
    {
        return $this->newName;
    }
    /**
     * Set newName value
     * @param string $newName
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\UpdateUniversalLineTemplateReq
     */
    public function setNewName($newName = null)
    {
        $this->newName = $newName;
        return $this;
    }
    /**
     * Get urgentPriority value
     * @return string|null
     */
    public function getUrgentPriority()
    {
        return $this->urgentPriority;
    }
    /**
     * Set urgentPriority value
     * @param string $urgentPriority
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\UpdateUniversalLineTemplateReq
     */
    public function setUrgentPriority($urgentPriority = null)
    {
        $this->urgentPriority = $urgentPriority;
        return $this;
    }
    /**
     * Get lineDescription value
     * @return string|null
     */
    public function getLineDescription()
    {
        return $this->lineDescription;
    }
    /**
     * Set lineDescription value
     * @param string $lineDescription
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\UpdateUniversalLineTemplateReq
     */
    public function setLineDescription($lineDescription = null)
    {
        $this->lineDescription = $lineDescription;
        return $this;
    }
    /**
     * Get routePartition value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XFkType|null
     */
    public function getRoutePartition()
    {
        return isset($this->routePartition) ? $this->routePartition : null;
    }
    /**
     * Set routePartition value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $routePartition
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\UpdateUniversalLineTemplateReq
     */
    public function setRoutePartition(\\Losc\CucmBundle\Model\Webservice\StructType\XFkType $routePartition = null)
    {
        if (is_null($routePartition) || (is_array($routePartition) && empty($routePartition))) {
            unset($this->routePartition);
        } else {
            $this->routePartition = $routePartition;
        }
        return $this;
    }
    /**
     * Get voiceMailProfile value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XFkType|null
     */
    public function getVoiceMailProfile()
    {
        return isset($this->voiceMailProfile) ? $this->voiceMailProfile : null;
    }
    /**
     * Set voiceMailProfile value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $voiceMailProfile
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\UpdateUniversalLineTemplateReq
     */
    public function setVoiceMailProfile(\\Losc\CucmBundle\Model\Webservice\StructType\XFkType $voiceMailProfile = null)
    {
        if (is_null($voiceMailProfile) || (is_array($voiceMailProfile) && empty($voiceMailProfile))) {
            unset($this->voiceMailProfile);
        } else {
            $this->voiceMailProfile = $voiceMailProfile;
        }
        return $this;
    }
    /**
     * Get callingSearchSpace value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XFkType|null
     */
    public function getCallingSearchSpace()
    {
        return isset($this->callingSearchSpace) ? $this->callingSearchSpace : null;
    }
    /**
     * Set callingSearchSpace value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $callingSearchSpace
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\UpdateUniversalLineTemplateReq
     */
    public function setCallingSearchSpace(\\Losc\CucmBundle\Model\Webservice\StructType\XFkType $callingSearchSpace = null)
    {
        if (is_null($callingSearchSpace) || (is_array($callingSearchSpace) && empty($callingSearchSpace))) {
            unset($this->callingSearchSpace);
        } else {
            $this->callingSearchSpace = $callingSearchSpace;
        }
        return $this;
    }
    /**
     * Get alertingName value
     * @return string|null
     */
    public function getAlertingName()
    {
        return $this->alertingName;
    }
    /**
     * Set alertingName value
     * @param string $alertingName
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\UpdateUniversalLineTemplateReq
     */
    public function setAlertingName($alertingName = null)
    {
        $this->alertingName = $alertingName;
        return $this;
    }
    /**
     * Get extCallControlProfile value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XFkType|null
     */
    public function getExtCallControlProfile()
    {
        return isset($this->extCallControlProfile) ? $this->extCallControlProfile : null;
    }
    /**
     * Set extCallControlProfile value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $extCallControlProfile
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\UpdateUniversalLineTemplateReq
     */
    public function setExtCallControlProfile(\\Losc\CucmBundle\Model\Webservice\StructType\XFkType $extCallControlProfile = null)
    {
        if (is_null($extCallControlProfile) || (is_array($extCallControlProfile) && empty($extCallControlProfile))) {
            unset($this->extCallControlProfile);
        } else {
            $this->extCallControlProfile = $extCallControlProfile;
        }
        return $this;
    }
    /**
     * Get blfPresenceGroup value
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XFkType|null
     */
    public function getBlfPresenceGroup()
    {
        return $this->blfPresenceGroup;
    }
    /**
     * Set blfPresenceGroup value
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $blfPresenceGroup
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\UpdateUniversalLineTemplateReq
     */
    public function setBlfPresenceGroup(\\Losc\CucmBundle\Model\Webservice\StructType\XFkType $blfPresenceGroup = null)
    {
        $this->blfPresenceGroup = $blfPresenceGroup;
        return $this;
    }
    /**
     * Get callPickupGroup value
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XFkType|null
     */
    public function getCallPickupGroup()
    {
        return $this->callPickupGroup;
    }
    /**
     * Set callPickupGroup value
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $callPickupGroup
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\UpdateUniversalLineTemplateReq
     */
    public function setCallPickupGroup(\\Losc\CucmBundle\Model\Webservice\StructType\XFkType $callPickupGroup = null)
    {
        $this->callPickupGroup = $callPickupGroup;
        return $this;
    }
    /**
     * Get partyEntranceTone value
     * @return string|null
     */
    public function getPartyEntranceTone()
    {
        return $this->partyEntranceTone;
    }
    /**
     * Set partyEntranceTone value
     * @param string $partyEntranceTone
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\UpdateUniversalLineTemplateReq
     */
    public function setPartyEntranceTone($partyEntranceTone = 'Default')
    {
        $this->partyEntranceTone = $partyEntranceTone;
        return $this;
    }
    /**
     * Get autoAnswer value
     * @return string|null
     */
    public function getAutoAnswer()
    {
        return $this->autoAnswer;
    }
    /**
     * Set autoAnswer value
     * @param string $autoAnswer
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\UpdateUniversalLineTemplateReq
     */
    public function setAutoAnswer($autoAnswer = 'Auto Answer Off')
    {
        $this->autoAnswer = $autoAnswer;
        return $this;
    }
    /**
     * Get rejectAnonymousCall value
     * @return string|null
     */
    public function getRejectAnonymousCall()
    {
        return $this->rejectAnonymousCall;
    }
    /**
     * Set rejectAnonymousCall value
     * @param string $rejectAnonymousCall
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\UpdateUniversalLineTemplateReq
     */
    public function setRejectAnonymousCall($rejectAnonymousCall = null)
    {
        $this->rejectAnonymousCall = $rejectAnonymousCall;
        return $this;
    }
    /**
     * Get userHoldMohAudioSource value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getUserHoldMohAudioSource()
    {
        return isset($this->userHoldMohAudioSource) ? $this->userHoldMohAudioSource : null;
    }
    /**
     * Set userHoldMohAudioSource value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $userHoldMohAudioSource
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\UpdateUniversalLineTemplateReq
     */
    public function setUserHoldMohAudioSource($userHoldMohAudioSource = null)
    {
        if (is_null($userHoldMohAudioSource) || (is_array($userHoldMohAudioSource) && empty($userHoldMohAudioSource))) {
            unset($this->userHoldMohAudioSource);
        } else {
            $this->userHoldMohAudioSource = $userHoldMohAudioSource;
        }
        return $this;
    }
    /**
     * Get networkHoldMohAudioSource value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getNetworkHoldMohAudioSource()
    {
        return isset($this->networkHoldMohAudioSource) ? $this->networkHoldMohAudioSource : null;
    }
    /**
     * Set networkHoldMohAudioSource value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $networkHoldMohAudioSource
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\UpdateUniversalLineTemplateReq
     */
    public function setNetworkHoldMohAudioSource($networkHoldMohAudioSource = null)
    {
        if (is_null($networkHoldMohAudioSource) || (is_array($networkHoldMohAudioSource) && empty($networkHoldMohAudioSource))) {
            unset($this->networkHoldMohAudioSource);
        } else {
            $this->networkHoldMohAudioSource = $networkHoldMohAudioSource;
        }
        return $this;
    }
    /**
     * Get aarDestinationMask value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAarDestinationMask()
    {
        return isset($this->aarDestinationMask) ? $this->aarDestinationMask : null;
    }
    /**
     * Set aarDestinationMask value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $aarDestinationMask
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\UpdateUniversalLineTemplateReq
     */
    public function setAarDestinationMask($aarDestinationMask = null)
    {
        if (is_null($aarDestinationMask) || (is_array($aarDestinationMask) && empty($aarDestinationMask))) {
            unset($this->aarDestinationMask);
        } else {
            $this->aarDestinationMask = $aarDestinationMask;
        }
        return $this;
    }
    /**
     * Get aarGroup value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XFkType|null
     */
    public function getAarGroup()
    {
        return isset($this->aarGroup) ? $this->aarGroup : null;
    }
    /**
     * Set aarGroup value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $aarGroup
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\UpdateUniversalLineTemplateReq
     */
    public function setAarGroup(\\Losc\CucmBundle\Model\Webservice\StructType\XFkType $aarGroup = null)
    {
        if (is_null($aarGroup) || (is_array($aarGroup) && empty($aarGroup))) {
            unset($this->aarGroup);
        } else {
            $this->aarGroup = $aarGroup;
        }
        return $this;
    }
    /**
     * Get retainDestInCallFwdHistory value
     * @return string|null
     */
    public function getRetainDestInCallFwdHistory()
    {
        return $this->retainDestInCallFwdHistory;
    }
    /**
     * Set retainDestInCallFwdHistory value
     * @param string $retainDestInCallFwdHistory
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\UpdateUniversalLineTemplateReq
     */
    public function setRetainDestInCallFwdHistory($retainDestInCallFwdHistory = null)
    {
        $this->retainDestInCallFwdHistory = $retainDestInCallFwdHistory;
        return $this;
    }
    /**
     * Get forwardDestAllCalls value
     * @return string|null
     */
    public function getForwardDestAllCalls()
    {
        return $this->forwardDestAllCalls;
    }
    /**
     * Set forwardDestAllCalls value
     * @param string $forwardDestAllCalls
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\UpdateUniversalLineTemplateReq
     */
    public function setForwardDestAllCalls($forwardDestAllCalls = null)
    {
        $this->forwardDestAllCalls = $forwardDestAllCalls;
        return $this;
    }
    /**
     * Get primaryCssForwardingAllCalls value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XFkType|null
     */
    public function getPrimaryCssForwardingAllCalls()
    {
        return isset($this->primaryCssForwardingAllCalls) ? $this->primaryCssForwardingAllCalls : null;
    }
    /**
     * Set primaryCssForwardingAllCalls value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $primaryCssForwardingAllCalls
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\UpdateUniversalLineTemplateReq
     */
    public function setPrimaryCssForwardingAllCalls(\\Losc\CucmBundle\Model\Webservice\StructType\XFkType $primaryCssForwardingAllCalls = null)
    {
        if (is_null($primaryCssForwardingAllCalls) || (is_array($primaryCssForwardingAllCalls) && empty($primaryCssForwardingAllCalls))) {
            unset($this->primaryCssForwardingAllCalls);
        } else {
            $this->primaryCssForwardingAllCalls = $primaryCssForwardingAllCalls;
        }
        return $this;
    }
    /**
     * Get secondaryCssForwardingAllCalls value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XFkType|null
     */
    public function getSecondaryCssForwardingAllCalls()
    {
        return isset($this->secondaryCssForwardingAllCalls) ? $this->secondaryCssForwardingAllCalls : null;
    }
    /**
     * Set secondaryCssForwardingAllCalls value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $secondaryCssForwardingAllCalls
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\UpdateUniversalLineTemplateReq
     */
    public function setSecondaryCssForwardingAllCalls(\\Losc\CucmBundle\Model\Webservice\StructType\XFkType $secondaryCssForwardingAllCalls = null)
    {
        if (is_null($secondaryCssForwardingAllCalls) || (is_array($secondaryCssForwardingAllCalls) && empty($secondaryCssForwardingAllCalls))) {
            unset($this->secondaryCssForwardingAllCalls);
        } else {
            $this->secondaryCssForwardingAllCalls = $secondaryCssForwardingAllCalls;
        }
        return $this;
    }
    /**
     * Get CssActivationPolicy value
     * @return string|null
     */
    public function getCssActivationPolicy()
    {
        return $this->CssActivationPolicy;
    }
    /**
     * Set CssActivationPolicy value
     * @param string $cssActivationPolicy
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\UpdateUniversalLineTemplateReq
     */
    public function setCssActivationPolicy($cssActivationPolicy = 'Use System Default')
    {
        $this->CssActivationPolicy = $cssActivationPolicy;
        return $this;
    }
    /**
     * Get fwdDestExtCallsWhenNotRetrieved value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getFwdDestExtCallsWhenNotRetrieved()
    {
        return isset($this->fwdDestExtCallsWhenNotRetrieved) ? $this->fwdDestExtCallsWhenNotRetrieved : null;
    }
    /**
     * Set fwdDestExtCallsWhenNotRetrieved value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $fwdDestExtCallsWhenNotRetrieved
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\UpdateUniversalLineTemplateReq
     */
    public function setFwdDestExtCallsWhenNotRetrieved($fwdDestExtCallsWhenNotRetrieved = null)
    {
        if (is_null($fwdDestExtCallsWhenNotRetrieved) || (is_array($fwdDestExtCallsWhenNotRetrieved) && empty($fwdDestExtCallsWhenNotRetrieved))) {
            unset($this->fwdDestExtCallsWhenNotRetrieved);
        } else {
            $this->fwdDestExtCallsWhenNotRetrieved = $fwdDestExtCallsWhenNotRetrieved;
        }
        return $this;
    }
    /**
     * Get cssFwdExtCallsWhenNotRetrieved value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XFkType|null
     */
    public function getCssFwdExtCallsWhenNotRetrieved()
    {
        return isset($this->cssFwdExtCallsWhenNotRetrieved) ? $this->cssFwdExtCallsWhenNotRetrieved : null;
    }
    /**
     * Set cssFwdExtCallsWhenNotRetrieved value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $cssFwdExtCallsWhenNotRetrieved
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\UpdateUniversalLineTemplateReq
     */
    public function setCssFwdExtCallsWhenNotRetrieved(\\Losc\CucmBundle\Model\Webservice\StructType\XFkType $cssFwdExtCallsWhenNotRetrieved = null)
    {
        if (is_null($cssFwdExtCallsWhenNotRetrieved) || (is_array($cssFwdExtCallsWhenNotRetrieved) && empty($cssFwdExtCallsWhenNotRetrieved))) {
            unset($this->cssFwdExtCallsWhenNotRetrieved);
        } else {
            $this->cssFwdExtCallsWhenNotRetrieved = $cssFwdExtCallsWhenNotRetrieved;
        }
        return $this;
    }
    /**
     * Get fwdDestInternalCallsWhenNotRetrieved value
     * @return string|null
     */
    public function getFwdDestInternalCallsWhenNotRetrieved()
    {
        return $this->fwdDestInternalCallsWhenNotRetrieved;
    }
    /**
     * Set fwdDestInternalCallsWhenNotRetrieved value
     * @param string $fwdDestInternalCallsWhenNotRetrieved
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\UpdateUniversalLineTemplateReq
     */
    public function setFwdDestInternalCallsWhenNotRetrieved($fwdDestInternalCallsWhenNotRetrieved = null)
    {
        $this->fwdDestInternalCallsWhenNotRetrieved = $fwdDestInternalCallsWhenNotRetrieved;
        return $this;
    }
    /**
     * Get cssFwdInternalCallsWhenNotRetrieved value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XFkType|null
     */
    public function getCssFwdInternalCallsWhenNotRetrieved()
    {
        return isset($this->cssFwdInternalCallsWhenNotRetrieved) ? $this->cssFwdInternalCallsWhenNotRetrieved : null;
    }
    /**
     * Set cssFwdInternalCallsWhenNotRetrieved value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $cssFwdInternalCallsWhenNotRetrieved
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\UpdateUniversalLineTemplateReq
     */
    public function setCssFwdInternalCallsWhenNotRetrieved(\\Losc\CucmBundle\Model\Webservice\StructType\XFkType $cssFwdInternalCallsWhenNotRetrieved = null)
    {
        if (is_null($cssFwdInternalCallsWhenNotRetrieved) || (is_array($cssFwdInternalCallsWhenNotRetrieved) && empty($cssFwdInternalCallsWhenNotRetrieved))) {
            unset($this->cssFwdInternalCallsWhenNotRetrieved);
        } else {
            $this->cssFwdInternalCallsWhenNotRetrieved = $cssFwdInternalCallsWhenNotRetrieved;
        }
        return $this;
    }
    /**
     * Get parkMonitorReversionTime value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getParkMonitorReversionTime()
    {
        return isset($this->parkMonitorReversionTime) ? $this->parkMonitorReversionTime : null;
    }
    /**
     * Set parkMonitorReversionTime value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $parkMonitorReversionTime
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\UpdateUniversalLineTemplateReq
     */
    public function setParkMonitorReversionTime($parkMonitorReversionTime = null)
    {
        if (is_null($parkMonitorReversionTime) || (is_array($parkMonitorReversionTime) && empty($parkMonitorReversionTime))) {
            unset($this->parkMonitorReversionTime);
        } else {
            $this->parkMonitorReversionTime = $parkMonitorReversionTime;
        }
        return $this;
    }
    /**
     * Get target value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTarget()
    {
        return isset($this->target) ? $this->target : null;
    }
    /**
     * Set target value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $target
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\UpdateUniversalLineTemplateReq
     */
    public function setTarget($target = null)
    {
        if (is_null($target) || (is_array($target) && empty($target))) {
            unset($this->target);
        } else {
            $this->target = $target;
        }
        return $this;
    }
    /**
     * Get mlppCss value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XFkType|null
     */
    public function getMlppCss()
    {
        return isset($this->mlppCss) ? $this->mlppCss : null;
    }
    /**
     * Set mlppCss value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $mlppCss
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\UpdateUniversalLineTemplateReq
     */
    public function setMlppCss(\\Losc\CucmBundle\Model\Webservice\StructType\XFkType $mlppCss = null)
    {
        if (is_null($mlppCss) || (is_array($mlppCss) && empty($mlppCss))) {
            unset($this->mlppCss);
        } else {
            $this->mlppCss = $mlppCss;
        }
        return $this;
    }
    /**
     * Get mlppNoAnsRingDuration value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMlppNoAnsRingDuration()
    {
        return isset($this->mlppNoAnsRingDuration) ? $this->mlppNoAnsRingDuration : null;
    }
    /**
     * Set mlppNoAnsRingDuration value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $mlppNoAnsRingDuration
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\UpdateUniversalLineTemplateReq
     */
    public function setMlppNoAnsRingDuration($mlppNoAnsRingDuration = null)
    {
        if (is_null($mlppNoAnsRingDuration) || (is_array($mlppNoAnsRingDuration) && empty($mlppNoAnsRingDuration))) {
            unset($this->mlppNoAnsRingDuration);
        } else {
            $this->mlppNoAnsRingDuration = $mlppNoAnsRingDuration;
        }
        return $this;
    }
    /**
     * Get confidentialAccess value
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\ConfidentialAccess|null
     */
    public function getConfidentialAccess()
    {
        return $this->confidentialAccess;
    }
    /**
     * Set confidentialAccess value
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\ConfidentialAccess $confidentialAccess
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\UpdateUniversalLineTemplateReq
     */
    public function setConfidentialAccess(\\Losc\CucmBundle\Model\Webservice\StructType\ConfidentialAccess $confidentialAccess = null)
    {
        $this->confidentialAccess = $confidentialAccess;
        return $this;
    }
    /**
     * Get holdReversionRingDuration value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getHoldReversionRingDuration()
    {
        return isset($this->holdReversionRingDuration) ? $this->holdReversionRingDuration : null;
    }
    /**
     * Set holdReversionRingDuration value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $holdReversionRingDuration
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\UpdateUniversalLineTemplateReq
     */
    public function setHoldReversionRingDuration($holdReversionRingDuration = null)
    {
        if (is_null($holdReversionRingDuration) || (is_array($holdReversionRingDuration) && empty($holdReversionRingDuration))) {
            unset($this->holdReversionRingDuration);
        } else {
            $this->holdReversionRingDuration = $holdReversionRingDuration;
        }
        return $this;
    }
    /**
     * Get holdReversionNotificationInterval value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getHoldReversionNotificationInterval()
    {
        return isset($this->holdReversionNotificationInterval) ? $this->holdReversionNotificationInterval : null;
    }
    /**
     * Set holdReversionNotificationInterval value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $holdReversionNotificationInterval
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\UpdateUniversalLineTemplateReq
     */
    public function setHoldReversionNotificationInterval($holdReversionNotificationInterval = null)
    {
        if (is_null($holdReversionNotificationInterval) || (is_array($holdReversionNotificationInterval) && empty($holdReversionNotificationInterval))) {
            unset($this->holdReversionNotificationInterval);
        } else {
            $this->holdReversionNotificationInterval = $holdReversionNotificationInterval;
        }
        return $this;
    }
    /**
     * Get busyIntCallsDestination value
     * @return string|null
     */
    public function getBusyIntCallsDestination()
    {
        return $this->busyIntCallsDestination;
    }
    /**
     * Set busyIntCallsDestination value
     * @param string $busyIntCallsDestination
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\UpdateUniversalLineTemplateReq
     */
    public function setBusyIntCallsDestination($busyIntCallsDestination = null)
    {
        $this->busyIntCallsDestination = $busyIntCallsDestination;
        return $this;
    }
    /**
     * Get busyIntCallsCss value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XFkType|null
     */
    public function getBusyIntCallsCss()
    {
        return isset($this->busyIntCallsCss) ? $this->busyIntCallsCss : null;
    }
    /**
     * Set busyIntCallsCss value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $busyIntCallsCss
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\UpdateUniversalLineTemplateReq
     */
    public function setBusyIntCallsCss(\\Losc\CucmBundle\Model\Webservice\StructType\XFkType $busyIntCallsCss = null)
    {
        if (is_null($busyIntCallsCss) || (is_array($busyIntCallsCss) && empty($busyIntCallsCss))) {
            unset($this->busyIntCallsCss);
        } else {
            $this->busyIntCallsCss = $busyIntCallsCss;
        }
        return $this;
    }
    /**
     * Get busyExtCallsDestination value
     * @return string|null
     */
    public function getBusyExtCallsDestination()
    {
        return $this->busyExtCallsDestination;
    }
    /**
     * Set busyExtCallsDestination value
     * @param string $busyExtCallsDestination
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\UpdateUniversalLineTemplateReq
     */
    public function setBusyExtCallsDestination($busyExtCallsDestination = null)
    {
        $this->busyExtCallsDestination = $busyExtCallsDestination;
        return $this;
    }
    /**
     * Get busyExtCallsCss value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XFkType|null
     */
    public function getBusyExtCallsCss()
    {
        return isset($this->busyExtCallsCss) ? $this->busyExtCallsCss : null;
    }
    /**
     * Set busyExtCallsCss value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $busyExtCallsCss
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\UpdateUniversalLineTemplateReq
     */
    public function setBusyExtCallsCss(\\Losc\CucmBundle\Model\Webservice\StructType\XFkType $busyExtCallsCss = null)
    {
        if (is_null($busyExtCallsCss) || (is_array($busyExtCallsCss) && empty($busyExtCallsCss))) {
            unset($this->busyExtCallsCss);
        } else {
            $this->busyExtCallsCss = $busyExtCallsCss;
        }
        return $this;
    }
    /**
     * Get noAnsIntCallsDestination value
     * @return string|null
     */
    public function getNoAnsIntCallsDestination()
    {
        return $this->noAnsIntCallsDestination;
    }
    /**
     * Set noAnsIntCallsDestination value
     * @param string $noAnsIntCallsDestination
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\UpdateUniversalLineTemplateReq
     */
    public function setNoAnsIntCallsDestination($noAnsIntCallsDestination = null)
    {
        $this->noAnsIntCallsDestination = $noAnsIntCallsDestination;
        return $this;
    }
    /**
     * Get noAnsIntCallsCss value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XFkType|null
     */
    public function getNoAnsIntCallsCss()
    {
        return isset($this->noAnsIntCallsCss) ? $this->noAnsIntCallsCss : null;
    }
    /**
     * Set noAnsIntCallsCss value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $noAnsIntCallsCss
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\UpdateUniversalLineTemplateReq
     */
    public function setNoAnsIntCallsCss(\\Losc\CucmBundle\Model\Webservice\StructType\XFkType $noAnsIntCallsCss = null)
    {
        if (is_null($noAnsIntCallsCss) || (is_array($noAnsIntCallsCss) && empty($noAnsIntCallsCss))) {
            unset($this->noAnsIntCallsCss);
        } else {
            $this->noAnsIntCallsCss = $noAnsIntCallsCss;
        }
        return $this;
    }
    /**
     * Get noAnsExtCallsDestination value
     * @return string|null
     */
    public function getNoAnsExtCallsDestination()
    {
        return $this->noAnsExtCallsDestination;
    }
    /**
     * Set noAnsExtCallsDestination value
     * @param string $noAnsExtCallsDestination
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\UpdateUniversalLineTemplateReq
     */
    public function setNoAnsExtCallsDestination($noAnsExtCallsDestination = null)
    {
        $this->noAnsExtCallsDestination = $noAnsExtCallsDestination;
        return $this;
    }
    /**
     * Get noAnsExtCallsCss value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XFkType|null
     */
    public function getNoAnsExtCallsCss()
    {
        return isset($this->noAnsExtCallsCss) ? $this->noAnsExtCallsCss : null;
    }
    /**
     * Set noAnsExtCallsCss value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $noAnsExtCallsCss
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\UpdateUniversalLineTemplateReq
     */
    public function setNoAnsExtCallsCss(\\Losc\CucmBundle\Model\Webservice\StructType\XFkType $noAnsExtCallsCss = null)
    {
        if (is_null($noAnsExtCallsCss) || (is_array($noAnsExtCallsCss) && empty($noAnsExtCallsCss))) {
            unset($this->noAnsExtCallsCss);
        } else {
            $this->noAnsExtCallsCss = $noAnsExtCallsCss;
        }
        return $this;
    }
    /**
     * Get noCoverageIntCallsDestination value
     * @return string|null
     */
    public function getNoCoverageIntCallsDestination()
    {
        return $this->noCoverageIntCallsDestination;
    }
    /**
     * Set noCoverageIntCallsDestination value
     * @param string $noCoverageIntCallsDestination
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\UpdateUniversalLineTemplateReq
     */
    public function setNoCoverageIntCallsDestination($noCoverageIntCallsDestination = null)
    {
        $this->noCoverageIntCallsDestination = $noCoverageIntCallsDestination;
        return $this;
    }
    /**
     * Get noCoverageIntCallsCss value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XFkType|null
     */
    public function getNoCoverageIntCallsCss()
    {
        return isset($this->noCoverageIntCallsCss) ? $this->noCoverageIntCallsCss : null;
    }
    /**
     * Set noCoverageIntCallsCss value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $noCoverageIntCallsCss
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\UpdateUniversalLineTemplateReq
     */
    public function setNoCoverageIntCallsCss(\\Losc\CucmBundle\Model\Webservice\StructType\XFkType $noCoverageIntCallsCss = null)
    {
        if (is_null($noCoverageIntCallsCss) || (is_array($noCoverageIntCallsCss) && empty($noCoverageIntCallsCss))) {
            unset($this->noCoverageIntCallsCss);
        } else {
            $this->noCoverageIntCallsCss = $noCoverageIntCallsCss;
        }
        return $this;
    }
    /**
     * Get noCoverageExtCallsDestination value
     * @return string|null
     */
    public function getNoCoverageExtCallsDestination()
    {
        return $this->noCoverageExtCallsDestination;
    }
    /**
     * Set noCoverageExtCallsDestination value
     * @param string $noCoverageExtCallsDestination
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\UpdateUniversalLineTemplateReq
     */
    public function setNoCoverageExtCallsDestination($noCoverageExtCallsDestination = null)
    {
        $this->noCoverageExtCallsDestination = $noCoverageExtCallsDestination;
        return $this;
    }
    /**
     * Get noCoverageExtCallsCss value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XFkType|null
     */
    public function getNoCoverageExtCallsCss()
    {
        return isset($this->noCoverageExtCallsCss) ? $this->noCoverageExtCallsCss : null;
    }
    /**
     * Set noCoverageExtCallsCss value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $noCoverageExtCallsCss
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\UpdateUniversalLineTemplateReq
     */
    public function setNoCoverageExtCallsCss(\\Losc\CucmBundle\Model\Webservice\StructType\XFkType $noCoverageExtCallsCss = null)
    {
        if (is_null($noCoverageExtCallsCss) || (is_array($noCoverageExtCallsCss) && empty($noCoverageExtCallsCss))) {
            unset($this->noCoverageExtCallsCss);
        } else {
            $this->noCoverageExtCallsCss = $noCoverageExtCallsCss;
        }
        return $this;
    }
    /**
     * Get unregisteredIntCallsDestination value
     * @return string|null
     */
    public function getUnregisteredIntCallsDestination()
    {
        return $this->unregisteredIntCallsDestination;
    }
    /**
     * Set unregisteredIntCallsDestination value
     * @param string $unregisteredIntCallsDestination
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\UpdateUniversalLineTemplateReq
     */
    public function setUnregisteredIntCallsDestination($unregisteredIntCallsDestination = null)
    {
        $this->unregisteredIntCallsDestination = $unregisteredIntCallsDestination;
        return $this;
    }
    /**
     * Get unregisteredIntCallsCss value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XFkType|null
     */
    public function getUnregisteredIntCallsCss()
    {
        return isset($this->unregisteredIntCallsCss) ? $this->unregisteredIntCallsCss : null;
    }
    /**
     * Set unregisteredIntCallsCss value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $unregisteredIntCallsCss
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\UpdateUniversalLineTemplateReq
     */
    public function setUnregisteredIntCallsCss(\\Losc\CucmBundle\Model\Webservice\StructType\XFkType $unregisteredIntCallsCss = null)
    {
        if (is_null($unregisteredIntCallsCss) || (is_array($unregisteredIntCallsCss) && empty($unregisteredIntCallsCss))) {
            unset($this->unregisteredIntCallsCss);
        } else {
            $this->unregisteredIntCallsCss = $unregisteredIntCallsCss;
        }
        return $this;
    }
    /**
     * Get unregisteredExtCallsDestination value
     * @return string|null
     */
    public function getUnregisteredExtCallsDestination()
    {
        return $this->unregisteredExtCallsDestination;
    }
    /**
     * Set unregisteredExtCallsDestination value
     * @param string $unregisteredExtCallsDestination
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\UpdateUniversalLineTemplateReq
     */
    public function setUnregisteredExtCallsDestination($unregisteredExtCallsDestination = null)
    {
        $this->unregisteredExtCallsDestination = $unregisteredExtCallsDestination;
        return $this;
    }
    /**
     * Get unregisteredExtCallsCss value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XFkType|null
     */
    public function getUnregisteredExtCallsCss()
    {
        return isset($this->unregisteredExtCallsCss) ? $this->unregisteredExtCallsCss : null;
    }
    /**
     * Set unregisteredExtCallsCss value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $unregisteredExtCallsCss
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\UpdateUniversalLineTemplateReq
     */
    public function setUnregisteredExtCallsCss(\\Losc\CucmBundle\Model\Webservice\StructType\XFkType $unregisteredExtCallsCss = null)
    {
        if (is_null($unregisteredExtCallsCss) || (is_array($unregisteredExtCallsCss) && empty($unregisteredExtCallsCss))) {
            unset($this->unregisteredExtCallsCss);
        } else {
            $this->unregisteredExtCallsCss = $unregisteredExtCallsCss;
        }
        return $this;
    }
    /**
     * Get ctiFailureDestination value
     * @return string|null
     */
    public function getCtiFailureDestination()
    {
        return $this->ctiFailureDestination;
    }
    /**
     * Set ctiFailureDestination value
     * @param string $ctiFailureDestination
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\UpdateUniversalLineTemplateReq
     */
    public function setCtiFailureDestination($ctiFailureDestination = null)
    {
        $this->ctiFailureDestination = $ctiFailureDestination;
        return $this;
    }
    /**
     * Get ctiFailureCss value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XFkType|null
     */
    public function getCtiFailureCss()
    {
        return isset($this->ctiFailureCss) ? $this->ctiFailureCss : null;
    }
    /**
     * Set ctiFailureCss value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $ctiFailureCss
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\UpdateUniversalLineTemplateReq
     */
    public function setCtiFailureCss(\\Losc\CucmBundle\Model\Webservice\StructType\XFkType $ctiFailureCss = null)
    {
        if (is_null($ctiFailureCss) || (is_array($ctiFailureCss) && empty($ctiFailureCss))) {
            unset($this->ctiFailureCss);
        } else {
            $this->ctiFailureCss = $ctiFailureCss;
        }
        return $this;
    }
    /**
     * Get callControlAgentProfile value
     * @return string|null
     */
    public function getCallControlAgentProfile()
    {
        return $this->callControlAgentProfile;
    }
    /**
     * Set callControlAgentProfile value
     * @param string $callControlAgentProfile
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\UpdateUniversalLineTemplateReq
     */
    public function setCallControlAgentProfile($callControlAgentProfile = null)
    {
        $this->callControlAgentProfile = $callControlAgentProfile;
        return $this;
    }
    /**
     * Get enterpriseAltNum value
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\EnterpriseAltNum|null
     */
    public function getEnterpriseAltNum()
    {
        return $this->enterpriseAltNum;
    }
    /**
     * Set enterpriseAltNum value
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\EnterpriseAltNum $enterpriseAltNum
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\UpdateUniversalLineTemplateReq
     */
    public function setEnterpriseAltNum(\\Losc\CucmBundle\Model\Webservice\StructType\EnterpriseAltNum $enterpriseAltNum = null)
    {
        $this->enterpriseAltNum = $enterpriseAltNum;
        return $this;
    }
    /**
     * Get e164AltNum value
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\E164AltNum|null
     */
    public function getE164AltNum()
    {
        return $this->e164AltNum;
    }
    /**
     * Set e164AltNum value
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\E164AltNum $e164AltNum
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\UpdateUniversalLineTemplateReq
     */
    public function setE164AltNum(\\Losc\CucmBundle\Model\Webservice\StructType\E164AltNum $e164AltNum = null)
    {
        $this->e164AltNum = $e164AltNum;
        return $this;
    }
    /**
     * Get advertisedFailoverNumber value
     * @return string|null
     */
    public function getAdvertisedFailoverNumber()
    {
        return $this->advertisedFailoverNumber;
    }
    /**
     * Set advertisedFailoverNumber value
     * @param string $advertisedFailoverNumber
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\UpdateUniversalLineTemplateReq
     */
    public function setAdvertisedFailoverNumber($advertisedFailoverNumber = null)
    {
        $this->advertisedFailoverNumber = $advertisedFailoverNumber;
        return $this;
    }
}
