<?php

namespace \Losc\CucmBundle\Model\Webservice\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UpdateRoutePartitionReq StructType
 * @subpackage Structs
 */
class UpdateRoutePartitionReq extends NameAndGUIDRequest
{
    /**
     * The newName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $newName;
    /**
     * The description
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $description;
    /**
     * The timeScheduleIdName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $timeScheduleIdName;
    /**
     * The useOriginatingDeviceTimeZone
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - default: true
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $useOriginatingDeviceTimeZone;
    /**
     * The timeZone
     * Meta information extracted from the WSDL
     * - documentation: Only Applicable if TimeSchedule is selected. If OriginatingDevice is selected then this tag is not applicable.
     * - default: Etc/GMT
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $timeZone;
    /**
     * Constructor method for UpdateRoutePartitionReq
     * @uses UpdateRoutePartitionReq::setNewName()
     * @uses UpdateRoutePartitionReq::setDescription()
     * @uses UpdateRoutePartitionReq::setTimeScheduleIdName()
     * @uses UpdateRoutePartitionReq::setUseOriginatingDeviceTimeZone()
     * @uses UpdateRoutePartitionReq::setTimeZone()
     * @param string $newName
     * @param string $description
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $timeScheduleIdName
     * @param string $useOriginatingDeviceTimeZone
     * @param string $timeZone
     */
    public function __construct($newName = null, $description = null, \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $timeScheduleIdName = null, $useOriginatingDeviceTimeZone = 'true', $timeZone = 'Etc/GMT')
    {
        $this
            ->setNewName($newName)
            ->setDescription($description)
            ->setTimeScheduleIdName($timeScheduleIdName)
            ->setUseOriginatingDeviceTimeZone($useOriginatingDeviceTimeZone)
            ->setTimeZone($timeZone);
    }
    /**
     * Get newName value
     * @return string|null
     */
    public function getNewName()
    {
        return $this->newName;
    }
    /**
     * Set newName value
     * @param string $newName
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\UpdateRoutePartitionReq
     */
    public function setNewName($newName = null)
    {
        $this->newName = $newName;
        return $this;
    }
    /**
     * Get description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->description;
    }
    /**
     * Set description value
     * @param string $description
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\UpdateRoutePartitionReq
     */
    public function setDescription($description = null)
    {
        $this->description = $description;
        return $this;
    }
    /**
     * Get timeScheduleIdName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XFkType|null
     */
    public function getTimeScheduleIdName()
    {
        return isset($this->timeScheduleIdName) ? $this->timeScheduleIdName : null;
    }
    /**
     * Set timeScheduleIdName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $timeScheduleIdName
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\UpdateRoutePartitionReq
     */
    public function setTimeScheduleIdName(\\Losc\CucmBundle\Model\Webservice\StructType\XFkType $timeScheduleIdName = null)
    {
        if (is_null($timeScheduleIdName) || (is_array($timeScheduleIdName) && empty($timeScheduleIdName))) {
            unset($this->timeScheduleIdName);
        } else {
            $this->timeScheduleIdName = $timeScheduleIdName;
        }
        return $this;
    }
    /**
     * Get useOriginatingDeviceTimeZone value
     * @return string|null
     */
    public function getUseOriginatingDeviceTimeZone()
    {
        return $this->useOriginatingDeviceTimeZone;
    }
    /**
     * Set useOriginatingDeviceTimeZone value
     * @param string $useOriginatingDeviceTimeZone
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\UpdateRoutePartitionReq
     */
    public function setUseOriginatingDeviceTimeZone($useOriginatingDeviceTimeZone = 'true')
    {
        $this->useOriginatingDeviceTimeZone = $useOriginatingDeviceTimeZone;
        return $this;
    }
    /**
     * Get timeZone value
     * @return string|null
     */
    public function getTimeZone()
    {
        return $this->timeZone;
    }
    /**
     * Set timeZone value
     * @param string $timeZone
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\UpdateRoutePartitionReq
     */
    public function setTimeZone($timeZone = 'Etc/GMT')
    {
        $this->timeZone = $timeZone;
        return $this;
    }
}
