<?php

namespace \Losc\CucmBundle\Model\Webservice\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UpdateRemoteDestinationReq StructType
 * @subpackage Structs
 */
class UpdateRemoteDestinationReq extends APIRequest
{
    /**
     * The destination
     * Meta information extracted from the WSDL
     * - choice: uuid | destination
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $destination;
    /**
     * The uuid
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - choice: uuid | destination
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - pattern: \{........-....-....-....-............\}
     * @var string
     */
    public $uuid;
    /**
     * The newName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $newName;
    /**
     * The newDestination
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $newDestination;
    /**
     * The answerTooSoonTimer
     * Meta information extracted from the WSDL
     * - default: 1500
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $answerTooSoonTimer;
    /**
     * The answerTooLateTimer
     * Meta information extracted from the WSDL
     * - default: 19000
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $answerTooLateTimer;
    /**
     * The delayBeforeRingingCell
     * Meta information extracted from the WSDL
     * - default: 4000
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $delayBeforeRingingCell;
    /**
     * The ownerUserId
     * Meta information extracted from the WSDL
     * - documentation: From 10.5, to get proper value of this tag in get handler's response it is required to have value of todaccess, in case if user does not give any value in todaccesss tag, axl will insert a random row so that get handler response can
     * return proper value of Owner User id
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $ownerUserId;
    /**
     * The enableUnifiedMobility
     * Meta information extracted from the WSDL
     * - documentation: While UPDATE set it to false if you want to delete enable Unified Mobility feature.Use only while update
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $enableUnifiedMobility;
    /**
     * The remoteDestinationProfileName
     * Meta information extracted from the WSDL
     * - documentation: If you are giving value to dualModeDeviceName then you can't give value to remoteDestinationProfileName,viceversa
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $remoteDestinationProfileName;
    /**
     * The enableExtendAndConnect
     * Meta information extracted from the WSDL
     * - documentation: While UPDATE set it to false if you want to delete Enable Extend and Connect.Use only while update
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $enableExtendAndConnect;
    /**
     * The ctiRemoteDeviceName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $ctiRemoteDeviceName;
    /**
     * The dualModeDeviceName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $dualModeDeviceName;
    /**
     * The isMobilePhone
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - default: false
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $isMobilePhone;
    /**
     * The enableMobileConnect
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - default: true
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $enableMobileConnect;
    /**
     * The lineAssociations
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\LineAssociations
     */
    public $lineAssociations;
    /**
     * The timeZone
     * Meta information extracted from the WSDL
     * - default: Etc/GMT
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $timeZone;
    /**
     * The todAccessName
     * Meta information extracted from the WSDL
     * - documentation: From 10.5 version if a user doesn't specify a value in this tag, AXL will still insert a random row in todaccess because value in todaccess is required to fetch value of owner user id properly in get handler
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $todAccessName;
    /**
     * The mobileSmartClientName
     * Meta information extracted from the WSDL
     * - documentation: This tag is not applicable for dualmode phones
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $mobileSmartClientName;
    /**
     * The mobilityProfileName
     * Meta information extracted from the WSDL
     * - documentation: This tag is applicable only to CUMC devices.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $mobilityProfileName;
    /**
     * The singleNumberReachVoicemail
     * Meta information extracted from the WSDL
     * - default: Use System Default
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $singleNumberReachVoicemail;
    /**
     * The dialViaOfficeReverseVoicemail
     * Meta information extracted from the WSDL
     * - documentation: This tag is for Mobility Identity
     * - default: Use System Default
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $dialViaOfficeReverseVoicemail;
    /**
     * Constructor method for UpdateRemoteDestinationReq
     * @uses UpdateRemoteDestinationReq::setDestination()
     * @uses UpdateRemoteDestinationReq::setUuid()
     * @uses UpdateRemoteDestinationReq::setNewName()
     * @uses UpdateRemoteDestinationReq::setNewDestination()
     * @uses UpdateRemoteDestinationReq::setAnswerTooSoonTimer()
     * @uses UpdateRemoteDestinationReq::setAnswerTooLateTimer()
     * @uses UpdateRemoteDestinationReq::setDelayBeforeRingingCell()
     * @uses UpdateRemoteDestinationReq::setOwnerUserId()
     * @uses UpdateRemoteDestinationReq::setEnableUnifiedMobility()
     * @uses UpdateRemoteDestinationReq::setRemoteDestinationProfileName()
     * @uses UpdateRemoteDestinationReq::setEnableExtendAndConnect()
     * @uses UpdateRemoteDestinationReq::setCtiRemoteDeviceName()
     * @uses UpdateRemoteDestinationReq::setDualModeDeviceName()
     * @uses UpdateRemoteDestinationReq::setIsMobilePhone()
     * @uses UpdateRemoteDestinationReq::setEnableMobileConnect()
     * @uses UpdateRemoteDestinationReq::setLineAssociations()
     * @uses UpdateRemoteDestinationReq::setTimeZone()
     * @uses UpdateRemoteDestinationReq::setTodAccessName()
     * @uses UpdateRemoteDestinationReq::setMobileSmartClientName()
     * @uses UpdateRemoteDestinationReq::setMobilityProfileName()
     * @uses UpdateRemoteDestinationReq::setSingleNumberReachVoicemail()
     * @uses UpdateRemoteDestinationReq::setDialViaOfficeReverseVoicemail()
     * @param string $destination
     * @param string $uuid
     * @param string $newName
     * @param string $newDestination
     * @param string $answerTooSoonTimer
     * @param string $answerTooLateTimer
     * @param string $delayBeforeRingingCell
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $ownerUserId
     * @param string $enableUnifiedMobility
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $remoteDestinationProfileName
     * @param string $enableExtendAndConnect
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $ctiRemoteDeviceName
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $dualModeDeviceName
     * @param string $isMobilePhone
     * @param string $enableMobileConnect
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\LineAssociations $lineAssociations
     * @param string $timeZone
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $todAccessName
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $mobileSmartClientName
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $mobilityProfileName
     * @param string $singleNumberReachVoicemail
     * @param string $dialViaOfficeReverseVoicemail
     */
    public function __construct($destination = null, $uuid = null, $newName = null, $newDestination = null, $answerTooSoonTimer = '1500', $answerTooLateTimer = '19000', $delayBeforeRingingCell = '4000', \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $ownerUserId = null, $enableUnifiedMobility = null, \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $remoteDestinationProfileName = null, $enableExtendAndConnect = null, \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $ctiRemoteDeviceName = null, \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $dualModeDeviceName = null, $isMobilePhone = 'false', $enableMobileConnect = 'true', \\Losc\CucmBundle\Model\Webservice\StructType\LineAssociations $lineAssociations = null, $timeZone = 'Etc/GMT', \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $todAccessName = null, \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $mobileSmartClientName = null, \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $mobilityProfileName = null, $singleNumberReachVoicemail = 'Use System Default', $dialViaOfficeReverseVoicemail = 'Use System Default')
    {
        $this
            ->setDestination($destination)
            ->setUuid($uuid)
            ->setNewName($newName)
            ->setNewDestination($newDestination)
            ->setAnswerTooSoonTimer($answerTooSoonTimer)
            ->setAnswerTooLateTimer($answerTooLateTimer)
            ->setDelayBeforeRingingCell($delayBeforeRingingCell)
            ->setOwnerUserId($ownerUserId)
            ->setEnableUnifiedMobility($enableUnifiedMobility)
            ->setRemoteDestinationProfileName($remoteDestinationProfileName)
            ->setEnableExtendAndConnect($enableExtendAndConnect)
            ->setCtiRemoteDeviceName($ctiRemoteDeviceName)
            ->setDualModeDeviceName($dualModeDeviceName)
            ->setIsMobilePhone($isMobilePhone)
            ->setEnableMobileConnect($enableMobileConnect)
            ->setLineAssociations($lineAssociations)
            ->setTimeZone($timeZone)
            ->setTodAccessName($todAccessName)
            ->setMobileSmartClientName($mobileSmartClientName)
            ->setMobilityProfileName($mobilityProfileName)
            ->setSingleNumberReachVoicemail($singleNumberReachVoicemail)
            ->setDialViaOfficeReverseVoicemail($dialViaOfficeReverseVoicemail);
    }
    /**
     * Get destination value
     * @return string
     */
    public function getDestination()
    {
        return isset($this->destination) ? $this->destination : null;
    }
    /**
     * Set destination value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @param string $destination
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\UpdateRemoteDestinationReq
     */
    public function setDestination($destination = null)
    {
        if (is_null($destination) || (is_array($destination) && empty($destination))) {
            unset($this->destination);
        } else {
            $this->destination = $destination;
        }
        return $this;
    }
    /**
     * Get uuid value
     * @return string|null
     */
    public function getUuid()
    {
        return isset($this->uuid) ? $this->uuid : null;
    }
    /**
     * Set uuid value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @param string $uuid
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\UpdateRemoteDestinationReq
     */
    public function setUuid($uuid = null)
    {
        if (is_null($uuid) || (is_array($uuid) && empty($uuid))) {
            unset($this->uuid);
        } else {
            $this->uuid = $uuid;
        }
        return $this;
    }
    /**
     * Get newName value
     * @return string|null
     */
    public function getNewName()
    {
        return $this->newName;
    }
    /**
     * Set newName value
     * @param string $newName
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\UpdateRemoteDestinationReq
     */
    public function setNewName($newName = null)
    {
        $this->newName = $newName;
        return $this;
    }
    /**
     * Get newDestination value
     * @return string|null
     */
    public function getNewDestination()
    {
        return $this->newDestination;
    }
    /**
     * Set newDestination value
     * @param string $newDestination
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\UpdateRemoteDestinationReq
     */
    public function setNewDestination($newDestination = null)
    {
        $this->newDestination = $newDestination;
        return $this;
    }
    /**
     * Get answerTooSoonTimer value
     * @return string|null
     */
    public function getAnswerTooSoonTimer()
    {
        return $this->answerTooSoonTimer;
    }
    /**
     * Set answerTooSoonTimer value
     * @param string $answerTooSoonTimer
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\UpdateRemoteDestinationReq
     */
    public function setAnswerTooSoonTimer($answerTooSoonTimer = '1500')
    {
        $this->answerTooSoonTimer = $answerTooSoonTimer;
        return $this;
    }
    /**
     * Get answerTooLateTimer value
     * @return string|null
     */
    public function getAnswerTooLateTimer()
    {
        return $this->answerTooLateTimer;
    }
    /**
     * Set answerTooLateTimer value
     * @param string $answerTooLateTimer
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\UpdateRemoteDestinationReq
     */
    public function setAnswerTooLateTimer($answerTooLateTimer = '19000')
    {
        $this->answerTooLateTimer = $answerTooLateTimer;
        return $this;
    }
    /**
     * Get delayBeforeRingingCell value
     * @return string|null
     */
    public function getDelayBeforeRingingCell()
    {
        return $this->delayBeforeRingingCell;
    }
    /**
     * Set delayBeforeRingingCell value
     * @param string $delayBeforeRingingCell
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\UpdateRemoteDestinationReq
     */
    public function setDelayBeforeRingingCell($delayBeforeRingingCell = '4000')
    {
        $this->delayBeforeRingingCell = $delayBeforeRingingCell;
        return $this;
    }
    /**
     * Get ownerUserId value
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XFkType|null
     */
    public function getOwnerUserId()
    {
        return $this->ownerUserId;
    }
    /**
     * Set ownerUserId value
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $ownerUserId
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\UpdateRemoteDestinationReq
     */
    public function setOwnerUserId(\\Losc\CucmBundle\Model\Webservice\StructType\XFkType $ownerUserId = null)
    {
        $this->ownerUserId = $ownerUserId;
        return $this;
    }
    /**
     * Get enableUnifiedMobility value
     * @return string|null
     */
    public function getEnableUnifiedMobility()
    {
        return $this->enableUnifiedMobility;
    }
    /**
     * Set enableUnifiedMobility value
     * @param string $enableUnifiedMobility
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\UpdateRemoteDestinationReq
     */
    public function setEnableUnifiedMobility($enableUnifiedMobility = null)
    {
        $this->enableUnifiedMobility = $enableUnifiedMobility;
        return $this;
    }
    /**
     * Get remoteDestinationProfileName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XFkType|null
     */
    public function getRemoteDestinationProfileName()
    {
        return isset($this->remoteDestinationProfileName) ? $this->remoteDestinationProfileName : null;
    }
    /**
     * Set remoteDestinationProfileName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $remoteDestinationProfileName
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\UpdateRemoteDestinationReq
     */
    public function setRemoteDestinationProfileName(\\Losc\CucmBundle\Model\Webservice\StructType\XFkType $remoteDestinationProfileName = null)
    {
        if (is_null($remoteDestinationProfileName) || (is_array($remoteDestinationProfileName) && empty($remoteDestinationProfileName))) {
            unset($this->remoteDestinationProfileName);
        } else {
            $this->remoteDestinationProfileName = $remoteDestinationProfileName;
        }
        return $this;
    }
    /**
     * Get enableExtendAndConnect value
     * @return string|null
     */
    public function getEnableExtendAndConnect()
    {
        return $this->enableExtendAndConnect;
    }
    /**
     * Set enableExtendAndConnect value
     * @param string $enableExtendAndConnect
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\UpdateRemoteDestinationReq
     */
    public function setEnableExtendAndConnect($enableExtendAndConnect = null)
    {
        $this->enableExtendAndConnect = $enableExtendAndConnect;
        return $this;
    }
    /**
     * Get ctiRemoteDeviceName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XFkType|null
     */
    public function getCtiRemoteDeviceName()
    {
        return isset($this->ctiRemoteDeviceName) ? $this->ctiRemoteDeviceName : null;
    }
    /**
     * Set ctiRemoteDeviceName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $ctiRemoteDeviceName
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\UpdateRemoteDestinationReq
     */
    public function setCtiRemoteDeviceName(\\Losc\CucmBundle\Model\Webservice\StructType\XFkType $ctiRemoteDeviceName = null)
    {
        if (is_null($ctiRemoteDeviceName) || (is_array($ctiRemoteDeviceName) && empty($ctiRemoteDeviceName))) {
            unset($this->ctiRemoteDeviceName);
        } else {
            $this->ctiRemoteDeviceName = $ctiRemoteDeviceName;
        }
        return $this;
    }
    /**
     * Get dualModeDeviceName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XFkType|null
     */
    public function getDualModeDeviceName()
    {
        return isset($this->dualModeDeviceName) ? $this->dualModeDeviceName : null;
    }
    /**
     * Set dualModeDeviceName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $dualModeDeviceName
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\UpdateRemoteDestinationReq
     */
    public function setDualModeDeviceName(\\Losc\CucmBundle\Model\Webservice\StructType\XFkType $dualModeDeviceName = null)
    {
        if (is_null($dualModeDeviceName) || (is_array($dualModeDeviceName) && empty($dualModeDeviceName))) {
            unset($this->dualModeDeviceName);
        } else {
            $this->dualModeDeviceName = $dualModeDeviceName;
        }
        return $this;
    }
    /**
     * Get isMobilePhone value
     * @return string|null
     */
    public function getIsMobilePhone()
    {
        return $this->isMobilePhone;
    }
    /**
     * Set isMobilePhone value
     * @param string $isMobilePhone
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\UpdateRemoteDestinationReq
     */
    public function setIsMobilePhone($isMobilePhone = 'false')
    {
        $this->isMobilePhone = $isMobilePhone;
        return $this;
    }
    /**
     * Get enableMobileConnect value
     * @return string|null
     */
    public function getEnableMobileConnect()
    {
        return $this->enableMobileConnect;
    }
    /**
     * Set enableMobileConnect value
     * @param string $enableMobileConnect
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\UpdateRemoteDestinationReq
     */
    public function setEnableMobileConnect($enableMobileConnect = 'true')
    {
        $this->enableMobileConnect = $enableMobileConnect;
        return $this;
    }
    /**
     * Get lineAssociations value
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\LineAssociations|null
     */
    public function getLineAssociations()
    {
        return $this->lineAssociations;
    }
    /**
     * Set lineAssociations value
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\LineAssociations $lineAssociations
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\UpdateRemoteDestinationReq
     */
    public function setLineAssociations(\\Losc\CucmBundle\Model\Webservice\StructType\LineAssociations $lineAssociations = null)
    {
        $this->lineAssociations = $lineAssociations;
        return $this;
    }
    /**
     * Get timeZone value
     * @return string|null
     */
    public function getTimeZone()
    {
        return $this->timeZone;
    }
    /**
     * Set timeZone value
     * @param string $timeZone
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\UpdateRemoteDestinationReq
     */
    public function setTimeZone($timeZone = 'Etc/GMT')
    {
        $this->timeZone = $timeZone;
        return $this;
    }
    /**
     * Get todAccessName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XFkType|null
     */
    public function getTodAccessName()
    {
        return isset($this->todAccessName) ? $this->todAccessName : null;
    }
    /**
     * Set todAccessName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $todAccessName
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\UpdateRemoteDestinationReq
     */
    public function setTodAccessName(\\Losc\CucmBundle\Model\Webservice\StructType\XFkType $todAccessName = null)
    {
        if (is_null($todAccessName) || (is_array($todAccessName) && empty($todAccessName))) {
            unset($this->todAccessName);
        } else {
            $this->todAccessName = $todAccessName;
        }
        return $this;
    }
    /**
     * Get mobileSmartClientName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XFkType|null
     */
    public function getMobileSmartClientName()
    {
        return isset($this->mobileSmartClientName) ? $this->mobileSmartClientName : null;
    }
    /**
     * Set mobileSmartClientName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $mobileSmartClientName
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\UpdateRemoteDestinationReq
     */
    public function setMobileSmartClientName(\\Losc\CucmBundle\Model\Webservice\StructType\XFkType $mobileSmartClientName = null)
    {
        if (is_null($mobileSmartClientName) || (is_array($mobileSmartClientName) && empty($mobileSmartClientName))) {
            unset($this->mobileSmartClientName);
        } else {
            $this->mobileSmartClientName = $mobileSmartClientName;
        }
        return $this;
    }
    /**
     * Get mobilityProfileName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XFkType|null
     */
    public function getMobilityProfileName()
    {
        return isset($this->mobilityProfileName) ? $this->mobilityProfileName : null;
    }
    /**
     * Set mobilityProfileName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $mobilityProfileName
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\UpdateRemoteDestinationReq
     */
    public function setMobilityProfileName(\\Losc\CucmBundle\Model\Webservice\StructType\XFkType $mobilityProfileName = null)
    {
        if (is_null($mobilityProfileName) || (is_array($mobilityProfileName) && empty($mobilityProfileName))) {
            unset($this->mobilityProfileName);
        } else {
            $this->mobilityProfileName = $mobilityProfileName;
        }
        return $this;
    }
    /**
     * Get singleNumberReachVoicemail value
     * @return string|null
     */
    public function getSingleNumberReachVoicemail()
    {
        return $this->singleNumberReachVoicemail;
    }
    /**
     * Set singleNumberReachVoicemail value
     * @param string $singleNumberReachVoicemail
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\UpdateRemoteDestinationReq
     */
    public function setSingleNumberReachVoicemail($singleNumberReachVoicemail = 'Use System Default')
    {
        $this->singleNumberReachVoicemail = $singleNumberReachVoicemail;
        return $this;
    }
    /**
     * Get dialViaOfficeReverseVoicemail value
     * @return string|null
     */
    public function getDialViaOfficeReverseVoicemail()
    {
        return $this->dialViaOfficeReverseVoicemail;
    }
    /**
     * Set dialViaOfficeReverseVoicemail value
     * @param string $dialViaOfficeReverseVoicemail
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\UpdateRemoteDestinationReq
     */
    public function setDialViaOfficeReverseVoicemail($dialViaOfficeReverseVoicemail = 'Use System Default')
    {
        $this->dialViaOfficeReverseVoicemail = $dialViaOfficeReverseVoicemail;
        return $this;
    }
}
