<?php

namespace \Losc\CucmBundle\Model\Webservice\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UpdateProcessNodeServiceReq StructType
 * @subpackage Structs
 */
class UpdateProcessNodeServiceReq extends APIRequest
{
    /**
     * The processNodeName
     * Meta information extracted from the WSDL
     * - choice: uuid | processNodeName | service
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $processNodeName;
    /**
     * The service
     * Meta information extracted from the WSDL
     * - choice: uuid | processNodeName | service
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $service;
    /**
     * The uuid
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - choice: uuid | processNodeName | service
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - pattern: \{........-....-....-....-............\}
     * @var string
     */
    public $uuid;
    /**
     * The traceLevel
     * Meta information extracted from the WSDL
     * - default: 0
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $traceLevel;
    /**
     * The userCategories
     * Meta information extracted from the WSDL
     * - default: 0
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $userCategories;
    /**
     * The enable
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - default: false
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $enable;
    /**
     * The numFiles
     * Meta information extracted from the WSDL
     * - default: 250
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $numFiles;
    /**
     * The maxFileSize
     * Meta information extracted from the WSDL
     * - default: 1
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $maxFileSize;
    /**
     * Constructor method for UpdateProcessNodeServiceReq
     * @uses UpdateProcessNodeServiceReq::setProcessNodeName()
     * @uses UpdateProcessNodeServiceReq::setService()
     * @uses UpdateProcessNodeServiceReq::setUuid()
     * @uses UpdateProcessNodeServiceReq::setTraceLevel()
     * @uses UpdateProcessNodeServiceReq::setUserCategories()
     * @uses UpdateProcessNodeServiceReq::setEnable()
     * @uses UpdateProcessNodeServiceReq::setNumFiles()
     * @uses UpdateProcessNodeServiceReq::setMaxFileSize()
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $processNodeName
     * @param string $service
     * @param string $uuid
     * @param string $traceLevel
     * @param string $userCategories
     * @param string $enable
     * @param string $numFiles
     * @param string $maxFileSize
     */
    public function __construct(\\Losc\CucmBundle\Model\Webservice\StructType\XFkType $processNodeName = null, $service = null, $uuid = null, $traceLevel = '0', $userCategories = '0', $enable = 'false', $numFiles = '250', $maxFileSize = '1')
    {
        $this
            ->setProcessNodeName($processNodeName)
            ->setService($service)
            ->setUuid($uuid)
            ->setTraceLevel($traceLevel)
            ->setUserCategories($userCategories)
            ->setEnable($enable)
            ->setNumFiles($numFiles)
            ->setMaxFileSize($maxFileSize);
    }
    /**
     * Get processNodeName value
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public function getProcessNodeName()
    {
        return isset($this->processNodeName) ? $this->processNodeName : null;
    }
    /**
     * Set processNodeName value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $processNodeName
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\UpdateProcessNodeServiceReq
     */
    public function setProcessNodeName(\\Losc\CucmBundle\Model\Webservice\StructType\XFkType $processNodeName = null)
    {
        if (is_null($processNodeName) || (is_array($processNodeName) && empty($processNodeName))) {
            unset($this->processNodeName);
        } else {
            $this->processNodeName = $processNodeName;
        }
        return $this;
    }
    /**
     * Get service value
     * @return string
     */
    public function getService()
    {
        return isset($this->service) ? $this->service : null;
    }
    /**
     * Set service value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @param string $service
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\UpdateProcessNodeServiceReq
     */
    public function setService($service = null)
    {
        if (is_null($service) || (is_array($service) && empty($service))) {
            unset($this->service);
        } else {
            $this->service = $service;
        }
        return $this;
    }
    /**
     * Get uuid value
     * @return string|null
     */
    public function getUuid()
    {
        return isset($this->uuid) ? $this->uuid : null;
    }
    /**
     * Set uuid value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @param string $uuid
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\UpdateProcessNodeServiceReq
     */
    public function setUuid($uuid = null)
    {
        if (is_null($uuid) || (is_array($uuid) && empty($uuid))) {
            unset($this->uuid);
        } else {
            $this->uuid = $uuid;
        }
        return $this;
    }
    /**
     * Get traceLevel value
     * @return string|null
     */
    public function getTraceLevel()
    {
        return $this->traceLevel;
    }
    /**
     * Set traceLevel value
     * @param string $traceLevel
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\UpdateProcessNodeServiceReq
     */
    public function setTraceLevel($traceLevel = '0')
    {
        $this->traceLevel = $traceLevel;
        return $this;
    }
    /**
     * Get userCategories value
     * @return string|null
     */
    public function getUserCategories()
    {
        return $this->userCategories;
    }
    /**
     * Set userCategories value
     * @param string $userCategories
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\UpdateProcessNodeServiceReq
     */
    public function setUserCategories($userCategories = '0')
    {
        $this->userCategories = $userCategories;
        return $this;
    }
    /**
     * Get enable value
     * @return string|null
     */
    public function getEnable()
    {
        return $this->enable;
    }
    /**
     * Set enable value
     * @param string $enable
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\UpdateProcessNodeServiceReq
     */
    public function setEnable($enable = 'false')
    {
        $this->enable = $enable;
        return $this;
    }
    /**
     * Get numFiles value
     * @return string|null
     */
    public function getNumFiles()
    {
        return $this->numFiles;
    }
    /**
     * Set numFiles value
     * @param string $numFiles
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\UpdateProcessNodeServiceReq
     */
    public function setNumFiles($numFiles = '250')
    {
        $this->numFiles = $numFiles;
        return $this;
    }
    /**
     * Get maxFileSize value
     * @return string|null
     */
    public function getMaxFileSize()
    {
        return $this->maxFileSize;
    }
    /**
     * Set maxFileSize value
     * @param string $maxFileSize
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\UpdateProcessNodeServiceReq
     */
    public function setMaxFileSize($maxFileSize = '1')
    {
        $this->maxFileSize = $maxFileSize;
        return $this;
    }
}
