<?php

namespace \Losc\CucmBundle\Model\Webservice\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UpdateMessageWaitingReq StructType
 * @subpackage Structs
 */
class UpdateMessageWaitingReq extends APIRequest
{
    /**
     * The pattern
     * Meta information extracted from the WSDL
     * - choice: uuid | pattern | routePartitionName
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $pattern;
    /**
     * The routePartitionName
     * Meta information extracted from the WSDL
     * - choice: uuid | pattern | routePartitionName
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $routePartitionName;
    /**
     * The uuid
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - choice: uuid | pattern | routePartitionName
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - pattern: \{........-....-....-....-............\}
     * @var string
     */
    public $uuid;
    /**
     * The newPattern
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $newPattern;
    /**
     * The newRoutePartitionName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $newRoutePartitionName;
    /**
     * The description
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 128
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $description;
    /**
     * The messageWaitingIndicator
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - default: false
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $messageWaitingIndicator;
    /**
     * The callingSearchSpaceName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $callingSearchSpaceName;
    /**
     * Constructor method for UpdateMessageWaitingReq
     * @uses UpdateMessageWaitingReq::setPattern()
     * @uses UpdateMessageWaitingReq::setRoutePartitionName()
     * @uses UpdateMessageWaitingReq::setUuid()
     * @uses UpdateMessageWaitingReq::setNewPattern()
     * @uses UpdateMessageWaitingReq::setNewRoutePartitionName()
     * @uses UpdateMessageWaitingReq::setDescription()
     * @uses UpdateMessageWaitingReq::setMessageWaitingIndicator()
     * @uses UpdateMessageWaitingReq::setCallingSearchSpaceName()
     * @param string $pattern
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $routePartitionName
     * @param string $uuid
     * @param string $newPattern
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $newRoutePartitionName
     * @param string $description
     * @param string $messageWaitingIndicator
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $callingSearchSpaceName
     */
    public function __construct($pattern = null, \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $routePartitionName = null, $uuid = null, $newPattern = null, \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $newRoutePartitionName = null, $description = null, $messageWaitingIndicator = 'false', \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $callingSearchSpaceName = null)
    {
        $this
            ->setPattern($pattern)
            ->setRoutePartitionName($routePartitionName)
            ->setUuid($uuid)
            ->setNewPattern($newPattern)
            ->setNewRoutePartitionName($newRoutePartitionName)
            ->setDescription($description)
            ->setMessageWaitingIndicator($messageWaitingIndicator)
            ->setCallingSearchSpaceName($callingSearchSpaceName);
    }
    /**
     * Get pattern value
     * @return string
     */
    public function getPattern()
    {
        return isset($this->pattern) ? $this->pattern : null;
    }
    /**
     * Set pattern value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @param string $pattern
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\UpdateMessageWaitingReq
     */
    public function setPattern($pattern = null)
    {
        if (is_null($pattern) || (is_array($pattern) && empty($pattern))) {
            unset($this->pattern);
        } else {
            $this->pattern = $pattern;
        }
        return $this;
    }
    /**
     * Get routePartitionName value
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public function getRoutePartitionName()
    {
        return isset($this->routePartitionName) ? $this->routePartitionName : null;
    }
    /**
     * Set routePartitionName value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $routePartitionName
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\UpdateMessageWaitingReq
     */
    public function setRoutePartitionName(\\Losc\CucmBundle\Model\Webservice\StructType\XFkType $routePartitionName = null)
    {
        if (is_null($routePartitionName) || (is_array($routePartitionName) && empty($routePartitionName))) {
            unset($this->routePartitionName);
        } else {
            $this->routePartitionName = $routePartitionName;
        }
        return $this;
    }
    /**
     * Get uuid value
     * @return string|null
     */
    public function getUuid()
    {
        return isset($this->uuid) ? $this->uuid : null;
    }
    /**
     * Set uuid value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @param string $uuid
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\UpdateMessageWaitingReq
     */
    public function setUuid($uuid = null)
    {
        if (is_null($uuid) || (is_array($uuid) && empty($uuid))) {
            unset($this->uuid);
        } else {
            $this->uuid = $uuid;
        }
        return $this;
    }
    /**
     * Get newPattern value
     * @return string|null
     */
    public function getNewPattern()
    {
        return $this->newPattern;
    }
    /**
     * Set newPattern value
     * @param string $newPattern
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\UpdateMessageWaitingReq
     */
    public function setNewPattern($newPattern = null)
    {
        $this->newPattern = $newPattern;
        return $this;
    }
    /**
     * Get newRoutePartitionName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XFkType|null
     */
    public function getNewRoutePartitionName()
    {
        return isset($this->newRoutePartitionName) ? $this->newRoutePartitionName : null;
    }
    /**
     * Set newRoutePartitionName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $newRoutePartitionName
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\UpdateMessageWaitingReq
     */
    public function setNewRoutePartitionName(\\Losc\CucmBundle\Model\Webservice\StructType\XFkType $newRoutePartitionName = null)
    {
        if (is_null($newRoutePartitionName) || (is_array($newRoutePartitionName) && empty($newRoutePartitionName))) {
            unset($this->newRoutePartitionName);
        } else {
            $this->newRoutePartitionName = $newRoutePartitionName;
        }
        return $this;
    }
    /**
     * Get description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->description;
    }
    /**
     * Set description value
     * @param string $description
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\UpdateMessageWaitingReq
     */
    public function setDescription($description = null)
    {
        $this->description = $description;
        return $this;
    }
    /**
     * Get messageWaitingIndicator value
     * @return string|null
     */
    public function getMessageWaitingIndicator()
    {
        return $this->messageWaitingIndicator;
    }
    /**
     * Set messageWaitingIndicator value
     * @param string $messageWaitingIndicator
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\UpdateMessageWaitingReq
     */
    public function setMessageWaitingIndicator($messageWaitingIndicator = 'false')
    {
        $this->messageWaitingIndicator = $messageWaitingIndicator;
        return $this;
    }
    /**
     * Get callingSearchSpaceName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XFkType|null
     */
    public function getCallingSearchSpaceName()
    {
        return isset($this->callingSearchSpaceName) ? $this->callingSearchSpaceName : null;
    }
    /**
     * Set callingSearchSpaceName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $callingSearchSpaceName
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\UpdateMessageWaitingReq
     */
    public function setCallingSearchSpaceName(\\Losc\CucmBundle\Model\Webservice\StructType\XFkType $callingSearchSpaceName = null)
    {
        if (is_null($callingSearchSpaceName) || (is_array($callingSearchSpaceName) && empty($callingSearchSpaceName))) {
            unset($this->callingSearchSpaceName);
        } else {
            $this->callingSearchSpaceName = $callingSearchSpaceName;
        }
        return $this;
    }
}
