<?php

namespace \Losc\CucmBundle\Model\Webservice\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UpdateGatekeeperReq StructType
 * @subpackage Structs
 */
class UpdateGatekeeperReq extends NameAndGUIDRequest
{
    /**
     * The newName
     * Meta information extracted from the WSDL
     * - documentation: From Device Table
     * - base: xsd:string
     * - maxLength: 128
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $newName;
    /**
     * The description
     * Meta information extracted from the WSDL
     * - documentation: From Device Table
     * - base: xsd:string
     * - maxLength: 128
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $description;
    /**
     * The rrqTimeToLive
     * Meta information extracted from the WSDL
     * - documentation: Value should be numbers in range of 30 to 300
     * - default: 60
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $rrqTimeToLive;
    /**
     * The retryTimeout
     * Meta information extracted from the WSDL
     * - documentation: Value should be numbers in range of 30 to 600
     * - default: 300
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $retryTimeout;
    /**
     * The enableDevice
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - default: true
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $enableDevice;
    /**
     * Constructor method for UpdateGatekeeperReq
     * @uses UpdateGatekeeperReq::setNewName()
     * @uses UpdateGatekeeperReq::setDescription()
     * @uses UpdateGatekeeperReq::setRrqTimeToLive()
     * @uses UpdateGatekeeperReq::setRetryTimeout()
     * @uses UpdateGatekeeperReq::setEnableDevice()
     * @param string $newName
     * @param string $description
     * @param string $rrqTimeToLive
     * @param string $retryTimeout
     * @param string $enableDevice
     */
    public function __construct($newName = null, $description = null, $rrqTimeToLive = '60', $retryTimeout = '300', $enableDevice = 'true')
    {
        $this
            ->setNewName($newName)
            ->setDescription($description)
            ->setRrqTimeToLive($rrqTimeToLive)
            ->setRetryTimeout($retryTimeout)
            ->setEnableDevice($enableDevice);
    }
    /**
     * Get newName value
     * @return string|null
     */
    public function getNewName()
    {
        return $this->newName;
    }
    /**
     * Set newName value
     * @param string $newName
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\UpdateGatekeeperReq
     */
    public function setNewName($newName = null)
    {
        $this->newName = $newName;
        return $this;
    }
    /**
     * Get description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->description;
    }
    /**
     * Set description value
     * @param string $description
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\UpdateGatekeeperReq
     */
    public function setDescription($description = null)
    {
        $this->description = $description;
        return $this;
    }
    /**
     * Get rrqTimeToLive value
     * @return string|null
     */
    public function getRrqTimeToLive()
    {
        return $this->rrqTimeToLive;
    }
    /**
     * Set rrqTimeToLive value
     * @param string $rrqTimeToLive
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\UpdateGatekeeperReq
     */
    public function setRrqTimeToLive($rrqTimeToLive = '60')
    {
        $this->rrqTimeToLive = $rrqTimeToLive;
        return $this;
    }
    /**
     * Get retryTimeout value
     * @return string|null
     */
    public function getRetryTimeout()
    {
        return $this->retryTimeout;
    }
    /**
     * Set retryTimeout value
     * @param string $retryTimeout
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\UpdateGatekeeperReq
     */
    public function setRetryTimeout($retryTimeout = '300')
    {
        $this->retryTimeout = $retryTimeout;
        return $this;
    }
    /**
     * Get enableDevice value
     * @return string|null
     */
    public function getEnableDevice()
    {
        return $this->enableDevice;
    }
    /**
     * Set enableDevice value
     * @param string $enableDevice
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\UpdateGatekeeperReq
     */
    public function setEnableDevice($enableDevice = 'true')
    {
        $this->enableDevice = $enableDevice;
        return $this;
    }
}
