<?php

namespace \Losc\CucmBundle\Model\Webservice\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UpdateFallbackProfileReq StructType
 * @subpackage Structs
 */
class UpdateFallbackProfileReq extends NameAndGUIDRequest
{
    /**
     * The newName
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 50
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $newName;
    /**
     * The description
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $description;
    /**
     * The advertisedFallbackDirectoryE164Number
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $advertisedFallbackDirectoryE164Number;
    /**
     * The qosSensistivityLevel
     * Meta information extracted from the WSDL
     * - documentation: The Fallback QOS Sensitivity should be in range 1 to 5
     * - default: 3
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $qosSensistivityLevel;
    /**
     * The callCss
     * Meta information extracted from the WSDL
     * - default: Calling device AAR Calling Search Space
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $callCss;
    /**
     * The callAnswerTimer
     * Meta information extracted from the WSDL
     * - documentation: The Fallback Call Answer Timer should be in range 1 to 10
     * - default: 6
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $callAnswerTimer;
    /**
     * The directoryNumberPartition
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $directoryNumberPartition;
    /**
     * The directoryNumber
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 16
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $directoryNumber;
    /**
     * The numberOfDigitsForCallerIDPartialMatch
     * Meta information extracted from the WSDL
     * - documentation: The number of digits for Caller ID partial match should be in range 4 to 15
     * - default: 5
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $numberOfDigitsForCallerIDPartialMatch;
    /**
     * Constructor method for UpdateFallbackProfileReq
     * @uses UpdateFallbackProfileReq::setNewName()
     * @uses UpdateFallbackProfileReq::setDescription()
     * @uses UpdateFallbackProfileReq::setAdvertisedFallbackDirectoryE164Number()
     * @uses UpdateFallbackProfileReq::setQosSensistivityLevel()
     * @uses UpdateFallbackProfileReq::setCallCss()
     * @uses UpdateFallbackProfileReq::setCallAnswerTimer()
     * @uses UpdateFallbackProfileReq::setDirectoryNumberPartition()
     * @uses UpdateFallbackProfileReq::setDirectoryNumber()
     * @uses UpdateFallbackProfileReq::setNumberOfDigitsForCallerIDPartialMatch()
     * @param string $newName
     * @param string $description
     * @param string $advertisedFallbackDirectoryE164Number
     * @param string $qosSensistivityLevel
     * @param string $callCss
     * @param string $callAnswerTimer
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $directoryNumberPartition
     * @param string $directoryNumber
     * @param string $numberOfDigitsForCallerIDPartialMatch
     */
    public function __construct($newName = null, $description = null, $advertisedFallbackDirectoryE164Number = null, $qosSensistivityLevel = '3', $callCss = 'Calling device AAR Calling Search Space', $callAnswerTimer = '6', \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $directoryNumberPartition = null, $directoryNumber = null, $numberOfDigitsForCallerIDPartialMatch = '5')
    {
        $this
            ->setNewName($newName)
            ->setDescription($description)
            ->setAdvertisedFallbackDirectoryE164Number($advertisedFallbackDirectoryE164Number)
            ->setQosSensistivityLevel($qosSensistivityLevel)
            ->setCallCss($callCss)
            ->setCallAnswerTimer($callAnswerTimer)
            ->setDirectoryNumberPartition($directoryNumberPartition)
            ->setDirectoryNumber($directoryNumber)
            ->setNumberOfDigitsForCallerIDPartialMatch($numberOfDigitsForCallerIDPartialMatch);
    }
    /**
     * Get newName value
     * @return string|null
     */
    public function getNewName()
    {
        return $this->newName;
    }
    /**
     * Set newName value
     * @param string $newName
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\UpdateFallbackProfileReq
     */
    public function setNewName($newName = null)
    {
        $this->newName = $newName;
        return $this;
    }
    /**
     * Get description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->description;
    }
    /**
     * Set description value
     * @param string $description
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\UpdateFallbackProfileReq
     */
    public function setDescription($description = null)
    {
        $this->description = $description;
        return $this;
    }
    /**
     * Get advertisedFallbackDirectoryE164Number value
     * @return string|null
     */
    public function getAdvertisedFallbackDirectoryE164Number()
    {
        return $this->advertisedFallbackDirectoryE164Number;
    }
    /**
     * Set advertisedFallbackDirectoryE164Number value
     * @param string $advertisedFallbackDirectoryE164Number
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\UpdateFallbackProfileReq
     */
    public function setAdvertisedFallbackDirectoryE164Number($advertisedFallbackDirectoryE164Number = null)
    {
        $this->advertisedFallbackDirectoryE164Number = $advertisedFallbackDirectoryE164Number;
        return $this;
    }
    /**
     * Get qosSensistivityLevel value
     * @return string|null
     */
    public function getQosSensistivityLevel()
    {
        return $this->qosSensistivityLevel;
    }
    /**
     * Set qosSensistivityLevel value
     * @param string $qosSensistivityLevel
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\UpdateFallbackProfileReq
     */
    public function setQosSensistivityLevel($qosSensistivityLevel = '3')
    {
        $this->qosSensistivityLevel = $qosSensistivityLevel;
        return $this;
    }
    /**
     * Get callCss value
     * @return string|null
     */
    public function getCallCss()
    {
        return $this->callCss;
    }
    /**
     * Set callCss value
     * @param string $callCss
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\UpdateFallbackProfileReq
     */
    public function setCallCss($callCss = 'Calling device AAR Calling Search Space')
    {
        $this->callCss = $callCss;
        return $this;
    }
    /**
     * Get callAnswerTimer value
     * @return string|null
     */
    public function getCallAnswerTimer()
    {
        return $this->callAnswerTimer;
    }
    /**
     * Set callAnswerTimer value
     * @param string $callAnswerTimer
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\UpdateFallbackProfileReq
     */
    public function setCallAnswerTimer($callAnswerTimer = '6')
    {
        $this->callAnswerTimer = $callAnswerTimer;
        return $this;
    }
    /**
     * Get directoryNumberPartition value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XFkType|null
     */
    public function getDirectoryNumberPartition()
    {
        return isset($this->directoryNumberPartition) ? $this->directoryNumberPartition : null;
    }
    /**
     * Set directoryNumberPartition value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $directoryNumberPartition
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\UpdateFallbackProfileReq
     */
    public function setDirectoryNumberPartition(\\Losc\CucmBundle\Model\Webservice\StructType\XFkType $directoryNumberPartition = null)
    {
        if (is_null($directoryNumberPartition) || (is_array($directoryNumberPartition) && empty($directoryNumberPartition))) {
            unset($this->directoryNumberPartition);
        } else {
            $this->directoryNumberPartition = $directoryNumberPartition;
        }
        return $this;
    }
    /**
     * Get directoryNumber value
     * @return string|null
     */
    public function getDirectoryNumber()
    {
        return $this->directoryNumber;
    }
    /**
     * Set directoryNumber value
     * @param string $directoryNumber
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\UpdateFallbackProfileReq
     */
    public function setDirectoryNumber($directoryNumber = null)
    {
        $this->directoryNumber = $directoryNumber;
        return $this;
    }
    /**
     * Get numberOfDigitsForCallerIDPartialMatch value
     * @return string|null
     */
    public function getNumberOfDigitsForCallerIDPartialMatch()
    {
        return $this->numberOfDigitsForCallerIDPartialMatch;
    }
    /**
     * Set numberOfDigitsForCallerIDPartialMatch value
     * @param string $numberOfDigitsForCallerIDPartialMatch
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\UpdateFallbackProfileReq
     */
    public function setNumberOfDigitsForCallerIDPartialMatch($numberOfDigitsForCallerIDPartialMatch = '5')
    {
        $this->numberOfDigitsForCallerIDPartialMatch = $numberOfDigitsForCallerIDPartialMatch;
        return $this;
    }
}
