<?php

namespace \Losc\CucmBundle\Model\Webservice\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UpdateCumaServerSecurityProfileReq StructType
 * @subpackage Structs
 */
class UpdateCumaServerSecurityProfileReq extends NameAndGUIDRequest
{
    /**
     * The newName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $newName;
    /**
     * The description
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $description;
    /**
     * The securityMode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $securityMode;
    /**
     * The transportType
     * Meta information extracted from the WSDL
     * - default: TCP+UDP
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $transportType;
    /**
     * The x509SubjectName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $x509SubjectName;
    /**
     * The serverIpHostName
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 255
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $serverIpHostName;
    /**
     * Constructor method for UpdateCumaServerSecurityProfileReq
     * @uses UpdateCumaServerSecurityProfileReq::setNewName()
     * @uses UpdateCumaServerSecurityProfileReq::setDescription()
     * @uses UpdateCumaServerSecurityProfileReq::setSecurityMode()
     * @uses UpdateCumaServerSecurityProfileReq::setTransportType()
     * @uses UpdateCumaServerSecurityProfileReq::setX509SubjectName()
     * @uses UpdateCumaServerSecurityProfileReq::setServerIpHostName()
     * @param string $newName
     * @param string $description
     * @param string $securityMode
     * @param string $transportType
     * @param string $x509SubjectName
     * @param string $serverIpHostName
     */
    public function __construct($newName = null, $description = null, $securityMode = null, $transportType = 'TCP+UDP', $x509SubjectName = null, $serverIpHostName = null)
    {
        $this
            ->setNewName($newName)
            ->setDescription($description)
            ->setSecurityMode($securityMode)
            ->setTransportType($transportType)
            ->setX509SubjectName($x509SubjectName)
            ->setServerIpHostName($serverIpHostName);
    }
    /**
     * Get newName value
     * @return string|null
     */
    public function getNewName()
    {
        return $this->newName;
    }
    /**
     * Set newName value
     * @param string $newName
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\UpdateCumaServerSecurityProfileReq
     */
    public function setNewName($newName = null)
    {
        $this->newName = $newName;
        return $this;
    }
    /**
     * Get description value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDescription()
    {
        return isset($this->description) ? $this->description : null;
    }
    /**
     * Set description value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $description
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\UpdateCumaServerSecurityProfileReq
     */
    public function setDescription($description = null)
    {
        if (is_null($description) || (is_array($description) && empty($description))) {
            unset($this->description);
        } else {
            $this->description = $description;
        }
        return $this;
    }
    /**
     * Get securityMode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSecurityMode()
    {
        return isset($this->securityMode) ? $this->securityMode : null;
    }
    /**
     * Set securityMode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $securityMode
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\UpdateCumaServerSecurityProfileReq
     */
    public function setSecurityMode($securityMode = null)
    {
        if (is_null($securityMode) || (is_array($securityMode) && empty($securityMode))) {
            unset($this->securityMode);
        } else {
            $this->securityMode = $securityMode;
        }
        return $this;
    }
    /**
     * Get transportType value
     * @return string|null
     */
    public function getTransportType()
    {
        return $this->transportType;
    }
    /**
     * Set transportType value
     * @param string $transportType
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\UpdateCumaServerSecurityProfileReq
     */
    public function setTransportType($transportType = 'TCP+UDP')
    {
        $this->transportType = $transportType;
        return $this;
    }
    /**
     * Get x509SubjectName value
     * @return string|null
     */
    public function getX509SubjectName()
    {
        return $this->x509SubjectName;
    }
    /**
     * Set x509SubjectName value
     * @param string $x509SubjectName
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\UpdateCumaServerSecurityProfileReq
     */
    public function setX509SubjectName($x509SubjectName = null)
    {
        $this->x509SubjectName = $x509SubjectName;
        return $this;
    }
    /**
     * Get serverIpHostName value
     * @return string|null
     */
    public function getServerIpHostName()
    {
        return $this->serverIpHostName;
    }
    /**
     * Set serverIpHostName value
     * @param string $serverIpHostName
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\UpdateCumaServerSecurityProfileReq
     */
    public function setServerIpHostName($serverIpHostName = null)
    {
        $this->serverIpHostName = $serverIpHostName;
        return $this;
    }
}
