<?php

namespace \Losc\CucmBundle\Model\Webservice\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UpdateCmcInfoReq StructType
 * @subpackage Structs
 */
class UpdateCmcInfoReq extends APIRequest
{
    /**
     * The code
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - choice: uuid | code
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - maxLength: 16
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $code;
    /**
     * The uuid
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - choice: uuid | code
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - pattern: \{........-....-....-....-............\}
     * @var string
     */
    public $uuid;
    /**
     * The newCode
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 16
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $newCode;
    /**
     * The description
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 50
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $description;
    /**
     * Constructor method for UpdateCmcInfoReq
     * @uses UpdateCmcInfoReq::setCode()
     * @uses UpdateCmcInfoReq::setUuid()
     * @uses UpdateCmcInfoReq::setNewCode()
     * @uses UpdateCmcInfoReq::setDescription()
     * @param string $code
     * @param string $uuid
     * @param string $newCode
     * @param string $description
     */
    public function __construct($code = null, $uuid = null, $newCode = null, $description = null)
    {
        $this
            ->setCode($code)
            ->setUuid($uuid)
            ->setNewCode($newCode)
            ->setDescription($description);
    }
    /**
     * Get code value
     * @return string
     */
    public function getCode()
    {
        return isset($this->code) ? $this->code : null;
    }
    /**
     * Set code value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @param string $code
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\UpdateCmcInfoReq
     */
    public function setCode($code = null)
    {
        if (is_null($code) || (is_array($code) && empty($code))) {
            unset($this->code);
        } else {
            $this->code = $code;
        }
        return $this;
    }
    /**
     * Get uuid value
     * @return string|null
     */
    public function getUuid()
    {
        return isset($this->uuid) ? $this->uuid : null;
    }
    /**
     * Set uuid value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @param string $uuid
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\UpdateCmcInfoReq
     */
    public function setUuid($uuid = null)
    {
        if (is_null($uuid) || (is_array($uuid) && empty($uuid))) {
            unset($this->uuid);
        } else {
            $this->uuid = $uuid;
        }
        return $this;
    }
    /**
     * Get newCode value
     * @return string|null
     */
    public function getNewCode()
    {
        return $this->newCode;
    }
    /**
     * Set newCode value
     * @param string $newCode
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\UpdateCmcInfoReq
     */
    public function setNewCode($newCode = null)
    {
        $this->newCode = $newCode;
        return $this;
    }
    /**
     * Get description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->description;
    }
    /**
     * Set description value
     * @param string $description
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\UpdateCmcInfoReq
     */
    public function setDescription($description = null)
    {
        $this->description = $description;
        return $this;
    }
}
