<?php

namespace \Losc\CucmBundle\Model\Webservice\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RemoveUnitsToGatewayReq StructType
 * @subpackage Structs
 */
class RemoveUnitsToGatewayReq extends AbstractStructBase
{
    /**
     * The gatewayUuid
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - choice: gatewayUuid | domainName
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - pattern: \{........-....-....-....-............\}
     * @var string
     */
    public $gatewayUuid;
    /**
     * The domainName
     * Meta information extracted from the WSDL
     * - documentation: For SCCP mention MAC Address
     * - choice: gatewayUuid | domainName
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - nillable: false
     * @var string
     */
    public $domainName;
    /**
     * The units
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\Units
     */
    public $units;
    /**
     * The sequence
     * Meta information extracted from the WSDL
     * - use: optional
     * @var int
     */
    public $sequence;
    /**
     * Constructor method for RemoveUnitsToGatewayReq
     * @uses RemoveUnitsToGatewayReq::setGatewayUuid()
     * @uses RemoveUnitsToGatewayReq::setDomainName()
     * @uses RemoveUnitsToGatewayReq::setUnits()
     * @uses RemoveUnitsToGatewayReq::setSequence()
     * @param string $gatewayUuid
     * @param string $domainName
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\Units $units
     * @param int $sequence
     */
    public function __construct($gatewayUuid = null, $domainName = null, \\Losc\CucmBundle\Model\Webservice\StructType\Units $units = null, $sequence = null)
    {
        $this
            ->setGatewayUuid($gatewayUuid)
            ->setDomainName($domainName)
            ->setUnits($units)
            ->setSequence($sequence);
    }
    /**
     * Get gatewayUuid value
     * @return string|null
     */
    public function getGatewayUuid()
    {
        return isset($this->gatewayUuid) ? $this->gatewayUuid : null;
    }
    /**
     * Set gatewayUuid value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @param string $gatewayUuid
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RemoveUnitsToGatewayReq
     */
    public function setGatewayUuid($gatewayUuid = null)
    {
        if (is_null($gatewayUuid) || (is_array($gatewayUuid) && empty($gatewayUuid))) {
            unset($this->gatewayUuid);
        } else {
            $this->gatewayUuid = $gatewayUuid;
        }
        return $this;
    }
    /**
     * Get domainName value
     * @return string|null
     */
    public function getDomainName()
    {
        return isset($this->domainName) ? $this->domainName : null;
    }
    /**
     * Set domainName value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @param string $domainName
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RemoveUnitsToGatewayReq
     */
    public function setDomainName($domainName = null)
    {
        if (is_null($domainName) || (is_array($domainName) && empty($domainName))) {
            unset($this->domainName);
        } else {
            $this->domainName = $domainName;
        }
        return $this;
    }
    /**
     * Get units value
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\Units|null
     */
    public function getUnits()
    {
        return $this->units;
    }
    /**
     * Set units value
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\Units $units
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RemoveUnitsToGatewayReq
     */
    public function setUnits(\\Losc\CucmBundle\Model\Webservice\StructType\Units $units = null)
    {
        $this->units = $units;
        return $this;
    }
    /**
     * Get sequence value
     * @return int|null
     */
    public function getSequence()
    {
        return $this->sequence;
    }
    /**
     * Set sequence value
     * @param int $sequence
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RemoveUnitsToGatewayReq
     */
    public function setSequence($sequence = null)
    {
        $this->sequence = $sequence;
        return $this;
    }
}
