<?php

namespace \Losc\CucmBundle\Model\Webservice\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RemoveRemoteClusterReq StructType
 * @subpackage Structs
 */
class RemoveRemoteClusterReq extends AbstractStructBase
{
    /**
     * The clusterId
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - choice: clusterId | uuid
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - maxLength: 255
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $clusterId;
    /**
     * The uuid
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - choice: clusterId | uuid
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - pattern: \{........-....-....-....-............\}
     * @var string
     */
    public $uuid;
    /**
     * The sequence
     * Meta information extracted from the WSDL
     * - use: optional
     * @var int
     */
    public $sequence;
    /**
     * Constructor method for RemoveRemoteClusterReq
     * @uses RemoveRemoteClusterReq::setClusterId()
     * @uses RemoveRemoteClusterReq::setUuid()
     * @uses RemoveRemoteClusterReq::setSequence()
     * @param string $clusterId
     * @param string $uuid
     * @param int $sequence
     */
    public function __construct($clusterId = null, $uuid = null, $sequence = null)
    {
        $this
            ->setClusterId($clusterId)
            ->setUuid($uuid)
            ->setSequence($sequence);
    }
    /**
     * Get clusterId value
     * @return string
     */
    public function getClusterId()
    {
        return isset($this->clusterId) ? $this->clusterId : null;
    }
    /**
     * Set clusterId value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @param string $clusterId
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RemoveRemoteClusterReq
     */
    public function setClusterId($clusterId = null)
    {
        if (is_null($clusterId) || (is_array($clusterId) && empty($clusterId))) {
            unset($this->clusterId);
        } else {
            $this->clusterId = $clusterId;
        }
        return $this;
    }
    /**
     * Get uuid value
     * @return string|null
     */
    public function getUuid()
    {
        return isset($this->uuid) ? $this->uuid : null;
    }
    /**
     * Set uuid value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @param string $uuid
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RemoveRemoteClusterReq
     */
    public function setUuid($uuid = null)
    {
        if (is_null($uuid) || (is_array($uuid) && empty($uuid))) {
            unset($this->uuid);
        } else {
            $this->uuid = $uuid;
        }
        return $this;
    }
    /**
     * Get sequence value
     * @return int|null
     */
    public function getSequence()
    {
        return $this->sequence;
    }
    /**
     * Set sequence value
     * @param int $sequence
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RemoveRemoteClusterReq
     */
    public function setSequence($sequence = null)
    {
        $this->sequence = $sequence;
        return $this;
    }
}
