<?php

namespace \Losc\CucmBundle\Model\Webservice\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RemoveLdapSyncCustomFieldReq StructType
 * @subpackage Structs
 */
class RemoveLdapSyncCustomFieldReq extends AbstractStructBase
{
    /**
     * The ldapConfigurationName
     * Meta information extracted from the WSDL
     * - choice: uuid | ldapConfigurationName | customUserField
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $ldapConfigurationName;
    /**
     * The customUserField
     * Meta information extracted from the WSDL
     * - choice: uuid | ldapConfigurationName | customUserField
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $customUserField;
    /**
     * The uuid
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - choice: uuid | ldapConfigurationName | customUserField
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - pattern: \{........-....-....-....-............\}
     * @var string
     */
    public $uuid;
    /**
     * The sequence
     * Meta information extracted from the WSDL
     * - use: optional
     * @var int
     */
    public $sequence;
    /**
     * Constructor method for RemoveLdapSyncCustomFieldReq
     * @uses RemoveLdapSyncCustomFieldReq::setLdapConfigurationName()
     * @uses RemoveLdapSyncCustomFieldReq::setCustomUserField()
     * @uses RemoveLdapSyncCustomFieldReq::setUuid()
     * @uses RemoveLdapSyncCustomFieldReq::setSequence()
     * @param string $ldapConfigurationName
     * @param string $customUserField
     * @param string $uuid
     * @param int $sequence
     */
    public function __construct($ldapConfigurationName = null, $customUserField = null, $uuid = null, $sequence = null)
    {
        $this
            ->setLdapConfigurationName($ldapConfigurationName)
            ->setCustomUserField($customUserField)
            ->setUuid($uuid)
            ->setSequence($sequence);
    }
    /**
     * Get ldapConfigurationName value
     * @return string
     */
    public function getLdapConfigurationName()
    {
        return isset($this->ldapConfigurationName) ? $this->ldapConfigurationName : null;
    }
    /**
     * Set ldapConfigurationName value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @param string $ldapConfigurationName
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RemoveLdapSyncCustomFieldReq
     */
    public function setLdapConfigurationName($ldapConfigurationName = null)
    {
        if (is_null($ldapConfigurationName) || (is_array($ldapConfigurationName) && empty($ldapConfigurationName))) {
            unset($this->ldapConfigurationName);
        } else {
            $this->ldapConfigurationName = $ldapConfigurationName;
        }
        return $this;
    }
    /**
     * Get customUserField value
     * @return string
     */
    public function getCustomUserField()
    {
        return isset($this->customUserField) ? $this->customUserField : null;
    }
    /**
     * Set customUserField value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @param string $customUserField
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RemoveLdapSyncCustomFieldReq
     */
    public function setCustomUserField($customUserField = null)
    {
        if (is_null($customUserField) || (is_array($customUserField) && empty($customUserField))) {
            unset($this->customUserField);
        } else {
            $this->customUserField = $customUserField;
        }
        return $this;
    }
    /**
     * Get uuid value
     * @return string|null
     */
    public function getUuid()
    {
        return isset($this->uuid) ? $this->uuid : null;
    }
    /**
     * Set uuid value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @param string $uuid
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RemoveLdapSyncCustomFieldReq
     */
    public function setUuid($uuid = null)
    {
        if (is_null($uuid) || (is_array($uuid) && empty($uuid))) {
            unset($this->uuid);
        } else {
            $this->uuid = $uuid;
        }
        return $this;
    }
    /**
     * Get sequence value
     * @return int|null
     */
    public function getSequence()
    {
        return $this->sequence;
    }
    /**
     * Set sequence value
     * @param int $sequence
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RemoveLdapSyncCustomFieldReq
     */
    public function setSequence($sequence = null)
    {
        $this->sequence = $sequence;
        return $this;
    }
}
