<?php

namespace \Losc\CucmBundle\Model\Webservice\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RemoveCcdHostedDNReq StructType
 * @subpackage Structs
 */
class RemoveCcdHostedDNReq extends AbstractStructBase
{
    /**
     * The hostedPattern
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - choice: hostedPattern | uuid
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - maxLength: 50
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $hostedPattern;
    /**
     * The uuid
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - choice: hostedPattern | uuid
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - pattern: \{........-....-....-....-............\}
     * @var string
     */
    public $uuid;
    /**
     * The sequence
     * Meta information extracted from the WSDL
     * - use: optional
     * @var int
     */
    public $sequence;
    /**
     * Constructor method for RemoveCcdHostedDNReq
     * @uses RemoveCcdHostedDNReq::setHostedPattern()
     * @uses RemoveCcdHostedDNReq::setUuid()
     * @uses RemoveCcdHostedDNReq::setSequence()
     * @param string $hostedPattern
     * @param string $uuid
     * @param int $sequence
     */
    public function __construct($hostedPattern = null, $uuid = null, $sequence = null)
    {
        $this
            ->setHostedPattern($hostedPattern)
            ->setUuid($uuid)
            ->setSequence($sequence);
    }
    /**
     * Get hostedPattern value
     * @return string
     */
    public function getHostedPattern()
    {
        return isset($this->hostedPattern) ? $this->hostedPattern : null;
    }
    /**
     * Set hostedPattern value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @param string $hostedPattern
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RemoveCcdHostedDNReq
     */
    public function setHostedPattern($hostedPattern = null)
    {
        if (is_null($hostedPattern) || (is_array($hostedPattern) && empty($hostedPattern))) {
            unset($this->hostedPattern);
        } else {
            $this->hostedPattern = $hostedPattern;
        }
        return $this;
    }
    /**
     * Get uuid value
     * @return string|null
     */
    public function getUuid()
    {
        return isset($this->uuid) ? $this->uuid : null;
    }
    /**
     * Set uuid value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @param string $uuid
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RemoveCcdHostedDNReq
     */
    public function setUuid($uuid = null)
    {
        if (is_null($uuid) || (is_array($uuid) && empty($uuid))) {
            unset($this->uuid);
        } else {
            $this->uuid = $uuid;
        }
        return $this;
    }
    /**
     * Get sequence value
     * @return int|null
     */
    public function getSequence()
    {
        return $this->sequence;
    }
    /**
     * Set sequence value
     * @param int $sequence
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RemoveCcdHostedDNReq
     */
    public function setSequence($sequence = null)
    {
        $this->sequence = $sequence;
        return $this;
    }
}
