<?php

namespace \Losc\CucmBundle\Model\Webservice\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RPhone StructType
 * @subpackage Structs
 */
class RPhone extends AbstractStructBase
{
    /**
     * The name
     * Meta information extracted from the WSDL
     * - documentation: The device name,using only URL-friendly characters
     * - base: xsd:string
     * - maxLength: 128
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $name;
    /**
     * The description
     * Meta information extracted from the WSDL
     * - documentation: Optional description of the device
     * - base: xsd:string
     * - maxLength: 128
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $description;
    /**
     * The product
     * Meta information extracted from the WSDL
     * - documentation: Product ID string. read-only except when creating a device.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $product;
    /**
     * The model
     * Meta information extracted from the WSDL
     * - documentation: Model ID string. Read Only
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $model;
    /**
     * The class
     * Meta information extracted from the WSDL
     * - documentation: Class ID string. Class information is read-only except when creating a device.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $class;
    /**
     * The protocol
     * Meta information extracted from the WSDL
     * - documentation: Protocol option is read-only,except when creating a device.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $protocol;
    /**
     * The protocolSide
     * Meta information extracted from the WSDL
     * - documentation: Side information is read-only except when creating a device
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $protocolSide;
    /**
     * The callingSearchSpaceName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $callingSearchSpaceName;
    /**
     * The devicePoolName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $devicePoolName;
    /**
     * The commonDeviceConfigName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $commonDeviceConfigName;
    /**
     * The commonPhoneConfigName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $commonPhoneConfigName;
    /**
     * The networkLocation
     * Meta information extracted from the WSDL
     * - documentation: The new Device Destination for Trunk to Trunk Transfer and Drop Conference Feature is required for most gateways ,except FXS gateways and phones.Not Nullable.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $networkLocation;
    /**
     * The locationName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $locationName;
    /**
     * The mediaResourceListName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $mediaResourceListName;
    /**
     * The networkHoldMohAudioSourceId
     * Meta information extracted from the WSDL
     * - documentation: This tag is not valid for H323Phone,H323trunk and SIPTrunk
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $networkHoldMohAudioSourceId;
    /**
     * The userHoldMohAudioSourceId
     * Meta information extracted from the WSDL
     * - documentation: This tag is not valid for H323Phone,H323trunk and SIPTrunk
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $userHoldMohAudioSourceId;
    /**
     * The automatedAlternateRoutingCssName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $automatedAlternateRoutingCssName;
    /**
     * The aarNeighborhoodName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $aarNeighborhoodName;
    /**
     * The loadInformation
     * Meta information extracted from the WSDL
     * - documentation: For devices with load information, if any special load information is specified the special attribute is set to TRUE.Otherwise,the load information is default for the product.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\XLoadInformation
     */
    public $loadInformation;
    /**
     * The vendorConfig
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\XVendorConfig
     */
    public $vendorConfig;
    /**
     * The versionStamp
     * Meta information extracted from the WSDL
     * - documentation: UUID changed each time device is updated
     * - base: xsd:string
     * - maxLength: 128
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $versionStamp;
    /**
     * The traceFlag
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $traceFlag;
    /**
     * The mlppDomainId
     * Meta information extracted from the WSDL
     * - documentation: This setting only effects devices that support MLPP. Use -1 to set to null
     * - base: xsd:string
     * - maxLength: 128
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $mlppDomainId;
    /**
     * The mlppIndicationStatus
     * Meta information extracted from the WSDL
     * - documentation: This setting only affects devices that support MLPP.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $mlppIndicationStatus;
    /**
     * The preemption
     * Meta information extracted from the WSDL
     * - documentation: This setting only affects devices that support MLPP.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $preemption;
    /**
     * The useTrustedRelayPoint
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $useTrustedRelayPoint;
    /**
     * The retryVideoCallAsAudio
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $retryVideoCallAsAudio;
    /**
     * The securityProfileName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $securityProfileName;
    /**
     * The sipProfileName
     * Meta information extracted from the WSDL
     * - documentation: This Tag is valid only for SIP Phones and SIP Trunks
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $sipProfileName;
    /**
     * The cgpnTransformationCssName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $cgpnTransformationCssName;
    /**
     * The useDevicePoolCgpnTransformCss
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $useDevicePoolCgpnTransformCss;
    /**
     * The geoLocationName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $geoLocationName;
    /**
     * The geoLocationFilterName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $geoLocationFilterName;
    /**
     * The sendGeoLocation
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $sendGeoLocation;
    /**
     * The lines
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\Lines
     */
    public $lines;
    /**
     * The numberOfButtons
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $numberOfButtons;
    /**
     * The phoneTemplateName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $phoneTemplateName;
    /**
     * The speeddials
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\Speeddials
     */
    public $speeddials;
    /**
     * The busyLampFields
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\BusyLampFields
     */
    public $busyLampFields;
    /**
     * The primaryPhoneName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $primaryPhoneName;
    /**
     * The ringSettingIdleBlfAudibleAlert
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ringSettingIdleBlfAudibleAlert;
    /**
     * The ringSettingBusyBlfAudibleAlert
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ringSettingBusyBlfAudibleAlert;
    /**
     * The blfDirectedCallParks
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\BlfDirectedCallParks
     */
    public $blfDirectedCallParks;
    /**
     * The addOnModules
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\AddOnModules
     */
    public $addOnModules;
    /**
     * The userLocale
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $userLocale;
    /**
     * The networkLocale
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $networkLocale;
    /**
     * The idleTimeout
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $idleTimeout;
    /**
     * The authenticationUrl
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $authenticationUrl;
    /**
     * The directoryUrl
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $directoryUrl;
    /**
     * The idleUrl
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $idleUrl;
    /**
     * The informationUrl
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $informationUrl;
    /**
     * The messagesUrl
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $messagesUrl;
    /**
     * The proxyServerUrl
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $proxyServerUrl;
    /**
     * The servicesUrl
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $servicesUrl;
    /**
     * The services
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\Services
     */
    public $services;
    /**
     * The softkeyTemplateName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $softkeyTemplateName;
    /**
     * The loginUserId
     * Meta information extracted from the WSDL
     * - documentation: Read-only for IP Phones.
     * - base: xsd:string
     * - maxLength: 255
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $loginUserId;
    /**
     * The defaultProfileName
     * Meta information extracted from the WSDL
     * - documentation: The name of the default profile for this device.Not Nullable.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $defaultProfileName;
    /**
     * The enableExtensionMobility
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $enableExtensionMobility;
    /**
     * The currentProfileName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $currentProfileName;
    /**
     * The loginTime
     * Meta information extracted from the WSDL
     * - documentation: Read-only
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $loginTime;
    /**
     * The loginDuration
     * Meta information extracted from the WSDL
     * - documentation: Read-only
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $loginDuration;
    /**
     * The currentConfig
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\CurrentConfig
     */
    public $currentConfig;
    /**
     * The singleButtonBarge
     * Meta information extracted from the WSDL
     * - documentation: This tag is valid only for devices that support SBB.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $singleButtonBarge;
    /**
     * The joinAcrossLines
     * Meta information extracted from the WSDL
     * - documentation: This tag is valid only for devices that support JAL..
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $joinAcrossLines;
    /**
     * The builtInBridgeStatus
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $builtInBridgeStatus;
    /**
     * The callInfoPrivacyStatus
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $callInfoPrivacyStatus;
    /**
     * The hlogStatus
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $hlogStatus;
    /**
     * The ownerUserName
     * Meta information extracted from the WSDL
     * - documentation: Read-only for IP Phones.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $ownerUserName;
    /**
     * The ignorePresentationIndicators
     * Meta information extracted from the WSDL
     * - documentation: The new Ignore Presentation Indicators flag for Hospitality feature is required for most phones andand device profiles. Not Nullable.
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $ignorePresentationIndicators;
    /**
     * The packetCaptureMode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $packetCaptureMode;
    /**
     * The packetCaptureDuration
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $packetCaptureDuration;
    /**
     * The subscribeCallingSearchSpaceName
     * Meta information extracted from the WSDL
     * - documentation: Support for this tag has been removed for IMS phones from 9.0
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $subscribeCallingSearchSpaceName;
    /**
     * The rerouteCallingSearchSpaceName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $rerouteCallingSearchSpaceName;
    /**
     * The allowCtiControlFlag
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $allowCtiControlFlag;
    /**
     * The presenceGroupName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $presenceGroupName;
    /**
     * The unattendedPort
     * Meta information extracted from the WSDL
     * - documentation: Applicable only for H323Phones and H323Trunks.Not for Gateways.
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $unattendedPort;
    /**
     * The requireDtmfReception
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $requireDtmfReception;
    /**
     * The rfc2833Disabled
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $rfc2833Disabled;
    /**
     * The certificateOperation
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $certificateOperation;
    /**
     * The authenticationMode
     * Meta information extracted from the WSDL
     * - documentation: authenticationMode can be updated only if certificateOperation field is Install/Upgrade,Delete or Troubleshoot.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $authenticationMode;
    /**
     * The keySize
     * Meta information extracted from the WSDL
     * - documentation: keySize can be updated only if certificateOperation field is Install/Upgrade,Delete or Troubleshoot.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $keySize;
    /**
     * The authenticationString
     * Meta information extracted from the WSDL
     * - documentation: authenticationString can be updated only if certificateOperation field is Install/Upgrade,Delete or Troubleshoot.
     * - base: xsd:string
     * - maxLength: 128
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $authenticationString;
    /**
     * The certificateStatus
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $certificateStatus;
    /**
     * The upgradeFinishTime
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $upgradeFinishTime;
    /**
     * The deviceMobilityMode
     * Meta information extracted from the WSDL
     * - documentation: Specifies if the phone is configured for device mobility or not.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $deviceMobilityMode;
    /**
     * The roamingDevicePoolName
     * Meta information extracted from the WSDL
     * - documentation: Read-only.Specifies the device pool being used if the device is roaming and the deviceMobility feature is enabled for it.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $roamingDevicePoolName;
    /**
     * The remoteDevice
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $remoteDevice;
    /**
     * The dndOption
     * Meta information extracted from the WSDL
     * - documentation: This tag is valid only for devices that support DND.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $dndOption;
    /**
     * The dndRingSetting
     * Meta information extracted from the WSDL
     * - documentation: This tag is valid only for devices that support DND.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $dndRingSetting;
    /**
     * The dndStatus
     * Meta information extracted from the WSDL
     * - documentation: This tag is valid only for devices that support DND.
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $dndStatus;
    /**
     * The isActive
     * Meta information extracted from the WSDL
     * - documentation: This tag determines if the newly added phone is active to determine consumption of license.If set to false the license units will not be consumed.
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $isActive;
    /**
     * The isDualMode
     * Meta information extracted from the WSDL
     * - documentation: Read-only tag.
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $isDualMode;
    /**
     * The mobilityUserIdName
     * Meta information extracted from the WSDL
     * - documentation: The userid of the mobility user for this phone.Nullable.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $mobilityUserIdName;
    /**
     * The phoneSuite
     * Meta information extracted from the WSDL
     * - documentation: If a blank tag is passed ,the value of the default is inserted into the database.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $phoneSuite;
    /**
     * The phoneServiceDisplay
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $phoneServiceDisplay;
    /**
     * The isProtected
     * Meta information extracted from the WSDL
     * - documentation: This tag is valid only for devices that support Secure Tone.
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $isProtected;
    /**
     * The mtpRequired
     * Meta information extracted from the WSDL
     * - documentation: This field is applicable only to SIP phones.
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $mtpRequired;
    /**
     * The mtpPreferedCodec
     * Meta information extracted from the WSDL
     * - documentation: This field is applicable only to SIP phones.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $mtpPreferedCodec;
    /**
     * The dialRulesName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $dialRulesName;
    /**
     * The sshUserId
     * Meta information extracted from the WSDL
     * - documentation: This tag is applicable only to thosedevices that support ssh feature.
     * - base: xsd:string
     * - maxLength: 50
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $sshUserId;
    /**
     * The sshPwd
     * Meta information extracted from the WSDL
     * - documentation: This tag is applicable only to thosedevices that support ssh feature.
     * - base: xsd:string
     * - maxLength: 255
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $sshPwd;
    /**
     * The digestUser
     * Meta information extracted from the WSDL
     * - documentation: This field is applicable only to SIP phones.
     * - base: xsd:string
     * - maxLength: 255
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $digestUser;
    /**
     * The outboundCallRollover
     * Meta information extracted from the WSDL
     * - documentation: This tag is valid only for devices that Automatic Outbound Callrollover
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $outboundCallRollover;
    /**
     * The hotlineDevice
     * Meta information extracted from the WSDL
     * - documentation: This tag is applicable for PLAR-supporting SIP/SCCP phones only
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $hotlineDevice;
    /**
     * The secureInformationUrl
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 255
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $secureInformationUrl;
    /**
     * The secureDirectoryUrl
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 255
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $secureDirectoryUrl;
    /**
     * The secureMessageUrl
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 255
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $secureMessageUrl;
    /**
     * The secureServicesUrl
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 255
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $secureServicesUrl;
    /**
     * The secureAuthenticationUrl
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 255
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $secureAuthenticationUrl;
    /**
     * The secureIdleUrl
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 255
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $secureIdleUrl;
    /**
     * The alwaysUsePrimeLine
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $alwaysUsePrimeLine;
    /**
     * The alwaysUsePrimeLineForVoiceMessage
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $alwaysUsePrimeLineForVoiceMessage;
    /**
     * The featureControlPolicy
     * Meta information extracted from the WSDL
     * - documentation: This tag is valid only for RT Phones.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $featureControlPolicy;
    /**
     * The deviceTrustMode
     * Meta information extracted from the WSDL
     * - documentation: This tag is valid only for TIP endpoints
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $deviceTrustMode;
    /**
     * The earlyOfferSupportForVoiceCall
     * Meta information extracted from the WSDL
     * - documentation: This field is applicable only for Third-party AS-SIP Endpoint.
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $earlyOfferSupportForVoiceCall;
    /**
     * The requireThirdPartyRegistration
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $requireThirdPartyRegistration;
    /**
     * The blockIncomingCallsWhenRoaming
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $blockIncomingCallsWhenRoaming;
    /**
     * The homeNetworkId
     * Meta information extracted from the WSDL
     * - documentation: This tag is only valid when value of blockIncomingCallsWhenRoaming is true
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $homeNetworkId;
    /**
     * The AllowPresentationSharingUsingBfcp
     * Meta information extracted from the WSDL
     * - documentation: This field is applicable only for Third-party AS-SIP Endpoint.
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $AllowPresentationSharingUsingBfcp;
    /**
     * The confidentialAccess
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\ConfidentialAccess
     */
    public $confidentialAccess;
    /**
     * The requireOffPremiseLocation
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $requireOffPremiseLocation;
    /**
     * The allowiXApplicableMedia
     * Meta information extracted from the WSDL
     * - documentation: This field is applicable only for Third-party AS-SIP Endpoint.
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $allowiXApplicableMedia;
    /**
     * The cgpnIngressDN
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $cgpnIngressDN;
    /**
     * The useDevicePoolCgpnIngressDN
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $useDevicePoolCgpnIngressDN;
    /**
     * The msisdn
     * Meta information extracted from the WSDL
     * - documentation: Mobile Subscriber ISDN
     * - base: xsd:string
     * - maxLength: 128
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $msisdn;
    /**
     * The enableCallRoutingToRdWhenNoneIsActive
     * Meta information extracted from the WSDL
     * - documentation: The new enableCallRoutingToRdWhenNoneIsActive flag for Remote Destination Call Forwarding feature is required for CTI Remote Device. Not Nullable.
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $enableCallRoutingToRdWhenNoneIsActive;
    /**
     * The wifiHotspotProfile
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $wifiHotspotProfile;
    /**
     * The wirelessLanProfileGroup
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $wirelessLanProfileGroup;
    /**
     * The ctiid
     * @var int
     */
    public $ctiid;
    /**
     * The uuid
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - pattern: \{........-....-....-....-............\}
     * @var string
     */
    public $uuid;
    /**
     * Constructor method for RPhone
     * @uses RPhone::setName()
     * @uses RPhone::setDescription()
     * @uses RPhone::setProduct()
     * @uses RPhone::setModel()
     * @uses RPhone::setClass()
     * @uses RPhone::setProtocol()
     * @uses RPhone::setProtocolSide()
     * @uses RPhone::setCallingSearchSpaceName()
     * @uses RPhone::setDevicePoolName()
     * @uses RPhone::setCommonDeviceConfigName()
     * @uses RPhone::setCommonPhoneConfigName()
     * @uses RPhone::setNetworkLocation()
     * @uses RPhone::setLocationName()
     * @uses RPhone::setMediaResourceListName()
     * @uses RPhone::setNetworkHoldMohAudioSourceId()
     * @uses RPhone::setUserHoldMohAudioSourceId()
     * @uses RPhone::setAutomatedAlternateRoutingCssName()
     * @uses RPhone::setAarNeighborhoodName()
     * @uses RPhone::setLoadInformation()
     * @uses RPhone::setVendorConfig()
     * @uses RPhone::setVersionStamp()
     * @uses RPhone::setTraceFlag()
     * @uses RPhone::setMlppDomainId()
     * @uses RPhone::setMlppIndicationStatus()
     * @uses RPhone::setPreemption()
     * @uses RPhone::setUseTrustedRelayPoint()
     * @uses RPhone::setRetryVideoCallAsAudio()
     * @uses RPhone::setSecurityProfileName()
     * @uses RPhone::setSipProfileName()
     * @uses RPhone::setCgpnTransformationCssName()
     * @uses RPhone::setUseDevicePoolCgpnTransformCss()
     * @uses RPhone::setGeoLocationName()
     * @uses RPhone::setGeoLocationFilterName()
     * @uses RPhone::setSendGeoLocation()
     * @uses RPhone::setLines()
     * @uses RPhone::setNumberOfButtons()
     * @uses RPhone::setPhoneTemplateName()
     * @uses RPhone::setSpeeddials()
     * @uses RPhone::setBusyLampFields()
     * @uses RPhone::setPrimaryPhoneName()
     * @uses RPhone::setRingSettingIdleBlfAudibleAlert()
     * @uses RPhone::setRingSettingBusyBlfAudibleAlert()
     * @uses RPhone::setBlfDirectedCallParks()
     * @uses RPhone::setAddOnModules()
     * @uses RPhone::setUserLocale()
     * @uses RPhone::setNetworkLocale()
     * @uses RPhone::setIdleTimeout()
     * @uses RPhone::setAuthenticationUrl()
     * @uses RPhone::setDirectoryUrl()
     * @uses RPhone::setIdleUrl()
     * @uses RPhone::setInformationUrl()
     * @uses RPhone::setMessagesUrl()
     * @uses RPhone::setProxyServerUrl()
     * @uses RPhone::setServicesUrl()
     * @uses RPhone::setServices()
     * @uses RPhone::setSoftkeyTemplateName()
     * @uses RPhone::setLoginUserId()
     * @uses RPhone::setDefaultProfileName()
     * @uses RPhone::setEnableExtensionMobility()
     * @uses RPhone::setCurrentProfileName()
     * @uses RPhone::setLoginTime()
     * @uses RPhone::setLoginDuration()
     * @uses RPhone::setCurrentConfig()
     * @uses RPhone::setSingleButtonBarge()
     * @uses RPhone::setJoinAcrossLines()
     * @uses RPhone::setBuiltInBridgeStatus()
     * @uses RPhone::setCallInfoPrivacyStatus()
     * @uses RPhone::setHlogStatus()
     * @uses RPhone::setOwnerUserName()
     * @uses RPhone::setIgnorePresentationIndicators()
     * @uses RPhone::setPacketCaptureMode()
     * @uses RPhone::setPacketCaptureDuration()
     * @uses RPhone::setSubscribeCallingSearchSpaceName()
     * @uses RPhone::setRerouteCallingSearchSpaceName()
     * @uses RPhone::setAllowCtiControlFlag()
     * @uses RPhone::setPresenceGroupName()
     * @uses RPhone::setUnattendedPort()
     * @uses RPhone::setRequireDtmfReception()
     * @uses RPhone::setRfc2833Disabled()
     * @uses RPhone::setCertificateOperation()
     * @uses RPhone::setAuthenticationMode()
     * @uses RPhone::setKeySize()
     * @uses RPhone::setAuthenticationString()
     * @uses RPhone::setCertificateStatus()
     * @uses RPhone::setUpgradeFinishTime()
     * @uses RPhone::setDeviceMobilityMode()
     * @uses RPhone::setRoamingDevicePoolName()
     * @uses RPhone::setRemoteDevice()
     * @uses RPhone::setDndOption()
     * @uses RPhone::setDndRingSetting()
     * @uses RPhone::setDndStatus()
     * @uses RPhone::setIsActive()
     * @uses RPhone::setIsDualMode()
     * @uses RPhone::setMobilityUserIdName()
     * @uses RPhone::setPhoneSuite()
     * @uses RPhone::setPhoneServiceDisplay()
     * @uses RPhone::setIsProtected()
     * @uses RPhone::setMtpRequired()
     * @uses RPhone::setMtpPreferedCodec()
     * @uses RPhone::setDialRulesName()
     * @uses RPhone::setSshUserId()
     * @uses RPhone::setSshPwd()
     * @uses RPhone::setDigestUser()
     * @uses RPhone::setOutboundCallRollover()
     * @uses RPhone::setHotlineDevice()
     * @uses RPhone::setSecureInformationUrl()
     * @uses RPhone::setSecureDirectoryUrl()
     * @uses RPhone::setSecureMessageUrl()
     * @uses RPhone::setSecureServicesUrl()
     * @uses RPhone::setSecureAuthenticationUrl()
     * @uses RPhone::setSecureIdleUrl()
     * @uses RPhone::setAlwaysUsePrimeLine()
     * @uses RPhone::setAlwaysUsePrimeLineForVoiceMessage()
     * @uses RPhone::setFeatureControlPolicy()
     * @uses RPhone::setDeviceTrustMode()
     * @uses RPhone::setEarlyOfferSupportForVoiceCall()
     * @uses RPhone::setRequireThirdPartyRegistration()
     * @uses RPhone::setBlockIncomingCallsWhenRoaming()
     * @uses RPhone::setHomeNetworkId()
     * @uses RPhone::setAllowPresentationSharingUsingBfcp()
     * @uses RPhone::setConfidentialAccess()
     * @uses RPhone::setRequireOffPremiseLocation()
     * @uses RPhone::setAllowiXApplicableMedia()
     * @uses RPhone::setCgpnIngressDN()
     * @uses RPhone::setUseDevicePoolCgpnIngressDN()
     * @uses RPhone::setMsisdn()
     * @uses RPhone::setEnableCallRoutingToRdWhenNoneIsActive()
     * @uses RPhone::setWifiHotspotProfile()
     * @uses RPhone::setWirelessLanProfileGroup()
     * @uses RPhone::setCtiid()
     * @uses RPhone::setUuid()
     * @param string $name
     * @param string $description
     * @param string $product
     * @param string $model
     * @param string $class
     * @param string $protocol
     * @param string $protocolSide
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $callingSearchSpaceName
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $devicePoolName
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $commonDeviceConfigName
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $commonPhoneConfigName
     * @param string $networkLocation
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $locationName
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $mediaResourceListName
     * @param string $networkHoldMohAudioSourceId
     * @param string $userHoldMohAudioSourceId
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $automatedAlternateRoutingCssName
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $aarNeighborhoodName
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XLoadInformation $loadInformation
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XVendorConfig $vendorConfig
     * @param string $versionStamp
     * @param string $traceFlag
     * @param string $mlppDomainId
     * @param string $mlppIndicationStatus
     * @param string $preemption
     * @param string $useTrustedRelayPoint
     * @param string $retryVideoCallAsAudio
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $securityProfileName
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $sipProfileName
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $cgpnTransformationCssName
     * @param string $useDevicePoolCgpnTransformCss
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $geoLocationName
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $geoLocationFilterName
     * @param string $sendGeoLocation
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\Lines $lines
     * @param string $numberOfButtons
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $phoneTemplateName
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\Speeddials $speeddials
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\BusyLampFields $busyLampFields
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $primaryPhoneName
     * @param string $ringSettingIdleBlfAudibleAlert
     * @param string $ringSettingBusyBlfAudibleAlert
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\BlfDirectedCallParks $blfDirectedCallParks
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\AddOnModules $addOnModules
     * @param string $userLocale
     * @param string $networkLocale
     * @param string $idleTimeout
     * @param string $authenticationUrl
     * @param string $directoryUrl
     * @param string $idleUrl
     * @param string $informationUrl
     * @param string $messagesUrl
     * @param string $proxyServerUrl
     * @param string $servicesUrl
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\Services $services
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $softkeyTemplateName
     * @param string $loginUserId
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $defaultProfileName
     * @param string $enableExtensionMobility
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $currentProfileName
     * @param string $loginTime
     * @param string $loginDuration
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\CurrentConfig $currentConfig
     * @param string $singleButtonBarge
     * @param string $joinAcrossLines
     * @param string $builtInBridgeStatus
     * @param string $callInfoPrivacyStatus
     * @param string $hlogStatus
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $ownerUserName
     * @param string $ignorePresentationIndicators
     * @param string $packetCaptureMode
     * @param string $packetCaptureDuration
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $subscribeCallingSearchSpaceName
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $rerouteCallingSearchSpaceName
     * @param string $allowCtiControlFlag
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $presenceGroupName
     * @param string $unattendedPort
     * @param string $requireDtmfReception
     * @param string $rfc2833Disabled
     * @param string $certificateOperation
     * @param string $authenticationMode
     * @param string $keySize
     * @param string $authenticationString
     * @param string $certificateStatus
     * @param string $upgradeFinishTime
     * @param string $deviceMobilityMode
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $roamingDevicePoolName
     * @param string $remoteDevice
     * @param string $dndOption
     * @param string $dndRingSetting
     * @param string $dndStatus
     * @param string $isActive
     * @param string $isDualMode
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $mobilityUserIdName
     * @param string $phoneSuite
     * @param string $phoneServiceDisplay
     * @param string $isProtected
     * @param string $mtpRequired
     * @param string $mtpPreferedCodec
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $dialRulesName
     * @param string $sshUserId
     * @param string $sshPwd
     * @param string $digestUser
     * @param string $outboundCallRollover
     * @param string $hotlineDevice
     * @param string $secureInformationUrl
     * @param string $secureDirectoryUrl
     * @param string $secureMessageUrl
     * @param string $secureServicesUrl
     * @param string $secureAuthenticationUrl
     * @param string $secureIdleUrl
     * @param string $alwaysUsePrimeLine
     * @param string $alwaysUsePrimeLineForVoiceMessage
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $featureControlPolicy
     * @param string $deviceTrustMode
     * @param string $earlyOfferSupportForVoiceCall
     * @param string $requireThirdPartyRegistration
     * @param string $blockIncomingCallsWhenRoaming
     * @param string $homeNetworkId
     * @param string $allowPresentationSharingUsingBfcp
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\ConfidentialAccess $confidentialAccess
     * @param string $requireOffPremiseLocation
     * @param string $allowiXApplicableMedia
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $cgpnIngressDN
     * @param string $useDevicePoolCgpnIngressDN
     * @param string $msisdn
     * @param string $enableCallRoutingToRdWhenNoneIsActive
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $wifiHotspotProfile
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $wirelessLanProfileGroup
     * @param int $ctiid
     * @param string $uuid
     */
    public function __construct($name = null, $description = null, $product = null, $model = null, $class = null, $protocol = null, $protocolSide = null, \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $callingSearchSpaceName = null, \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $devicePoolName = null, \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $commonDeviceConfigName = null, \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $commonPhoneConfigName = null, $networkLocation = null, \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $locationName = null, \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $mediaResourceListName = null, $networkHoldMohAudioSourceId = null, $userHoldMohAudioSourceId = null, \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $automatedAlternateRoutingCssName = null, \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $aarNeighborhoodName = null, \\Losc\CucmBundle\Model\Webservice\StructType\XLoadInformation $loadInformation = null, \\Losc\CucmBundle\Model\Webservice\StructType\XVendorConfig $vendorConfig = null, $versionStamp = null, $traceFlag = null, $mlppDomainId = null, $mlppIndicationStatus = null, $preemption = null, $useTrustedRelayPoint = null, $retryVideoCallAsAudio = null, \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $securityProfileName = null, \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $sipProfileName = null, \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $cgpnTransformationCssName = null, $useDevicePoolCgpnTransformCss = null, \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $geoLocationName = null, \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $geoLocationFilterName = null, $sendGeoLocation = null, \\Losc\CucmBundle\Model\Webservice\StructType\Lines $lines = null, $numberOfButtons = null, \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $phoneTemplateName = null, \\Losc\CucmBundle\Model\Webservice\StructType\Speeddials $speeddials = null, \\Losc\CucmBundle\Model\Webservice\StructType\BusyLampFields $busyLampFields = null, \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $primaryPhoneName = null, $ringSettingIdleBlfAudibleAlert = null, $ringSettingBusyBlfAudibleAlert = null, \\Losc\CucmBundle\Model\Webservice\StructType\BlfDirectedCallParks $blfDirectedCallParks = null, \\Losc\CucmBundle\Model\Webservice\StructType\AddOnModules $addOnModules = null, $userLocale = null, $networkLocale = null, $idleTimeout = null, $authenticationUrl = null, $directoryUrl = null, $idleUrl = null, $informationUrl = null, $messagesUrl = null, $proxyServerUrl = null, $servicesUrl = null, \\Losc\CucmBundle\Model\Webservice\StructType\Services $services = null, \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $softkeyTemplateName = null, $loginUserId = null, \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $defaultProfileName = null, $enableExtensionMobility = null, \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $currentProfileName = null, $loginTime = null, $loginDuration = null, \\Losc\CucmBundle\Model\Webservice\StructType\CurrentConfig $currentConfig = null, $singleButtonBarge = null, $joinAcrossLines = null, $builtInBridgeStatus = null, $callInfoPrivacyStatus = null, $hlogStatus = null, \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $ownerUserName = null, $ignorePresentationIndicators = null, $packetCaptureMode = null, $packetCaptureDuration = null, \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $subscribeCallingSearchSpaceName = null, \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $rerouteCallingSearchSpaceName = null, $allowCtiControlFlag = null, \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $presenceGroupName = null, $unattendedPort = null, $requireDtmfReception = null, $rfc2833Disabled = null, $certificateOperation = null, $authenticationMode = null, $keySize = null, $authenticationString = null, $certificateStatus = null, $upgradeFinishTime = null, $deviceMobilityMode = null, \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $roamingDevicePoolName = null, $remoteDevice = null, $dndOption = null, $dndRingSetting = null, $dndStatus = null, $isActive = null, $isDualMode = null, \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $mobilityUserIdName = null, $phoneSuite = null, $phoneServiceDisplay = null, $isProtected = null, $mtpRequired = null, $mtpPreferedCodec = null, \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $dialRulesName = null, $sshUserId = null, $sshPwd = null, $digestUser = null, $outboundCallRollover = null, $hotlineDevice = null, $secureInformationUrl = null, $secureDirectoryUrl = null, $secureMessageUrl = null, $secureServicesUrl = null, $secureAuthenticationUrl = null, $secureIdleUrl = null, $alwaysUsePrimeLine = null, $alwaysUsePrimeLineForVoiceMessage = null, \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $featureControlPolicy = null, $deviceTrustMode = null, $earlyOfferSupportForVoiceCall = null, $requireThirdPartyRegistration = null, $blockIncomingCallsWhenRoaming = null, $homeNetworkId = null, $allowPresentationSharingUsingBfcp = null, \\Losc\CucmBundle\Model\Webservice\StructType\ConfidentialAccess $confidentialAccess = null, $requireOffPremiseLocation = null, $allowiXApplicableMedia = null, \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $cgpnIngressDN = null, $useDevicePoolCgpnIngressDN = null, $msisdn = null, $enableCallRoutingToRdWhenNoneIsActive = null, \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $wifiHotspotProfile = null, \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $wirelessLanProfileGroup = null, $ctiid = null, $uuid = null)
    {
        $this
            ->setName($name)
            ->setDescription($description)
            ->setProduct($product)
            ->setModel($model)
            ->setClass($class)
            ->setProtocol($protocol)
            ->setProtocolSide($protocolSide)
            ->setCallingSearchSpaceName($callingSearchSpaceName)
            ->setDevicePoolName($devicePoolName)
            ->setCommonDeviceConfigName($commonDeviceConfigName)
            ->setCommonPhoneConfigName($commonPhoneConfigName)
            ->setNetworkLocation($networkLocation)
            ->setLocationName($locationName)
            ->setMediaResourceListName($mediaResourceListName)
            ->setNetworkHoldMohAudioSourceId($networkHoldMohAudioSourceId)
            ->setUserHoldMohAudioSourceId($userHoldMohAudioSourceId)
            ->setAutomatedAlternateRoutingCssName($automatedAlternateRoutingCssName)
            ->setAarNeighborhoodName($aarNeighborhoodName)
            ->setLoadInformation($loadInformation)
            ->setVendorConfig($vendorConfig)
            ->setVersionStamp($versionStamp)
            ->setTraceFlag($traceFlag)
            ->setMlppDomainId($mlppDomainId)
            ->setMlppIndicationStatus($mlppIndicationStatus)
            ->setPreemption($preemption)
            ->setUseTrustedRelayPoint($useTrustedRelayPoint)
            ->setRetryVideoCallAsAudio($retryVideoCallAsAudio)
            ->setSecurityProfileName($securityProfileName)
            ->setSipProfileName($sipProfileName)
            ->setCgpnTransformationCssName($cgpnTransformationCssName)
            ->setUseDevicePoolCgpnTransformCss($useDevicePoolCgpnTransformCss)
            ->setGeoLocationName($geoLocationName)
            ->setGeoLocationFilterName($geoLocationFilterName)
            ->setSendGeoLocation($sendGeoLocation)
            ->setLines($lines)
            ->setNumberOfButtons($numberOfButtons)
            ->setPhoneTemplateName($phoneTemplateName)
            ->setSpeeddials($speeddials)
            ->setBusyLampFields($busyLampFields)
            ->setPrimaryPhoneName($primaryPhoneName)
            ->setRingSettingIdleBlfAudibleAlert($ringSettingIdleBlfAudibleAlert)
            ->setRingSettingBusyBlfAudibleAlert($ringSettingBusyBlfAudibleAlert)
            ->setBlfDirectedCallParks($blfDirectedCallParks)
            ->setAddOnModules($addOnModules)
            ->setUserLocale($userLocale)
            ->setNetworkLocale($networkLocale)
            ->setIdleTimeout($idleTimeout)
            ->setAuthenticationUrl($authenticationUrl)
            ->setDirectoryUrl($directoryUrl)
            ->setIdleUrl($idleUrl)
            ->setInformationUrl($informationUrl)
            ->setMessagesUrl($messagesUrl)
            ->setProxyServerUrl($proxyServerUrl)
            ->setServicesUrl($servicesUrl)
            ->setServices($services)
            ->setSoftkeyTemplateName($softkeyTemplateName)
            ->setLoginUserId($loginUserId)
            ->setDefaultProfileName($defaultProfileName)
            ->setEnableExtensionMobility($enableExtensionMobility)
            ->setCurrentProfileName($currentProfileName)
            ->setLoginTime($loginTime)
            ->setLoginDuration($loginDuration)
            ->setCurrentConfig($currentConfig)
            ->setSingleButtonBarge($singleButtonBarge)
            ->setJoinAcrossLines($joinAcrossLines)
            ->setBuiltInBridgeStatus($builtInBridgeStatus)
            ->setCallInfoPrivacyStatus($callInfoPrivacyStatus)
            ->setHlogStatus($hlogStatus)
            ->setOwnerUserName($ownerUserName)
            ->setIgnorePresentationIndicators($ignorePresentationIndicators)
            ->setPacketCaptureMode($packetCaptureMode)
            ->setPacketCaptureDuration($packetCaptureDuration)
            ->setSubscribeCallingSearchSpaceName($subscribeCallingSearchSpaceName)
            ->setRerouteCallingSearchSpaceName($rerouteCallingSearchSpaceName)
            ->setAllowCtiControlFlag($allowCtiControlFlag)
            ->setPresenceGroupName($presenceGroupName)
            ->setUnattendedPort($unattendedPort)
            ->setRequireDtmfReception($requireDtmfReception)
            ->setRfc2833Disabled($rfc2833Disabled)
            ->setCertificateOperation($certificateOperation)
            ->setAuthenticationMode($authenticationMode)
            ->setKeySize($keySize)
            ->setAuthenticationString($authenticationString)
            ->setCertificateStatus($certificateStatus)
            ->setUpgradeFinishTime($upgradeFinishTime)
            ->setDeviceMobilityMode($deviceMobilityMode)
            ->setRoamingDevicePoolName($roamingDevicePoolName)
            ->setRemoteDevice($remoteDevice)
            ->setDndOption($dndOption)
            ->setDndRingSetting($dndRingSetting)
            ->setDndStatus($dndStatus)
            ->setIsActive($isActive)
            ->setIsDualMode($isDualMode)
            ->setMobilityUserIdName($mobilityUserIdName)
            ->setPhoneSuite($phoneSuite)
            ->setPhoneServiceDisplay($phoneServiceDisplay)
            ->setIsProtected($isProtected)
            ->setMtpRequired($mtpRequired)
            ->setMtpPreferedCodec($mtpPreferedCodec)
            ->setDialRulesName($dialRulesName)
            ->setSshUserId($sshUserId)
            ->setSshPwd($sshPwd)
            ->setDigestUser($digestUser)
            ->setOutboundCallRollover($outboundCallRollover)
            ->setHotlineDevice($hotlineDevice)
            ->setSecureInformationUrl($secureInformationUrl)
            ->setSecureDirectoryUrl($secureDirectoryUrl)
            ->setSecureMessageUrl($secureMessageUrl)
            ->setSecureServicesUrl($secureServicesUrl)
            ->setSecureAuthenticationUrl($secureAuthenticationUrl)
            ->setSecureIdleUrl($secureIdleUrl)
            ->setAlwaysUsePrimeLine($alwaysUsePrimeLine)
            ->setAlwaysUsePrimeLineForVoiceMessage($alwaysUsePrimeLineForVoiceMessage)
            ->setFeatureControlPolicy($featureControlPolicy)
            ->setDeviceTrustMode($deviceTrustMode)
            ->setEarlyOfferSupportForVoiceCall($earlyOfferSupportForVoiceCall)
            ->setRequireThirdPartyRegistration($requireThirdPartyRegistration)
            ->setBlockIncomingCallsWhenRoaming($blockIncomingCallsWhenRoaming)
            ->setHomeNetworkId($homeNetworkId)
            ->setAllowPresentationSharingUsingBfcp($allowPresentationSharingUsingBfcp)
            ->setConfidentialAccess($confidentialAccess)
            ->setRequireOffPremiseLocation($requireOffPremiseLocation)
            ->setAllowiXApplicableMedia($allowiXApplicableMedia)
            ->setCgpnIngressDN($cgpnIngressDN)
            ->setUseDevicePoolCgpnIngressDN($useDevicePoolCgpnIngressDN)
            ->setMsisdn($msisdn)
            ->setEnableCallRoutingToRdWhenNoneIsActive($enableCallRoutingToRdWhenNoneIsActive)
            ->setWifiHotspotProfile($wifiHotspotProfile)
            ->setWirelessLanProfileGroup($wirelessLanProfileGroup)
            ->setCtiid($ctiid)
            ->setUuid($uuid);
    }
    /**
     * Get name value
     * @return string|null
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Set name value
     * @param string $name
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RPhone
     */
    public function setName($name = null)
    {
        $this->name = $name;
        return $this;
    }
    /**
     * Get description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->description;
    }
    /**
     * Set description value
     * @param string $description
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RPhone
     */
    public function setDescription($description = null)
    {
        $this->description = $description;
        return $this;
    }
    /**
     * Get product value
     * @return string|null
     */
    public function getProduct()
    {
        return $this->product;
    }
    /**
     * Set product value
     * @param string $product
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RPhone
     */
    public function setProduct($product = null)
    {
        $this->product = $product;
        return $this;
    }
    /**
     * Get model value
     * @return string|null
     */
    public function getModel()
    {
        return $this->model;
    }
    /**
     * Set model value
     * @param string $model
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RPhone
     */
    public function setModel($model = null)
    {
        $this->model = $model;
        return $this;
    }
    /**
     * Get class value
     * @return string|null
     */
    public function getClass()
    {
        return $this->class;
    }
    /**
     * Set class value
     * @param string $class
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RPhone
     */
    public function setClass($class = null)
    {
        $this->class = $class;
        return $this;
    }
    /**
     * Get protocol value
     * @return string|null
     */
    public function getProtocol()
    {
        return $this->protocol;
    }
    /**
     * Set protocol value
     * @param string $protocol
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RPhone
     */
    public function setProtocol($protocol = null)
    {
        $this->protocol = $protocol;
        return $this;
    }
    /**
     * Get protocolSide value
     * @return string|null
     */
    public function getProtocolSide()
    {
        return $this->protocolSide;
    }
    /**
     * Set protocolSide value
     * @param string $protocolSide
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RPhone
     */
    public function setProtocolSide($protocolSide = null)
    {
        $this->protocolSide = $protocolSide;
        return $this;
    }
    /**
     * Get callingSearchSpaceName value
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XFkType|null
     */
    public function getCallingSearchSpaceName()
    {
        return $this->callingSearchSpaceName;
    }
    /**
     * Set callingSearchSpaceName value
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $callingSearchSpaceName
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RPhone
     */
    public function setCallingSearchSpaceName(\\Losc\CucmBundle\Model\Webservice\StructType\XFkType $callingSearchSpaceName = null)
    {
        $this->callingSearchSpaceName = $callingSearchSpaceName;
        return $this;
    }
    /**
     * Get devicePoolName value
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XFkType|null
     */
    public function getDevicePoolName()
    {
        return $this->devicePoolName;
    }
    /**
     * Set devicePoolName value
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $devicePoolName
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RPhone
     */
    public function setDevicePoolName(\\Losc\CucmBundle\Model\Webservice\StructType\XFkType $devicePoolName = null)
    {
        $this->devicePoolName = $devicePoolName;
        return $this;
    }
    /**
     * Get commonDeviceConfigName value
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XFkType|null
     */
    public function getCommonDeviceConfigName()
    {
        return $this->commonDeviceConfigName;
    }
    /**
     * Set commonDeviceConfigName value
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $commonDeviceConfigName
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RPhone
     */
    public function setCommonDeviceConfigName(\\Losc\CucmBundle\Model\Webservice\StructType\XFkType $commonDeviceConfigName = null)
    {
        $this->commonDeviceConfigName = $commonDeviceConfigName;
        return $this;
    }
    /**
     * Get commonPhoneConfigName value
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XFkType|null
     */
    public function getCommonPhoneConfigName()
    {
        return $this->commonPhoneConfigName;
    }
    /**
     * Set commonPhoneConfigName value
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $commonPhoneConfigName
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RPhone
     */
    public function setCommonPhoneConfigName(\\Losc\CucmBundle\Model\Webservice\StructType\XFkType $commonPhoneConfigName = null)
    {
        $this->commonPhoneConfigName = $commonPhoneConfigName;
        return $this;
    }
    /**
     * Get networkLocation value
     * @return string|null
     */
    public function getNetworkLocation()
    {
        return $this->networkLocation;
    }
    /**
     * Set networkLocation value
     * @param string $networkLocation
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RPhone
     */
    public function setNetworkLocation($networkLocation = null)
    {
        $this->networkLocation = $networkLocation;
        return $this;
    }
    /**
     * Get locationName value
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XFkType|null
     */
    public function getLocationName()
    {
        return $this->locationName;
    }
    /**
     * Set locationName value
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $locationName
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RPhone
     */
    public function setLocationName(\\Losc\CucmBundle\Model\Webservice\StructType\XFkType $locationName = null)
    {
        $this->locationName = $locationName;
        return $this;
    }
    /**
     * Get mediaResourceListName value
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XFkType|null
     */
    public function getMediaResourceListName()
    {
        return $this->mediaResourceListName;
    }
    /**
     * Set mediaResourceListName value
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $mediaResourceListName
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RPhone
     */
    public function setMediaResourceListName(\\Losc\CucmBundle\Model\Webservice\StructType\XFkType $mediaResourceListName = null)
    {
        $this->mediaResourceListName = $mediaResourceListName;
        return $this;
    }
    /**
     * Get networkHoldMohAudioSourceId value
     * @return string|null
     */
    public function getNetworkHoldMohAudioSourceId()
    {
        return $this->networkHoldMohAudioSourceId;
    }
    /**
     * Set networkHoldMohAudioSourceId value
     * @param string $networkHoldMohAudioSourceId
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RPhone
     */
    public function setNetworkHoldMohAudioSourceId($networkHoldMohAudioSourceId = null)
    {
        $this->networkHoldMohAudioSourceId = $networkHoldMohAudioSourceId;
        return $this;
    }
    /**
     * Get userHoldMohAudioSourceId value
     * @return string|null
     */
    public function getUserHoldMohAudioSourceId()
    {
        return $this->userHoldMohAudioSourceId;
    }
    /**
     * Set userHoldMohAudioSourceId value
     * @param string $userHoldMohAudioSourceId
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RPhone
     */
    public function setUserHoldMohAudioSourceId($userHoldMohAudioSourceId = null)
    {
        $this->userHoldMohAudioSourceId = $userHoldMohAudioSourceId;
        return $this;
    }
    /**
     * Get automatedAlternateRoutingCssName value
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XFkType|null
     */
    public function getAutomatedAlternateRoutingCssName()
    {
        return $this->automatedAlternateRoutingCssName;
    }
    /**
     * Set automatedAlternateRoutingCssName value
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $automatedAlternateRoutingCssName
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RPhone
     */
    public function setAutomatedAlternateRoutingCssName(\\Losc\CucmBundle\Model\Webservice\StructType\XFkType $automatedAlternateRoutingCssName = null)
    {
        $this->automatedAlternateRoutingCssName = $automatedAlternateRoutingCssName;
        return $this;
    }
    /**
     * Get aarNeighborhoodName value
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XFkType|null
     */
    public function getAarNeighborhoodName()
    {
        return $this->aarNeighborhoodName;
    }
    /**
     * Set aarNeighborhoodName value
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $aarNeighborhoodName
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RPhone
     */
    public function setAarNeighborhoodName(\\Losc\CucmBundle\Model\Webservice\StructType\XFkType $aarNeighborhoodName = null)
    {
        $this->aarNeighborhoodName = $aarNeighborhoodName;
        return $this;
    }
    /**
     * Get loadInformation value
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XLoadInformation|null
     */
    public function getLoadInformation()
    {
        return $this->loadInformation;
    }
    /**
     * Set loadInformation value
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XLoadInformation $loadInformation
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RPhone
     */
    public function setLoadInformation(\\Losc\CucmBundle\Model\Webservice\StructType\XLoadInformation $loadInformation = null)
    {
        $this->loadInformation = $loadInformation;
        return $this;
    }
    /**
     * Get vendorConfig value
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XVendorConfig|null
     */
    public function getVendorConfig()
    {
        return $this->vendorConfig;
    }
    /**
     * Set vendorConfig value
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XVendorConfig $vendorConfig
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RPhone
     */
    public function setVendorConfig(\\Losc\CucmBundle\Model\Webservice\StructType\XVendorConfig $vendorConfig = null)
    {
        $this->vendorConfig = $vendorConfig;
        return $this;
    }
    /**
     * Get versionStamp value
     * @return string|null
     */
    public function getVersionStamp()
    {
        return $this->versionStamp;
    }
    /**
     * Set versionStamp value
     * @param string $versionStamp
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RPhone
     */
    public function setVersionStamp($versionStamp = null)
    {
        $this->versionStamp = $versionStamp;
        return $this;
    }
    /**
     * Get traceFlag value
     * @return string|null
     */
    public function getTraceFlag()
    {
        return $this->traceFlag;
    }
    /**
     * Set traceFlag value
     * @param string $traceFlag
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RPhone
     */
    public function setTraceFlag($traceFlag = null)
    {
        $this->traceFlag = $traceFlag;
        return $this;
    }
    /**
     * Get mlppDomainId value
     * @return string|null
     */
    public function getMlppDomainId()
    {
        return $this->mlppDomainId;
    }
    /**
     * Set mlppDomainId value
     * @param string $mlppDomainId
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RPhone
     */
    public function setMlppDomainId($mlppDomainId = null)
    {
        $this->mlppDomainId = $mlppDomainId;
        return $this;
    }
    /**
     * Get mlppIndicationStatus value
     * @return string|null
     */
    public function getMlppIndicationStatus()
    {
        return $this->mlppIndicationStatus;
    }
    /**
     * Set mlppIndicationStatus value
     * @param string $mlppIndicationStatus
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RPhone
     */
    public function setMlppIndicationStatus($mlppIndicationStatus = null)
    {
        $this->mlppIndicationStatus = $mlppIndicationStatus;
        return $this;
    }
    /**
     * Get preemption value
     * @return string|null
     */
    public function getPreemption()
    {
        return $this->preemption;
    }
    /**
     * Set preemption value
     * @param string $preemption
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RPhone
     */
    public function setPreemption($preemption = null)
    {
        $this->preemption = $preemption;
        return $this;
    }
    /**
     * Get useTrustedRelayPoint value
     * @return string|null
     */
    public function getUseTrustedRelayPoint()
    {
        return $this->useTrustedRelayPoint;
    }
    /**
     * Set useTrustedRelayPoint value
     * @param string $useTrustedRelayPoint
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RPhone
     */
    public function setUseTrustedRelayPoint($useTrustedRelayPoint = null)
    {
        $this->useTrustedRelayPoint = $useTrustedRelayPoint;
        return $this;
    }
    /**
     * Get retryVideoCallAsAudio value
     * @return string|null
     */
    public function getRetryVideoCallAsAudio()
    {
        return $this->retryVideoCallAsAudio;
    }
    /**
     * Set retryVideoCallAsAudio value
     * @param string $retryVideoCallAsAudio
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RPhone
     */
    public function setRetryVideoCallAsAudio($retryVideoCallAsAudio = null)
    {
        $this->retryVideoCallAsAudio = $retryVideoCallAsAudio;
        return $this;
    }
    /**
     * Get securityProfileName value
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XFkType|null
     */
    public function getSecurityProfileName()
    {
        return $this->securityProfileName;
    }
    /**
     * Set securityProfileName value
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $securityProfileName
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RPhone
     */
    public function setSecurityProfileName(\\Losc\CucmBundle\Model\Webservice\StructType\XFkType $securityProfileName = null)
    {
        $this->securityProfileName = $securityProfileName;
        return $this;
    }
    /**
     * Get sipProfileName value
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XFkType|null
     */
    public function getSipProfileName()
    {
        return $this->sipProfileName;
    }
    /**
     * Set sipProfileName value
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $sipProfileName
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RPhone
     */
    public function setSipProfileName(\\Losc\CucmBundle\Model\Webservice\StructType\XFkType $sipProfileName = null)
    {
        $this->sipProfileName = $sipProfileName;
        return $this;
    }
    /**
     * Get cgpnTransformationCssName value
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XFkType|null
     */
    public function getCgpnTransformationCssName()
    {
        return $this->cgpnTransformationCssName;
    }
    /**
     * Set cgpnTransformationCssName value
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $cgpnTransformationCssName
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RPhone
     */
    public function setCgpnTransformationCssName(\\Losc\CucmBundle\Model\Webservice\StructType\XFkType $cgpnTransformationCssName = null)
    {
        $this->cgpnTransformationCssName = $cgpnTransformationCssName;
        return $this;
    }
    /**
     * Get useDevicePoolCgpnTransformCss value
     * @return string|null
     */
    public function getUseDevicePoolCgpnTransformCss()
    {
        return $this->useDevicePoolCgpnTransformCss;
    }
    /**
     * Set useDevicePoolCgpnTransformCss value
     * @param string $useDevicePoolCgpnTransformCss
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RPhone
     */
    public function setUseDevicePoolCgpnTransformCss($useDevicePoolCgpnTransformCss = null)
    {
        $this->useDevicePoolCgpnTransformCss = $useDevicePoolCgpnTransformCss;
        return $this;
    }
    /**
     * Get geoLocationName value
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XFkType|null
     */
    public function getGeoLocationName()
    {
        return $this->geoLocationName;
    }
    /**
     * Set geoLocationName value
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $geoLocationName
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RPhone
     */
    public function setGeoLocationName(\\Losc\CucmBundle\Model\Webservice\StructType\XFkType $geoLocationName = null)
    {
        $this->geoLocationName = $geoLocationName;
        return $this;
    }
    /**
     * Get geoLocationFilterName value
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XFkType|null
     */
    public function getGeoLocationFilterName()
    {
        return $this->geoLocationFilterName;
    }
    /**
     * Set geoLocationFilterName value
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $geoLocationFilterName
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RPhone
     */
    public function setGeoLocationFilterName(\\Losc\CucmBundle\Model\Webservice\StructType\XFkType $geoLocationFilterName = null)
    {
        $this->geoLocationFilterName = $geoLocationFilterName;
        return $this;
    }
    /**
     * Get sendGeoLocation value
     * @return string|null
     */
    public function getSendGeoLocation()
    {
        return $this->sendGeoLocation;
    }
    /**
     * Set sendGeoLocation value
     * @param string $sendGeoLocation
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RPhone
     */
    public function setSendGeoLocation($sendGeoLocation = null)
    {
        $this->sendGeoLocation = $sendGeoLocation;
        return $this;
    }
    /**
     * Get lines value
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\Lines|null
     */
    public function getLines()
    {
        return $this->lines;
    }
    /**
     * Set lines value
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\Lines $lines
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RPhone
     */
    public function setLines(\\Losc\CucmBundle\Model\Webservice\StructType\Lines $lines = null)
    {
        $this->lines = $lines;
        return $this;
    }
    /**
     * Get numberOfButtons value
     * @return string|null
     */
    public function getNumberOfButtons()
    {
        return $this->numberOfButtons;
    }
    /**
     * Set numberOfButtons value
     * @param string $numberOfButtons
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RPhone
     */
    public function setNumberOfButtons($numberOfButtons = null)
    {
        $this->numberOfButtons = $numberOfButtons;
        return $this;
    }
    /**
     * Get phoneTemplateName value
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XFkType|null
     */
    public function getPhoneTemplateName()
    {
        return $this->phoneTemplateName;
    }
    /**
     * Set phoneTemplateName value
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $phoneTemplateName
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RPhone
     */
    public function setPhoneTemplateName(\\Losc\CucmBundle\Model\Webservice\StructType\XFkType $phoneTemplateName = null)
    {
        $this->phoneTemplateName = $phoneTemplateName;
        return $this;
    }
    /**
     * Get speeddials value
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\Speeddials|null
     */
    public function getSpeeddials()
    {
        return $this->speeddials;
    }
    /**
     * Set speeddials value
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\Speeddials $speeddials
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RPhone
     */
    public function setSpeeddials(\\Losc\CucmBundle\Model\Webservice\StructType\Speeddials $speeddials = null)
    {
        $this->speeddials = $speeddials;
        return $this;
    }
    /**
     * Get busyLampFields value
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\BusyLampFields|null
     */
    public function getBusyLampFields()
    {
        return $this->busyLampFields;
    }
    /**
     * Set busyLampFields value
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\BusyLampFields $busyLampFields
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RPhone
     */
    public function setBusyLampFields(\\Losc\CucmBundle\Model\Webservice\StructType\BusyLampFields $busyLampFields = null)
    {
        $this->busyLampFields = $busyLampFields;
        return $this;
    }
    /**
     * Get primaryPhoneName value
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XFkType|null
     */
    public function getPrimaryPhoneName()
    {
        return $this->primaryPhoneName;
    }
    /**
     * Set primaryPhoneName value
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $primaryPhoneName
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RPhone
     */
    public function setPrimaryPhoneName(\\Losc\CucmBundle\Model\Webservice\StructType\XFkType $primaryPhoneName = null)
    {
        $this->primaryPhoneName = $primaryPhoneName;
        return $this;
    }
    /**
     * Get ringSettingIdleBlfAudibleAlert value
     * @return string|null
     */
    public function getRingSettingIdleBlfAudibleAlert()
    {
        return $this->ringSettingIdleBlfAudibleAlert;
    }
    /**
     * Set ringSettingIdleBlfAudibleAlert value
     * @param string $ringSettingIdleBlfAudibleAlert
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RPhone
     */
    public function setRingSettingIdleBlfAudibleAlert($ringSettingIdleBlfAudibleAlert = null)
    {
        $this->ringSettingIdleBlfAudibleAlert = $ringSettingIdleBlfAudibleAlert;
        return $this;
    }
    /**
     * Get ringSettingBusyBlfAudibleAlert value
     * @return string|null
     */
    public function getRingSettingBusyBlfAudibleAlert()
    {
        return $this->ringSettingBusyBlfAudibleAlert;
    }
    /**
     * Set ringSettingBusyBlfAudibleAlert value
     * @param string $ringSettingBusyBlfAudibleAlert
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RPhone
     */
    public function setRingSettingBusyBlfAudibleAlert($ringSettingBusyBlfAudibleAlert = null)
    {
        $this->ringSettingBusyBlfAudibleAlert = $ringSettingBusyBlfAudibleAlert;
        return $this;
    }
    /**
     * Get blfDirectedCallParks value
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\BlfDirectedCallParks|null
     */
    public function getBlfDirectedCallParks()
    {
        return $this->blfDirectedCallParks;
    }
    /**
     * Set blfDirectedCallParks value
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\BlfDirectedCallParks $blfDirectedCallParks
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RPhone
     */
    public function setBlfDirectedCallParks(\\Losc\CucmBundle\Model\Webservice\StructType\BlfDirectedCallParks $blfDirectedCallParks = null)
    {
        $this->blfDirectedCallParks = $blfDirectedCallParks;
        return $this;
    }
    /**
     * Get addOnModules value
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\AddOnModules|null
     */
    public function getAddOnModules()
    {
        return $this->addOnModules;
    }
    /**
     * Set addOnModules value
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\AddOnModules $addOnModules
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RPhone
     */
    public function setAddOnModules(\\Losc\CucmBundle\Model\Webservice\StructType\AddOnModules $addOnModules = null)
    {
        $this->addOnModules = $addOnModules;
        return $this;
    }
    /**
     * Get userLocale value
     * @return string|null
     */
    public function getUserLocale()
    {
        return $this->userLocale;
    }
    /**
     * Set userLocale value
     * @param string $userLocale
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RPhone
     */
    public function setUserLocale($userLocale = null)
    {
        $this->userLocale = $userLocale;
        return $this;
    }
    /**
     * Get networkLocale value
     * @return string|null
     */
    public function getNetworkLocale()
    {
        return $this->networkLocale;
    }
    /**
     * Set networkLocale value
     * @param string $networkLocale
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RPhone
     */
    public function setNetworkLocale($networkLocale = null)
    {
        $this->networkLocale = $networkLocale;
        return $this;
    }
    /**
     * Get idleTimeout value
     * @return string|null
     */
    public function getIdleTimeout()
    {
        return $this->idleTimeout;
    }
    /**
     * Set idleTimeout value
     * @param string $idleTimeout
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RPhone
     */
    public function setIdleTimeout($idleTimeout = null)
    {
        $this->idleTimeout = $idleTimeout;
        return $this;
    }
    /**
     * Get authenticationUrl value
     * @return string|null
     */
    public function getAuthenticationUrl()
    {
        return $this->authenticationUrl;
    }
    /**
     * Set authenticationUrl value
     * @param string $authenticationUrl
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RPhone
     */
    public function setAuthenticationUrl($authenticationUrl = null)
    {
        $this->authenticationUrl = $authenticationUrl;
        return $this;
    }
    /**
     * Get directoryUrl value
     * @return string|null
     */
    public function getDirectoryUrl()
    {
        return $this->directoryUrl;
    }
    /**
     * Set directoryUrl value
     * @param string $directoryUrl
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RPhone
     */
    public function setDirectoryUrl($directoryUrl = null)
    {
        $this->directoryUrl = $directoryUrl;
        return $this;
    }
    /**
     * Get idleUrl value
     * @return string|null
     */
    public function getIdleUrl()
    {
        return $this->idleUrl;
    }
    /**
     * Set idleUrl value
     * @param string $idleUrl
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RPhone
     */
    public function setIdleUrl($idleUrl = null)
    {
        $this->idleUrl = $idleUrl;
        return $this;
    }
    /**
     * Get informationUrl value
     * @return string|null
     */
    public function getInformationUrl()
    {
        return $this->informationUrl;
    }
    /**
     * Set informationUrl value
     * @param string $informationUrl
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RPhone
     */
    public function setInformationUrl($informationUrl = null)
    {
        $this->informationUrl = $informationUrl;
        return $this;
    }
    /**
     * Get messagesUrl value
     * @return string|null
     */
    public function getMessagesUrl()
    {
        return $this->messagesUrl;
    }
    /**
     * Set messagesUrl value
     * @param string $messagesUrl
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RPhone
     */
    public function setMessagesUrl($messagesUrl = null)
    {
        $this->messagesUrl = $messagesUrl;
        return $this;
    }
    /**
     * Get proxyServerUrl value
     * @return string|null
     */
    public function getProxyServerUrl()
    {
        return $this->proxyServerUrl;
    }
    /**
     * Set proxyServerUrl value
     * @param string $proxyServerUrl
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RPhone
     */
    public function setProxyServerUrl($proxyServerUrl = null)
    {
        $this->proxyServerUrl = $proxyServerUrl;
        return $this;
    }
    /**
     * Get servicesUrl value
     * @return string|null
     */
    public function getServicesUrl()
    {
        return $this->servicesUrl;
    }
    /**
     * Set servicesUrl value
     * @param string $servicesUrl
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RPhone
     */
    public function setServicesUrl($servicesUrl = null)
    {
        $this->servicesUrl = $servicesUrl;
        return $this;
    }
    /**
     * Get services value
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\Services|null
     */
    public function getServices()
    {
        return $this->services;
    }
    /**
     * Set services value
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\Services $services
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RPhone
     */
    public function setServices(\\Losc\CucmBundle\Model\Webservice\StructType\Services $services = null)
    {
        $this->services = $services;
        return $this;
    }
    /**
     * Get softkeyTemplateName value
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XFkType|null
     */
    public function getSoftkeyTemplateName()
    {
        return $this->softkeyTemplateName;
    }
    /**
     * Set softkeyTemplateName value
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $softkeyTemplateName
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RPhone
     */
    public function setSoftkeyTemplateName(\\Losc\CucmBundle\Model\Webservice\StructType\XFkType $softkeyTemplateName = null)
    {
        $this->softkeyTemplateName = $softkeyTemplateName;
        return $this;
    }
    /**
     * Get loginUserId value
     * @return string|null
     */
    public function getLoginUserId()
    {
        return $this->loginUserId;
    }
    /**
     * Set loginUserId value
     * @param string $loginUserId
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RPhone
     */
    public function setLoginUserId($loginUserId = null)
    {
        $this->loginUserId = $loginUserId;
        return $this;
    }
    /**
     * Get defaultProfileName value
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XFkType|null
     */
    public function getDefaultProfileName()
    {
        return $this->defaultProfileName;
    }
    /**
     * Set defaultProfileName value
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $defaultProfileName
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RPhone
     */
    public function setDefaultProfileName(\\Losc\CucmBundle\Model\Webservice\StructType\XFkType $defaultProfileName = null)
    {
        $this->defaultProfileName = $defaultProfileName;
        return $this;
    }
    /**
     * Get enableExtensionMobility value
     * @return string|null
     */
    public function getEnableExtensionMobility()
    {
        return $this->enableExtensionMobility;
    }
    /**
     * Set enableExtensionMobility value
     * @param string $enableExtensionMobility
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RPhone
     */
    public function setEnableExtensionMobility($enableExtensionMobility = null)
    {
        $this->enableExtensionMobility = $enableExtensionMobility;
        return $this;
    }
    /**
     * Get currentProfileName value
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XFkType|null
     */
    public function getCurrentProfileName()
    {
        return $this->currentProfileName;
    }
    /**
     * Set currentProfileName value
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $currentProfileName
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RPhone
     */
    public function setCurrentProfileName(\\Losc\CucmBundle\Model\Webservice\StructType\XFkType $currentProfileName = null)
    {
        $this->currentProfileName = $currentProfileName;
        return $this;
    }
    /**
     * Get loginTime value
     * @return string|null
     */
    public function getLoginTime()
    {
        return $this->loginTime;
    }
    /**
     * Set loginTime value
     * @param string $loginTime
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RPhone
     */
    public function setLoginTime($loginTime = null)
    {
        $this->loginTime = $loginTime;
        return $this;
    }
    /**
     * Get loginDuration value
     * @return string|null
     */
    public function getLoginDuration()
    {
        return $this->loginDuration;
    }
    /**
     * Set loginDuration value
     * @param string $loginDuration
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RPhone
     */
    public function setLoginDuration($loginDuration = null)
    {
        $this->loginDuration = $loginDuration;
        return $this;
    }
    /**
     * Get currentConfig value
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\CurrentConfig|null
     */
    public function getCurrentConfig()
    {
        return $this->currentConfig;
    }
    /**
     * Set currentConfig value
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\CurrentConfig $currentConfig
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RPhone
     */
    public function setCurrentConfig(\\Losc\CucmBundle\Model\Webservice\StructType\CurrentConfig $currentConfig = null)
    {
        $this->currentConfig = $currentConfig;
        return $this;
    }
    /**
     * Get singleButtonBarge value
     * @return string|null
     */
    public function getSingleButtonBarge()
    {
        return $this->singleButtonBarge;
    }
    /**
     * Set singleButtonBarge value
     * @param string $singleButtonBarge
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RPhone
     */
    public function setSingleButtonBarge($singleButtonBarge = null)
    {
        $this->singleButtonBarge = $singleButtonBarge;
        return $this;
    }
    /**
     * Get joinAcrossLines value
     * @return string|null
     */
    public function getJoinAcrossLines()
    {
        return $this->joinAcrossLines;
    }
    /**
     * Set joinAcrossLines value
     * @param string $joinAcrossLines
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RPhone
     */
    public function setJoinAcrossLines($joinAcrossLines = null)
    {
        $this->joinAcrossLines = $joinAcrossLines;
        return $this;
    }
    /**
     * Get builtInBridgeStatus value
     * @return string|null
     */
    public function getBuiltInBridgeStatus()
    {
        return $this->builtInBridgeStatus;
    }
    /**
     * Set builtInBridgeStatus value
     * @param string $builtInBridgeStatus
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RPhone
     */
    public function setBuiltInBridgeStatus($builtInBridgeStatus = null)
    {
        $this->builtInBridgeStatus = $builtInBridgeStatus;
        return $this;
    }
    /**
     * Get callInfoPrivacyStatus value
     * @return string|null
     */
    public function getCallInfoPrivacyStatus()
    {
        return $this->callInfoPrivacyStatus;
    }
    /**
     * Set callInfoPrivacyStatus value
     * @param string $callInfoPrivacyStatus
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RPhone
     */
    public function setCallInfoPrivacyStatus($callInfoPrivacyStatus = null)
    {
        $this->callInfoPrivacyStatus = $callInfoPrivacyStatus;
        return $this;
    }
    /**
     * Get hlogStatus value
     * @return string|null
     */
    public function getHlogStatus()
    {
        return $this->hlogStatus;
    }
    /**
     * Set hlogStatus value
     * @param string $hlogStatus
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RPhone
     */
    public function setHlogStatus($hlogStatus = null)
    {
        $this->hlogStatus = $hlogStatus;
        return $this;
    }
    /**
     * Get ownerUserName value
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XFkType|null
     */
    public function getOwnerUserName()
    {
        return $this->ownerUserName;
    }
    /**
     * Set ownerUserName value
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $ownerUserName
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RPhone
     */
    public function setOwnerUserName(\\Losc\CucmBundle\Model\Webservice\StructType\XFkType $ownerUserName = null)
    {
        $this->ownerUserName = $ownerUserName;
        return $this;
    }
    /**
     * Get ignorePresentationIndicators value
     * @return string|null
     */
    public function getIgnorePresentationIndicators()
    {
        return $this->ignorePresentationIndicators;
    }
    /**
     * Set ignorePresentationIndicators value
     * @param string $ignorePresentationIndicators
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RPhone
     */
    public function setIgnorePresentationIndicators($ignorePresentationIndicators = null)
    {
        $this->ignorePresentationIndicators = $ignorePresentationIndicators;
        return $this;
    }
    /**
     * Get packetCaptureMode value
     * @return string|null
     */
    public function getPacketCaptureMode()
    {
        return $this->packetCaptureMode;
    }
    /**
     * Set packetCaptureMode value
     * @param string $packetCaptureMode
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RPhone
     */
    public function setPacketCaptureMode($packetCaptureMode = null)
    {
        $this->packetCaptureMode = $packetCaptureMode;
        return $this;
    }
    /**
     * Get packetCaptureDuration value
     * @return string|null
     */
    public function getPacketCaptureDuration()
    {
        return $this->packetCaptureDuration;
    }
    /**
     * Set packetCaptureDuration value
     * @param string $packetCaptureDuration
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RPhone
     */
    public function setPacketCaptureDuration($packetCaptureDuration = null)
    {
        $this->packetCaptureDuration = $packetCaptureDuration;
        return $this;
    }
    /**
     * Get subscribeCallingSearchSpaceName value
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XFkType|null
     */
    public function getSubscribeCallingSearchSpaceName()
    {
        return $this->subscribeCallingSearchSpaceName;
    }
    /**
     * Set subscribeCallingSearchSpaceName value
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $subscribeCallingSearchSpaceName
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RPhone
     */
    public function setSubscribeCallingSearchSpaceName(\\Losc\CucmBundle\Model\Webservice\StructType\XFkType $subscribeCallingSearchSpaceName = null)
    {
        $this->subscribeCallingSearchSpaceName = $subscribeCallingSearchSpaceName;
        return $this;
    }
    /**
     * Get rerouteCallingSearchSpaceName value
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XFkType|null
     */
    public function getRerouteCallingSearchSpaceName()
    {
        return $this->rerouteCallingSearchSpaceName;
    }
    /**
     * Set rerouteCallingSearchSpaceName value
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $rerouteCallingSearchSpaceName
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RPhone
     */
    public function setRerouteCallingSearchSpaceName(\\Losc\CucmBundle\Model\Webservice\StructType\XFkType $rerouteCallingSearchSpaceName = null)
    {
        $this->rerouteCallingSearchSpaceName = $rerouteCallingSearchSpaceName;
        return $this;
    }
    /**
     * Get allowCtiControlFlag value
     * @return string|null
     */
    public function getAllowCtiControlFlag()
    {
        return $this->allowCtiControlFlag;
    }
    /**
     * Set allowCtiControlFlag value
     * @param string $allowCtiControlFlag
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RPhone
     */
    public function setAllowCtiControlFlag($allowCtiControlFlag = null)
    {
        $this->allowCtiControlFlag = $allowCtiControlFlag;
        return $this;
    }
    /**
     * Get presenceGroupName value
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XFkType|null
     */
    public function getPresenceGroupName()
    {
        return $this->presenceGroupName;
    }
    /**
     * Set presenceGroupName value
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $presenceGroupName
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RPhone
     */
    public function setPresenceGroupName(\\Losc\CucmBundle\Model\Webservice\StructType\XFkType $presenceGroupName = null)
    {
        $this->presenceGroupName = $presenceGroupName;
        return $this;
    }
    /**
     * Get unattendedPort value
     * @return string|null
     */
    public function getUnattendedPort()
    {
        return $this->unattendedPort;
    }
    /**
     * Set unattendedPort value
     * @param string $unattendedPort
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RPhone
     */
    public function setUnattendedPort($unattendedPort = null)
    {
        $this->unattendedPort = $unattendedPort;
        return $this;
    }
    /**
     * Get requireDtmfReception value
     * @return string|null
     */
    public function getRequireDtmfReception()
    {
        return $this->requireDtmfReception;
    }
    /**
     * Set requireDtmfReception value
     * @param string $requireDtmfReception
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RPhone
     */
    public function setRequireDtmfReception($requireDtmfReception = null)
    {
        $this->requireDtmfReception = $requireDtmfReception;
        return $this;
    }
    /**
     * Get rfc2833Disabled value
     * @return string|null
     */
    public function getRfc2833Disabled()
    {
        return $this->rfc2833Disabled;
    }
    /**
     * Set rfc2833Disabled value
     * @param string $rfc2833Disabled
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RPhone
     */
    public function setRfc2833Disabled($rfc2833Disabled = null)
    {
        $this->rfc2833Disabled = $rfc2833Disabled;
        return $this;
    }
    /**
     * Get certificateOperation value
     * @return string|null
     */
    public function getCertificateOperation()
    {
        return $this->certificateOperation;
    }
    /**
     * Set certificateOperation value
     * @param string $certificateOperation
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RPhone
     */
    public function setCertificateOperation($certificateOperation = null)
    {
        $this->certificateOperation = $certificateOperation;
        return $this;
    }
    /**
     * Get authenticationMode value
     * @return string|null
     */
    public function getAuthenticationMode()
    {
        return $this->authenticationMode;
    }
    /**
     * Set authenticationMode value
     * @param string $authenticationMode
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RPhone
     */
    public function setAuthenticationMode($authenticationMode = null)
    {
        $this->authenticationMode = $authenticationMode;
        return $this;
    }
    /**
     * Get keySize value
     * @return string|null
     */
    public function getKeySize()
    {
        return $this->keySize;
    }
    /**
     * Set keySize value
     * @param string $keySize
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RPhone
     */
    public function setKeySize($keySize = null)
    {
        $this->keySize = $keySize;
        return $this;
    }
    /**
     * Get authenticationString value
     * @return string|null
     */
    public function getAuthenticationString()
    {
        return $this->authenticationString;
    }
    /**
     * Set authenticationString value
     * @param string $authenticationString
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RPhone
     */
    public function setAuthenticationString($authenticationString = null)
    {
        $this->authenticationString = $authenticationString;
        return $this;
    }
    /**
     * Get certificateStatus value
     * @return string|null
     */
    public function getCertificateStatus()
    {
        return $this->certificateStatus;
    }
    /**
     * Set certificateStatus value
     * @param string $certificateStatus
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RPhone
     */
    public function setCertificateStatus($certificateStatus = null)
    {
        $this->certificateStatus = $certificateStatus;
        return $this;
    }
    /**
     * Get upgradeFinishTime value
     * @return string|null
     */
    public function getUpgradeFinishTime()
    {
        return $this->upgradeFinishTime;
    }
    /**
     * Set upgradeFinishTime value
     * @param string $upgradeFinishTime
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RPhone
     */
    public function setUpgradeFinishTime($upgradeFinishTime = null)
    {
        $this->upgradeFinishTime = $upgradeFinishTime;
        return $this;
    }
    /**
     * Get deviceMobilityMode value
     * @return string|null
     */
    public function getDeviceMobilityMode()
    {
        return $this->deviceMobilityMode;
    }
    /**
     * Set deviceMobilityMode value
     * @param string $deviceMobilityMode
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RPhone
     */
    public function setDeviceMobilityMode($deviceMobilityMode = null)
    {
        $this->deviceMobilityMode = $deviceMobilityMode;
        return $this;
    }
    /**
     * Get roamingDevicePoolName value
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XFkType|null
     */
    public function getRoamingDevicePoolName()
    {
        return $this->roamingDevicePoolName;
    }
    /**
     * Set roamingDevicePoolName value
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $roamingDevicePoolName
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RPhone
     */
    public function setRoamingDevicePoolName(\\Losc\CucmBundle\Model\Webservice\StructType\XFkType $roamingDevicePoolName = null)
    {
        $this->roamingDevicePoolName = $roamingDevicePoolName;
        return $this;
    }
    /**
     * Get remoteDevice value
     * @return string|null
     */
    public function getRemoteDevice()
    {
        return $this->remoteDevice;
    }
    /**
     * Set remoteDevice value
     * @param string $remoteDevice
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RPhone
     */
    public function setRemoteDevice($remoteDevice = null)
    {
        $this->remoteDevice = $remoteDevice;
        return $this;
    }
    /**
     * Get dndOption value
     * @return string|null
     */
    public function getDndOption()
    {
        return $this->dndOption;
    }
    /**
     * Set dndOption value
     * @param string $dndOption
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RPhone
     */
    public function setDndOption($dndOption = null)
    {
        $this->dndOption = $dndOption;
        return $this;
    }
    /**
     * Get dndRingSetting value
     * @return string|null
     */
    public function getDndRingSetting()
    {
        return $this->dndRingSetting;
    }
    /**
     * Set dndRingSetting value
     * @param string $dndRingSetting
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RPhone
     */
    public function setDndRingSetting($dndRingSetting = null)
    {
        $this->dndRingSetting = $dndRingSetting;
        return $this;
    }
    /**
     * Get dndStatus value
     * @return string|null
     */
    public function getDndStatus()
    {
        return $this->dndStatus;
    }
    /**
     * Set dndStatus value
     * @param string $dndStatus
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RPhone
     */
    public function setDndStatus($dndStatus = null)
    {
        $this->dndStatus = $dndStatus;
        return $this;
    }
    /**
     * Get isActive value
     * @return string|null
     */
    public function getIsActive()
    {
        return $this->isActive;
    }
    /**
     * Set isActive value
     * @param string $isActive
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RPhone
     */
    public function setIsActive($isActive = null)
    {
        $this->isActive = $isActive;
        return $this;
    }
    /**
     * Get isDualMode value
     * @return string|null
     */
    public function getIsDualMode()
    {
        return $this->isDualMode;
    }
    /**
     * Set isDualMode value
     * @param string $isDualMode
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RPhone
     */
    public function setIsDualMode($isDualMode = null)
    {
        $this->isDualMode = $isDualMode;
        return $this;
    }
    /**
     * Get mobilityUserIdName value
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XFkType|null
     */
    public function getMobilityUserIdName()
    {
        return $this->mobilityUserIdName;
    }
    /**
     * Set mobilityUserIdName value
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $mobilityUserIdName
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RPhone
     */
    public function setMobilityUserIdName(\\Losc\CucmBundle\Model\Webservice\StructType\XFkType $mobilityUserIdName = null)
    {
        $this->mobilityUserIdName = $mobilityUserIdName;
        return $this;
    }
    /**
     * Get phoneSuite value
     * @return string|null
     */
    public function getPhoneSuite()
    {
        return $this->phoneSuite;
    }
    /**
     * Set phoneSuite value
     * @param string $phoneSuite
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RPhone
     */
    public function setPhoneSuite($phoneSuite = null)
    {
        $this->phoneSuite = $phoneSuite;
        return $this;
    }
    /**
     * Get phoneServiceDisplay value
     * @return string|null
     */
    public function getPhoneServiceDisplay()
    {
        return $this->phoneServiceDisplay;
    }
    /**
     * Set phoneServiceDisplay value
     * @param string $phoneServiceDisplay
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RPhone
     */
    public function setPhoneServiceDisplay($phoneServiceDisplay = null)
    {
        $this->phoneServiceDisplay = $phoneServiceDisplay;
        return $this;
    }
    /**
     * Get isProtected value
     * @return string|null
     */
    public function getIsProtected()
    {
        return $this->isProtected;
    }
    /**
     * Set isProtected value
     * @param string $isProtected
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RPhone
     */
    public function setIsProtected($isProtected = null)
    {
        $this->isProtected = $isProtected;
        return $this;
    }
    /**
     * Get mtpRequired value
     * @return string|null
     */
    public function getMtpRequired()
    {
        return $this->mtpRequired;
    }
    /**
     * Set mtpRequired value
     * @param string $mtpRequired
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RPhone
     */
    public function setMtpRequired($mtpRequired = null)
    {
        $this->mtpRequired = $mtpRequired;
        return $this;
    }
    /**
     * Get mtpPreferedCodec value
     * @return string|null
     */
    public function getMtpPreferedCodec()
    {
        return $this->mtpPreferedCodec;
    }
    /**
     * Set mtpPreferedCodec value
     * @param string $mtpPreferedCodec
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RPhone
     */
    public function setMtpPreferedCodec($mtpPreferedCodec = null)
    {
        $this->mtpPreferedCodec = $mtpPreferedCodec;
        return $this;
    }
    /**
     * Get dialRulesName value
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XFkType|null
     */
    public function getDialRulesName()
    {
        return $this->dialRulesName;
    }
    /**
     * Set dialRulesName value
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $dialRulesName
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RPhone
     */
    public function setDialRulesName(\\Losc\CucmBundle\Model\Webservice\StructType\XFkType $dialRulesName = null)
    {
        $this->dialRulesName = $dialRulesName;
        return $this;
    }
    /**
     * Get sshUserId value
     * @return string|null
     */
    public function getSshUserId()
    {
        return $this->sshUserId;
    }
    /**
     * Set sshUserId value
     * @param string $sshUserId
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RPhone
     */
    public function setSshUserId($sshUserId = null)
    {
        $this->sshUserId = $sshUserId;
        return $this;
    }
    /**
     * Get sshPwd value
     * @return string|null
     */
    public function getSshPwd()
    {
        return $this->sshPwd;
    }
    /**
     * Set sshPwd value
     * @param string $sshPwd
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RPhone
     */
    public function setSshPwd($sshPwd = null)
    {
        $this->sshPwd = $sshPwd;
        return $this;
    }
    /**
     * Get digestUser value
     * @return string|null
     */
    public function getDigestUser()
    {
        return $this->digestUser;
    }
    /**
     * Set digestUser value
     * @param string $digestUser
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RPhone
     */
    public function setDigestUser($digestUser = null)
    {
        $this->digestUser = $digestUser;
        return $this;
    }
    /**
     * Get outboundCallRollover value
     * @return string|null
     */
    public function getOutboundCallRollover()
    {
        return $this->outboundCallRollover;
    }
    /**
     * Set outboundCallRollover value
     * @param string $outboundCallRollover
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RPhone
     */
    public function setOutboundCallRollover($outboundCallRollover = null)
    {
        $this->outboundCallRollover = $outboundCallRollover;
        return $this;
    }
    /**
     * Get hotlineDevice value
     * @return string|null
     */
    public function getHotlineDevice()
    {
        return $this->hotlineDevice;
    }
    /**
     * Set hotlineDevice value
     * @param string $hotlineDevice
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RPhone
     */
    public function setHotlineDevice($hotlineDevice = null)
    {
        $this->hotlineDevice = $hotlineDevice;
        return $this;
    }
    /**
     * Get secureInformationUrl value
     * @return string|null
     */
    public function getSecureInformationUrl()
    {
        return $this->secureInformationUrl;
    }
    /**
     * Set secureInformationUrl value
     * @param string $secureInformationUrl
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RPhone
     */
    public function setSecureInformationUrl($secureInformationUrl = null)
    {
        $this->secureInformationUrl = $secureInformationUrl;
        return $this;
    }
    /**
     * Get secureDirectoryUrl value
     * @return string|null
     */
    public function getSecureDirectoryUrl()
    {
        return $this->secureDirectoryUrl;
    }
    /**
     * Set secureDirectoryUrl value
     * @param string $secureDirectoryUrl
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RPhone
     */
    public function setSecureDirectoryUrl($secureDirectoryUrl = null)
    {
        $this->secureDirectoryUrl = $secureDirectoryUrl;
        return $this;
    }
    /**
     * Get secureMessageUrl value
     * @return string|null
     */
    public function getSecureMessageUrl()
    {
        return $this->secureMessageUrl;
    }
    /**
     * Set secureMessageUrl value
     * @param string $secureMessageUrl
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RPhone
     */
    public function setSecureMessageUrl($secureMessageUrl = null)
    {
        $this->secureMessageUrl = $secureMessageUrl;
        return $this;
    }
    /**
     * Get secureServicesUrl value
     * @return string|null
     */
    public function getSecureServicesUrl()
    {
        return $this->secureServicesUrl;
    }
    /**
     * Set secureServicesUrl value
     * @param string $secureServicesUrl
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RPhone
     */
    public function setSecureServicesUrl($secureServicesUrl = null)
    {
        $this->secureServicesUrl = $secureServicesUrl;
        return $this;
    }
    /**
     * Get secureAuthenticationUrl value
     * @return string|null
     */
    public function getSecureAuthenticationUrl()
    {
        return $this->secureAuthenticationUrl;
    }
    /**
     * Set secureAuthenticationUrl value
     * @param string $secureAuthenticationUrl
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RPhone
     */
    public function setSecureAuthenticationUrl($secureAuthenticationUrl = null)
    {
        $this->secureAuthenticationUrl = $secureAuthenticationUrl;
        return $this;
    }
    /**
     * Get secureIdleUrl value
     * @return string|null
     */
    public function getSecureIdleUrl()
    {
        return $this->secureIdleUrl;
    }
    /**
     * Set secureIdleUrl value
     * @param string $secureIdleUrl
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RPhone
     */
    public function setSecureIdleUrl($secureIdleUrl = null)
    {
        $this->secureIdleUrl = $secureIdleUrl;
        return $this;
    }
    /**
     * Get alwaysUsePrimeLine value
     * @return string|null
     */
    public function getAlwaysUsePrimeLine()
    {
        return $this->alwaysUsePrimeLine;
    }
    /**
     * Set alwaysUsePrimeLine value
     * @param string $alwaysUsePrimeLine
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RPhone
     */
    public function setAlwaysUsePrimeLine($alwaysUsePrimeLine = null)
    {
        $this->alwaysUsePrimeLine = $alwaysUsePrimeLine;
        return $this;
    }
    /**
     * Get alwaysUsePrimeLineForVoiceMessage value
     * @return string|null
     */
    public function getAlwaysUsePrimeLineForVoiceMessage()
    {
        return $this->alwaysUsePrimeLineForVoiceMessage;
    }
    /**
     * Set alwaysUsePrimeLineForVoiceMessage value
     * @param string $alwaysUsePrimeLineForVoiceMessage
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RPhone
     */
    public function setAlwaysUsePrimeLineForVoiceMessage($alwaysUsePrimeLineForVoiceMessage = null)
    {
        $this->alwaysUsePrimeLineForVoiceMessage = $alwaysUsePrimeLineForVoiceMessage;
        return $this;
    }
    /**
     * Get featureControlPolicy value
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XFkType|null
     */
    public function getFeatureControlPolicy()
    {
        return $this->featureControlPolicy;
    }
    /**
     * Set featureControlPolicy value
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $featureControlPolicy
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RPhone
     */
    public function setFeatureControlPolicy(\\Losc\CucmBundle\Model\Webservice\StructType\XFkType $featureControlPolicy = null)
    {
        $this->featureControlPolicy = $featureControlPolicy;
        return $this;
    }
    /**
     * Get deviceTrustMode value
     * @return string|null
     */
    public function getDeviceTrustMode()
    {
        return $this->deviceTrustMode;
    }
    /**
     * Set deviceTrustMode value
     * @param string $deviceTrustMode
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RPhone
     */
    public function setDeviceTrustMode($deviceTrustMode = null)
    {
        $this->deviceTrustMode = $deviceTrustMode;
        return $this;
    }
    /**
     * Get earlyOfferSupportForVoiceCall value
     * @return string|null
     */
    public function getEarlyOfferSupportForVoiceCall()
    {
        return $this->earlyOfferSupportForVoiceCall;
    }
    /**
     * Set earlyOfferSupportForVoiceCall value
     * @param string $earlyOfferSupportForVoiceCall
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RPhone
     */
    public function setEarlyOfferSupportForVoiceCall($earlyOfferSupportForVoiceCall = null)
    {
        $this->earlyOfferSupportForVoiceCall = $earlyOfferSupportForVoiceCall;
        return $this;
    }
    /**
     * Get requireThirdPartyRegistration value
     * @return string|null
     */
    public function getRequireThirdPartyRegistration()
    {
        return $this->requireThirdPartyRegistration;
    }
    /**
     * Set requireThirdPartyRegistration value
     * @param string $requireThirdPartyRegistration
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RPhone
     */
    public function setRequireThirdPartyRegistration($requireThirdPartyRegistration = null)
    {
        $this->requireThirdPartyRegistration = $requireThirdPartyRegistration;
        return $this;
    }
    /**
     * Get blockIncomingCallsWhenRoaming value
     * @return string|null
     */
    public function getBlockIncomingCallsWhenRoaming()
    {
        return $this->blockIncomingCallsWhenRoaming;
    }
    /**
     * Set blockIncomingCallsWhenRoaming value
     * @param string $blockIncomingCallsWhenRoaming
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RPhone
     */
    public function setBlockIncomingCallsWhenRoaming($blockIncomingCallsWhenRoaming = null)
    {
        $this->blockIncomingCallsWhenRoaming = $blockIncomingCallsWhenRoaming;
        return $this;
    }
    /**
     * Get homeNetworkId value
     * @return string|null
     */
    public function getHomeNetworkId()
    {
        return $this->homeNetworkId;
    }
    /**
     * Set homeNetworkId value
     * @param string $homeNetworkId
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RPhone
     */
    public function setHomeNetworkId($homeNetworkId = null)
    {
        $this->homeNetworkId = $homeNetworkId;
        return $this;
    }
    /**
     * Get AllowPresentationSharingUsingBfcp value
     * @return string|null
     */
    public function getAllowPresentationSharingUsingBfcp()
    {
        return $this->AllowPresentationSharingUsingBfcp;
    }
    /**
     * Set AllowPresentationSharingUsingBfcp value
     * @param string $allowPresentationSharingUsingBfcp
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RPhone
     */
    public function setAllowPresentationSharingUsingBfcp($allowPresentationSharingUsingBfcp = null)
    {
        $this->AllowPresentationSharingUsingBfcp = $allowPresentationSharingUsingBfcp;
        return $this;
    }
    /**
     * Get confidentialAccess value
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\ConfidentialAccess|null
     */
    public function getConfidentialAccess()
    {
        return $this->confidentialAccess;
    }
    /**
     * Set confidentialAccess value
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\ConfidentialAccess $confidentialAccess
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RPhone
     */
    public function setConfidentialAccess(\\Losc\CucmBundle\Model\Webservice\StructType\ConfidentialAccess $confidentialAccess = null)
    {
        $this->confidentialAccess = $confidentialAccess;
        return $this;
    }
    /**
     * Get requireOffPremiseLocation value
     * @return string|null
     */
    public function getRequireOffPremiseLocation()
    {
        return $this->requireOffPremiseLocation;
    }
    /**
     * Set requireOffPremiseLocation value
     * @param string $requireOffPremiseLocation
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RPhone
     */
    public function setRequireOffPremiseLocation($requireOffPremiseLocation = null)
    {
        $this->requireOffPremiseLocation = $requireOffPremiseLocation;
        return $this;
    }
    /**
     * Get allowiXApplicableMedia value
     * @return string|null
     */
    public function getAllowiXApplicableMedia()
    {
        return $this->allowiXApplicableMedia;
    }
    /**
     * Set allowiXApplicableMedia value
     * @param string $allowiXApplicableMedia
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RPhone
     */
    public function setAllowiXApplicableMedia($allowiXApplicableMedia = null)
    {
        $this->allowiXApplicableMedia = $allowiXApplicableMedia;
        return $this;
    }
    /**
     * Get cgpnIngressDN value
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XFkType|null
     */
    public function getCgpnIngressDN()
    {
        return $this->cgpnIngressDN;
    }
    /**
     * Set cgpnIngressDN value
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $cgpnIngressDN
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RPhone
     */
    public function setCgpnIngressDN(\\Losc\CucmBundle\Model\Webservice\StructType\XFkType $cgpnIngressDN = null)
    {
        $this->cgpnIngressDN = $cgpnIngressDN;
        return $this;
    }
    /**
     * Get useDevicePoolCgpnIngressDN value
     * @return string|null
     */
    public function getUseDevicePoolCgpnIngressDN()
    {
        return $this->useDevicePoolCgpnIngressDN;
    }
    /**
     * Set useDevicePoolCgpnIngressDN value
     * @param string $useDevicePoolCgpnIngressDN
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RPhone
     */
    public function setUseDevicePoolCgpnIngressDN($useDevicePoolCgpnIngressDN = null)
    {
        $this->useDevicePoolCgpnIngressDN = $useDevicePoolCgpnIngressDN;
        return $this;
    }
    /**
     * Get msisdn value
     * @return string|null
     */
    public function getMsisdn()
    {
        return $this->msisdn;
    }
    /**
     * Set msisdn value
     * @param string $msisdn
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RPhone
     */
    public function setMsisdn($msisdn = null)
    {
        $this->msisdn = $msisdn;
        return $this;
    }
    /**
     * Get enableCallRoutingToRdWhenNoneIsActive value
     * @return string|null
     */
    public function getEnableCallRoutingToRdWhenNoneIsActive()
    {
        return $this->enableCallRoutingToRdWhenNoneIsActive;
    }
    /**
     * Set enableCallRoutingToRdWhenNoneIsActive value
     * @param string $enableCallRoutingToRdWhenNoneIsActive
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RPhone
     */
    public function setEnableCallRoutingToRdWhenNoneIsActive($enableCallRoutingToRdWhenNoneIsActive = null)
    {
        $this->enableCallRoutingToRdWhenNoneIsActive = $enableCallRoutingToRdWhenNoneIsActive;
        return $this;
    }
    /**
     * Get wifiHotspotProfile value
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XFkType|null
     */
    public function getWifiHotspotProfile()
    {
        return $this->wifiHotspotProfile;
    }
    /**
     * Set wifiHotspotProfile value
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $wifiHotspotProfile
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RPhone
     */
    public function setWifiHotspotProfile(\\Losc\CucmBundle\Model\Webservice\StructType\XFkType $wifiHotspotProfile = null)
    {
        $this->wifiHotspotProfile = $wifiHotspotProfile;
        return $this;
    }
    /**
     * Get wirelessLanProfileGroup value
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XFkType|null
     */
    public function getWirelessLanProfileGroup()
    {
        return $this->wirelessLanProfileGroup;
    }
    /**
     * Set wirelessLanProfileGroup value
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $wirelessLanProfileGroup
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RPhone
     */
    public function setWirelessLanProfileGroup(\\Losc\CucmBundle\Model\Webservice\StructType\XFkType $wirelessLanProfileGroup = null)
    {
        $this->wirelessLanProfileGroup = $wirelessLanProfileGroup;
        return $this;
    }
    /**
     * Get ctiid value
     * @return int|null
     */
    public function getCtiid()
    {
        return $this->ctiid;
    }
    /**
     * Set ctiid value
     * @param int $ctiid
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RPhone
     */
    public function setCtiid($ctiid = null)
    {
        $this->ctiid = $ctiid;
        return $this;
    }
    /**
     * Get uuid value
     * @return string|null
     */
    public function getUuid()
    {
        return $this->uuid;
    }
    /**
     * Set uuid value
     * @param string $uuid
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RPhone
     */
    public function setUuid($uuid = null)
    {
        $this->uuid = $uuid;
        return $this;
    }
}
