<?php

namespace \Losc\CucmBundle\Model\Webservice\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RLine StructType
 * @subpackage Structs
 */
class RLine extends AbstractStructBase
{
    /**
     * The pattern
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $pattern;
    /**
     * The description
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $description;
    /**
     * The usage
     * Meta information extracted from the WSDL
     * - documentation: For Intercom DN and Intercom Translation patterns the usage tag value needs to be specified explicitly as Device Intercom and Translation Intercom respectively. For all other patterns it is a Read-only tag.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $usage;
    /**
     * The routePartitionName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $routePartitionName;
    /**
     * The aarNeighborhoodName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $aarNeighborhoodName;
    /**
     * The aarDestinationMask
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 128
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $aarDestinationMask;
    /**
     * The aarKeepCallHistory
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $aarKeepCallHistory;
    /**
     * The aarVoiceMailEnabled
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $aarVoiceMailEnabled;
    /**
     * The callForwardAll
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\RCallForwardAll
     */
    public $callForwardAll;
    /**
     * The callForwardBusy
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\RCallForwardBusy
     */
    public $callForwardBusy;
    /**
     * The callForwardBusyInt
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\RCallForwardBusyInt
     */
    public $callForwardBusyInt;
    /**
     * The callForwardNoAnswer
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\RCallForwardNoAnswer
     */
    public $callForwardNoAnswer;
    /**
     * The callForwardNoAnswerInt
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\RCallForwardNoAnswerInt
     */
    public $callForwardNoAnswerInt;
    /**
     * The callForwardNoCoverage
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\RCallForwardNoCoverage
     */
    public $callForwardNoCoverage;
    /**
     * The callForwardNoCoverageInt
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\RCallForwardNoCoverageInt
     */
    public $callForwardNoCoverageInt;
    /**
     * The callForwardOnFailure
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\RCallForwardOnFailure
     */
    public $callForwardOnFailure;
    /**
     * The callForwardAlternateParty
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\RCallForwardAlternateParty
     */
    public $callForwardAlternateParty;
    /**
     * The callForwardNotRegistered
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\RCallForwardNotRegistered
     */
    public $callForwardNotRegistered;
    /**
     * The callForwardNotRegisteredInt
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\RCallForwardNotRegisteredInt
     */
    public $callForwardNotRegisteredInt;
    /**
     * The callPickupGroupName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $callPickupGroupName;
    /**
     * The autoAnswer
     * Meta information extracted from the WSDL
     * - documentation: For an intercom line this tag should be treated as a mandatory tag and the valid values are Auto Answer with Headset and Auto Answer with Speakerphone.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $autoAnswer;
    /**
     * The networkHoldMohAudioSourceId
     * Meta information extracted from the WSDL
     * - documentation: A value of 0 means 'none selected'.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $networkHoldMohAudioSourceId;
    /**
     * The userHoldMohAudioSourceId
     * Meta information extracted from the WSDL
     * - documentation: A value of 0 means 'none selected'.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $userHoldMohAudioSourceId;
    /**
     * The alertingName
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 50
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $alertingName;
    /**
     * The asciiAlertingName
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 32
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $asciiAlertingName;
    /**
     * The presenceGroupName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $presenceGroupName;
    /**
     * The shareLineAppearanceCssName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $shareLineAppearanceCssName;
    /**
     * The voiceMailProfileName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $voiceMailProfileName;
    /**
     * The patternPrecedence
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $patternPrecedence;
    /**
     * The releaseClause
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $releaseClause;
    /**
     * The hrDuration
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $hrDuration;
    /**
     * The hrInterval
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $hrInterval;
    /**
     * The cfaCssPolicy
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $cfaCssPolicy;
    /**
     * The defaultActivatedDeviceName
     * Meta information extracted from the WSDL
     * - documentation: This tag is applicable for only intercom lines and if not set, intercom lines will not be active.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $defaultActivatedDeviceName;
    /**
     * The parkMonForwardNoRetrieveDn
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 50
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $parkMonForwardNoRetrieveDn;
    /**
     * The parkMonForwardNoRetrieveIntDn
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 50
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $parkMonForwardNoRetrieveIntDn;
    /**
     * The parkMonForwardNoRetrieveVmEnabled
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $parkMonForwardNoRetrieveVmEnabled;
    /**
     * The parkMonForwardNoRetrieveIntVmEnabled
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $parkMonForwardNoRetrieveIntVmEnabled;
    /**
     * The parkMonForwardNoRetrieveCssName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $parkMonForwardNoRetrieveCssName;
    /**
     * The parkMonForwardNoRetrieveIntCssName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $parkMonForwardNoRetrieveIntCssName;
    /**
     * The parkMonReversionTimer
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $parkMonReversionTimer;
    /**
     * The partyEntranceTone
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $partyEntranceTone;
    /**
     * The directoryURIs
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\DirectoryURIs
     */
    public $directoryURIs;
    /**
     * The allowCtiControlFlag
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $allowCtiControlFlag;
    /**
     * The rejectAnonymousCall
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $rejectAnonymousCall;
    /**
     * The patternUrgency
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $patternUrgency;
    /**
     * The confidentialAccess
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\ConfidentialAccess
     */
    public $confidentialAccess;
    /**
     * The externalCallControlProfile
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $externalCallControlProfile;
    /**
     * The enterpriseAltNum
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\EnterpriseAltNum
     */
    public $enterpriseAltNum;
    /**
     * The e164AltNum
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\E164AltNum
     */
    public $e164AltNum;
    /**
     * The pstnFailover
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $pstnFailover;
    /**
     * The callControlAgentProfile
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $callControlAgentProfile;
    /**
     * The associatedDevices
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\AssociatedDevices
     */
    public $associatedDevices;
    /**
     * The useEnterpriseAltNum
     * Meta information extracted from the WSDL
     * - documentation: While UPDATE set it to false if you want to delete enterpriseAltNumber.Use only while update
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $useEnterpriseAltNum;
    /**
     * The useE164AltNum
     * Meta information extracted from the WSDL
     * - documentation: While UPDATE set it to false if you want to delete e164AltNumber
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $useE164AltNum;
    /**
     * The active
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $active;
    /**
     * The uuid
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - pattern: \{........-....-....-....-............\}
     * @var string
     */
    public $uuid;
    /**
     * Constructor method for RLine
     * @uses RLine::setPattern()
     * @uses RLine::setDescription()
     * @uses RLine::setUsage()
     * @uses RLine::setRoutePartitionName()
     * @uses RLine::setAarNeighborhoodName()
     * @uses RLine::setAarDestinationMask()
     * @uses RLine::setAarKeepCallHistory()
     * @uses RLine::setAarVoiceMailEnabled()
     * @uses RLine::setCallForwardAll()
     * @uses RLine::setCallForwardBusy()
     * @uses RLine::setCallForwardBusyInt()
     * @uses RLine::setCallForwardNoAnswer()
     * @uses RLine::setCallForwardNoAnswerInt()
     * @uses RLine::setCallForwardNoCoverage()
     * @uses RLine::setCallForwardNoCoverageInt()
     * @uses RLine::setCallForwardOnFailure()
     * @uses RLine::setCallForwardAlternateParty()
     * @uses RLine::setCallForwardNotRegistered()
     * @uses RLine::setCallForwardNotRegisteredInt()
     * @uses RLine::setCallPickupGroupName()
     * @uses RLine::setAutoAnswer()
     * @uses RLine::setNetworkHoldMohAudioSourceId()
     * @uses RLine::setUserHoldMohAudioSourceId()
     * @uses RLine::setAlertingName()
     * @uses RLine::setAsciiAlertingName()
     * @uses RLine::setPresenceGroupName()
     * @uses RLine::setShareLineAppearanceCssName()
     * @uses RLine::setVoiceMailProfileName()
     * @uses RLine::setPatternPrecedence()
     * @uses RLine::setReleaseClause()
     * @uses RLine::setHrDuration()
     * @uses RLine::setHrInterval()
     * @uses RLine::setCfaCssPolicy()
     * @uses RLine::setDefaultActivatedDeviceName()
     * @uses RLine::setParkMonForwardNoRetrieveDn()
     * @uses RLine::setParkMonForwardNoRetrieveIntDn()
     * @uses RLine::setParkMonForwardNoRetrieveVmEnabled()
     * @uses RLine::setParkMonForwardNoRetrieveIntVmEnabled()
     * @uses RLine::setParkMonForwardNoRetrieveCssName()
     * @uses RLine::setParkMonForwardNoRetrieveIntCssName()
     * @uses RLine::setParkMonReversionTimer()
     * @uses RLine::setPartyEntranceTone()
     * @uses RLine::setDirectoryURIs()
     * @uses RLine::setAllowCtiControlFlag()
     * @uses RLine::setRejectAnonymousCall()
     * @uses RLine::setPatternUrgency()
     * @uses RLine::setConfidentialAccess()
     * @uses RLine::setExternalCallControlProfile()
     * @uses RLine::setEnterpriseAltNum()
     * @uses RLine::setE164AltNum()
     * @uses RLine::setPstnFailover()
     * @uses RLine::setCallControlAgentProfile()
     * @uses RLine::setAssociatedDevices()
     * @uses RLine::setUseEnterpriseAltNum()
     * @uses RLine::setUseE164AltNum()
     * @uses RLine::setActive()
     * @uses RLine::setUuid()
     * @param string $pattern
     * @param string $description
     * @param string $usage
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $routePartitionName
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $aarNeighborhoodName
     * @param string $aarDestinationMask
     * @param string $aarKeepCallHistory
     * @param string $aarVoiceMailEnabled
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\RCallForwardAll $callForwardAll
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\RCallForwardBusy $callForwardBusy
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\RCallForwardBusyInt $callForwardBusyInt
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\RCallForwardNoAnswer $callForwardNoAnswer
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\RCallForwardNoAnswerInt $callForwardNoAnswerInt
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\RCallForwardNoCoverage $callForwardNoCoverage
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\RCallForwardNoCoverageInt $callForwardNoCoverageInt
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\RCallForwardOnFailure $callForwardOnFailure
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\RCallForwardAlternateParty $callForwardAlternateParty
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\RCallForwardNotRegistered $callForwardNotRegistered
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\RCallForwardNotRegisteredInt $callForwardNotRegisteredInt
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $callPickupGroupName
     * @param string $autoAnswer
     * @param string $networkHoldMohAudioSourceId
     * @param string $userHoldMohAudioSourceId
     * @param string $alertingName
     * @param string $asciiAlertingName
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $presenceGroupName
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $shareLineAppearanceCssName
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $voiceMailProfileName
     * @param string $patternPrecedence
     * @param string $releaseClause
     * @param string $hrDuration
     * @param string $hrInterval
     * @param string $cfaCssPolicy
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $defaultActivatedDeviceName
     * @param string $parkMonForwardNoRetrieveDn
     * @param string $parkMonForwardNoRetrieveIntDn
     * @param string $parkMonForwardNoRetrieveVmEnabled
     * @param string $parkMonForwardNoRetrieveIntVmEnabled
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $parkMonForwardNoRetrieveCssName
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $parkMonForwardNoRetrieveIntCssName
     * @param string $parkMonReversionTimer
     * @param string $partyEntranceTone
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\DirectoryURIs $directoryURIs
     * @param string $allowCtiControlFlag
     * @param string $rejectAnonymousCall
     * @param string $patternUrgency
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\ConfidentialAccess $confidentialAccess
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $externalCallControlProfile
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\EnterpriseAltNum $enterpriseAltNum
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\E164AltNum $e164AltNum
     * @param string $pstnFailover
     * @param string $callControlAgentProfile
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\AssociatedDevices $associatedDevices
     * @param string $useEnterpriseAltNum
     * @param string $useE164AltNum
     * @param string $active
     * @param string $uuid
     */
    public function __construct($pattern = null, $description = null, $usage = null, \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $routePartitionName = null, \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $aarNeighborhoodName = null, $aarDestinationMask = null, $aarKeepCallHistory = null, $aarVoiceMailEnabled = null, \\Losc\CucmBundle\Model\Webservice\StructType\RCallForwardAll $callForwardAll = null, \\Losc\CucmBundle\Model\Webservice\StructType\RCallForwardBusy $callForwardBusy = null, \\Losc\CucmBundle\Model\Webservice\StructType\RCallForwardBusyInt $callForwardBusyInt = null, \\Losc\CucmBundle\Model\Webservice\StructType\RCallForwardNoAnswer $callForwardNoAnswer = null, \\Losc\CucmBundle\Model\Webservice\StructType\RCallForwardNoAnswerInt $callForwardNoAnswerInt = null, \\Losc\CucmBundle\Model\Webservice\StructType\RCallForwardNoCoverage $callForwardNoCoverage = null, \\Losc\CucmBundle\Model\Webservice\StructType\RCallForwardNoCoverageInt $callForwardNoCoverageInt = null, \\Losc\CucmBundle\Model\Webservice\StructType\RCallForwardOnFailure $callForwardOnFailure = null, \\Losc\CucmBundle\Model\Webservice\StructType\RCallForwardAlternateParty $callForwardAlternateParty = null, \\Losc\CucmBundle\Model\Webservice\StructType\RCallForwardNotRegistered $callForwardNotRegistered = null, \\Losc\CucmBundle\Model\Webservice\StructType\RCallForwardNotRegisteredInt $callForwardNotRegisteredInt = null, \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $callPickupGroupName = null, $autoAnswer = null, $networkHoldMohAudioSourceId = null, $userHoldMohAudioSourceId = null, $alertingName = null, $asciiAlertingName = null, \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $presenceGroupName = null, \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $shareLineAppearanceCssName = null, \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $voiceMailProfileName = null, $patternPrecedence = null, $releaseClause = null, $hrDuration = null, $hrInterval = null, $cfaCssPolicy = null, \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $defaultActivatedDeviceName = null, $parkMonForwardNoRetrieveDn = null, $parkMonForwardNoRetrieveIntDn = null, $parkMonForwardNoRetrieveVmEnabled = null, $parkMonForwardNoRetrieveIntVmEnabled = null, \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $parkMonForwardNoRetrieveCssName = null, \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $parkMonForwardNoRetrieveIntCssName = null, $parkMonReversionTimer = null, $partyEntranceTone = null, \\Losc\CucmBundle\Model\Webservice\StructType\DirectoryURIs $directoryURIs = null, $allowCtiControlFlag = null, $rejectAnonymousCall = null, $patternUrgency = null, \\Losc\CucmBundle\Model\Webservice\StructType\ConfidentialAccess $confidentialAccess = null, \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $externalCallControlProfile = null, \\Losc\CucmBundle\Model\Webservice\StructType\EnterpriseAltNum $enterpriseAltNum = null, \\Losc\CucmBundle\Model\Webservice\StructType\E164AltNum $e164AltNum = null, $pstnFailover = null, $callControlAgentProfile = null, \\Losc\CucmBundle\Model\Webservice\StructType\AssociatedDevices $associatedDevices = null, $useEnterpriseAltNum = null, $useE164AltNum = null, $active = null, $uuid = null)
    {
        $this
            ->setPattern($pattern)
            ->setDescription($description)
            ->setUsage($usage)
            ->setRoutePartitionName($routePartitionName)
            ->setAarNeighborhoodName($aarNeighborhoodName)
            ->setAarDestinationMask($aarDestinationMask)
            ->setAarKeepCallHistory($aarKeepCallHistory)
            ->setAarVoiceMailEnabled($aarVoiceMailEnabled)
            ->setCallForwardAll($callForwardAll)
            ->setCallForwardBusy($callForwardBusy)
            ->setCallForwardBusyInt($callForwardBusyInt)
            ->setCallForwardNoAnswer($callForwardNoAnswer)
            ->setCallForwardNoAnswerInt($callForwardNoAnswerInt)
            ->setCallForwardNoCoverage($callForwardNoCoverage)
            ->setCallForwardNoCoverageInt($callForwardNoCoverageInt)
            ->setCallForwardOnFailure($callForwardOnFailure)
            ->setCallForwardAlternateParty($callForwardAlternateParty)
            ->setCallForwardNotRegistered($callForwardNotRegistered)
            ->setCallForwardNotRegisteredInt($callForwardNotRegisteredInt)
            ->setCallPickupGroupName($callPickupGroupName)
            ->setAutoAnswer($autoAnswer)
            ->setNetworkHoldMohAudioSourceId($networkHoldMohAudioSourceId)
            ->setUserHoldMohAudioSourceId($userHoldMohAudioSourceId)
            ->setAlertingName($alertingName)
            ->setAsciiAlertingName($asciiAlertingName)
            ->setPresenceGroupName($presenceGroupName)
            ->setShareLineAppearanceCssName($shareLineAppearanceCssName)
            ->setVoiceMailProfileName($voiceMailProfileName)
            ->setPatternPrecedence($patternPrecedence)
            ->setReleaseClause($releaseClause)
            ->setHrDuration($hrDuration)
            ->setHrInterval($hrInterval)
            ->setCfaCssPolicy($cfaCssPolicy)
            ->setDefaultActivatedDeviceName($defaultActivatedDeviceName)
            ->setParkMonForwardNoRetrieveDn($parkMonForwardNoRetrieveDn)
            ->setParkMonForwardNoRetrieveIntDn($parkMonForwardNoRetrieveIntDn)
            ->setParkMonForwardNoRetrieveVmEnabled($parkMonForwardNoRetrieveVmEnabled)
            ->setParkMonForwardNoRetrieveIntVmEnabled($parkMonForwardNoRetrieveIntVmEnabled)
            ->setParkMonForwardNoRetrieveCssName($parkMonForwardNoRetrieveCssName)
            ->setParkMonForwardNoRetrieveIntCssName($parkMonForwardNoRetrieveIntCssName)
            ->setParkMonReversionTimer($parkMonReversionTimer)
            ->setPartyEntranceTone($partyEntranceTone)
            ->setDirectoryURIs($directoryURIs)
            ->setAllowCtiControlFlag($allowCtiControlFlag)
            ->setRejectAnonymousCall($rejectAnonymousCall)
            ->setPatternUrgency($patternUrgency)
            ->setConfidentialAccess($confidentialAccess)
            ->setExternalCallControlProfile($externalCallControlProfile)
            ->setEnterpriseAltNum($enterpriseAltNum)
            ->setE164AltNum($e164AltNum)
            ->setPstnFailover($pstnFailover)
            ->setCallControlAgentProfile($callControlAgentProfile)
            ->setAssociatedDevices($associatedDevices)
            ->setUseEnterpriseAltNum($useEnterpriseAltNum)
            ->setUseE164AltNum($useE164AltNum)
            ->setActive($active)
            ->setUuid($uuid);
    }
    /**
     * Get pattern value
     * @return string|null
     */
    public function getPattern()
    {
        return $this->pattern;
    }
    /**
     * Set pattern value
     * @param string $pattern
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RLine
     */
    public function setPattern($pattern = null)
    {
        $this->pattern = $pattern;
        return $this;
    }
    /**
     * Get description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->description;
    }
    /**
     * Set description value
     * @param string $description
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RLine
     */
    public function setDescription($description = null)
    {
        $this->description = $description;
        return $this;
    }
    /**
     * Get usage value
     * @return string|null
     */
    public function getUsage()
    {
        return $this->usage;
    }
    /**
     * Set usage value
     * @param string $usage
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RLine
     */
    public function setUsage($usage = null)
    {
        $this->usage = $usage;
        return $this;
    }
    /**
     * Get routePartitionName value
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XFkType|null
     */
    public function getRoutePartitionName()
    {
        return $this->routePartitionName;
    }
    /**
     * Set routePartitionName value
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $routePartitionName
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RLine
     */
    public function setRoutePartitionName(\\Losc\CucmBundle\Model\Webservice\StructType\XFkType $routePartitionName = null)
    {
        $this->routePartitionName = $routePartitionName;
        return $this;
    }
    /**
     * Get aarNeighborhoodName value
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XFkType|null
     */
    public function getAarNeighborhoodName()
    {
        return $this->aarNeighborhoodName;
    }
    /**
     * Set aarNeighborhoodName value
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $aarNeighborhoodName
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RLine
     */
    public function setAarNeighborhoodName(\\Losc\CucmBundle\Model\Webservice\StructType\XFkType $aarNeighborhoodName = null)
    {
        $this->aarNeighborhoodName = $aarNeighborhoodName;
        return $this;
    }
    /**
     * Get aarDestinationMask value
     * @return string|null
     */
    public function getAarDestinationMask()
    {
        return $this->aarDestinationMask;
    }
    /**
     * Set aarDestinationMask value
     * @param string $aarDestinationMask
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RLine
     */
    public function setAarDestinationMask($aarDestinationMask = null)
    {
        $this->aarDestinationMask = $aarDestinationMask;
        return $this;
    }
    /**
     * Get aarKeepCallHistory value
     * @return string|null
     */
    public function getAarKeepCallHistory()
    {
        return $this->aarKeepCallHistory;
    }
    /**
     * Set aarKeepCallHistory value
     * @param string $aarKeepCallHistory
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RLine
     */
    public function setAarKeepCallHistory($aarKeepCallHistory = null)
    {
        $this->aarKeepCallHistory = $aarKeepCallHistory;
        return $this;
    }
    /**
     * Get aarVoiceMailEnabled value
     * @return string|null
     */
    public function getAarVoiceMailEnabled()
    {
        return $this->aarVoiceMailEnabled;
    }
    /**
     * Set aarVoiceMailEnabled value
     * @param string $aarVoiceMailEnabled
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RLine
     */
    public function setAarVoiceMailEnabled($aarVoiceMailEnabled = null)
    {
        $this->aarVoiceMailEnabled = $aarVoiceMailEnabled;
        return $this;
    }
    /**
     * Get callForwardAll value
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RCallForwardAll|null
     */
    public function getCallForwardAll()
    {
        return $this->callForwardAll;
    }
    /**
     * Set callForwardAll value
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\RCallForwardAll $callForwardAll
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RLine
     */
    public function setCallForwardAll(\\Losc\CucmBundle\Model\Webservice\StructType\RCallForwardAll $callForwardAll = null)
    {
        $this->callForwardAll = $callForwardAll;
        return $this;
    }
    /**
     * Get callForwardBusy value
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RCallForwardBusy|null
     */
    public function getCallForwardBusy()
    {
        return $this->callForwardBusy;
    }
    /**
     * Set callForwardBusy value
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\RCallForwardBusy $callForwardBusy
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RLine
     */
    public function setCallForwardBusy(\\Losc\CucmBundle\Model\Webservice\StructType\RCallForwardBusy $callForwardBusy = null)
    {
        $this->callForwardBusy = $callForwardBusy;
        return $this;
    }
    /**
     * Get callForwardBusyInt value
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RCallForwardBusyInt|null
     */
    public function getCallForwardBusyInt()
    {
        return $this->callForwardBusyInt;
    }
    /**
     * Set callForwardBusyInt value
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\RCallForwardBusyInt $callForwardBusyInt
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RLine
     */
    public function setCallForwardBusyInt(\\Losc\CucmBundle\Model\Webservice\StructType\RCallForwardBusyInt $callForwardBusyInt = null)
    {
        $this->callForwardBusyInt = $callForwardBusyInt;
        return $this;
    }
    /**
     * Get callForwardNoAnswer value
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RCallForwardNoAnswer|null
     */
    public function getCallForwardNoAnswer()
    {
        return $this->callForwardNoAnswer;
    }
    /**
     * Set callForwardNoAnswer value
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\RCallForwardNoAnswer $callForwardNoAnswer
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RLine
     */
    public function setCallForwardNoAnswer(\\Losc\CucmBundle\Model\Webservice\StructType\RCallForwardNoAnswer $callForwardNoAnswer = null)
    {
        $this->callForwardNoAnswer = $callForwardNoAnswer;
        return $this;
    }
    /**
     * Get callForwardNoAnswerInt value
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RCallForwardNoAnswerInt|null
     */
    public function getCallForwardNoAnswerInt()
    {
        return $this->callForwardNoAnswerInt;
    }
    /**
     * Set callForwardNoAnswerInt value
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\RCallForwardNoAnswerInt $callForwardNoAnswerInt
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RLine
     */
    public function setCallForwardNoAnswerInt(\\Losc\CucmBundle\Model\Webservice\StructType\RCallForwardNoAnswerInt $callForwardNoAnswerInt = null)
    {
        $this->callForwardNoAnswerInt = $callForwardNoAnswerInt;
        return $this;
    }
    /**
     * Get callForwardNoCoverage value
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RCallForwardNoCoverage|null
     */
    public function getCallForwardNoCoverage()
    {
        return $this->callForwardNoCoverage;
    }
    /**
     * Set callForwardNoCoverage value
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\RCallForwardNoCoverage $callForwardNoCoverage
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RLine
     */
    public function setCallForwardNoCoverage(\\Losc\CucmBundle\Model\Webservice\StructType\RCallForwardNoCoverage $callForwardNoCoverage = null)
    {
        $this->callForwardNoCoverage = $callForwardNoCoverage;
        return $this;
    }
    /**
     * Get callForwardNoCoverageInt value
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RCallForwardNoCoverageInt|null
     */
    public function getCallForwardNoCoverageInt()
    {
        return $this->callForwardNoCoverageInt;
    }
    /**
     * Set callForwardNoCoverageInt value
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\RCallForwardNoCoverageInt $callForwardNoCoverageInt
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RLine
     */
    public function setCallForwardNoCoverageInt(\\Losc\CucmBundle\Model\Webservice\StructType\RCallForwardNoCoverageInt $callForwardNoCoverageInt = null)
    {
        $this->callForwardNoCoverageInt = $callForwardNoCoverageInt;
        return $this;
    }
    /**
     * Get callForwardOnFailure value
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RCallForwardOnFailure|null
     */
    public function getCallForwardOnFailure()
    {
        return $this->callForwardOnFailure;
    }
    /**
     * Set callForwardOnFailure value
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\RCallForwardOnFailure $callForwardOnFailure
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RLine
     */
    public function setCallForwardOnFailure(\\Losc\CucmBundle\Model\Webservice\StructType\RCallForwardOnFailure $callForwardOnFailure = null)
    {
        $this->callForwardOnFailure = $callForwardOnFailure;
        return $this;
    }
    /**
     * Get callForwardAlternateParty value
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RCallForwardAlternateParty|null
     */
    public function getCallForwardAlternateParty()
    {
        return $this->callForwardAlternateParty;
    }
    /**
     * Set callForwardAlternateParty value
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\RCallForwardAlternateParty $callForwardAlternateParty
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RLine
     */
    public function setCallForwardAlternateParty(\\Losc\CucmBundle\Model\Webservice\StructType\RCallForwardAlternateParty $callForwardAlternateParty = null)
    {
        $this->callForwardAlternateParty = $callForwardAlternateParty;
        return $this;
    }
    /**
     * Get callForwardNotRegistered value
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RCallForwardNotRegistered|null
     */
    public function getCallForwardNotRegistered()
    {
        return $this->callForwardNotRegistered;
    }
    /**
     * Set callForwardNotRegistered value
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\RCallForwardNotRegistered $callForwardNotRegistered
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RLine
     */
    public function setCallForwardNotRegistered(\\Losc\CucmBundle\Model\Webservice\StructType\RCallForwardNotRegistered $callForwardNotRegistered = null)
    {
        $this->callForwardNotRegistered = $callForwardNotRegistered;
        return $this;
    }
    /**
     * Get callForwardNotRegisteredInt value
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RCallForwardNotRegisteredInt|null
     */
    public function getCallForwardNotRegisteredInt()
    {
        return $this->callForwardNotRegisteredInt;
    }
    /**
     * Set callForwardNotRegisteredInt value
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\RCallForwardNotRegisteredInt $callForwardNotRegisteredInt
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RLine
     */
    public function setCallForwardNotRegisteredInt(\\Losc\CucmBundle\Model\Webservice\StructType\RCallForwardNotRegisteredInt $callForwardNotRegisteredInt = null)
    {
        $this->callForwardNotRegisteredInt = $callForwardNotRegisteredInt;
        return $this;
    }
    /**
     * Get callPickupGroupName value
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XFkType|null
     */
    public function getCallPickupGroupName()
    {
        return $this->callPickupGroupName;
    }
    /**
     * Set callPickupGroupName value
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $callPickupGroupName
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RLine
     */
    public function setCallPickupGroupName(\\Losc\CucmBundle\Model\Webservice\StructType\XFkType $callPickupGroupName = null)
    {
        $this->callPickupGroupName = $callPickupGroupName;
        return $this;
    }
    /**
     * Get autoAnswer value
     * @return string|null
     */
    public function getAutoAnswer()
    {
        return $this->autoAnswer;
    }
    /**
     * Set autoAnswer value
     * @param string $autoAnswer
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RLine
     */
    public function setAutoAnswer($autoAnswer = null)
    {
        $this->autoAnswer = $autoAnswer;
        return $this;
    }
    /**
     * Get networkHoldMohAudioSourceId value
     * @return string|null
     */
    public function getNetworkHoldMohAudioSourceId()
    {
        return $this->networkHoldMohAudioSourceId;
    }
    /**
     * Set networkHoldMohAudioSourceId value
     * @param string $networkHoldMohAudioSourceId
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RLine
     */
    public function setNetworkHoldMohAudioSourceId($networkHoldMohAudioSourceId = null)
    {
        $this->networkHoldMohAudioSourceId = $networkHoldMohAudioSourceId;
        return $this;
    }
    /**
     * Get userHoldMohAudioSourceId value
     * @return string|null
     */
    public function getUserHoldMohAudioSourceId()
    {
        return $this->userHoldMohAudioSourceId;
    }
    /**
     * Set userHoldMohAudioSourceId value
     * @param string $userHoldMohAudioSourceId
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RLine
     */
    public function setUserHoldMohAudioSourceId($userHoldMohAudioSourceId = null)
    {
        $this->userHoldMohAudioSourceId = $userHoldMohAudioSourceId;
        return $this;
    }
    /**
     * Get alertingName value
     * @return string|null
     */
    public function getAlertingName()
    {
        return $this->alertingName;
    }
    /**
     * Set alertingName value
     * @param string $alertingName
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RLine
     */
    public function setAlertingName($alertingName = null)
    {
        $this->alertingName = $alertingName;
        return $this;
    }
    /**
     * Get asciiAlertingName value
     * @return string|null
     */
    public function getAsciiAlertingName()
    {
        return $this->asciiAlertingName;
    }
    /**
     * Set asciiAlertingName value
     * @param string $asciiAlertingName
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RLine
     */
    public function setAsciiAlertingName($asciiAlertingName = null)
    {
        $this->asciiAlertingName = $asciiAlertingName;
        return $this;
    }
    /**
     * Get presenceGroupName value
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XFkType|null
     */
    public function getPresenceGroupName()
    {
        return $this->presenceGroupName;
    }
    /**
     * Set presenceGroupName value
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $presenceGroupName
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RLine
     */
    public function setPresenceGroupName(\\Losc\CucmBundle\Model\Webservice\StructType\XFkType $presenceGroupName = null)
    {
        $this->presenceGroupName = $presenceGroupName;
        return $this;
    }
    /**
     * Get shareLineAppearanceCssName value
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XFkType|null
     */
    public function getShareLineAppearanceCssName()
    {
        return $this->shareLineAppearanceCssName;
    }
    /**
     * Set shareLineAppearanceCssName value
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $shareLineAppearanceCssName
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RLine
     */
    public function setShareLineAppearanceCssName(\\Losc\CucmBundle\Model\Webservice\StructType\XFkType $shareLineAppearanceCssName = null)
    {
        $this->shareLineAppearanceCssName = $shareLineAppearanceCssName;
        return $this;
    }
    /**
     * Get voiceMailProfileName value
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XFkType|null
     */
    public function getVoiceMailProfileName()
    {
        return $this->voiceMailProfileName;
    }
    /**
     * Set voiceMailProfileName value
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $voiceMailProfileName
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RLine
     */
    public function setVoiceMailProfileName(\\Losc\CucmBundle\Model\Webservice\StructType\XFkType $voiceMailProfileName = null)
    {
        $this->voiceMailProfileName = $voiceMailProfileName;
        return $this;
    }
    /**
     * Get patternPrecedence value
     * @return string|null
     */
    public function getPatternPrecedence()
    {
        return $this->patternPrecedence;
    }
    /**
     * Set patternPrecedence value
     * @param string $patternPrecedence
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RLine
     */
    public function setPatternPrecedence($patternPrecedence = null)
    {
        $this->patternPrecedence = $patternPrecedence;
        return $this;
    }
    /**
     * Get releaseClause value
     * @return string|null
     */
    public function getReleaseClause()
    {
        return $this->releaseClause;
    }
    /**
     * Set releaseClause value
     * @param string $releaseClause
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RLine
     */
    public function setReleaseClause($releaseClause = null)
    {
        $this->releaseClause = $releaseClause;
        return $this;
    }
    /**
     * Get hrDuration value
     * @return string|null
     */
    public function getHrDuration()
    {
        return $this->hrDuration;
    }
    /**
     * Set hrDuration value
     * @param string $hrDuration
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RLine
     */
    public function setHrDuration($hrDuration = null)
    {
        $this->hrDuration = $hrDuration;
        return $this;
    }
    /**
     * Get hrInterval value
     * @return string|null
     */
    public function getHrInterval()
    {
        return $this->hrInterval;
    }
    /**
     * Set hrInterval value
     * @param string $hrInterval
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RLine
     */
    public function setHrInterval($hrInterval = null)
    {
        $this->hrInterval = $hrInterval;
        return $this;
    }
    /**
     * Get cfaCssPolicy value
     * @return string|null
     */
    public function getCfaCssPolicy()
    {
        return $this->cfaCssPolicy;
    }
    /**
     * Set cfaCssPolicy value
     * @param string $cfaCssPolicy
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RLine
     */
    public function setCfaCssPolicy($cfaCssPolicy = null)
    {
        $this->cfaCssPolicy = $cfaCssPolicy;
        return $this;
    }
    /**
     * Get defaultActivatedDeviceName value
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XFkType|null
     */
    public function getDefaultActivatedDeviceName()
    {
        return $this->defaultActivatedDeviceName;
    }
    /**
     * Set defaultActivatedDeviceName value
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $defaultActivatedDeviceName
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RLine
     */
    public function setDefaultActivatedDeviceName(\\Losc\CucmBundle\Model\Webservice\StructType\XFkType $defaultActivatedDeviceName = null)
    {
        $this->defaultActivatedDeviceName = $defaultActivatedDeviceName;
        return $this;
    }
    /**
     * Get parkMonForwardNoRetrieveDn value
     * @return string|null
     */
    public function getParkMonForwardNoRetrieveDn()
    {
        return $this->parkMonForwardNoRetrieveDn;
    }
    /**
     * Set parkMonForwardNoRetrieveDn value
     * @param string $parkMonForwardNoRetrieveDn
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RLine
     */
    public function setParkMonForwardNoRetrieveDn($parkMonForwardNoRetrieveDn = null)
    {
        $this->parkMonForwardNoRetrieveDn = $parkMonForwardNoRetrieveDn;
        return $this;
    }
    /**
     * Get parkMonForwardNoRetrieveIntDn value
     * @return string|null
     */
    public function getParkMonForwardNoRetrieveIntDn()
    {
        return $this->parkMonForwardNoRetrieveIntDn;
    }
    /**
     * Set parkMonForwardNoRetrieveIntDn value
     * @param string $parkMonForwardNoRetrieveIntDn
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RLine
     */
    public function setParkMonForwardNoRetrieveIntDn($parkMonForwardNoRetrieveIntDn = null)
    {
        $this->parkMonForwardNoRetrieveIntDn = $parkMonForwardNoRetrieveIntDn;
        return $this;
    }
    /**
     * Get parkMonForwardNoRetrieveVmEnabled value
     * @return string|null
     */
    public function getParkMonForwardNoRetrieveVmEnabled()
    {
        return $this->parkMonForwardNoRetrieveVmEnabled;
    }
    /**
     * Set parkMonForwardNoRetrieveVmEnabled value
     * @param string $parkMonForwardNoRetrieveVmEnabled
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RLine
     */
    public function setParkMonForwardNoRetrieveVmEnabled($parkMonForwardNoRetrieveVmEnabled = null)
    {
        $this->parkMonForwardNoRetrieveVmEnabled = $parkMonForwardNoRetrieveVmEnabled;
        return $this;
    }
    /**
     * Get parkMonForwardNoRetrieveIntVmEnabled value
     * @return string|null
     */
    public function getParkMonForwardNoRetrieveIntVmEnabled()
    {
        return $this->parkMonForwardNoRetrieveIntVmEnabled;
    }
    /**
     * Set parkMonForwardNoRetrieveIntVmEnabled value
     * @param string $parkMonForwardNoRetrieveIntVmEnabled
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RLine
     */
    public function setParkMonForwardNoRetrieveIntVmEnabled($parkMonForwardNoRetrieveIntVmEnabled = null)
    {
        $this->parkMonForwardNoRetrieveIntVmEnabled = $parkMonForwardNoRetrieveIntVmEnabled;
        return $this;
    }
    /**
     * Get parkMonForwardNoRetrieveCssName value
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XFkType|null
     */
    public function getParkMonForwardNoRetrieveCssName()
    {
        return $this->parkMonForwardNoRetrieveCssName;
    }
    /**
     * Set parkMonForwardNoRetrieveCssName value
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $parkMonForwardNoRetrieveCssName
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RLine
     */
    public function setParkMonForwardNoRetrieveCssName(\\Losc\CucmBundle\Model\Webservice\StructType\XFkType $parkMonForwardNoRetrieveCssName = null)
    {
        $this->parkMonForwardNoRetrieveCssName = $parkMonForwardNoRetrieveCssName;
        return $this;
    }
    /**
     * Get parkMonForwardNoRetrieveIntCssName value
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XFkType|null
     */
    public function getParkMonForwardNoRetrieveIntCssName()
    {
        return $this->parkMonForwardNoRetrieveIntCssName;
    }
    /**
     * Set parkMonForwardNoRetrieveIntCssName value
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $parkMonForwardNoRetrieveIntCssName
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RLine
     */
    public function setParkMonForwardNoRetrieveIntCssName(\\Losc\CucmBundle\Model\Webservice\StructType\XFkType $parkMonForwardNoRetrieveIntCssName = null)
    {
        $this->parkMonForwardNoRetrieveIntCssName = $parkMonForwardNoRetrieveIntCssName;
        return $this;
    }
    /**
     * Get parkMonReversionTimer value
     * @return string|null
     */
    public function getParkMonReversionTimer()
    {
        return $this->parkMonReversionTimer;
    }
    /**
     * Set parkMonReversionTimer value
     * @param string $parkMonReversionTimer
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RLine
     */
    public function setParkMonReversionTimer($parkMonReversionTimer = null)
    {
        $this->parkMonReversionTimer = $parkMonReversionTimer;
        return $this;
    }
    /**
     * Get partyEntranceTone value
     * @return string|null
     */
    public function getPartyEntranceTone()
    {
        return $this->partyEntranceTone;
    }
    /**
     * Set partyEntranceTone value
     * @param string $partyEntranceTone
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RLine
     */
    public function setPartyEntranceTone($partyEntranceTone = null)
    {
        $this->partyEntranceTone = $partyEntranceTone;
        return $this;
    }
    /**
     * Get directoryURIs value
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\DirectoryURIs|null
     */
    public function getDirectoryURIs()
    {
        return $this->directoryURIs;
    }
    /**
     * Set directoryURIs value
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\DirectoryURIs $directoryURIs
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RLine
     */
    public function setDirectoryURIs(\\Losc\CucmBundle\Model\Webservice\StructType\DirectoryURIs $directoryURIs = null)
    {
        $this->directoryURIs = $directoryURIs;
        return $this;
    }
    /**
     * Get allowCtiControlFlag value
     * @return string|null
     */
    public function getAllowCtiControlFlag()
    {
        return $this->allowCtiControlFlag;
    }
    /**
     * Set allowCtiControlFlag value
     * @param string $allowCtiControlFlag
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RLine
     */
    public function setAllowCtiControlFlag($allowCtiControlFlag = null)
    {
        $this->allowCtiControlFlag = $allowCtiControlFlag;
        return $this;
    }
    /**
     * Get rejectAnonymousCall value
     * @return string|null
     */
    public function getRejectAnonymousCall()
    {
        return $this->rejectAnonymousCall;
    }
    /**
     * Set rejectAnonymousCall value
     * @param string $rejectAnonymousCall
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RLine
     */
    public function setRejectAnonymousCall($rejectAnonymousCall = null)
    {
        $this->rejectAnonymousCall = $rejectAnonymousCall;
        return $this;
    }
    /**
     * Get patternUrgency value
     * @return string|null
     */
    public function getPatternUrgency()
    {
        return $this->patternUrgency;
    }
    /**
     * Set patternUrgency value
     * @param string $patternUrgency
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RLine
     */
    public function setPatternUrgency($patternUrgency = null)
    {
        $this->patternUrgency = $patternUrgency;
        return $this;
    }
    /**
     * Get confidentialAccess value
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\ConfidentialAccess|null
     */
    public function getConfidentialAccess()
    {
        return $this->confidentialAccess;
    }
    /**
     * Set confidentialAccess value
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\ConfidentialAccess $confidentialAccess
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RLine
     */
    public function setConfidentialAccess(\\Losc\CucmBundle\Model\Webservice\StructType\ConfidentialAccess $confidentialAccess = null)
    {
        $this->confidentialAccess = $confidentialAccess;
        return $this;
    }
    /**
     * Get externalCallControlProfile value
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XFkType|null
     */
    public function getExternalCallControlProfile()
    {
        return $this->externalCallControlProfile;
    }
    /**
     * Set externalCallControlProfile value
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $externalCallControlProfile
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RLine
     */
    public function setExternalCallControlProfile(\\Losc\CucmBundle\Model\Webservice\StructType\XFkType $externalCallControlProfile = null)
    {
        $this->externalCallControlProfile = $externalCallControlProfile;
        return $this;
    }
    /**
     * Get enterpriseAltNum value
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\EnterpriseAltNum|null
     */
    public function getEnterpriseAltNum()
    {
        return $this->enterpriseAltNum;
    }
    /**
     * Set enterpriseAltNum value
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\EnterpriseAltNum $enterpriseAltNum
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RLine
     */
    public function setEnterpriseAltNum(\\Losc\CucmBundle\Model\Webservice\StructType\EnterpriseAltNum $enterpriseAltNum = null)
    {
        $this->enterpriseAltNum = $enterpriseAltNum;
        return $this;
    }
    /**
     * Get e164AltNum value
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\E164AltNum|null
     */
    public function getE164AltNum()
    {
        return $this->e164AltNum;
    }
    /**
     * Set e164AltNum value
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\E164AltNum $e164AltNum
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RLine
     */
    public function setE164AltNum(\\Losc\CucmBundle\Model\Webservice\StructType\E164AltNum $e164AltNum = null)
    {
        $this->e164AltNum = $e164AltNum;
        return $this;
    }
    /**
     * Get pstnFailover value
     * @return string|null
     */
    public function getPstnFailover()
    {
        return $this->pstnFailover;
    }
    /**
     * Set pstnFailover value
     * @param string $pstnFailover
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RLine
     */
    public function setPstnFailover($pstnFailover = null)
    {
        $this->pstnFailover = $pstnFailover;
        return $this;
    }
    /**
     * Get callControlAgentProfile value
     * @return string|null
     */
    public function getCallControlAgentProfile()
    {
        return $this->callControlAgentProfile;
    }
    /**
     * Set callControlAgentProfile value
     * @param string $callControlAgentProfile
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RLine
     */
    public function setCallControlAgentProfile($callControlAgentProfile = null)
    {
        $this->callControlAgentProfile = $callControlAgentProfile;
        return $this;
    }
    /**
     * Get associatedDevices value
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\AssociatedDevices|null
     */
    public function getAssociatedDevices()
    {
        return $this->associatedDevices;
    }
    /**
     * Set associatedDevices value
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\AssociatedDevices $associatedDevices
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RLine
     */
    public function setAssociatedDevices(\\Losc\CucmBundle\Model\Webservice\StructType\AssociatedDevices $associatedDevices = null)
    {
        $this->associatedDevices = $associatedDevices;
        return $this;
    }
    /**
     * Get useEnterpriseAltNum value
     * @return string|null
     */
    public function getUseEnterpriseAltNum()
    {
        return $this->useEnterpriseAltNum;
    }
    /**
     * Set useEnterpriseAltNum value
     * @param string $useEnterpriseAltNum
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RLine
     */
    public function setUseEnterpriseAltNum($useEnterpriseAltNum = null)
    {
        $this->useEnterpriseAltNum = $useEnterpriseAltNum;
        return $this;
    }
    /**
     * Get useE164AltNum value
     * @return string|null
     */
    public function getUseE164AltNum()
    {
        return $this->useE164AltNum;
    }
    /**
     * Set useE164AltNum value
     * @param string $useE164AltNum
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RLine
     */
    public function setUseE164AltNum($useE164AltNum = null)
    {
        $this->useE164AltNum = $useE164AltNum;
        return $this;
    }
    /**
     * Get active value
     * @return string|null
     */
    public function getActive()
    {
        return $this->active;
    }
    /**
     * Set active value
     * @param string $active
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RLine
     */
    public function setActive($active = null)
    {
        $this->active = $active;
        return $this;
    }
    /**
     * Get uuid value
     * @return string|null
     */
    public function getUuid()
    {
        return $this->uuid;
    }
    /**
     * Set uuid value
     * @param string $uuid
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RLine
     */
    public function setUuid($uuid = null)
    {
        $this->uuid = $uuid;
        return $this;
    }
}
